<?php
declare(strict_types=1);                                 // Użyj ścisłej kontroli typów
include '../../src/bootstrap.php';                       // Dołącz plik konfiguracyjny

$id    = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT); // Pobierz i sprawdź id
$obraz = [];                                             // Inicjalizacja tablicy $obraz

if (!$id) {                                              // Jeśli nie ma id
    przekieruj('admin/publikacje.php', ['niepowodzenie' => 'Nie znaleziono publikacji']); // Przekieruj
}

$publikacja = $cms->pobierzPublikacje()->pobierz($id, false);  // Pobierz publikację
if (!$publikacja['obraz_plik']) {                              // Jeśli nie ma publikacji
    przekieruj('admin/publikacja.php', ['id' => $id]);         // Przekieruj
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {              // Jeśli formularz został wysłany
    $sciezka = APP_ROOT . '/public/wyslane/' . $publikacja['obraz_plik']; // Ścieżka do pliku
    $cms->pobierzPublikacje()->usunObraz($publikacja['id_obrazu'], $sciezka, $id); // Usuń obraz
    przekieruj('admin/publikacja.php', ['id' => $id]);        // Przekieruj
}
?>
<?php include APP_ROOT . '/public/dolaczane/admin-naglowek.php'; ?>
  <main class="container admin" id="content">
      <form action="usun-obraz.php?id=<?= $id ?>" method="POST" class="narrow">
        <h1>Usuń obraz</h1>
        <p><img src="../wyslane/<?= zastap_html($publikacja['obraz_plik']) ?>" alt="<?= zastap_html($publikacja['obraz_alt']) ?>"></p>
        <p>Kliknij <em>Potwierdź</em>, aby usunąć obraz:</p>
        <input type="submit" name="delete" value="Potwierdź" class="btn btn-primary" />
        <a href="publikacja.php?id=<?= $id ?>" class="btn btn-danger">Anuluj</a>
      </form>
  </main>
<?php include APP_ROOT . '/public/dolaczane/admin-stopka.php'; ?>