<?php
declare(strict_types=1);                                 // Użyj ścisłej kontroli typów
include '../../src/bootstrap.php';                       // Dołącz plik konfiguracyjny

$sukces = $_GET['sukces'] ?? null;                       // Sprawdź wiadomość o sukcesie
$niepowodzenie = $_GET['niepowodzenie'] ?? null;         // Sprawdź wiadomość o niepowodzeniu

$publikacje = $cms->pobierzPublikacje()->pobierzWszystko(0);     // Pobierz streszczenia publikacji
?>
<?php include APP_ROOT . '/public/dolaczane/admin-naglowek.php'; ?>
  <main class="container" id="content">
    <section class="header">
      <h1>Publikacje</h1>
      <?php if ($sukces) { ?><div class="alert alert-success"><?= $sukces ?></div><?php } ?>
      <?php if ($niepowodzenie) { ?><div class="alert alert-danger"><?= $niepowodzenie ?></div><?php } ?>
      <p><a href="publikacja.php" class="btn btn-primary">Dodaj nową publikację</a></p>
    </section>
    <table>
      <tr>
        <th>Obraz</th><th>Tytuł</th><th class="created">Utworzono</th><th class="pub">Widoczna</th><th class="edit">Zmień</th><th class="del">Usuń</th>
      </tr>
      <?php foreach ($publikacje as $publikacja) { ?>
      <tr>
        <td><img src="../wyslane/<?= zastap_html($publikacja['obraz_plik'] ?? 'blank.png') ?>"
                 alt="<?= zastap_html($publikacja['obraz_alt']) ?>"></td>
        <td><strong><?= zastap_html($publikacja['tytul']) ?></strong></td>
        <td><?= formatuj_date($publikacja['utworzono']) ?></td>
        <td><?= ($publikacja['opublikowano']) ? 'Tak' : 'Nie' ?></td>
        <td><a href="publikacja.php?id=<?= $publikacja['id'] ?>" class="btn btn-primary">Zmień</a></td>
        <td><a href="usun-publikacje.php?id=<?= $publikacja['id'] ?>" class="btn btn-danger">Usuń</a></td>
      </tr>
      <?php } ?>
    </table>
  </main>
<?php include APP_ROOT . '/public/dolaczane/admin-stopka.php'; ?>