<?php
declare(strict_types = 1);                                   // Użyj ścisłej kontroli typów
require '../dolaczane/polaczenie-baza.php';                  // Połączenie z bazą
require '../dolaczane/funkcje.php';                          // Dołącz funkcje

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);    // Pobierz i sprawdź id
if (!$id) {                                                  // Jeśli nie ma prawidłowego id
    przekieruj('publikacje.php', ['niepowodzenie' => 'Nie odnalezieono publikacji']); // Przekieruj z błędem
}

$publikacja = false;                                         // Inicjalizacja zmiennej $publikacja
$sql = "SELECT p.tytul, p.id_obrazu,
               o.plik      AS obraz_plik 
          FROM publikacje  AS p
          LEFT JOIN obrazy AS o ON p.id_obrazu    = o.id
         WHERE p.id = :id;";                                 // Zapytanie SQL o dane publikacji
$publikacja = pdo($pdo, $sql, [$id])->fetch();               // Pobierz dane publikacji
if (!$publikacja) {                                          // Jeśli zmienna $publikacja jest pusta
    przekieruj('publikacje.php', ['niepowodzenie' => 'Nie odnalezieono publikacji']); // Przekieruj z błędem
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {                  // Jeśli formularz został przesłany
    try {
        $pdo->beginTransaction();                            // Rozpocznij transakcję

        // Jeśli istnieje obraz, najpierw go usuń
        if ($publikacja['id_obrazu']) {                      // Jeśli był obraz
            $sql = "UPDATE publikacje SET id_obrazu = null WHERE id = :id_publikacji;"; // SQL aktualizujący tabelę publikacje
            pdo($pdo, $sql, [$id]);                          // Usuń obraz z publikacji
            $sql = "DELETE FROM obrazy WHERE id = :id;";     // SQL usuwający obraz z tabeli obrazy
            pdo($pdo, $sql, [$publikacja['id_obrazu']]);     // Usuń obraz z tabeli obrazy
            $sciezka = '../wyslane/' . $publikacja['obraz_plik']; // Określ ścieżkę
            if (file_exists($sciezka)) {                     // Jeśli plik obrazu istnieje
                $unlink = unlink($sciezka);                  // Usuń go
            }
        }

        $sql = "DELETE FROM publikacje WHERE id = :id;";    // SQL usuwający publikację
        pdo($pdo, $sql, [$id]);                             // Usuń publikację
        $pdo->commit();                                     // Zatwierdź transakcję
        przekieruj('publikacje.php', ['sukces' => 'Publikacja została usunięta']); // Przekieruj
    } catch (PDOException $e) {                             // W razie wyrzucenia wyjątku
        $pdo->rollBack();                                   // Anuluj zmiany SQL
        throw $e;                                           // Ponownie wyrzuć wyjątek
    }
}
?>
<?php include '../dolaczane/admin-naglowek.php'; ?>
  <main class="container admin" id="content">
    <form action="usun-publikacje.php?id=<?= $id ?>" method="POST" class="narrow">
      <h1>Usuń publikację</h1>
      <p>Kliknij <em>Potwierdź</em>, aby usunąć publikację: <em><?= zastap_html($publikacja['tytul']) ?></em></p>
      <input type="submit" name="delete" value="Potwierdź" class="btn btn-primary">
      <a href="publikacje.php" class="btn btn-danger">Anuluj</a>
    </form>
  </main>
<?php include '../dolaczane/admin-stopka.php'; ?>