<?php
declare(strict_types = 1);                                       // Włącz ścisłą kontrolę typów
use PhpMysql\Weryfikacja\Weryfikacja;                            // Zaimportuj przestrzeń Weryfikacja

if (!$id) {                                                      // Jeśli nie ma prawidłowego id
    include APP_ROOT . '/src/strony/nie-odnaleziono-strony.php'; // Nie odnaleziono strony
}

$publikacja = $cms->pobierzPublikacje()->pobierz($id);           // Pobierz dane publikacji
if (!$publikacja) {                                              // Jeśli tablica $publikacja jest pusta
    include APP_ROOT . '/src/strony/nie-odnaleziono-strony.php'; // Nie odnaleziono strony
}

if (mb_strtolower($czesci[2]) != mb_strtolower($publikacja['seo_tytul'])) {    // W przypadku niepoprawnego tytułu SEO
    przekieruj('publikacja/' . $id . '/' . $publikacja['seo_tytul'], [], 301); // Przekieruj na właściwy URL
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {                       // Jeśli formularz został przesłany
    $komentarz = $_POST['komentarz'];                             // Pobierz komentarz
    $purifier = new HTMLPurifier();                               // Utwórz obiekt HTMLPurifier
    $purifier->config->set('HTML.Allowed', 'br,b,i,a[href]');     // Określ dozwolone znaczniki
    $komentarz  = $purifier->purify($komentarz);                  // Oczyść komentarz

    $blad    = Weryfikacja::czyTekst($komentarz, 1, 2000)
        ? '' : 'Komentarz musi mieć od 1 do 2000 znaków.
                Może zawierać znaczniki <b>, <i>, <a> i <br>.';   // Skontroluj komentarz

    if ($blad === '') {                                           // Jeśli nie było błędów, zapisz
        $argumenty = [$komentarz, $publikacja['id'], $cms->pobierzSesje()->id,]; // Argumenty
        $cms->pobierzKomentarz()->utworz($argumenty);             // Utwórz komentarz
        przekieruj($sciezka);                                     // Przeładuj stronę
    }
}

$dane['nawigacja']  = $cms->pobierzKategorie()->pobierzWszystko();    // Pobierz kategorie
$dane['publikacja'] = $publikacja;                                    // Publikacja
$dane['sekcja']     = $publikacja['id_kategorii'];                    // Bieżąca kategoria
$dane['komentarze'] = $cms->pobierzKomentarz()->pobierzWszystko($id); // Pobierz komentarze

if ($cms->pobierzSesje()->id > 0) {                                   // Jeśli użytkownik jest zalogowany
    $dane['polubione']    = $cms->pobierzPolubienie()->pobierz([$id, $cms->pobierzSesje()->id],); // Czy dodał polubienie?
    $dane['blad']    = $blad ?? null;                                 // Błąd komentarza
}

echo $twig->render('publikacja.html', $dane);                         // Wyrenderuj szablon Twiga