<?php
namespace PhpMysql\CMS;                                   // Declare namespace

class Sesja
{                                                        // Define Session class
    public $id;                                          // Zapisz id użytkownika
    public $imie;                                        // Zapisz imię użytkownika
    public $rola;                                        // Zapisz rolę użytkownika

    public function __construct()
    {                                                    // Uruchamia się przy tworzeniu obiektu
        session_start();                                 // Rozpoczyna lub restartuje sesję
        $this->id     = $_SESSION['id'] ?? 0;            // Określ właściwość id utworzonego obiektu
        $this->imie   = $_SESSION['imie'] ?? '';         // Określ właściwość imie utworzonego obiektu
        $this->rola   = $_SESSION['rola'] ?? 'ogolna';   // Określ właściwość rola utworzonego obiektu
    }

    // Tworzenie nowej sesji
    public function utworz($uczestnik)
    {
        session_regenerate_id(true);                     // Zaktualizuj id sesji
        $_SESSION['id']   = $uczestnik['id'];            // Dodaj id użytkownika do sesji
        $_SESSION['imie'] = $uczestnik['imie'];          // Dodaj imię użytkownika do sesji
        $_SESSION['rola'] = $uczestnik['rola'];          // Dodaj rolę użytkownika do sesji
    }

    // Odświeżanie istniejącej sesji - alias metody utworz()
    public function odswiez($uczestnik)
    {
        $this->utworz($uczestnik);                       // Aktualizacja danych sesji
    }

    // Usuń istniejącą sesję
    public function usun()
    {
        $_SESSION = [];                                  // Opróżnik tablice $_SESSION
        $param    = session_get_cookie_params();         // Pobierz parametry ciasteczka sesji
        setcookie(session_name(), '', time() - 2400, $param['path'], $param['domain'],
            $param['secure'], $param['httponly']);       // Wyczyść ciasteczko sesji
        session_destroy();                               // Usuń sesję
    }
}