<?php
// CZĘŚĆ A: Konfiguracja
declare(strict_types=1);                                 // Użyj ścisłej kontroli typów
include '../../src/bootstrap.php';                       // Dołącz plik konfiguracyjny

// Inicjalizacja zmiennych potrzebnych w kodzie PHP
$id          = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT); // Pobierz i sprawdź id
$tymcz        = $_FILES['obraz']['tmp_name'] ?? '';      // Tymczasowy obraz
$cel = '';                                               // Miejsce zapisania obrazu
$zapisano       = null;                                  // Czy publikacja została zapisana?

// Inicjalizacja zmiennych potrzebnych w kodzie HTML
$publikacja = [
    'id'            => $id,
    'tytul'         => '',
    'podsumowanie'  => '',
    'tresc'         => '',
    'id_uczestnika' => 0,
    'id_kategorii'  => 0,
    'id_obrazu'     => null,
    'opublikowano'  => false,
    'obraz_plik'    => '',
    'obraz_alt'     => '',
];                                                                  // Dane publikacji
$bledy  = [
    'ostrzezenie'   => '',
    'tytul'         => '',
    'podsumowanie'  => '',
    'tresc'         => '',
    'autor'         => '',
    'kategoria'     => '',
    'obraz_plik'    => '',
    'obraz_alt'     => '',
];                                                                  // Komunikaty błędów

if ($id) {                                                          // Jeśli id jest prawidłowy
    $publikacja = $cms->pobierzPublikacje()->pobierz($id, false);   // Pobierz dane o publikacji
    if (!$publikacja) {                                             // Jeśli nie ma publikacji
        przekieruj('admin/publikacje.php', ['niepowodzenie' => 'Publikacji nie odnaleziono']); // Przekieruj
    }
}

$zapisany_obraz = $publikacja['obraz_plik'] ? true : false;         // Czy obraz został przesłany?
$autorzy    = $cms->pobierzUczestnika()->pobierzWszystko();         // Pobierz wszystkich uczestników
$kategorie = $cms->pobierzKategorie()->pobierzWszystko();           // Pobierz kategorie


// CZĘŚĆ B: Pobierz i sprawdź dane z formularza
if ($_SERVER['REQUEST_METHOD'] == 'POST') {                         // Jeśli formularz został przesłany
    // Jeśli plik jest większy niż ograniczenia w php.ini lub .htaccess zapisz komunikat błędu
    $bledy['obraz_plik'] = ($tymcz and $_FILES['obraz']['error'] === 1) ? 'Plik jest za duży ' : '';

    // Jeśli obraz został przesłany, pobierz dane i sprawdź
    if ($tymcz and $_FILES['obraz']['error'] == 0) {                // Sprawdź plik
        $publikacja['obraz_alt'] = $_POST['obraz_alt'];             // Pobierz tekst zastępczy

        // Zweryfikuj plik obrazu
        $bledy['obraz_plik'] = in_array(mime_content_type($tymcz), TYPY_MIME)
            ? '' : 'Nieobsługiwany typ pliku. ';                             // Sprawdź typ pliku
        $rozszerzenie = strtolower(pathinfo($_FILES['obraz']['name'], PATHINFO_EXTENSION)); // Rozszerzenie pliku małymi literami
        $bledy['obraz_plik'] .= in_array($rozszerzenie, ROZSZERZENIA)
            ? '' : 'Nieobsługiwane rozszerzenie. ';                          // Sprawdź rozszerzenie
        $bledy['obraz_plik'] .= ($_FILES['obraz']['size'] <= MAX_ROZMIAR)
            ? '' : 'Plik jest za duży. ';                                    // Sprawdź rozmiar
        $bledy['obraz_alt']  = (Weryfikacja::czyTekst($publikacja['obraz_alt'], 1, 254))
            ? '' : 'Tekst zastępczy musi mieć 1-254 znaków.';                // Sprawdź tekst zastępczy

        // Jeśli plik z obrazem jest prawidłowy, określ miejsce zapisu
        if ($bledy['obraz_plik'] === '' and $bledy['obraz_alt'] === '') {    // Jeśli prawidłowy
            $publikacja['obraz_plik'] = utworz_nazwepliku($_FILES['obraz']['name'], WYSLANE);
            $cel = WYSLANE . $publikacja['obraz_plik'];                      // Miejsce docelowe
        }
    }

    // Pobierz dane publikacji
    $publikacja['tytul']         = $_POST['tytul'];                 // Tytuł
    $publikacja['podsumowanie']  = $_POST['podsumowanie'];          // Streszczenie
    $publikacja['tresc']         = $_POST['tresc'];                 // Treść
    $publikacja['id_uczestnika'] = $_POST['id_uczestnika'];         // Autor
    $publikacja['id_kategorii']  = $_POST['id_kategorii'];          // Kategoria
    $publikacja['opublikowano']  = (isset($_POST['opublikowano']) and ($_POST['opublikowano'] == 1)) ? 1 : 0;   // Czy opublikowano?

    // Zweryfikuj dane publikacji i utwórz komunikaty w razie błędów
    $bledy['tytul']    = Weryfikacja::czyTekst($publikacja['tytul'], 1, 80)
        ? '' : 'Tytuł musi mieć 1-80 znaków';
    $bledy['podsumowanie']  = Weryfikacja::czyTekst($publikacja['podsumowanie'], 1, 254)
        ? '' : 'Podsumowanie musi mieć 1-254 znaków';
    $bledy['tresc']  = Weryfikacja::czyTekst($publikacja['tresc'], 1, 100000)
        ? '' : 'Publikacja musi mieć 1-100 000 znaków';
    $bledy['uczestnik']   = Weryfikacja::czyIdUczestnika($publikacja['id_uczestnika'], $autorzy)
        ? '' : 'Proszę wybrać autora';
    $bledy['kategoria'] = Weryfikacja::czyIdKategorii($publikacja['id_kategorii'], $kategorie)
        ? '' : 'Proszę wybrać kateogrię';

    $nieprawidlowe = implode($bledy);                                   // Połącz błędy

    // CZĘŚĆ C: Jeśli dane są poprawne, zaktualizuj bazę
    if ($nieprawidlowe) {                                               // Jeśli niepoprawne
        $bledy['ostrzezenie'] = 'Prosimy o poprawienie błędów';         // Zapisz komunikat
    } else {                                                            // W przeciwnym razie
        $argumenty = $publikacja;                                       // Zapisz dane w tablicy $argumenty
        if ($id) {                                                      // Jeśli id istnieje, aktualizuj
            $zapisano = $cms->pobierzPublikacje()->aktualizuj($argumenty, $tymcz, $cel); // Aktualizuj publikację
        } else {                                                        // Jeśli nie ma id, utwórz
            unset($argumenty['id']);                                    // Usuń id z argumentów
            $zapisano = $cms->pobierzPublikacje()->utworz($argumenty, $tymcz, $cel); // Utwórz publikację
        }

        if ($zapisano == true) {                                        // Jeśli zaktualizowano
            przekieruj('admin/publikacje.php', ['sukces' => 'Publikacja zapisana']); // Przekieruj
        } else {                                                        // W przeciwnym razie
            $bledy['ostrzezenie'] = 'Istnieje już publikacja o takim tytule';        // Zapisz komunikat
        }
    }
    $publikacja['obraz_plik'] = $zapisany_obraz ? $publikacja['obraz_plik'] : ''; 
}
?>
<?php include APP_ROOT . '/public/dolaczane/admin-naglowek.php'; ?>
<!-- CZĘŚĆ D: Formularz -->
  <form action="publikacja.php?id=<?= $id ?>" method="POST" enctype="multipart/form-data">
    <main class="container admin" id="content">

      <h1>Edytowanie publikacji</h1>
      <?php if ($bledy['ostrzezenie']) { ?>
        <div class="alert alert-danger"><?= $bledy['ostrzezenie'] ?></div>
      <?php } ?>

      <div class="admin-article">
        <section class="image">
          <?php if (!$publikacja['obraz_plik']) { ?>
            <label for="obraz">Prześlij obraz:</label>
            <div class="form-group image-placeholder">
              <input type="file" name="obraz" class="form-control-file" id="obraz"><br>
              <span class="errors"><?= $bledy['obraz_plik'] ?></span>
            </div>
            <div class="form-group">
              <label for="obraz_alt">Tekst zastępczy (alt): </label>
              <input type="text" name="obraz_alt" id="obraz_alt" value="" class="form-control">
              <span class="errors"><?= $bledy['obraz_alt'] ?></span>
            </div>
          <?php } else { ?>
            <label>Obraz:</label>
            <img src="../wyslane/<?= zastap_html($publikacja['obraz_plik']) ?>"
                 alt="<?= zastap_html($publikacja['obraz_alt']) ?>">
            <p class="alt"><strong>Tekst zastępczy (alt):</strong> <?= zastap_html($publikacja['obraz_alt']) ?></p>
            <a href="edytuj-alt.php?id=<?= $publikacja['id'] ?>" class="btn btn-secondary">Edytuj tekst zastępczy</a>
            <a href="usun-obraz.php?id=<?= $id ?>" class="btn btn-secondary">Usuń obraz</a><br><br>
          <?php } ?>
        </section>

        <section class="text">
          <div class="form-group">
            <label for="tytul">Tytuł: </label>
            <input type="text" name="tytul" id="tytul" value="<?= zastap_html($publikacja['tytul']) ?>"
                   class="form-control">
            <span class="errors"><?= $bledy['tytul'] ?></span>
          </div>
          <div class="form-group">
            <label for="podsumowanie">Podsumowanie: </label>
            <textarea name="podsumowanie" id="podsumowanie"
                      class="form-control"><?= zastap_html($publikacja['podsumowanie']) ?></textarea>
            <span class="errors"><?= $bledy['podsumowanie'] ?></span>
          </div>
          <div class="form-group">
            <label for="tresc">Treść: </label>
            <textarea name="tresc" id="tresc"
                      class="form-control"><?= zastap_html($publikacja['tresc']) ?></textarea>
            <span class="errors"><?= $bledy['tresc'] ?></span>
          </div>
          <div class="form-group">
            <label for="id_uczestnika">Autor: </label>
            <select name="id_uczestnika" id="id_uczestnika">
              <?php foreach ($autorzy as $autor) { ?>
                <option value="<?= $autor['id'] ?>"
                    <?= ($publikacja['id_uczestnika'] == $autor['id']) ? 'selected' : ''; ?>>
                    <?= zastap_html($autor['imie'] . ' ' . $autor['nazwisko']) ?></option>
              <?php } ?>
            </select>
            <span class="errors"><?= $bledy['autor'] ?></span>
          </div>
          <div class="form-group">
            <label for="kategoria">Kategoria: </label>
            <select name="id_kategorii" id="kategoria">
              <?php foreach ($kategorie as $kategoria) { ?>
                <option value="<?= $kategoria['id'] ?>"
                    <?= ($publikacja['id_kategorii'] == $kategoria['id']) ? 'selected' : ''; ?>>
                    <?= zastap_html($kategoria['nazwa']) ?></option>
              <?php } ?>
            </select>
            <span class="errors"><?= $bledy['kategoria'] ?></span>
          </div>
          <div class="form-check">
            <input type="checkbox" name="opublikowano" value="1" class="form-check-input" id="opublikowano"
                <?= ($publikacja['opublikowano'] == 1) ? 'checked' : ''; ?>>
            <label for="opublikowano" class="form-check-label">Opublikowano</label>
          </div>
          <input type="submit" name="update" value="Zapisz" class="btn btn-primary">
        </section><!-- /.tekst -->
      </div><!-- /.admin-publikacja -->
    </main>
  </form>
<?php include APP_ROOT . '/public/dolaczane/admin-stopka.php'; ?>