<?php
// CZĘŚĆ A: Przygotowanie
declare(strict_types = 1);                                  // Użyj ścisłej kontroli typów
require '../dolaczane/polaczenie-baza.php';                 // Połączenie z bazą
require '../dolaczane/funkcje.php';                         // Dołącz funkcje
include '../dolaczane/weryfikacja.php';                     // Dołącz kontrolę danych

// Inicjalizacja zmiennych
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);   // Pobierz id i zweryfikuj
$kategoria = [
    'id'          => $id,
    'nazwa'       => '',
    'opis'        => '',
    'nawigacja'   => false,
];                                                          // Inicjalizacja tablicy kategorii
$bledy = [
    'ostrzezenie' => '',
    'nazwa'       => '',
    'opis'        => '',
];                                                          // Inicjalizacja tablicy błędów

// Jeśli przekazano id, strona powinna umożliwić edytowanie kategorii, pobierz więc dane kategorii
if ($id) {                                                  // Jeśli jest id
    $sql = "SELECT id, nazwa, opis, nawigacja
              FROM kategorie 
             WHERE id = :id;";                              // Instrukcja SQL 
    $kategoria = pdo($pdo, $sql, [$id])->fetch();           // Pobierz dane o kategorii

    if (!$kategoria) {                                      // Jeśli nie znaleziono kategorii
        przekieruj('kategorie.php', ['niepowodzenie' => 'Nie odnaleziono kategorii']); // Przekieruj z błędem
    }
}

// CZĘŚĆ B: Pobierz i zweryfikuj dane z formularza
if ($_SERVER['REQUEST_METHOD'] == 'POST') {                 // Jeśli przesłano formularz
    $kategoria['nazwa']        = $_POST['nazwa'];           // Pobierz nazwę
    $kategoria['opis']         = $_POST['opis'];            // Pobierz opis
    $kategoria['nawigacja']    = (isset($_POST['nawigacja']) and ($_POST['nawigacja'] == 1)) ? 1 : 0; // Pobierz nawigację

    // Sprawdź poprawność wszystkich danych i utwórz komunikaty w razie błędów 
    $bledy['nazwa']          = (czy_tekst($kategoria['nazwa'], 1, 24))
        ? '' : 'Nazwa powinna składać się z 1-24 znaków.';  // Sprawdź nazwę
    $bledy['opis']   = (czy_tekst($kategoria['opis'], 1, 254))
        ? '' : 'Opis powinien składać się z 1-254 znaków.'; // Sprawdź opis

    $nieprawidlowe = implode($bledy);                       // Połącz komunikaty błędów

// CZĘŚĆ C: Po skontrolowaniu poprawności danych zaktualizuj bazę
    if ($nieprawidlowe) {                                   // Jeśli dane są niepoprawne
        $bledy['ostrzezenie'] = 'Proszę poprawić błędy';    // Utwórz komunikat błędu
    } else {                                                // W przeciwnym razie
        $argumenty = $kategoria;                            // Skonfiguruj tablicę argumentów dla  SQL
        if ($id) {                                          // Jeśli id istnieje
            $sql = "UPDATE kategorie 
                       SET nazwa = :nazwa, opis = :opis, 
                           nawigacja = :nawigacja 
                     WHERE id = :id;";                      // Instrukcja SQL aktualizująca kategorię
        } else {                                            // Jeśli nie ma id
            unset($argumenty['id']);                        // Usuń id z tablicy argumentów
            $sql = "INSERT INTO kategorie (nazwa, opis, nawigacja) 
                         VALUES (:nazwa, :opis, :nawigacja);"; // Utwórz kategorię
        }

        // Uruchomienie powyższego zapytania SQL może mieć trojakie skutki:
        // Zapisanie kategorii | Nazwa jest już w użyciu | Wyrzucenie wyjątku z innego powodu
        try {                                               // Blok try z zapytaniem
            pdo($pdo, $sql, $argumenty);                    // Uruchomienie zapytania
            przekieruj('kategorie.php', ['sukces' => 'Kategoria zapisana']); // Przekierowanie
        } catch (PDOException $e) {                         // W razie wyjątku PDO
            if ($e->errorInfo[1] === 1062) {                // Jeśli użyto istniejącej nazwy
                $bledy['ostrzezenie'] = 'Nazwa kategorii już istnieje'; // Zapisz komunikat błędu
            } else {                                        // W razie innego nieoczekiwanego błędu
                throw $e;                                   // Ponownie wyrzuć wyjątek
            }
        }
    }
}
?>
<?php include '../dolaczane/admin-naglowek.php'; ?>
  <main class="container admin" id="content">
    <form action="kategoria.php?id=<?= $id ?>" method="post" class="narrow">
      <h1>Edytuj kategorię</h1>
      <?php if ($bledy['ostrzezenie']) { ?>
        <div class="alert alert-danger"><?= $bledy['ostrzezenie'] ?></div>
      <?php } ?>

      <div class="form-group">
        <label for="nazwa">Nazwa: </label>
        <input type="text" name="nazwa" id="nazwa"
               value="<?= zastap_html($kategoria['nazwa']) ?>" class="form-control">
        <span class="errors"><?= $bledy['nazwa'] ?></span>
      </div>

      <div class="form-group">
        <label for="opis">Opis: </label>
        <textarea name="opis" id="opis"
                  class="form-control"><?= zastap_html($kategoria['opis']) ?></textarea>
        <span class="errors"><?= $bledy['opis'] ?></span>
      </div>

      <div class="form-check">
        <input type="checkbox" name="nawigacja" id="nawigacja"
               value="1" class="form-check-input"
          <?= ($kategoria['nawigacja'] === 1) ? 'checked' : '' ?>>
        <label class="form-check-label" for="nawigacja">Nawigacja</label>
      </div>

      <input type="submit" value="Zapisz" class="btn btn-primary btn-save">
    </form>
  </main>
<?php include '../dolaczane/admin-stopka.php'; ?>