<?php

class Uczestnik
{
    protected $db;                                       // Przechowuje referencję do obiektu Baza

    public function __construct(Baza $db)
    {
        $this->db = $db;                                 // Dodaj referencję do obiektu Baza
    }

    // Get individual member by id
    public function pobierz(int $id)
    {
        $sql = "SELECT id, imie, nazwisko, dolaczyl, zdjecie 
                  FROM uczestnicy
                 WHERE id = :id;";                           // SQL pobierający uczestnika
        return $this->db->wykonajSQL($sql, [$id])->fetch();  // Zwróć uczestnika
    }

    // Pobierz informacje o wszystkich uczestnikach
    public function pobierzWszystko(): array
    {
        $sql = "SELECT id, imie, nazwisko, dolaczyl, zdjecie
                FROM uczestnicy;";                           // SQL pobierający wszystkich uczestników
        return $this->db->wykonajSQL($sql)->fetchAll();      // Zwróć wszystkich uczestników
    }

}