<?php
declare(strict_types = 1);                                  // Użyj ścisłej kontroli typów
require '../dolaczane/polaczenie-baza.php';                 // Połączenie z bazą
require '../dolaczane/funkcje.php';                         // Dołącz funkcje
include '../dolaczane/weryfikacja.php';                     // Dołącz kontrolę danych

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);   // Pobierz i sprawdź id

$obraz = [
    'plik' => '',
    'alt' => '',
];                                                          // Inicjalizacja tablicy $obraz
$bledy = [
    'alt' => '',
    'ostrzezenie' => '',
];                                                          // Inicjalizacja komunikatów błędów

if ($id) {                                                  // Jeśli id publikacji jest prawidłowy
    $sql = "SELECT o.id, o.plik, o.alt 
            FROM obrazy   AS o
            JOIN publikacje AS p
              ON o.id = p.id_obrazu
           WHERE p.id = :id;";                            // SQL pobierające dane obrazu
    $obraz = pdo($pdo, $sql, [$id])->fetch();             // Pobierz dane obrazu
}
if (!$obraz) {                                            // Jeśli nie ma obrazu
    przekieruj('publikacja.php', ['id' => $id]);          // Przekieruj
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {               // Jeśli formularz został przesłany
    $obraz['alt'] = $_POST['obraz_alt'];                  // Pobierz tekst zastępczy

    $bledy['alt'] = (czy_tekst($obraz['alt'], 1, 254))
        ? '' : 'Tekst zastępczy musi mieć 1-254 znaków.'; // Sprawdź tekst zastępczy

    if ($bledy['alt']) {                                   // Jeśli tekst ma nieprawidłową długość
        $bledy['ostrzezenie'] = 'Prosimy o poprawienie błedu';  // Zapisz komunikat błędu
    } else {                                                // W przeciwnym razie
        unset($obraz['plik']);                              // Usuń plik z tablicy $obraz
        $sql = "UPDATE obrazy 
                   SET alt = :alt 
                 WHERE id = :id;";                          // SQL aktualizujący tabelę obrazy
        pdo($pdo, $sql, $obraz);                            // Zmiana tekstu zastępczeo
        przekieruj('publikacja.php', ['id' => $id]);        // Powrót do strony publikacji
    }
}
?>
<?php include '../dolaczane/admin-naglowek.php'; ?>
  <main class="container admin" id="content">
    <form action="edytuj-alt.php?id=<?= $id ?>" method="POST" class="narrow">
      <h1>Zmień tekst zastępczy</h1>
      <?php if ($bledy['ostrzezenie']) { ?><div class="alert alert-danger"><?= $bledy['ostrzezenie'] ?></div><?php } ?>

      <div class="form-group">
        <label for="obraz_alt">Tekst zastępczy: </label>
        <input type="text" name="obraz_alt" id="obraz_alt" value="<?= zastap_html($obraz['alt']) ?>"  class="form-control">
        <span class="errors"><?= $bledy['alt'] ?></span>
      </div>

      <div class="form-group">
        <input type="submit" name="delete" value="Potwierdź" class="btn btn-primary btn-save">
      </div>

      <img src="../uploads/<?= $obraz['file'] ?>" alt="<?= zastap_html($obraz['alt']) ?>">
    </form>
  </main>
<?php include '../dolaczane/admin-stppka.php'; ?>