<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+

//Menu i modu promocji
include_once('specialsmenu.php');

//Funkcja wywoywaba w sytuacji gdy nie mona
//wywietli formularza edycji promocji
function noSpecialToEdit() {
	//Dodatkowe komunikaty
	global $appCore, $smarty;
	$doselect = $appCore->getMessage('specials', 'selectspectoseedata');
	$smarty->assign('doselect', $doselect['VALUE']);
	$smarty->assign('form', NULL);
}

function prepareFormData() {
	global $formObj, $smarty;
	//Walidacja formularza przebiega niepomylnie	
	$formObj->setFormAction('?menu=51d9a87ceb513de9363d548dc1bee90d');
	if (isset($_POST['specactive'])) {$act = array(array('catactive', NULL, NULL, TRUE));} else {$act = array(array('catactive', NULL, NULL));}
	$formObj->setValueArray('specactive', $act);
	$formObj->setValueArray('specid', $_POST['specid']);
	$specToEdit = Special::getData($_POST['specid'], FALSE);
	$prod = $specToEdit->getProduct();
	$params = array(array($prod[0]->getId(), $prod[0]->_Item->getName()));
	$formObj->setValueArray('prodid', $params);
	$smarty->assign_by_ref('form', $formObj);
}

//Tytuy
$title      = $appCore->getMessage('specials', 'title');
$listtitle  = $appCore->getMessage('specials', 'listtitle');
$selspecial = $appCore->getMessage('specials', 'selectedspecial');
$smarty->assign('submenu_title', $title['VALUE']);
$smarty->assign('title', $listtitle['VALUE']);
$smarty->assign('selectedspecial', $selspecial['VALUE']);

//Sprawdzenie czy przypadkiem nie nadeszy dane z formularza
if (isset($_POST['save'])) {
	//Prawdopodobnie nadeszy dane z formularza. Walidacja
	//Zaadowanie moduu formularza
	$adminContent = 'specials/result.tpl';
	$windowTitle = $appCore->getMessage('specials', 'windowTitle2');
	$smarty->assign('windowTitle', $windowTitle['VALUE']);
	if (PEAR::isError($err = $appCore->loadModule('Forms'))){echo($appCore->getLastErrorMessage()); exit;}
	//Utworzenie obiektu formularza i przypisanie go przez referencj do obiektu Smarty
	$appCore->clearLastErrorMessage();
	$formObj = new Forms('admin/special/new_special.xml');
	if($appCore->getLastErrorMessage()!='') {echo($appCore->getLastErrorMessage()); exit;}
	
	//Wstpna walidacja formularza
	$result = array();
	$formObj->checkForm(&$result);
	if (count(&$result)!=0) {
		prepareFormData();
	} else {
		//Walidacja formularza przebiega pomylnie
				
		//Tworzenie obiektu promocji oraz prb jego zapisania
		$specObj = new Special();
		$specObj->setId($_POST['specid']);
		$specObj->setProductId($_POST['prodid']);
		$specObj->setDateFrom(str_replace('-', '', $_POST['datefrom']));
		$specObj->setDateTo($_POST['dateto']);
		$specObj->setSpecPrice($_POST['price']);				
		if (isset($_POST['specactive'])) {$specObj->setActive(TRUE);} else {$specObj->setActive(FALSE);}
		
		if(PEAR::isError($result = $specObj->saveData($_SESSION['CurrentUser']))) {
			//Nie zapisano
			$formObj->setConditionError($appCore->getLastErrorMessage());	
			prepareFormData();	
		} else {	
			//Zapisano
			$title = $appCore->getMessage('specials', 'reok');
			$smarty->assign('message', $title['VALUE']);
		}
	}
}  else if (isset($_GET['specid'])) {//Sprawdzenie czy podano poprawny identyfikator obiektu promocji
	if(Special::doesSpecialExist($_GET['specid'])) {
		//Dokument zawierajcy szablon
		$adminContent = 'specials/newspecial.tpl';
		$windowTitle = $appCore->getMessage('specials', 'windowTitle2');
		$smarty->assign('windowTitle', $windowTitle['VALUE']);
		//Promocja istnieje
		//Pobranie obiektu promocji
		if (PEAR::isError($specToEdit = Special::getData($_GET['specid'], FALSE))) {
			//Nie mona zaadowa obiektu promocji
			noSpecialToEdit();
		} else {				
			//Zaadowanie moduu formularza
			if (PEAR::isError($err = $appCore->loadModule('Forms'))){echo($appCore->getLastErrorMessage()); exit;}
			//Utworzenie obiektu formularza i przypisanie go przez referencj do obiektu Smarty
			$appCore->clearLastErrorMessage();
			$formObj = new Forms('admin/special/new_special.xml');
			if($appCore->getLastErrorMessage()!='') {echo($appCore->getLastErrorMessage()); exit;}
			
			//Produkt, ktrego dotyczy promocja
			$prod = $specToEdit->getProduct();
			
			//Przypisywanie danych do obiektu
			$formObj->setValueArray('specid', $_GET['specid']);
			$formObj->setValueArray('datefrom', date('Y-m-d', $specToEdit->getDateFrom()));
			$formObj->setValueArray('dateto', date('Y-m-d', $specToEdit->getDateTo()));
			$formObj->setValueArray('price', $specToEdit->getSpecialPrice());
			if ($specToEdit->getActive()) {$act = array(array('catactive', NULL, NULL, TRUE));} else {$act = array(array('catactive', NULL, NULL));}
			$formObj->setValueArray('specactive', $act);
			$params = array(array($prod[0]->getId(), $prod[0]->_Item->getName()));
			$formObj->setValueArray('prodid', $params);
			$formObj->setFormAction('?menu=51d9a87ceb513de9363d548dc1bee90d');
			
			//Przypisanie obiektu formularza do szablonw smarty
			$smarty->assign_by_ref('form', $formObj);
		}
	} else {	
		//Podany identyfikator jest nieprawidowy
		noSpecialToEdit();
	}
} else {

	$filter = 'all';
	if (isset($_GET['filter'])){
		switch ($_GET['filter']) {
			case 1:
				$filter = 'present';
			break;
			case 2:
				$filter = 'ended';
			break;
			case 3:
				$filter = 'notstarted';
			break;
			case 4:
				$filter = 'unactive';
			break;						
		}
	}

	//Tworzenie tablicy obiektw promocji
	if(PEAR::isError($specList = Special::getSpecialsList($filter))) {
		$errorMsg = $appCore->getMessage('specials', 'error');
		$smarty->assign('message', '<span style="color:#FF0000">'.$errorMsg['VALUE'].'</span>');
		$smarty->assign('specList', NULL);
	} else {
		//Pobranie pozostaych komunikatw
		$nodata = $appCore->getMessage('specials', 'nodata'); $smarty->assign('nodata', $nodata['VALUE']);
		$notavaliable = $appCore->getMessage('specials', 'notavaliable'); $smarty->assign('notavaliable', $notavaliable['VALUE']);
		$after = $appCore->getMessage('specials', 'after'); $smarty->assign('after', $after['VALUE']);
		$current = $appCore->getMessage('specials', 'current'); $smarty->assign('current', $current['VALUE']);
		$before = $appCore->getMessage('specials', 'before'); $smarty->assign('before', $before['VALUE']);
		$emptyMsg = $appCore->getMessage('specials', 'empty');
		$smarty->assign('message', $emptyMsg['VALUE']);
		$smarty->assign_by_ref('specList', $specList);
	}
	//Dokument zawierajcy szablon
	$adminContent = 'specials/specials.tpl';
}
?>
