<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+


include_once("dict_menu.php");

// Pobranie etykiet
$newTax_link = $appCore->getMessage('dict_tax', 'newTax_link');
$showFilter_label = $appCore->getMessage('dict_tax', 'showFilter_label');
$filterActive_link = $appCore->getMessage('dict_tax', 'filterActive_link');
$filterNonactive_link = $appCore->getMessage('dict_tax', 'filterNonactive_link');
$filterAll_link = $appCore->getMessage('dict_tax', 'filterAll_link');
$smarty->assign('newTax_link', $newTax_link['VALUE']);
$smarty->assign('showFilter_label', $showFilter_label['VALUE']);
$smarty->assign('filterActive_link', $filterActive_link['VALUE']);
$smarty->assign('filterNonactive_link', $filterNonactive_link['VALUE']);
$smarty->assign('filterAll_link', $filterAll_link['VALUE']);

// Usunicie stawki podatku VAT ze sownika
if (isSet($_POST['tax_delete']) && isSet($_SESSION['tax_deleted']) && $_SESSION['tax_deleted'] == 1) {
	session_unregister('tax_deleted');
	if (PEAR::isError($err = $appCore->loadModule('Forms'))){echo($appCore->getLastErrorMessage()); exit;}
	
	// Czyszczenie ostatniego bdu aby sprawdzi czy podczas tworzenia obiektu 
	// formularza nie zosta wygenrowany bd
	$appCore->clearLastErrorMessage();
	$formObj = new Forms('admin/dict/dict_tax_update_1.xml');
	if($appCore->getLastErrorMessage() != '') { 
		echo($appCore->getLastErrorMessage());
		exit;
	}
	// Pobranie etykiet
	$windowTitle = $appCore->getMessage('dict_tax', 'deleteWindow_title');
	$smarty->assign('windowTitle', $windowTitle['VALUE']);

	$formObj = new Forms('admin/dict/dict_tax_update_2.xml');

	if (isSet($_POST['tax_currentid']) && !PEAR::isError(Object::parseVar($_POST['tax_currentid'], 'id'))) {
		if (PEAR::isError($result = Tax::deleteData($_POST['tax_currentid']))) {
			$appCore->handleError($result);
			$errorMsg = 'UWAGA: ' . $appCore->getLastErrorMessage();
		} else {
			$msg = $appCore->getMessage('dict_tax','tax_deleted_successfully');
			$errorMsg = $msg['VALUE'];
		}
	} else {
		$msg = $appCore->getMessage('error',-5);
		$errorMsg = $msg['VALUE'];
	}

	$smarty->assign('errorMsg', $errorMsg);
	// Dokument zawierajcy szablon
	$adminContent = 'dict/dict_tax_update_2.tpl';

	$smarty->assign_by_ref('form', $formObj);
// Uaktualnianie danych stawki podatku VAT
} elseif (isSet($_POST['tax_update']) && isSet($_SESSION['tax_updated']) && $_SESSION['tax_updated'] == 1) {
	session_unregister('tax_updated');
	if (PEAR::isError($err = $appCore->loadModule('Forms'))){echo($appCore->getLastErrorMessage()); exit;}
	
	// Czyszczenie ostatniego bdu aby sprawdzi czy podczas tworzenia obiektu 
	// formularza nie zosta wygenrowany bd
	$appCore->clearLastErrorMessage();
	$formObj = new Forms('admin/dict/dict_tax_update_1.xml');
	if($appCore->getLastErrorMessage() != '') { 
		echo($appCore->getLastErrorMessage());
		exit;
	}

	$windowTitle = $appCore->getMessage('dict_tax', 'updateWindow_title');
	$smarty->assign('windowTitle', $windowTitle['VALUE']); 

	if (isSet($_POST['tax_currentid']) && !PEAR::isError(Object::parseVar($_POST['tax_currentid'], 'id'))) {
		$taxdata['tax_id'] = $_POST['tax_currentid'];
		$taxdata['usr_id'] = $_SESSION['CurrentUser']->getId();
		if (isSet($_POST['tax_value'])) { $taxdata['tax_value'] = $_POST['tax_value'];}
		if (isSet($_POST['tax_desc'])) { $taxdata['tax_desc'] = $_POST['tax_desc'];}
		$taxdata['tax_lastmodifydate'] = date(DATE_FORMAT_DBSAVE);
		if (isSet($_POST['tax_default'])) { 
			$taxdata['tax_default'] = 1;
		} else { $taxdata['tax_default'] = 0;}
		if (isSet($_POST['tax_active'])) { 
			$taxdata['tax_active'] = 1;
		} else { $taxdata['tax_active'] = 0;}

		if (PEAR::isError($tax = new Tax($taxdata))){
			$formObj = new Forms('admin/dict/dict_tax_update_2.xml');
			$appCore->handleError($result);
			$errorMsg = 'UWAGA: ' . $appCore->getLastErrorMessage();

			$smarty->assign('errorMsg', $errorMsg);

			// Dokument zawierajcy szablon
			$adminContent = 'dict/dict_tax_update_2.tpl';
		} else {
			$result = array();
			$formObj->checkForm($result);
			//Walidacja formularza wykazaa bdy
			if (count($result)!=0) {
				// Zarejestrowanie pomocniczych zmiennych sesyjnych
				session_register('tax_updated');
				session_register('tax_deleted'); 
				$_SESSION['tax_updated'] = 1;
				$_SESSION['tax_deleted'] = 1;
			
				$errorMsg = NULL;
				foreach ($result as $key => $value) {
					$errorMsg .= $value[1] . '<br/>';
				}
				$smarty->assign('errorMsg', $errorMsg);
print_r($_POST);
				if (isSet($_POST['tax_currentid'])) {
					if (!PEAR::isError(Object::parseVar($_POST['tax_currentid'], 'id'))) {
						$currentTax = current(Tax::getData($_POST['tax_currentid'], 'all'));
						// Ustalenie stanu domylnoci stawki podatku
						if (isSet($_POST['tax_default'])) { 
							$formObj->setValueArray('tax_default', array(array('true', 'taxdefault', 'right', TRUE)));
						} else {
							$formObj->setValueArray('tax_default', array(array('true', 'taxdefault', 'right')));
						}

						// Ustalenie aktywnoci stawki podatku
						if (isSet($_POST['tax_active'])) { 
							$formObj->setValueArray('tax_active', array(array('true', 'taxactive', 'right', TRUE)));
						} else {
							$formObj->setValueArray('tax_active', array(array('true', 'taxactive', 'right')));
						}
						$formObj->setValueArray('current_id', $_POST['tax_currentid']);
					}
				}

				// Dokument zawierajcy szablon
				$adminContent = 'dict/dict_tax_update_1.tpl';
			} else {
				$formObj = new Forms('admin/dict/dict_tax_update_2.xml');

				if (PEAR::isError($result = $tax->updateData())) {
					$appCore->handleError($result);
					$errorMsg = 'UWAGA: ' . $appCore->getLastErrorMessage();
				} else {
					$msg = $appCore->getMessage('dict_tax','tax_updated_successfully');
					$errorMsg = $msg['VALUE'];
				}
				$smarty->assign('errorMsg', $errorMsg);

				// Dokument zawierajcy szablon
				$adminContent = 'dict/dict_tax_update_2.tpl';
			}
		}
	} else {
		$formObj = new Forms('admin/dict/dict_tax_update_2.xml');
		$msg = $appCore->getMessage('error',-5);
		$errorMsg = $msg['VALUE'];

		$smarty->assign('errorMsg', $errorMsg);

		// Dokument zawierajcy szablon
		$adminContent = 'dict/dict_tax_update_2.tpl';
	}
	$smarty->assign_by_ref('form', $formObj);
} elseif (isSet($_GET['tax_id'])) {
	// Zarejestrowanie pomocniczych zmiennych sesyjnych
	session_register('tax_updated');
	session_register('tax_deleted'); 
	$_SESSION['tax_updated'] = 1;
	$_SESSION['tax_deleted'] = 1;

    // Zaadowanie moduu formularza
	if (PEAR::isError($err = $appCore->loadModule('Forms'))){echo($appCore->getLastErrorMessage()); exit;}

	// Czyszczenie ostatniego bdu aby sprawdzi czy podczas tworzenia obiektu 
	// formularza nie zosta wygenrowany bd
	$appCore->clearLastErrorMessage();
	$formObj = new Forms('admin/dict/dict_tax_update_1.xml');
	if($appCore->getLastErrorMessage() != '') { 
		echo($appCore->getLastErrorMessage());
		exit;
	}

	$windowTitle = $appCore->getMessage('dict_tax', 'updateWindow_title');
	$smarty->assign('windowTitle', $windowTitle['VALUE']);
	 
	if (isSet($_GET['tax_id'])) {
		if (!PEAR::isError(Object::parseVar($_GET['tax_id'], 'id'))) {
			$currentTax = current(Tax::getData($_GET['tax_id'], 'all'));
			$formObj->setValueArray('tax_value', number_format($currentTax->getValue(), 0));
			$formObj->setValueArray('tax_desc', $currentTax->getDesc());
			$formObj->setValueArray('tax_default', array($currentTax->getDefault()));

			// Ustalenie stanu domylnoci stawki podatku
			if ($currentTax->getDefault() == 0) { 
				$formObj->setValueArray('tax_default', array(array('true', 'taxdefault', 'right')));
			} else {
				$formObj->setValueArray('tax_default', array(array('true', 'taxdefault', 'right', TRUE)));
			}

			// Ustalenie aktywnoci stawki podatku
			if ($currentTax->getActive() == 0) { 
				$formObj->setValueArray('tax_active', array(array('true', 'taxactive', 'right')));
			} else {
				$formObj->setValueArray('tax_active', array(array('true', 'taxactive', 'right', TRUE)));
			}
			$formObj->setValueArray('current_id', $_GET['tax_id']);
		}
	}
	
	$smarty->assign_by_ref('form', $formObj);

	// Dokument zawierajcy szablon
	$adminContent = 'dict/dict_tax_update_1.tpl';
// Anulowanie akcji
} else {
	header("Location: ?menu=1f2dd94a5c7f3133f16ce4a05ed71501");
}

?>