<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+

include_once("dict_menu.php");

// Pobranie etykiet
$newProducer_link = $appCore->getMessage('dict_producer', 'newProducer_link');
$newAddress_link = $appCore->getMessage('dict_producer', 'newAddress_link');
$showFilter_label = $appCore->getMessage('dict_producer', 'showFilter_label');
$filterActive_link = $appCore->getMessage('dict_producer', 'filterActive_link');
$filterNonactive_link = $appCore->getMessage('dict_producer', 'filterNonactive_link');
$filterAll_link = $appCore->getMessage('dict_producer', 'filterAll_link');
$smarty->assign('newProducer_link', $newProducer_link['VALUE']);
$smarty->assign('newAddress_link', $newAddress_link['VALUE']);
$smarty->assign('showFilter_label', $showFilter_label['VALUE']);
$smarty->assign('filterActive_link', $filterActive_link['VALUE']);
$smarty->assign('filterNonactive_link', $filterNonactive_link['VALUE']);
$smarty->assign('filterAll_link', $filterAll_link['VALUE']);

// Usunicie producenta ze sownika
if (isSet($_POST['producer_delete']) && isSet($_SESSION['producer_deleted']) && $_SESSION['producer_deleted'] == 1) {
	session_unregister('producer_deleted');
	if (PEAR::isError($err = $appCore->loadModule('Forms'))){echo($appCore->getLastErrorMessage()); exit;}
	
	// Czyszczenie ostatniego bdu aby sprawdzi czy podczas tworzenia obiektu 
	// formularza nie zosta wygenrowany bd
	$appCore->clearLastErrorMessage();
	$formObj = new Forms('admin/dict/dict_producer_update_1.xml');
	if($appCore->getLastErrorMessage() != '') { 
		echo($appCore->getLastErrorMessage());
		exit;
	}
	// Pobranie etykiet
	$windowTitle = $appCore->getMessage('dict_producer', 'deleteWindow_title');
	$smarty->assign('windowTitle', $windowTitle['VALUE']);

	$formObj = new Forms('admin/dict/dict_producer_update_2.xml');

	if (isSet($_POST['producer_currentid']) && !PEAR::isError(Object::parseVar($_POST['producer_currentid'], 'id'))) {
		if (PEAR::isError($result = Producer::deleteData($_POST['producer_currentid']))) {
			$appCore->handleError($result);
			$errorMsg = $appCore->getLastErrorMessage();
		} else {
			$msg = $appCore->getMessage('dict_producer','producer_deleted_successfully');
			$errorMsg = $msg['VALUE'];
		}
	} else {
		$msg = $appCore->getMessage('error',-5);
		$errorMsg = $msg['VALUE'];
	}

	$smarty->assign('errorMsg', $errorMsg);
	// Dokument zawierajcy szablon
	$adminContent = 'dict/dict_producer_update_2.tpl';

	$smarty->assign_by_ref('form', $formObj);
// Uaktualnianie danych producenta
} elseif (isSet($_POST['producer_update']) && isSet($_SESSION['producer_updated']) && $_SESSION['producer_updated'] == 1) {
	if (PEAR::isError($err = $appCore->loadModule('Forms'))){echo($appCore->getLastErrorMessage()); exit;}
	
	// Czyszczenie ostatniego bdu aby sprawdzi czy podczas tworzenia obiektu 
	// formularza nie zosta wygenrowany bd
	$appCore->clearLastErrorMessage();
	$formObj = new Forms('admin/dict/dict_producer_update_1.xml');
	if($appCore->getLastErrorMessage() != '') { 
		echo($appCore->getLastErrorMessage());
		exit;
	}

	$windowTitle = $appCore->getMessage('dict_producer', 'updateWindow_title');
	$smarty->assign('windowTitle', $windowTitle['VALUE']); 

	//$formObj = new Forms('admin/dict/dict_producer_update_2.xml');

	if (isSet($_SESSION['currentProducer'])) {
        $_SESSION['currentProducer']->setOwner($_SESSION['CurrentUser']->getId());
        if (isSet($_POST['producer_name'])) { $_SESSION['currentProducer']->setName($_POST['producer_name']);}
        if (isSet($_POST['producer_desc'])) { $_SESSION['currentProducer']->setDesc($_POST['producer_desc']);}
        if (isSet($_POST['producer_url'])) { $_SESSION['currentProducer']->setURL($_POST['producer_url']);}
        if (isSet($_POST['producer_email'])) { $_SESSION['currentProducer']->setEmail($_POST['producer_email']);}
        if (isSet($_POST['producer_active'])) { 
            $_SESSION['currentProducer']->setActive('true');
        } else { $_SESSION['currentProducer']->setActive('false');}

		//Walidacja danych producenta
        $result = array();
        $formObj->checkForm($result);
        if (count($result)!=0) {
            //session_unregister('newProducer');
            $errorMsg = NULL;
            foreach ($result as $key => $value) {
                $errorMsg .= $value[1] . '<br/>';
            }

			if (!isSet($_SESSION['currentProducer'])) {
				$currentProducer = current(Producer::getData($_GET['producer_id'], 'all'));
				session_register('$currentProducer');
				$_SESSION['currentProducer'] = $currentProducer;			
			}

			$formObj->setValueArray('producer_name', $_SESSION['currentProducer']->getName());
			$formObj->setValueArray('producer_desc', $_SESSION['currentProducer']->getDesc());
			$formObj->setValueArray('producer_url', $_SESSION['currentProducer']->getURL());
			$formObj->setValueArray('producer_email', $_SESSION['currentProducer']->getEmail());
			// Ustalenie aktywnoci producenta
			if ($_SESSION['currentProducer']->getActive() == 0) { 
				$formObj->setValueArray('producer_active', array(array('true', 'produceractive', 'right')));
			} else {
				$formObj->setValueArray('producer_active', array(array('true', 'produceractive', 'right', TRUE)));
			}
			$formObj->setValueArray('current_id', $_SESSION['currentProducer']->getId());
			$addresses = $_SESSION['currentProducer']->getAddresses();
			$smarty->assign_by_ref('address_list', $addresses);

            $smarty->assign('errorMsg', $errorMsg);

            $formObj->setFormAction('?menu=' . $_GET['menu'] . '&producer_id=' . $_SESSION['currentProducer']->getId());

            // Dokument zawierajcy szablon
            $adminContent = 'dict/dict_producer_update_1.tpl';
        } else {
            if (PEAR::isError($result = $_SESSION['currentProducer']->updateData())) {
                $appCore->handleError($result);
                $errorMsg = $appCore->getLastErrorMessage();
            } else {
                session_unregister('producer_updated');
                session_unregister('producer_deleted');
                $msg = $appCore->getMessage('dict_producer','producer_updated_successfully');
                $errorMsg = $msg['VALUE'];
                session_unregister('currentProducer');
            }
            $smarty->assign('errorMsg', $errorMsg);
            $formObj = new Forms('admin/dict/dict_producer_update_2.xml');
            // Dokument zawierajcy szablon
            $adminContent = 'dict/dict_producer_update_2.tpl';
        }
	} else {
		// Dokument zawierajcy szablon
		$adminContent = 'dict/dict_producer_update_2.tpl';
		$msg = $appCore->getMessage('error',-5);
		$errorMsg = $msg['VALUE'];

		$smarty->assign('errorMsg', $errorMsg);
	}

	$smarty->assign_by_ref('form', $formObj);
// Wywieltenie formularza z danymi producenta
} elseif (isSet($_GET['producer_id']) || isSet($_SESSION['currentProducer'])) {
	// Zarejestrowanie pomocniczych zmiennych sesyjnych
	session_register('producer_updated');
	session_register('producer_deleted'); 
	$_SESSION['producer_updated'] = 1;
	$_SESSION['producer_deleted'] = 1;
	$result = array();

    // Zaadowanie moduu formularza
	if (PEAR::isError($err = $appCore->loadModule('Forms'))){echo($appCore->getLastErrorMessage()); exit;}

	$windowTitle = $appCore->getMessage('dict_producer', 'updateWindow_title');
	$smarty->assign('windowTitle', $windowTitle['VALUE']);
	 
	if (!PEAR::isError(Object::parseVar($_GET['producer_id'], 'id')) || isSet($_SESSION['currentProducer'])) {
		// Dodanie nowego adresu do producenta 
		if (isSet($_POST['address_add']) && !isSet($_SESSION['address_saved'])) {
			// Czyszczenie ostatniego bdu aby sprawdzi czy podczas tworzenia 
			// obiektu formularza nie zosta wygenrowany bd
			$appCore->clearLastErrorMessage();
			$formObj = new Forms('admin/dict/dict_producer_address_new_1.xml');
			if($appCore->getLastErrorMessage() != '') { 
				echo($appCore->getLastErrorMessage());
				exit;
			}
			$addressdata = array();
			$addressdata['addr_id'] = md5 (uniqid (rand()));
			$addressdata['usr_id'] = $_SESSION['CurrentUser']->getId();
			if (isSet($_POST['address_type'])) { $addressdata['adt_id'] = $_POST['address_type'];}
			if (isSet($_POST['address_streetname'])) { $addressdata['addr_streetname'] = $_POST['address_streetname'];}
			if (isSet($_POST['address_streetnr'])) { $addressdata['addr_streetnr'] = $_POST['address_streetnr'];}
			if (isSet($_POST['address_homenr'])) { $addressdata['addr_homenr'] = $_POST['address_homenr'];}
			if (isSet($_POST['address_city'])) { $addressdata['addr_city'] = $_POST['address_city'];}
			if (isSet($_POST['address_zip'])) { $addressdata['addr_zip'] = $_POST['address_zip'];}
			if (isSet($_POST['address_country'])) { $addressdata['cry_id'] = $_POST['address_country'];}
			if (isSet($_POST['address_state'])) { $addressdata['st_id'] = $_POST['address_state'];}
			if (isSet($_POST['address_phone'])) { $addressdata['addr_phone'] = $_POST['address_phone'];}
			if (isSet($_POST['address_fax'])) { $addressdata['addr_fax'] = $_POST['address_fax'];}
			$addressdata['addr_createdate'] = date(DATE_FORMAT_DBSAVE);
			if (isSet($_POST['address_active'])) { $addressdata['addr_active'] = $_POST['address_active'];}
			$newAddress = new Address($addressdata);
		
			//Walidacja danych adresu
			$formObj->checkForm($result);
			if (count($result)!=0) {
				$errorMsg = NULL;
				foreach ($result as $key => $value) {
					$errorMsg .= $value[1] . '<br/>';
				}
				$smarty->assign('errorMsg', $errorMsg);
	
				// Okrelenie typw adresu
				$type_list = AddressType::getData();
				$types = array(
	  							array('start', 'Wybierz typ adresu...'));
				foreach ($type_list as $key => $value) {
					$types[] = array($value->getId(), $value->getName());
				}
				$formObj->setValueArray('type', $types);

				// Okrelenie listy wojewdztw
				$state_list = State::getData();
				$states = array(
	  							array('start', 'Wybierz wojewdztwo...'));
				foreach ($state_list as $key => $value) {
					$states[] = array($value->getId(), $value->getName());
				}
				$formObj->setValueArray('state', $states);

				// Okrelenie listy pastw
				$country_list = Country::getData();
				$countries = array(
					  			array('start', 'Wybierz pastwo...'));
				foreach ($country_list as $key => $value) {
					$countries[] = array($value->getId(), $value->getName());
				}
				$formObj->setValueArray('country', $countries);

				$formObj->setFormAction('?menu=1f2dd94a5c7f3133f16ce4a05ed71484&producer_id=' . $_SESSION['currentProducer']->getId());
				// Dokument zawierajcy szablon
				$adminContent = 'dict/dict_producer_address_new_1.tpl';
			} else {
				session_register('address_saved'); 
				$_SESSION['address_saved'] = 1;			
			}
		}
		// Modyfikacja danych adresu producenta 
		if (isSet($_POST['address_update']) && !isSet($_SESSION['address_updated'])) {
			// Czyszczenie ostatniego bdu aby sprawdzi czy podczas tworzenia 
			// obiektu formularza nie zosta wygenrowany bd
			$appCore->clearLastErrorMessage();
			$formObj = new Forms('admin/dict/dict_producer_address_update_1.xml');
			if($appCore->getLastErrorMessage() != '') { 
				echo($appCore->getLastErrorMessage());
				exit;
			}

			//Walidacja danych adresu
			$formObj->checkForm($result);
			// W formularzu wystpuje bd
			if (count($result)!=0) {
				$errorMsg = NULL;
				foreach ($result as $key => $value) {
					$errorMsg .= $value[1] . '<br/>';
				}
				$smarty->assign('errorMsg', $errorMsg);
	
				$addr_obj = $_SESSION['currentProducer']->_Address[$_GET['address_id']];
				$formObj->setValueArray('address_streetname', $addr_obj->getStreetName());
				$formObj->setValueArray('address_streetnr', $addr_obj->getStreetNr());
				$formObj->setValueArray('address_homenr', $addr_obj->getHomeNr());
				$formObj->setValueArray('address_city', $addr_obj->getCity());
				$formObj->setValueArray('address_zip', $addr_obj->getZIP());
				$formObj->setValueArray('address_phone', $addr_obj->getPhone());
				$formObj->setValueArray('address_fax', $addr_obj->getFax());
				// Okrelenie typw adresu
				$types = array(
	  							array('start', 'Wybierz typ adresu...'));
				if ($addr_obj->_addressType <> NULL) {
					AddressType::prepareComboBoxValues($types, 'active', $addr_obj->_addressType->getId());				
				} else { AddressType::prepareComboBoxValues($types, 'active');}
				$formObj->setValueArray('type', $types);

				// Okrelenie listy wojewdztw
				$states = array(
	  							array('start', 'Wybierz wojewdztwo...'));
				if ($addr_obj->_state <> NULL) {
					State::prepareComboBoxValues($states, TRUE, $addr_obj->_state->getId());				
				} else { State::prepareComboBoxValues($states, TRUE);}
				$formObj->setValueArray('state', $states);

				// Okrelenie listy pastw
				$countries = array(
	  							array('start', 'Wybierz pastwo...'));
				if ($addr_obj->_country <> NULL) {
					Country::prepareComboBoxValues($countries, TRUE, $addr_obj->_country->getId());				
				} else { Country::prepareComboBoxValues($countries, TRUE);}
				$formObj->setValueArray('country', $countries);

				$formObj->setFormAction('?menu=1f2dd94a5c7f3133f16ce4a05ed71484&producer_id=' . $_SESSION['currentProducer']->getId() . '&address_id=' . $_GET['address_id']);
				// Dokument zawierajcy szablon
				$adminContent = 'dict/dict_producer_address_update_1.tpl';
			// Dane w formularzu s poprawne
			} else {
				$addr_obj = &$_SESSION['currentProducer']->_Address[$_GET['address_id']];
				$addr_obj->setOwner($_SESSION['CurrentUser']->getId());
				if (isSet($_POST['address_type'])) { $addr_obj->setAddressType($_POST['address_type']);}
				if (isSet($_POST['address_streetname'])) { $addr_obj->setStreetName($_POST['address_streetname']);}
				if (isSet($_POST['address_streetnr'])) { $addr_obj->setStreetNr($_POST['address_streetnr']);}
				if (isSet($_POST['address_homenr'])) { $addr_obj->setHomeNr($_POST['address_homenr']);}
				if (isSet($_POST['address_city'])) { $addr_obj->setCity($_POST['address_city']);}
				if (isSet($_POST['address_zip'])) { $addr_obj->setZIP($_POST['address_zip']);}
				if (isSet($_POST['address_country'])) { $addr_obj->setCountry($_POST['address_country']);}
				if (isSet($_POST['address_state'])) { $addr_obj->setState($_POST['address_state']);}
				if (isSet($_POST['address_phone'])) { $addr_obj->setPhone($_POST['address_phone']);}
				if (isSet($_POST['address_fax'])) { $addr_obj->setFax($_POST['address_fax']);}
				$addr_obj->setLastModifyDate(date(DATE_FORMAT_DBSAVE));
				if (isSet($_POST['address_active'])) { $addr_obj->setActive($_POST['address_active']);}
				$addr_obj->updateData();
				session_register('address_updated'); 
				$_SESSION['address_updated'] = 1;			
			}
		}
		// Usunicie adresu producenta 
		if (isSet($_POST['address_delete']) && !isSet($_SESSION['address_deleted'])) {
			$_SESSION['currentProducer']->deleteAddress($_SESSION['currentProducer']->_Address[$_GET['address_id']]->getId(), 'producer');
			$_SESSION['currentProducer']->getAddressData();
			session_register('address_deleted'); 
			$_SESSION['address_updated'] = 1;
		}
		// Brak bdw walidacji formularza adresu
		if (count($result) == 0) {
			// Czyszczenie ostatniego bdu aby sprawdzi czy podczas tworzenia 
			// obiektu formularza nie zosta wygenrowany bd
			$appCore->clearLastErrorMessage();
			$formObj = new Forms('admin/dict/dict_producer_update_1.xml');
			if($appCore->getLastErrorMessage() != '') { 
				echo($appCore->getLastErrorMessage());
				exit;
			}
			if (!isSet($_SESSION['currentProducer'])) {
				$currentProducer = current(Producer::getData($_GET['producer_id'], 'all'));
				session_register('$currentProducer');
				$_SESSION['currentProducer'] = $currentProducer;			
			}

			$formObj->setValueArray('producer_name', $_SESSION['currentProducer']->getName());
			$formObj->setValueArray('producer_desc', $_SESSION['currentProducer']->getDesc());
			$formObj->setValueArray('producer_url', $_SESSION['currentProducer']->getURL());
			$formObj->setValueArray('producer_email', $_SESSION['currentProducer']->getEmail());
			// Ustalenie aktywnoci producenta
			if ($_SESSION['currentProducer']->getActive() == 0) { 
				$formObj->setValueArray('producer_active', array(array('true', 'produceractive', 'right')));
			} else {
				$formObj->setValueArray('producer_active', array(array('true', 'produceractive', 'right', TRUE)));
			}
			$formObj->setValueArray('current_id', $_SESSION['currentProducer']->getId());
			if (isSet($newAddress)) $_SESSION['currentProducer']->addAddress($newAddress);
			$addresses = $_SESSION['currentProducer']->getAddresses();
			$smarty->assign_by_ref('address_list', $addresses);

			// Dokument zawierajcy szablon
			$adminContent = 'dict/dict_producer_update_1.tpl';		
		}

		$smarty->assign_by_ref('form', $formObj);
	// Nieprawidlowy identyfikator producenta
	} else {
	
	}
// Anulowanie akcji
} else {
	header("Location: ?menu=1f2dd94a5c7f3133f16ce4a05ed71483");
}

?>