<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+

include_once("dict_menu.php");

// Pobranie etykiet
$newProducer_link = $appCore->getMessage('dict_producer', 'newProducer_link');
$showFilter_label = $appCore->getMessage('dict_producer', 'showFilter_label');
$filterActive_link = $appCore->getMessage('dict_producer', 'filterActive_link');
$filterNonactive_link = $appCore->getMessage('dict_producer', 'filterNonactive_link');
$filterAll_link = $appCore->getMessage('dict_producer', 'filterAll_link');
$smarty->assign('newProducer_link', $newProducer_link['VALUE']);
$smarty->assign('showFilter_label', $showFilter_label['VALUE']);
$smarty->assign('filterActive_link', $filterActive_link['VALUE']);
$smarty->assign('filterNonactive_link', $filterNonactive_link['VALUE']);
$smarty->assign('filterAll_link', $filterAll_link['VALUE']);

$windowTitle = $appCore->getMessage('dict_producer', 'newWindow_title');
$smarty->assign('windowTitle', $windowTitle['VALUE']);

if (isSet($_SESSION['newProducer']) && isSet($_POST['producer_save'])) {
	if (PEAR::isError($result = $_SESSION['newProducer']->saveData())) {
		$appCore->handleError($result);
 		$errorMsg = 'UWAGA: ' . $appCore->getLastErrorMessage();
 	} else {
 		$msg = $appCore->getMessage('dict_producer','producer_created_successfully');
 		$errorMsg = $msg['VALUE'];
 	}

 	$smarty->assign('errorMsg', $errorMsg);

    // Zaadowanie moduu formularza
	if (PEAR::isError($err = $appCore->loadModule('Forms'))){echo($appCore->getLastErrorMessage()); exit;}

	// Czyszczenie ostatniego bdu aby sprawdzi czy podczas tworzenia obiektu 
	// formularza nie zosta wygenrowany bd
	$appCore->clearLastErrorMessage();
	$formObj = new Forms('admin/dict/dict_producer_new_3.xml');
	if($appCore->getLastErrorMessage() != '') { 
		echo($appCore->getLastErrorMessage());
		exit;
	}

	$smarty->assign_by_ref('form', $formObj);
	
	// Dokument zawierajcy szablon
	$adminContent = 'dict/dict_producer_new_3.tpl';

	$_SESSION['producer_saved'] == 0;
	session_unregister('producer_saved');
 
} elseif ((isSet($_POST['producer_new']) || isSet($_SESSION['newProducer'])) && (isSet($_SESSION['producer_saved']) && $_SESSION['producer_saved'] == 1)) {

	if (PEAR::isError($err = $appCore->loadModule('Forms'))){echo($appCore->getLastErrorMessage()); exit;}

	// Czyszczenie ostatniego bdu aby sprawdzi czy podczas tworzenia obiektu 
	// formularza nie zosta wygenrowany bd
	$appCore->clearLastErrorMessage();
	$formObj = new Forms('admin/dict/dict_producer_new_1.xml');
	if($appCore->getLastErrorMessage() != '') { 
		echo($appCore->getLastErrorMessage());
		exit;
	}
	// Stworzenie nowego obiektu producenta 
	if (isSet($_POST['producer_new'])) {
		if (!isSet($_SESSION['newProducer'])) {
			$producerdata = array();
			$producerdata['prc_id'] = md5 (uniqid (rand()));
			$producerdata['usr_id'] = $_SESSION['CurrentUser']->getId();
			if (isSet($_POST['producer_name'])) { $producerdata['prc_name'] = $_POST['producer_name'];}
			if (isSet($_POST['producer_desc'])) { $producerdata['prc_desc'] = $_POST['producer_desc'];}
			if (isSet($_POST['producer_url'])) { $producerdata['prc_url'] = $_POST['producer_url'];}
			if (isSet($_POST['producer_email'])) { $producerdata['prc_email'] = $_POST['producer_email'];}
			$producerdata['prc_createdate'] = date(DATE_FORMAT_DBSAVE);
			if (isSet($_POST['producer_active'])) { $producerdata['prc_active'] = $_POST['producer_active'];}
			session_register('newProducer');
			$_SESSION['newProducer'] = new Producer($producerdata);
			$_SESSION['newProducer'] = serialize($_SESSION['newProducer']);
			$_SESSION['newProducer'] = unserialize($_SESSION['newProducer']);
		}

		//Walidacja danych producenta
		if (isSet($_SESSION['newProducer'])) {
			$result = array();
			$formObj->checkForm($result);
			if (count($result)!=0) {
				session_unregister('newProducer');
				$errorMsg = NULL;
				foreach ($result as $key => $value) {
					$errorMsg .= $value[1] . '<br/>';
				}
				$smarty->assign('errorMsg', $errorMsg);

				// Dokument zawierajcy szablon
				$adminContent = 'dict/dict_producer_new_1.tpl';
			} else {
				$formObj = new Forms('admin/dict/dict_producer_new_2.xml');

				// Dokument zawierajcy szablon
				$adminContent = 'dict/dict_producer_new_2.tpl';
			}
		} else {
			$smarty->assign('errorMsg', $errorMsg);

			$_SESSION['producer_saved'] == 0;
			session_unregister('producer_saved');
	
			// Dokument zawierajcy szablon
			$adminContent = 'dict/dict_producer_new_3.tpl';
		}
	// Przypisanie adresu do producenta
	} elseif (isSet($_POST['address_add']) && !isSet($_SESSION['address_saved'])) {
		session_register('address_saved');
		$_SESSION['address_saved'] = 1;
		// Czyszczenie ostatniego bdu aby sprawdzi czy podczas tworzenia obiektu 
		// formularza nie zosta wygenrowany bd
		$appCore->clearLastErrorMessage();
		$formObj = new Forms('admin/dict/dict_producer_address_new_1.xml');
		if($appCore->getLastErrorMessage() != '') { 
			echo($appCore->getLastErrorMessage());
			exit;
		}

		$addressdata = array();
		$addressdata['addr_id'] = md5 (uniqid (rand()));
		$addressdata['usr_id'] = $_SESSION['CurrentUser']->getId();
		if (isSet($_POST['address_type'])) { $addressdata['adt_id'] = $_POST['address_type'];}
		if (isSet($_POST['address_streetname'])) { $addressdata['addr_streetname'] = $_POST['address_streetname'];}
		if (isSet($_POST['address_streetnr'])) { $addressdata['addr_streetnr'] = $_POST['address_streetnr'];}
		if (isSet($_POST['address_homenr'])) { $addressdata['addr_homenr'] = $_POST['address_homenr'];}
		if (isSet($_POST['address_city'])) { $addressdata['addr_city'] = $_POST['address_city'];}
		if (isSet($_POST['address_zip'])) { $addressdata['addr_zip'] = $_POST['address_zip'];}
		if (isSet($_POST['address_country'])) { $addressdata['cry_id'] = $_POST['address_country'];}
		if (isSet($_POST['address_state'])) { $addressdata['st_id'] = $_POST['address_state'];}
		if (isSet($_POST['address_phone'])) { $addressdata['addr_phone'] = $_POST['address_phone'];}
		if (isSet($_POST['address_fax'])) { $addressdata['addr_fax'] = $_POST['address_fax'];}
		$addressdata['addr_createdate'] = date(DATE_FORMAT_DBSAVE);
		if (isSet($_POST['address_active'])) { $addressdata['addr_active'] = $_POST['address_active'];}
		$newAddress = new Address($addressdata);

		//Walidacja danych adresu
		if (isSet($newAddress)) {
			$result = array();
			$formObj->checkForm($result);

			if (count($result)!=0) {
				$errorMsg = NULL;
				foreach ($result as $key => $value) {
					$errorMsg .= $value[1] . '<br/>';
				}
				$smarty->assign('errorMsg', $errorMsg);

				// Okrelenie typw adresu
				$type_list = AddressType::getData();
				$types = array(
	  							array('start', 'Wybierz typ adresu...'));
				foreach ($type_list as $key => $value) {
					$types[] = array($value->getId(), $value->getName());
				}
				$formObj->setValueArray('type', $types);

				// Okrelenie listy wojewdztw
				$state_list = State::getData();
                $states = array(
                                array('start', 'Wybierz wojewdztwo...'));
                foreach ($state_list as $key => $value) {
                    $states[] = array($value->getId(), $value->getName());
                }
                $formObj->setValueArray('state', $states);

                // Okrelenie listy pastw
                $country_list = Country::getData();
                $countries = array(
                                array('start', 'Wybierz pastwo...'));
                foreach ($country_list as $key => $value) {
                    $countries[] = array($value->getId(), $value->getName());
                }
                $formObj->setValueArray('country', $countries);
		
                if (isSet($_GET['menu'])) {
                    $menu = $_GET['menu'];
                } else { $menu = NULL;}
                if (isSet($_GET['prevmenu'])) {
                    $prevmenu = $_GET['prevmenu'];
                } else { $prevmenu = NULL;}

                $formObj->setFormAction('?menu=' . $menu . '&prevmenu=' . $prevmenu . '&producer_id=' . $_SESSION['newProducer']->getId());

				session_unregister('address_saved');
		 
				// Dokument zawierajcy szablon
				$adminContent = 'dict/dict_producer_address_new_1.tpl';
			} else {
				$_SESSION['newProducer']->addAddress($newAddress);
				$formObj = new Forms('admin/dict/dict_producer_new_2.xml');

				// Dokument zawierajcy szablon
				$adminContent = 'dict/dict_producer_new_2.tpl';
			}
		} else {
			$smarty->assign('errorMsg', $errorMsg);

			$_SESSION['producer_saved'] == 0;
			session_unregister('producer_saved');
	
			// Dokument zawierajcy szablon
			$adminContent = 'dict/dict_producer_new_3.tpl';
		}
	} else {
		$formObj = new Forms('admin/dict/dict_producer_new_2.xml');

		// Dokument zawierajcy szablon
		$adminContent = 'dict/dict_producer_new_2.tpl';
	}
	$smarty->assign_by_ref('form', $formObj);
	$smarty->assign_by_ref('newProducer', $_SESSION['newProducer']);	
} else {
	session_unregister('newProducer');
	session_unregister('producer_saved');

	if (!isSet($_SESSION['producer_saved'])) { session_register('producer_saved');}
	$_SESSION['producer_saved'] = 1;
    // Zaadowanie moduu formularza
	if (PEAR::isError($err = $appCore->loadModule('Forms'))){echo($appCore->getLastErrorMessage()); exit;}

	// Czyszczenie ostatniego bdu aby sprawdzi czy podczas tworzenia obiektu 
	// formularza nie zosta wygenrowany bd
	$appCore->clearLastErrorMessage();
	$formObj = new Forms('admin/dict/dict_producer_new_1.xml');
	if($appCore->getLastErrorMessage() != '') { 
		echo($appCore->getLastErrorMessage());
		exit;
	}

	$smarty->assign_by_ref('form', $formObj);

	// Dokument zawierajcy szablon
	$adminContent = 'dict/dict_producer_new_1.tpl';
}

?>