<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+


include_once("dict_menu.php");

// Pobranie etykiet
$windowTitle = $appCore->getMessage('dict_producer', 'updateAddressWindow_title');
$smarty->assign('windowTitle', $windowTitle['VALUE']);

if (isSet($_SESSION['address_updated'])) $_SESSION['address_updated'] = 0;
session_unregister('address_updated');

// Zaadowanie moduu formularza
if (PEAR::isError($err = $appCore->loadModule('Forms'))){echo($appCore->getLastErrorMessage()); exit;}

// Czyszczenie ostatniego bdu aby sprawdzi czy podczas tworzenia obiektu 
// formularza nie zosta wygenrowany bd
$appCore->clearLastErrorMessage();
$formObj = new Forms('admin/dict/dict_producer_address_update_1.xml');
if($appCore->getLastErrorMessage() != '') { 
	echo($appCore->getLastErrorMessage());
	exit;
}
$addr_obj = $_SESSION['currentProducer']->_Address[$_GET['address_id']];
$formObj->setValueArray('address_streetname', $addr_obj->getStreetName());
$formObj->setValueArray('address_streetnr', $addr_obj->getStreetNr());
$formObj->setValueArray('address_homenr', $addr_obj->getHomeNr());
$formObj->setValueArray('address_city', $addr_obj->getCity());
$formObj->setValueArray('address_zip', $addr_obj->getZIP());
$formObj->setValueArray('address_phone', $addr_obj->getPhone());
$formObj->setValueArray('address_fax', $addr_obj->getFax());

// Okrelenie typw adresu
$types = array(
	  			array('start', 'Wybierz typ adresu...'));
if ($addr_obj->_addressType <> NULL) {
	AddressType::prepareComboBoxValues($types, 'active', $addr_obj->_addressType->getId());
} else { AddressType::prepareComboBoxValues($types, 'active');}
$formObj->setValueArray('type', $types);

// Okrelenie listy wojewdztw
$states = array(
	  			array('start', 'Wybierz wojewdztwo...'));
if ($addr_obj->_state <> NULL) {
	State::prepareComboBoxValues($states, TRUE, $addr_obj->_state->getId());
} else { State::prepareComboBoxValues($states, TRUE);}
$formObj->setValueArray('state', $states);

// Okrelenie listy pastw
$countries = array(
	  			array('start', 'Wybierz pastwo...'));
if ($addr_obj->_country <> NULL) {
	Country::prepareComboBoxValues($countries, TRUE, $addr_obj->_country->getId());
} else { Country::prepareComboBoxValues($countries, TRUE);}
$formObj->setValueArray('country', $countries);

if (isSet($_GET['prevmenu'])) {
	$menu = $_GET['prevmenu'];
} else { $menu = NULL;}

$formObj->setFormAction('?menu=' . $menu . '&producer_id=' . $_SESSION['currentProducer']->getId() . '&address_id=' . $_GET['address_id']);
$smarty->assign_by_ref('form', $formObj);

// Dokument zawierajcy szablon
$adminContent = 'dict/dict_producer_address_update_1.tpl';

?>