<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+


include_once("dict_menu.php");

// Pobranie etykiet
$newCountry_link = $appCore->getMessage('dict_country', 'newCountry_link');
$showFilter_label = $appCore->getMessage('dict_country', 'showFilter_label');
$filterActive_link = $appCore->getMessage('dict_country', 'filterActive_link');
$filterNonactive_link = $appCore->getMessage('dict_country', 'filterNonactive_link');
$filterAll_link = $appCore->getMessage('dict_country', 'filterAll_link');
$smarty->assign('newCountry_link', $newCountry_link['VALUE']);
$smarty->assign('showFilter_label', $showFilter_label['VALUE']);
$smarty->assign('filterActive_link', $filterActive_link['VALUE']);
$smarty->assign('filterNonactive_link', $filterNonactive_link['VALUE']);
$smarty->assign('filterAll_link', $filterAll_link['VALUE']);

// Usunicie kraju ze sownika
if (isSet($_POST['country_delete']) && isSet($_SESSION['country_deleted']) && $_SESSION['country_deleted'] == 1) {
	session_unregister('country_deleted');
	if (PEAR::isError($err = $appCore->loadModule('Forms'))){echo($appCore->getLastErrorMessage()); exit;}
	
	// Czyszczenie ostatniego bdu aby sprawdzi czy podczas tworzenia obiektu 
	// formularza nie zosta wygenrowany bd
	$appCore->clearLastErrorMessage();
	$formObj = new Forms('admin/dict/dict_country_update_1.xml');
	if($appCore->getLastErrorMessage() != '') { 
		echo($appCore->getLastErrorMessage());
		exit;
	}
	// Pobranie etykiet
	$windowTitle = $appCore->getMessage('dict_country', 'deleteWindow_title');
	$smarty->assign('windowTitle', $windowTitle['VALUE']);

	$formObj = new Forms('admin/dict/dict_country_update_2.xml');

	if (isSet($_POST['country_currentid']) && !PEAR::isError(Object::parseVar($_POST['country_currentid'], 'id'))) {
		if (PEAR::isError($result = Country::deleteData($_POST['country_currentid']))) {
			$appCore->handleError($result);
			$errorMsg = $appCore->getLastErrorMessage();
		} else {
			$msg = $appCore->getMessage('dict_country','country_deleted_successfully');
			$errorMsg = $msg['VALUE'];
		}
	} else {
		$msg = $appCore->getMessage('error',-5);
		$errorMsg = $msg['VALUE'];
	}

	$smarty->assign('errorMsg', $errorMsg);
	// Dokument zawierajcy szablon
	$adminContent = 'dict/dict_country_update_2.tpl';

	$smarty->assign_by_ref('form', $formObj);
// Uaktualnianie danych kraju
} elseif (isSet($_POST['country_update']) && isSet($_SESSION['country_updated']) && $_SESSION['country_updated'] == 1) {
	session_unregister('country_updated');
	if (PEAR::isError($err = $appCore->loadModule('Forms'))){echo($appCore->getLastErrorMessage()); exit;}
	
	// Czyszczenie ostatniego bdu aby sprawdzi czy podczas tworzenia obiektu 
	// formularza nie zosta wygenrowany bd
	$appCore->clearLastErrorMessage();
	$formObj = new Forms('admin/dict/dict_country_update_1.xml');
	if($appCore->getLastErrorMessage() != '') { 
		echo($appCore->getLastErrorMessage());
		exit;
	}

	$windowTitle = $appCore->getMessage('dict_country', 'updateWindow_title');
	$smarty->assign('windowTitle', $windowTitle['VALUE']); 

	if (isSet($_POST['country_currentid']) && !PEAR::isError(Object::parseVar($_POST['country_currentid'], 'id'))) {
		$countrydata['cry_id'] = $_POST['country_currentid'];
		$countrydata['usr_id'] = $_SESSION['CurrentUser']->getId();
		if (isSet($_POST['country_name'])) { $countrydata['cry_name'] = $_POST['country_name'];}
		if (isSet($_POST['country_symbol'])) { $countrydata['cry_symbol'] = $_POST['country_symbol'];}
		$countrydata['cry_lastmodifydate'] = date(DATE_FORMAT_DBSAVE);
		if (isSet($_POST['country_active'])) { 
			$countrydata['cry_active'] = 1;
		} else { $countrydata['cry_active'] = 0;}

		if (PEAR::isError($country = new Country($countrydata))){
			$formObj = new Forms('admin/dict/dict_country_update_2.xml');
			$appCore->handleError($result);
			$errorMsg = $appCore->getLastErrorMessage();

			$smarty->assign('errorMsg', $errorMsg);

			// Dokument zawierajcy szablon
			$adminContent = 'dict/dict_country_update_2.tpl';
		} else {
			$result = array();
			$formObj->checkForm($result);
			//Walidacja formularza wykazaa bdy
			if (count($result)!=0) {
				// Zarejestrowanie pomocniczych zmiennych sesyjnych
				session_register('country_updated');
				session_register('country_deleted'); 
				$_SESSION['country_updated'] = 1;
				$_SESSION['country_deleted'] = 1;
			
				$errorMsg = NULL;
				foreach ($result as $key => $value) {
					$errorMsg .= $value[1] . '<br/>';
				}
				$smarty->assign('errorMsg', $errorMsg);
				if (isSet($_POST['country_currentid'])) {
					if (!PEAR::isError(Object::parseVar($_POST['country_currentid'], 'id'))) {
						$currentCountry = current(Country::getData($_POST['country_currentid'], 'all'));

						// Ustalenie aktywnoci kraju
						if (isSet($_POST['country_active'])) { 
							$formObj->setValueArray('country_active', array(array('true', 'countryactive', 'right', TRUE)));
						} else {
							$formObj->setValueArray('country_active', array(array('true', 'countryactive', 'right')));
						}
						$formObj->setValueArray('current_id', $_POST['country_currentid']);
					}
				}

				// Dokument zawierajcy szablon
				$adminContent = 'dict/dict_country_update_1.tpl';
			} else {
				$formObj = new Forms('admin/dict/dict_country_update_2.xml');

				if (PEAR::isError($result = $country->updateData())) {
					$appCore->handleError($result);
					$errorMsg = $appCore->getLastErrorMessage();
				} else {
					$msg = $appCore->getMessage('dict_country','country_updated_successfully');
					$errorMsg = $msg['VALUE'];
				}
				$smarty->assign('errorMsg', $errorMsg);

				// Dokument zawierajcy szablon
				$adminContent = 'dict/dict_country_update_2.tpl';
			}
		}
	} else {
		$formObj = new Forms('admin/dict/dict_country_update_2.xml');
		$msg = $appCore->getMessage('error',-5);
		$errorMsg = $msg['VALUE'];

		$smarty->assign('errorMsg', $errorMsg);

		// Dokument zawierajcy szablon
		$adminContent = 'dict/dict_country_update_2.tpl';
	}
	$smarty->assign_by_ref('form', $formObj);
} elseif (isSet($_GET['country_id'])) {
	// Zarejestrowanie pomocniczych zmiennych sesyjnych
	session_register('country_updated');
	session_register('country_deleted'); 
	$_SESSION['country_updated'] = 1;
	$_SESSION['country_deleted'] = 1;

    // Zaadowanie moduu formularza
	if (PEAR::isError($err = $appCore->loadModule('Forms'))){echo($appCore->getLastErrorMessage()); exit;}

	// Czyszczenie ostatniego bdu aby sprawdzi czy podczas tworzenia obiektu 
	// formularza nie zosta wygenrowany bd
	$appCore->clearLastErrorMessage();
	$formObj = new Forms('admin/dict/dict_country_update_1.xml');
	if($appCore->getLastErrorMessage() != '') { 
		echo($appCore->getLastErrorMessage());
		exit;
	}

	$windowTitle = $appCore->getMessage('dict_country', 'updateWindow_title');
	$smarty->assign('windowTitle', $windowTitle['VALUE']);
	 
	if (isSet($_GET['country_id'])) {
		if (!PEAR::isError(Object::parseVar($_GET['country_id'], 'id'))) {
			$currentCountry = current(Country::getData($_GET['country_id'], 'all'));
			$formObj->setValueArray('country_name', $currentCountry->getName());
			$formObj->setValueArray('country_symbol', $currentCountry->getSymbol());

			// Ustalenie aktywnoci kraju
			if ($currentCountry->getActive() == 0) { 
				$formObj->setValueArray('country_active', array(array('true', 'countryactive', 'right')));
			} else {
				$formObj->setValueArray('country_active', array(array('true', 'countryactive', 'right', TRUE)));
			}
			$formObj->setValueArray('current_id', $_GET['country_id']);
		}
	}
	
	$smarty->assign_by_ref('form', $formObj);

	// Dokument zawierajcy szablon
	$adminContent = 'dict/dict_country_update_1.tpl';
// Anulowanie akcji
} else {
	header("Location: ?menu=1f2dd94a5c7f3133f16ce4a05ed71485");
}

?>