<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+


include_once("dict_menu.php");

// Pobranie etykiet
$newAdt_link = $appCore->getMessage('dict_addresstype', 'newAdt_link');
$showFilter_label = $appCore->getMessage('dict_addresstype', 'showFilter_label');
$filterActive_link = $appCore->getMessage('dict_addresstype', 'filterActive_link');
$filterNonactive_link = $appCore->getMessage('dict_addresstype', 'filterNonactive_link');
$filterAll_link = $appCore->getMessage('dict_addresstype', 'filterAll_link');
$smarty->assign('newAdt_link', $newAdt_link['VALUE']);
$smarty->assign('showFilter_label', $showFilter_label['VALUE']);
$smarty->assign('filterActive_link', $filterActive_link['VALUE']);
$smarty->assign('filterNonactive_link', $filterNonactive_link['VALUE']);
$smarty->assign('filterAll_link', $filterAll_link['VALUE']);

// Usunicie kraju ze sownika
if (isSet($_POST['addresstype_delete']) && isSet($_SESSION['addresstype_deleted']) && $_SESSION['addresstype_deleted'] == 1) {
	session_unregister('addresstype_deleted');
	if (PEAR::isError($err = $appCore->loadModule('Forms'))){echo($appCore->getLastErrorMessage()); exit;}
	
	// Czyszczenie ostatniego bdu aby sprawdzi czy podczas tworzenia obiektu 
	// formularza nie zosta wygenrowany bd
	$appCore->clearLastErrorMessage();
	$formObj = new Forms('admin/dict/dict_addresstype_update_1.xml');
	if($appCore->getLastErrorMessage() != '') { 
		echo($appCore->getLastErrorMessage());
		exit;
	}
	// Pobranie etykiet
	$windowTitle = $appCore->getMessage('dict_addresstype', 'deleteWindow_title');
	$smarty->assign('windowTitle', $windowTitle['VALUE']);

	$formObj = new Forms('admin/dict/dict_addresstype_update_2.xml');

	if (isSet($_POST['addresstype_currentid']) && !PEAR::isError(Object::parseVar($_POST['addresstype_currentid'], 'id'))) {
		if (PEAR::isError($result = AddressType::deleteData($_POST['addresstype_currentid']))) {
			$appCore->handleError($result);
			$errorMsg = $appCore->getLastErrorMessage();
		} else {
			$msg = $appCore->getMessage('dict_addresstype','addresstype_deleted_successfully');
			$errorMsg = $msg['VALUE'];
		}
	} else {
		$msg = $appCore->getMessage('error',-5);
		$errorMsg = $msg['VALUE'];
	}

	$smarty->assign('errorMsg', $errorMsg);
	// Dokument zawierajcy szablon
	$adminContent = 'dict/dict_addresstype_update_2.tpl';

	$smarty->assign_by_ref('form', $formObj);
// Uaktualnianie danych typu adresu
} elseif (isSet($_POST['addresstype_update']) && isSet($_SESSION['addresstype_updated']) && $_SESSION['addresstype_updated'] == 1) {
	session_unregister('addresstype_updated');
	if (PEAR::isError($err = $appCore->loadModule('Forms'))){echo($appCore->getLastErrorMessage()); exit;}
	
	// Czyszczenie ostatniego bdu aby sprawdzi czy podczas tworzenia obiektu 
	// formularza nie zosta wygenrowany bd
	$appCore->clearLastErrorMessage();
	$formObj = new Forms('admin/dict/dict_addresstype_update_1.xml');
	if($appCore->getLastErrorMessage() != '') { 
		echo($appCore->getLastErrorMessage());
		exit;
	}

	$windowTitle = $appCore->getMessage('dict_addresstype', 'updateWindow_title');
	$smarty->assign('windowTitle', $windowTitle['VALUE']); 

	if (isSet($_POST['addresstype_currentid']) && !PEAR::isError(Object::parseVar($_POST['addresstype_currentid'], 'id'))) {
		$addresstypedata['adt_id'] = $_POST['addresstype_currentid'];
		$addresstypedata['usr_id'] = $_SESSION['CurrentUser']->getId();
		if (isSet($_POST['addresstype_name'])) { $addresstypedata['adt_name'] = $_POST['addresstype_name'];}
		$addresstypedata['adt_lastmodifydate'] = date(DATE_FORMAT_DBSAVE);
		if (isSet($_POST['addresstype_active'])) { 
			$addresstypedata['adt_active'] = 1;
		} else { $addresstypedata['adt_active'] = 0;}

		if (PEAR::isError($addresstype = new AddressType($addresstypedata))){
			$formObj = new Forms('admin/dict/dict_addresstype_update_2.xml');
			$appCore->handleError($result);
			$errorMsg = $appCore->getLastErrorMessage();

			$smarty->assign('errorMsg', $errorMsg);

			// Dokument zawierajcy szablon
			$adminContent = 'dict/dict_addresstype_update_2.tpl';
		} else {
			$result = array();
			$formObj->checkForm($result);
			//Walidacja formularza wykazaa bdy
			if (count($result)!=0) {
				// Zarejestrowanie pomocniczych zmiennych sesyjnych
				session_register('addresstype_updated');
				session_register('addresstype_deleted'); 
				$_SESSION['addresstype_updated'] = 1;
				$_SESSION['addresstype_deleted'] = 1;
			
				$errorMsg = NULL;
				foreach ($result as $key => $value) {
					$errorMsg .= $value[1] . '<br/>';
				}
				$smarty->assign('errorMsg', $errorMsg);
				if (isSet($_POST['addresstype_currentid'])) {
					if (!PEAR::isError(Object::parseVar($_POST['addresstype_currentid'], 'id'))) {
						$currentAddressType = current(AddressType::getData($_POST['addresstype_currentid'], 'all'));

						// Ustalenie aktywnoci kraju
						if (isSet($_POST['addresstype_active'])) { 
							$formObj->setValueArray('addresstype_active', array(array('true', 'addresstypeactive', 'right', TRUE)));
						} else {
							$formObj->setValueArray('addresstype_active', array(array('true', 'addresstypeactive', 'right')));
						}
						$formObj->setValueArray('current_id', $_POST['addresstype_currentid']);
					}
				}

				// Dokument zawierajcy szablon
				$adminContent = 'dict/dict_addresstype_update_1.tpl';
			} else {
				$formObj = new Forms('admin/dict/dict_addresstype_update_2.xml');

				if (PEAR::isError($result = $addresstype->updateData())) {
					$appCore->handleError($result);
					$errorMsg = $appCore->getLastErrorMessage();
				} else {
					$msg = $appCore->getMessage('dict_addresstype','addresstype_updated_successfully');
					$errorMsg = $msg['VALUE'];
				}
				$smarty->assign('errorMsg', $errorMsg);

				// Dokument zawierajcy szablon
				$adminContent = 'dict/dict_addresstype_update_2.tpl';
			}
		}
	} else {
		$formObj = new Forms('admin/dict/dict_addresstype_update_2.xml');
		$msg = $appCore->getMessage('error',-5);
		$errorMsg = $msg['VALUE'];

		$smarty->assign('errorMsg', $errorMsg);

		// Dokument zawierajcy szablon
		$adminContent = 'dict/dict_addresstype_update_2.tpl';
	}
	$smarty->assign_by_ref('form', $formObj);
} elseif (isSet($_GET['addresstype_id'])) {
	// Zarejestrowanie pomocniczych zmiennych sesyjnych
	session_register('addresstype_updated');
	session_register('addresstype_deleted'); 
	$_SESSION['addresstype_updated'] = 1;
	$_SESSION['addresstype_deleted'] = 1;

    // Zaadowanie moduu formularza
	if (PEAR::isError($err = $appCore->loadModule('Forms'))){echo($appCore->getLastErrorMessage()); exit;}

	// Czyszczenie ostatniego bdu aby sprawdzi czy podczas tworzenia obiektu 
	// formularza nie zosta wygenrowany bd
	$appCore->clearLastErrorMessage();
	$formObj = new Forms('admin/dict/dict_addresstype_update_1.xml');
	if($appCore->getLastErrorMessage() != '') { 
		echo($appCore->getLastErrorMessage());
		exit;
	}

	$windowTitle = $appCore->getMessage('dict_addresstype', 'updateWindow_title');
	$smarty->assign('windowTitle', $windowTitle['VALUE']);
	 
	if (isSet($_GET['addresstype_id'])) {
		if (!PEAR::isError(Object::parseVar($_GET['addresstype_id'], 'id'))) {
			$currentAddressType = current(AddressType::getData($_GET['addresstype_id'], 'all'));
			$formObj->setValueArray('addresstype_name', $currentAddressType->getName());

			// Ustalenie aktywnoci typu adresu
			if ($currentAddressType->getActive() == 0) { 
				$formObj->setValueArray('addresstype_active', array(array('true', 'addresstypeactive', 'right')));
			} else {
				$formObj->setValueArray('addresstype_active', array(array('true', 'addresstypeactive', 'right', TRUE)));
			}
			$formObj->setValueArray('current_id', $_GET['addresstype_id']);
		}
	}
	
	$smarty->assign_by_ref('form', $formObj);

	// Dokument zawierajcy szablon
	$adminContent = 'dict/dict_addresstype_update_1.tpl';
// Anulowanie akcji
} else {
	header("Location: ?menu=1f2dd94a5c7f3133f16ce4a05ed71497");
}

?>