-- MySQL dump 9.10
--
-- Host: localhost    Database: sklep
-- ------------------------------------------------------
-- Server version	4.0.17-log

--
-- Table structure for table `Address`
--
SET FOREIGN_KEY_CHECKS=0;

CREATE DATABASE sklep;
USE sklep;

DROP TABLE IF EXISTS Address;
CREATE TABLE Address (
  ADDR_Id varchar(32) NOT NULL default '',
  ADT_Id varchar(32) default NULL,
  CRY_Id varchar(32) default NULL,
  ST_Id varchar(32) default NULL,
  ADDR_StreetName varchar(50) NOT NULL default '',
  ADDR_StreetNr varchar(5) NOT NULL default '',
  ADDR_HomeNr varchar(5) default NULL,
  ADDR_City varchar(50) NOT NULL default '',
  ADDR_Zip varchar(10) NOT NULL default '',
  ADDR_Phone varchar(25) default NULL,
  ADDR_Fax varchar(25) default NULL,
  ADDR_CreateDate timestamp(14) NOT NULL,
  ADDR_LastModifyDate timestamp(14) NOT NULL,
  ADDR_Active tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (ADDR_Id),
  KEY addr_has_adt_FK (ADT_Id),
  KEY addr_has_cry_FK (CRY_Id),
  KEY addr_has_st_FK (ST_Id),
  CONSTRAINT `0_668` FOREIGN KEY (`ADT_Id`) REFERENCES `AddressType` (`ADT_Id`),
  CONSTRAINT `0_670` FOREIGN KEY (`CRY_Id`) REFERENCES `Country` (`CRY_Id`),
  CONSTRAINT `0_672` FOREIGN KEY (`ST_Id`) REFERENCES `State` (`ST_Id`)
) TYPE=InnoDB;

--
-- Dumping data for table `Address`
--


/*!40000 ALTER TABLE Address DISABLE KEYS */;
LOCK TABLES Address WRITE;
INSERT INTO Address VALUES ('0e93135b604815764c15dfc444a8e239','f3b1d62cc14dcab5e9647d89a6cd2652','629b49b0e201116fa9a26f9d9c47db7d','dcf0da138d42015931764d452d711277','Wojciechowska','1','2','Wojciechowice','00-000','','',00000000000000,00000000000000,1),('0e93c1b63237c2ba4c3d7c0a4d67c4a0','837d8dc1e00c1f9dda3a412c3a2bc8c9','3855bc1a990d2a15ca907921fa190583','e48889eded8be83352f07882cf43e586','Wodna','13','5','Pyry','11-117','235235896','2345234696',00000000000000,00000000000000,1),('3c0273caf8ebcbe9737efc1aeef5ff56','837d8dc1e00c1f9dda3a412c3a2bc8c9','629b49b0e201116fa9a26f9d9c47db7d','dcf0da138d42015931764d452d711277','Lenartowicza','12','','Bielsko-Biaa','43-300','','',00000000000000,00000000000000,1),('4519ccc7e53e897a69a6b820ca2b6823','0ebeef064c95489db59af759d7f1500f','629b49b0e201116fa9a26f9d9c47db7d','dcf0da138d42015931764d452d711277','GenMaczka','55','21','Bielsko-Biaa','43-300','','',00000000000000,00000000000000,1),('53bc029a30d7f11676ee0bb6857a60cc','0ebeef064c95489db59af759d7f1500f','9293fb86ec9408886b1c611645bdd6e9','a525d7a81b6c026a5b04f0a5a75e54ef','Beberoka','25','12','Bielsko-Biaa','43-300','','',00000000000000,00000000000000,1),('7676947b345f34b026824a16f2f9e9de','837d8dc1e00c1f9dda3a412c3a2bc8c9','629b49b0e201116fa9a26f9d9c47db7d','dcf0da138d42015931764d452d711277','Sternicza','28','15','Bielsko - Biaa','43-300','','',00000000000000,00000000000000,1),('b4dcda55c2a207acfade3dc89924aff0','f3b1d62cc14dcab5e9647d89a6cd2652','629b49b0e201116fa9a26f9d9c47db7d','dcf0da138d42015931764d452d711277','Sternicza','28','15','Bielsko - Biaa','43-30','','',00000000000000,00000000000000,1),('c53f4b0bc494aa28d74b9ce715a26fb7','0ebeef064c95489db59af759d7f1500f','629b49b0e201116fa9a26f9d9c47db7d','dcf0da138d42015931764d452d711277','Lenartowicza','12','22','Bielsko-Biaa','43-300','(33) 496-53-75','(33) 496-53-75',20040625152902,00000000000000,1);
UNLOCK TABLES;
/*!40000 ALTER TABLE Address ENABLE KEYS */;

--
-- Table structure for table `AddressType`
--

DROP TABLE IF EXISTS AddressType;
CREATE TABLE AddressType (
  ADT_Id varchar(32) NOT NULL default '',
  USR_Id varchar(32) default NULL,
  ADT_Name varchar(50) NOT NULL default '',
  ADT_CreateDate timestamp(14) NOT NULL,
  ADT_LastModifyDate timestamp(14) NOT NULL,
  ADT_Active tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (ADT_Id),
  KEY usr_add_adt_FK (USR_Id),
  CONSTRAINT `0_674` FOREIGN KEY (`USR_Id`) REFERENCES `Users` (`USR_Id`)
) TYPE=InnoDB;

--
-- Dumping data for table `AddressType`
--


/*!40000 ALTER TABLE AddressType DISABLE KEYS */;
LOCK TABLES AddressType WRITE;
INSERT INTO AddressType VALUES ('0ebeef064c95489db59af759d7f1500f','admin','Gwna siedziba firmy',20040523133513,00000000000000,1),('3c5611300e397cb6631ca46aab5bf8f4','admin','Filia firmy',20040629225054,20040629205054,1),('837d8dc1e00c1f9dda3a412c3a2bc8c9','admin','Adres korespondencyjny',20040615230117,20040615210117,1),('f3b1d62cc14dcab5e9647d89a6cd2652','admin','Adres zameldowania',20040523133440,00000000000000,1);
UNLOCK TABLES;
/*!40000 ALTER TABLE AddressType ENABLE KEYS */;

--
-- Table structure for table `Category`
--

DROP TABLE IF EXISTS Category;
CREATE TABLE Category (
  CAT_Id varchar(32) NOT NULL default '',
  CAT_Parent varchar(32) default NULL,
  USR_Id varchar(32) default NULL,
  CAT_Name varchar(50) NOT NULL default '',
  CAT_Desc text,
  CAT_CreateDate timestamp(14) NOT NULL,
  CAT_LastModifyDate timestamp(14) NOT NULL,
  CAT_Active tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (CAT_Id),
  KEY cat_has_subcat_FK (CAT_Parent),
  KEY usr_add_cat_FK (USR_Id),
  CONSTRAINT `0_678` FOREIGN KEY (`USR_Id`) REFERENCES `Users` (`USR_Id`),
  CONSTRAINT `0_676` FOREIGN KEY (`CAT_Parent`) REFERENCES `Category` (`CAT_Id`)
) TYPE=InnoDB;

--
-- Dumping data for table `Category`
--


/*!40000 ALTER TABLE Category DISABLE KEYS */;
LOCK TABLES Category WRITE;
INSERT INTO Category VALUES ('134d4f13e4ea7b77531d7de7259e8851',NULL,NULL,'Muzyka','Muzyka',20040527120629,20040527120629,1),('198cf8cc73fe67b92231521117642a5d',NULL,NULL,'Sprzt RTV','Sprzt RTV',20040527120604,20040527120604,1),('25737420ed4d41bf0f466ad2bd03c6ac','50d48f69ecf007ba67596ff71489d4e2',NULL,'Aplikacje internetowe','Aplikacje internetowe',20040522213036,20040522213036,1),('30328bf58f08bd4cd6f4c8403dffb8d6','50d48f69ecf007ba67596ff71489d4e2',NULL,'Aplikacje biurowe','Aplikacje biurowe',20040527120902,20040527120902,1),('321dde80e2431c975e6e63cc1fe18e62','134d4f13e4ea7b77531d7de7259e8851',NULL,'Blues','Blues',20040527120800,20040527120800,1),('41b4fe27bdd33beb9a84b5b91b669fbe','ba8034670decf7c249f82948efdc0aeb',NULL,'Poezja','Poezja',20040527120941,20040527120941,1),('4eb819b2b2fab92d4ca126e18d317c3f','79f9aaeee42e08636ee0d69ecfb9c125',NULL,'Komedia','Komedia',20040527120720,20040527120720,1),('50d48f69ecf007ba67596ff71489d4e2',NULL,NULL,'Oprogramowanie','Oprogramowanie',20040522213009,20040525192326,1),('5a39f52efd00e9c0f702827849d59c87','134d4f13e4ea7b77531d7de7259e8851',NULL,'Dance','Dance',20040527120809,20040527120809,1),('5b74700e4a7a229c2b2b9ebc9ae89461','ba8034670decf7c249f82948efdc0aeb',NULL,'Poradniki','Poradniki',20040527120952,20040527120952,1),('5d50880d01726c14ede83599f3afe26b',NULL,NULL,'Sprzt komputerowy','Sprzt komputerowy',20040522212453,20040525192738,1),('678a9bcb1897af64c156cd5754f3db8f',NULL,NULL,'Sprzt AGD','Sprzt AGD',20040527120549,20040527120549,1),('720fd64717053f38783e20dd80db6369','5d50880d01726c14ede83599f3afe26b',NULL,'Urzdzenia sieciowe','Urzdzenia sieciowe',20040522212513,20040522212513,1),('78dadab6c70035cd4c9881f797f413c3','50d48f69ecf007ba67596ff71489d4e2',NULL,'Systemy operacyjne','Systemy operacyjne',20040527120851,20040527120851,1),('79f9aaeee42e08636ee0d69ecfb9c125',NULL,NULL,'Film','Film',20040527120641,20040630173907,1),('7adc6ae81a53375314eb9534ed9430f6','79f9aaeee42e08636ee0d69ecfb9c125',NULL,'Horror','Horror',20040527120730,20040527120730,1),('7baea95395591ed9456e7705c41fe417','79f9aaeee42e08636ee0d69ecfb9c125',NULL,'Sensacja','Sensacja',20040527120709,20040527120709,1),('995dada6205fea50a980e54223b34d37','ba8034670decf7c249f82948efdc0aeb',NULL,'Albumy','Albumy',20040527121000,20040527121000,1),('a29b56008a6d56c1165bc9dbd4429896','79f9aaeee42e08636ee0d69ecfb9c125',NULL,'Dramat','Dramat',20040629203848,20040629203848,1),('a38ecc92641a21f5cd0fb970351227a2','50d48f69ecf007ba67596ff71489d4e2',NULL,'Gry i Multimedia','Gry i Multimedia',20040527120926,20040527120926,1),('ba8034670decf7c249f82948efdc0aeb',NULL,NULL,'Ksiki','Ksiki',20040527120535,20040630173916,1),('bc40a667c9f69609b5655e449a687a89','134d4f13e4ea7b77531d7de7259e8851',NULL,'Rock','Rock',20040527120750,20040527120750,1),('bdb33ae3d50e70d6bd96187dfde823af','134d4f13e4ea7b77531d7de7259e8851',NULL,'Klasyczna','Klasyczna',20040527120831,20040527120831,1),('e770d25e00d3f0d6cc1346dad6007336','5d50880d01726c14ede83599f3afe26b',NULL,'Napdy','Napdy',20040526121208,20040526121208,1),('fb9d98e857626a497b0e55e944a627bb','134d4f13e4ea7b77531d7de7259e8851',NULL,'Hip-Hop','Hip-Hop',20040527120822,20040527120822,1);
UNLOCK TABLES;
/*!40000 ALTER TABLE Category ENABLE KEYS */;

--
-- Table structure for table `Country`
--

DROP TABLE IF EXISTS Country;
CREATE TABLE Country (
  CRY_Id varchar(32) NOT NULL default '',
  USR_Id varchar(32) default NULL,
  CRY_Name varchar(50) NOT NULL default '',
  CRY_CreateDate timestamp(14) NOT NULL,
  CRY_LastModifyDate timestamp(14) NOT NULL,
  CRY_Symbol char(3) NOT NULL default '',
  CRY_Active tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (CRY_Id),
  KEY usr_add_cry_FK (USR_Id),
  CONSTRAINT `0_680` FOREIGN KEY (`USR_Id`) REFERENCES `Users` (`USR_Id`)
) TYPE=InnoDB;

--
-- Dumping data for table `Country`
--


/*!40000 ALTER TABLE Country DISABLE KEYS */;
LOCK TABLES Country WRITE;
INSERT INTO Country VALUES ('21989749cef82564b6d005cec6c6c60d','admin','Niemcy',20040614225938,20040614205938,'DE',1),('3855bc1a990d2a15ca907921fa190583','admin','Wielka Brytania',20040629222616,20040629202616,'GB',1),('629b49b0e201116fa9a26f9d9c47db7d','admin','Polska',20040629221728,20040629201728,'PL',0),('9293fb86ec9408886b1c611645bdd6e9','admin','Polska',20040629201917,00000000000000,'PL',1);
UNLOCK TABLES;
/*!40000 ALTER TABLE Country ENABLE KEYS */;

--
-- Table structure for table `Currency`
--

DROP TABLE IF EXISTS Currency;
CREATE TABLE Currency (
  CUR_Id varchar(32) NOT NULL default '',
  USR_Id varchar(32) default NULL,
  CUR_Name varchar(50) NOT NULL default '',
  CUR_Symbol char(3) NOT NULL default '',
  CUR_Default tinyint(1) NOT NULL default '0',
  CUR_CreateDate timestamp(14) NOT NULL,
  CUR_LastModifyDate timestamp(14) NOT NULL,
  CUR_Active tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (CUR_Id),
  KEY prd_add_cur_FK (USR_Id),
  CONSTRAINT `0_682` FOREIGN KEY (`USR_Id`) REFERENCES `Users` (`USR_Id`)
) TYPE=InnoDB;

--
-- Dumping data for table `Currency`
--


/*!40000 ALTER TABLE Currency DISABLE KEYS */;
LOCK TABLES Currency WRITE;
INSERT INTO Currency VALUES ('c71b8b214b4fa21e2f4ef3f5ca24ad73','admin','Polski zoty','PLN',0,20040525160540,20040525160540,1);
UNLOCK TABLES;
/*!40000 ALTER TABLE Currency ENABLE KEYS */;

--
-- Table structure for table `DeliveryType`
--

DROP TABLE IF EXISTS DeliveryType;
CREATE TABLE DeliveryType (
  DLT_Id varchar(32) NOT NULL default '',
  USR_Id varchar(32) default NULL,
  DLT_Name varchar(50) NOT NULL default '',
  DLT_Desc text,
  DLT_CreateDate timestamp(14) NOT NULL,
  DLT_LastModifyDate timestamp(14) NOT NULL,
  DLT_Price decimal(10,2) NOT NULL default '0.00',
  DLT_Active tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (DLT_Id),
  KEY usr_add_dlt_FK (USR_Id),
  CONSTRAINT `0_684` FOREIGN KEY (`USR_Id`) REFERENCES `Users` (`USR_Id`)
) TYPE=InnoDB;

--
-- Dumping data for table `DeliveryType`
--


/*!40000 ALTER TABLE DeliveryType DISABLE KEYS */;
LOCK TABLES DeliveryType WRITE;
INSERT INTO DeliveryType VALUES ('0af30bdbc19743ad3f438e98f2e9647a','admin','Odbir wasny','',20040525160117,20040525160117,"0.00",1),('e077b4e2fd8ec7c5af708976c389550f','admin','Przesyka pocztowa','',20040525160244,20040525160244,"5.00",1),('f53efbc0b3e0a90957ad978f81e1d57c','admin','Przesyka kurierska','',20040525160224,20040525160224,"10.00",1);
UNLOCK TABLES;
/*!40000 ALTER TABLE DeliveryType ENABLE KEYS */;

--
-- Table structure for table `Image`
--

DROP TABLE IF EXISTS Image;
CREATE TABLE Image (
  IMG_Id varchar(32) NOT NULL default '',
  USR_Id varchar(32) default NULL,
  ITP_Id varchar(32) default NULL,
  IMG_Desc text,
  IMG_Image longblob,
  IMG_FileName varchar(255) default NULL,
  IMG_ContentType varchar(20) NOT NULL default '',
  IMG_Default tinyint(1) default NULL,
  IMG_CreateDate timestamp(14) NOT NULL,
  IMG_LastModifyDate timestamp(14) NOT NULL,
  IMG_Active tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (IMG_Id),
  KEY img_is_itp_FK (ITP_Id),
  KEY usr_add_img_FK (USR_Id),
  CONSTRAINT `0_688` FOREIGN KEY (`USR_Id`) REFERENCES `Users` (`USR_Id`),
  CONSTRAINT `0_686` FOREIGN KEY (`ITP_Id`) REFERENCES `ImageType` (`ITP_Id`)
) TYPE=InnoDB;

--
-- Dumping data for table `Image`
--


/*!40000 ALTER TABLE Image DISABLE KEYS */;
LOCK TABLES Image WRITE;
INSERT INTO Image VALUES ('23c42e76d82ca33dde6c84ec6d893c2b','admin',NULL,'Platforma thorEngine','\0JFIF\0\0\0\0\0P\r\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0X\"\0\0\0\r	\r\Z#\Z !\"!%\'$ \'!!                                                   \0\0\0\0\0\0\0\0\0\0	\n\0\0\0}\0!1AQa\"q2#BR$3br	\n\Z%&\'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\0\0\0\0\0\0\0	\n\0\0w\0!1AQaq\"2B	#3Rbr\n$4%\Z&\'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\0\0\0?\0hh@(\0(\0(\0(\0(Z~auw>UKy^h䍊2GcT%khJ[OQWG,4\"[ZW͛h 0*F19+??\0_o\\X@pLѪxɸfcC|⏛][Fҵ޶i|<j|BʼMG\\[Ķ_\n|-qi]n&ey+ʩ	 \'=O=`u{_q6*+Y٭}`Q^ѿMRX|KA˨_`t??uǛBN\'$2sW^c2Z9VܶӮ9r+3\Z2ʥ濦3(h}ws-O$EC<\"	g5e3?<e\\Xۨ#/1x.$;<`jU[koR\Z+G.t&I1\"Cqί9R՚v#է8ԂvjETQE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QS鷺;w2۲i+\n^ecO@bp6䯧+:\0Gto3υv1ds~u\0:bGe565ق.:G4m8YΛEǊRM.t*Z=m`wN{5_~&i-uY,mJDK*0x$u{<m9BSj3J5{P\0N&_)\r8YiWws_6KEouw*E@UsۨA\ZBS$qWCK/I!F;2#3rjZx<0o3b*b1uw)\\|!\Z\\w<2»/_4kɥE%Pzq\nc\']P^jijS)7u@F]\'VW6l.Gp:$Q⡖{V^\Zʵզ5tՙ\ZSjGߴ7|!]U/kMŸ铌.:|ჳ_lP:s2#3,sMm/@G0+:ZXjJh5wzoO\0܇\0D:ᶩ-wWZ~%rǨJbv}?>s,<6_:ʹAF \nA>o~\"S-rmBQ1+ yJ<\'Uj⟺KVa/yE^-g^/5IDYyY)\0X*\\kxemOl9˘nO#T̶9v+A5KClX7NwP+=P(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0|wt|-x_7R@,;\"\"4Yǹ((~WP 1_cTϝ^J7qZv|ozDeKx|G7 =2Gk/xk> %626wCrC+A8\'\'WZ%a5Ŕdk~:}W>0P+&C[w벴҇93ךƊ<yؖccA  F:✨`\n@SZ4%u4zBE1X#AP{QJ\\}@p&;R\0Fw GV,LԀM\'yhZK_\'h~q:ä!1iqpO}׀\'҄k<r+p:q^|\n-o}=G뷢\0SnnO<bclV&xoֲKWcQPQ\\\r\'dʰd^̧?cs6\0.<SrI flW,:V-~sa#N6OW?B1RaZ[\0\0((\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0++\r*FFFx9i貾iэ	$\'=~hu$+F+{{\\ܟ]=R4kglcv\'eh\0\0+y\\]1Ș(Dj.Cx#PpxJiy9}]p8b#7hkɮ\\I[^JG$mhR((n-(iu>U,8SF~\\SZhK*(4=)v-O<ƣ$SUkq[8I{zMEji\nr>l4^&aqw!	[ּ3x~Zj5匠4e[C_^_O[[(_;C[\0̿DwbS +:cR!+:}_#\nE3cbP;tynEÖoKRWEdFnDqn*\0h6LVȯ?\'🌴߱j:EлQ0kߏ	W@v?(^{}+\ZU!Q/^(.jzTSڞy-C\rMsKkһO\rŝD [	<هAb?1\\m[ǉ/\\ҮW1G),-O|ykTI\"<1>FOHrA;p0I:5wA+H,%E>H1QXoJ>	|d>7x_Z/eYNip|B@=~w*ӕJm[Wo4MEgVO|_S׼7ӾEiJJPٝZΤKGҵK>}:2m $ddJ|!/\Zi_qqae@9\00O0|MyMN=F#r$z\Z/~;\0<7qgwi|lD\0Tbf2Z9{^X}>\0CᰜKZyRq\\Dm~S׫}o|uo\0^_\'י>2?wv\0z<Ore\Z{o>m}UXvՔ\0TGP{֍y<_x_ގ5k팞iEyzڷV(xdA\0WqR4)I3M&mocwBR*nm6=lR4k$N2 Pi^KM;3M5tW73zdj\rpDH\"\0gZ_&aghѓ_qK3AʬS\0\03?$\rrTeNRjW-Z5(˒Z}J:$uQ\\-g\0%\0knĚMW\r=\"y3\ZJr`1Tui)jױ~qR2i_F#FxM?? [yv9aU\'rW_ya q\\gku+\rےaYc$`a}\rzFKV2<U9(I_elIjE)lIm7}o|uo\0G/\r\0ώ\0~\0[j;ӭḁʁx{!\0{I\08\0½\\euӓo+(fٝZ\"G),,-8LΊ\0ُ?04\Z]nH t~U_>/|)k}~vgk\n8\Zrmz>*j.Xڑ}Zw5wJ}j;PI<D\nXT&gѶ?3{^ܮX5k^VmΪм[xpnFJZFrTOV:iVZ<f\0S6}SV	q\0kjN\"<ԩK7>Z#β\0ox3?-/\0Z\Z?{ǳү:Fde]0Ԋy^6r$3gcV-2\02/xM?? [yv9aXgƿ꺕6zs2B@\0gӚ=/hϴ3cwc\nqkL79+Xl ̋M0Hۃ`ׯ00&7צ#14Vooo 滹.#i$l@8\0gZ_&,>nqWMF]e?<1lzqhي0ʒ\0$dz⢱-Bu\rj#x\ne֜)YuߧC\'`Quc.u:Z)HHꈣ,p\05v{&ewΟ?-/\0]ʱWTeo8i	QTt}LLܯu^:JNVkR\"t*\n(\n(\n(\n(\nB ϣ,\nj~x?U8\0]?ËuVYdX,leXg^!X{ʮA]MO.9M6k-OeKKL3Bv#\"@2EoKcu=N8V+\ZҰmȧ~g~M$9#)Y1N=)lm42j֑^kz:vs3l4\\&uywnսC)푌~il4}:Z_->\rg]+:|o?@\0`\nběUC\"y\\u]j7C5sPm$\rKg?&k+S_\0bZDFt?ֺ޺}83r\Z]ZGN{ΰ|aɅ_O¸QkGxIZ`TnѹV?S01Tu:Mƙxt(=Z!#Kqq/4$q\0ZqwG4IhL|3ᧈ;ӱ*Q4a_wĨq>H-N}\n(JFJ\\I=Bj¥.ň(4~cOȫ[,nBNqM}o|\r\"xV^`߫]7D=:K~ !(»s}wkO><ӠU[_@( \0Á&]߱\\?5OVNv|/6Q_˲%ŌXŰO8Ҳ+:zy:?WZhswAY>!#^?g~ng+ZUQ94TV:p\0I\'\Z䝪2y+о\'ޫthL(D aX?5O\0\Zc\'~+ChɩrC[}w/ў~)ǞzY[E+iW|^O\0\0w\0n=n9\0z_W1mK%2,H9ݸs\\Oğ	AYg9PI\'ꦽ/\0ׯ=\0#\0FISxg9[{wWQ9n\Z9k0w뭖t+\'Х0p8ֿ/\\:k#Fo݄K¹O8]\0=\0duB\0\0:.#%g깿`qõZz\\\0<\0GlēèP=\rz~~qHd	+C\0%K\0)ۼg\0\"~\0`\0[V\\Yp7Wwuׅ2&/RurkYm}vhYJOF{WӺEt;]/|_Mx3D赮8ZM7Zk:7\\/M/|CzmusnF;ְk߾\ro)VIG刑g!CyG^WǏʄeʜ5|<n?xOjCn-Kg[G,VL0UD?{]y?\00?o\0#fh	%&I~\\;G,V	Rom?zu6\'I\\\"b`2OHo\r\'\0#\0\Zh\'Uv4DFa:ڽO\'\0V\0\0\\SG/./RQ\"_Kx^a$\ZewGWп\0\0Nb\0\0u\\+\0#j_ϣU\0p^_]M\0ގ&r?\Z\Z!,1uy%͜-6+0(LW\rJ\0mS׷xDk\0趯3<VB\\zuy=7<pؼh{kEg漏tFHfxX22?_NU,66M?Zjg/\0k]qB	N;|oG֚N~i<W^(5)\ZgQW|._k~W\"{p\"HȨ^S_B|!\0w\0_\Zg吆e7sp(f9\\떻^mϋ<1K{=*=˽,]rĞVO.\0\02:>=\0i\0`\0ђQG\rjvS&ۧ=[ANU!V_d\0m\0y?p!Z/`\0iמ3G\rŮ\0M/{\0Jg֯\0O\0ȟ>-}5?\0ھe?\0n\0q\0ڼ%Eռ7gwwVѸ5F\0E\0\\ו@-*T0Ͼ<\0\"~\0`?Z׈^\0/גc5E\Zn+ˢVɝ`prl=ZpJO﫼[w\0\\ޝs#IA7$#\nβ<)(dhx0ba}=)gY?\0p\0z+4\0֞^Uk{ڧw{[k}z<׆m-%p_ou?~i\Zƍ}M#$rEr?u\0-<m󼽸95\0xvH7j߷kzc{y9пM_T]_]<W*YRZvl~%O\\[\\meJT|_XWpR-o͞NN5ދ +\n(\n(\n(\nVmk`_hжqnO\r=K[6dbW=]Xxqs)9Cuo[U^|\rVkE9W%>\"m5-,~X\nG@7w?|7.N y	KBT^Lӣ.jqI%NJ\'${t,=3;$Sj\ndjS]\nhi! AҘnG\0f$<$@r=+~~ʗ\0)7nu?Z&F{OkJ!\\>BnŸ8uMCE[.{I4lE}u;pt^uj23Am\\\"-E\ZџZ,^l0ϑ3q+\0CuR06^TmSYN$H%ш&,8wojhRT/] %ԯn#M-u(\'b0sP%euP:R\rIoUc$+2]ΏjQVH r\05~ӺKKiHH!~_Z	]\\i+`.[N\'ؠC~}jB\'wЊ+cVV\0<ڬI2,s`\0`Ҟhp$7\0c?<<uK-GY9~3ˬthX#t:C{}kO!c6Ҙ<\Z眄P=Wc:SO%PI¢&\r_LŇo~#vT-mQ0\0;\nV`OdvУ:Tv:ռ+?i?eՍռ29#8^ׯII yUXײ\0\\j~?fQqNVGY6^UJNaEWz>:zJXFbDW5}h$_9/Po04.V@:Fv\'lxC,:JJ1Zm~{<2>x7_j\0gWx(O\0d\0+6{yߖ;/=o;Iޗ\0mkמ{\0\0$R&s\nWo%N]c v[o-[z1ED3xqe爔<YXȖ1 w\0`\0ёo#[Ӆ>Z4АtUᖭz{\"աbrYOu|_~Tnhd8d#؊slO9I?)ɫ\'e)]_6]\r/ir\"ƛ2xh@=z\"{)U\0\0ud?T}Ѱ9]Bl\"ZKw+*N+8Y^m^uQIY=};=Yϓ):Wrm=7umƕo2+(Є\0|B-*;n+$)ّб<^\\Ya+$¹&#9b1\nͫ%c/\0ׯ=\0	OEz4xVJx^x7h*r\0#vqni\n:zv98S+1h8FFy?\00?o\0+K\0ٿE_3̹ݳ~Rf4vGq#.J\0_\0E=}	^-gGź}\\u靲Eq*2`BEh\0·\0CwTg\0k`sLLkCm=a+n~Wп\0\0N\0Kź-ν٭$k\\> ⟀u/\0f\0gi|{2vc\nkʖ.iIRNlsGrTet{4v<=/\0觯n\0m\\>~Uwu<oܱHQ`|Aɪ:,-ͬsv(b	).Dv.`\n|vg/\0k^O\0\nğ\0?iZa3#Kmk.PIU\0ۊ4q\nO=;Y7\nex&2S־~h^gE*VS؎}7u\07< L~L+?_mI{&\\ܧ2c>s\\ޟgZSXvVu*=x\Zs452e)\ZkNƑHYr-Υ	\0#\0FGX_+\0iby-.~w\0`\0ёש\ZyF\\T\0+yթBU\'R\ZvlmB\0\0:\0Bx7>{Hoٗ;cS\\	Vy4VQ$rHVrpqeU\09F7ԩJqvGDk\0趯k/ija\"sk$(\\Ae g\0	OExa~F1qv_{/a+s^v=c\'\0Ex(z\0I^>M+A&dimc*{q^u㿄z߉Uyi>ͫ,aN@R:ތ0Pkש4.k>k/Q[֋O\"9\0l?f|||Qc9R#{ }Hv$gu/\0h\0hOi/ڼC1TxVLdd;>m+Fkr/\Zm~|\\r\\\0\0\"Of6l~J*Jy\\n4U9Gvx)W_-zcF&3ZѯO6OÑKQ	5/<_>O\rMym]L빮\0	c5}Z_ߩ%0cղycwp4:XWO>,xڎuqK7Mp+=`(\0(\0(\0<#yXK&(SlM\'8 ǽkFJT髷FujJuf߅Eڝ!\"^b^rL\0,9 \0ȯix?B%\\}Z*=}3^⿈>g_Cڞ{jm[@+׀A+gS:5ҩ\n͐M~x<f/?(,vdv}>~\\⤌&gLj{W	1)\Z\"qV@8Pߊ4n~2p+?/~xM;˨0Rkc|_˥q\\J0UQjkQU@\0k˔;B	Qo$߂YlZK2>x{zβMe3Bʇ0Ai6g (9Ğ~!\Z-˝6aqzWvkcaIEyFP+CԼiMGpFc<\0,.}kĳ{UHa}\\~&.XsaQ@<xRJQyq{~Py\n}2{W+%дkkmмSYJ_]:Bd+=Ń:G,[v:zUIuHt6f`\Zğa[\0,&xU!EGA \nH5xgV>-uB2fW8+uTi3Xw:Ve+/آn*TbכR=4#EZ\'ƭ>7GxA9kTHP2~.`87n?&5Ys^8I\"vW k[[H|9Q0xk|%{\Zq{08%^GʭԤ\n~3YjI.tn[W\'Ӯ\0w|bS|\"z^=F	uWN{H,bp31\0dg6-8*X~WC7>v\n(L(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(t\0j\0}=/+-%	Hzֻ[\r۟sӧ٥\0ksZ֑(=Rt/ЎEb¡gf_*aa	b58ϓu|<gㄜ%+~k-:C+ŐxĆ7[xX\".0XNH»]61,6W%ǢDXtJ?&b+$5$TEUQٌL42\0`ҵfN<be6iKE+\n(\n(\n(\n(\n(\n(\n(\n(\n(\n{G\\A\0Tvm5~\\ig<8ي@{p\"2RW4x\Zx(+>)%+ǜ8\08c*?~#i>S/a9S޼|\'գuօrW14Ӓ1Z?m(\0qKMX&v\Z8i_̖0%lK\'derUoErᬬ~ې`B;;?Z^gG-K+Ѹs^5IYOʓM:yԨ۫BnAiq/u9h)Ȉ}=nKR{˙늻}RI<I&cֲR4MR(@^y{JvC$X^V7ZEVNȹ?W,yLnY]Uk6eғ\\DD*T\\߉\'_\\j\ZB`A\0aq_WƿV^#HgaןZ׼_S6p9EW^c+YGQ*ǈ<G}O%/&v>|Hq)W=\nN=).\0=kI[n~{ĚW-Y>6EZ/\"ӬgEe8\0d\0^&QIj*WxѼ[	-uqA$q\\O\ns?/3Xo\'&88\ntZTI-\'͚Kk).FcWk)*)>Uٯ\0e-|/t2ƀ	\rp98?,`z+k¾(GײXʺa)SWVy3l6+cV׳Iq+4$ŝ=I=6tM/fmSO[]Y,t	Q>_6˪eJslOU`݂(0((((((+K\0ٿZK3qf15Ղ׍\n_\0CWvWx^}zbsu.R\'`>~װ^er_n{Yk˖l˛_ݵ\0(P(\0(.?\'NWd؜ϛ[ݵ\0<\r{׵kV5RUHyX\n6($+ίFT*ʔiBhץ\ZI5<I!+~i3o!z~#(p?zy~E Qݻ#3ji{ݒ4Wx[W#*IMpfjki_Gs)QEvQ@Q@Q@Q@Q@Q@Q@Q@Q@U=S\\qs.Pǿ4OjVp\0dY$iUUaN~XǾ,B:\nڗ~ok	zff̰@p1ׯ_;G5FGC*\'yKV\0E~7fr1jmZ0KIޘhy8p)N>{	;j\n\"& &A1:ƽwLAf2\\&MXsOvvqU$fB3r\nJEVU?*I\rI#TO-3\0m \'}c=Z=_V*\"3?\\*+hJ>z]+xuj24I_e|Bu5cnes~GpD\"FT`_}{>&?O\rUUVN?꜔՚H+[8|qDVVR:?sfAOOMKΆ~}U	ʮRQW{Jo;}ؓz:+u*OԓM&ږ_c+R*ѰT9qc炦գ=0xc#G\"Cb@wqֽռ+|Jh<-14\\\\*3w#Wx>֧2V$kFFaժ<@w[Sjx/7Ew|Wt7صSXo[=8%󞇌`Ex\Z_YيBkvBzF!$fF>=\"okZ[.\0u%[]m[^t\rgiQĘ3`{cE~KUuɟԕ*jQ\\EPEPEPEP^O\0\r\0RN\0}}	eXLf<ܼխ}|昬y{Zۧ+vKL8Xo$ iTOH]#*?n|l|o~\'nC,~b>^k=\0YBͲ\01fS\ZarjJ\\uwk_ezڜNqK/?+Z-Uݭ-}i\0iDNaƼ\0\0u\nT\rciܮɍh~п\0\0N	,\Zt^S+3yԫ5i&\0E\01k8h\0F-}\'~c:Y-%68϶q[\0\0\0q,ɤrKki568DSn\n\0\0s\0\'\nu:WsmY~f;sסIsFȊXd\\(Z˙_$f,YUJGKO61\0h)Tfq!կHuM^+{yWr:#>$i6\'u++(P#\"&il5k&bbHAX0?O9ȰQV?\nt來ߪd6YZWZ׏~)\0E\0d̷oGci^\r_XW)JHB/tnp:NRede\r)\0e7\\~c̐wjOj\0fO~~ۜ/\\uJC\0$K\05묯α8Ic-rԗ7[#l>*8ZwOo7p]3h刼3[8rPx1x?[ӓN̱2FMlƺo8Z=?d|\0\0#W#u!N䟻v\\W_cb#*sy޲ZgmlzǄ<C\0	Wmu}rp=3ҦAgN{Jq*p8s@kBcɎs3%[fɽ7WvV1˲V~ފ^zj\\V)G٤O\0:~У\0+/Y0\"-tG]FGk~3W^x6@`L¾XX)Pm=.촿߱,noUFJӕtWzܹϊ\ZGf\"$wȆRiE\Z=yeynۻj_0iwVX$YPs_IDk\0趯2ZmHJ+=+fT\Z\0m{ߧh_?w\0Y:&}wdKHfP\'vOÏM~o0̅w*(A8kB3⥫Gd|zӔ!Ee]ksz?S\0XOgn&/fָkZr\0\\\0좢\0#\0FI^C丌C\n]#u\0#X_ڒ=]><˦]\\i\r2$0)m$oQU\\ wJG5+YV5M۲G9֯ǭ\Zt{=Y DHF)V<ҭɰeEm+$}{!뱬vZ]<FE-F}soXG\0;\06ҭuiW	`gfd=j3\0}{W-\nRf[E[W*1JѩIϛ_U{e6ʭ:|)=ۭ⟂*i>/F\'#+?}+lo%ӯ`\"؃_UW95%CHv+4\Z|(>(\0(\0(\0?kͯj74>Ym+E8G )p9\rxd?O1	gFBI8\"<svP1+X$)=qdZ<_j\\j`hv#H1_[NpBRZ[WuRq:ќcNmτukEiw\Z|pS\Z_W?&dVD\n\0=yrF*ھە>!MNۧt`\Z\n,ܮ\0tH4-^Y\'d$NkLeX-ʹ	c4Aǯh>ң>XTc$5_.~\0ͅ>ȷ4rz~g-ō7G+S]ިp8g,W\0Ν5P+!ǫ\0}pOA_~~(Ծ(jn@D-BQ]9|e+\0)ŜAΜw_ѩ_ i>X8?,PJx\0m^A\n@ꟲVc;!c#TrB\'7?CÿiO.\'ծPǈe;>%kÍҼ\rnI_|ky-vڄ,۱XO8?%eby#5D)E\nZsH.e*HojvprFF2$Hmyfdvsw%,!vo\r\Z]Z)(G\0[S}(s96EQ1v` 6j?[.C2f t\ny\0gxŶ\Zq%c=Ƭ>R6^zYu_K\\cjNN2}z=+ǋ)WԡړM+N+<=zuJ΢+O\n(\n(\n(\n(\n(\n>.\0\0|\0ˏ{\0m>C\0$K\05~=\0i\0`\0ђWc&=:XO3trܢV# \"ω,M?O͂uHAbHW6Wu9_*~gFg~3g\Z?p\0{\0[\0\0uS;j-b@/\0ӯ[R3j1\r?[IMVUiK~i{4_A\0hy`f=\0M|4_A\0׬_Sbmqm$J})\0ˏ{\0m;x_\0ۿq~/w&u.bGkfa?˨[x\0յz3ּ{ymgx&6(H^>>Ra)\\!F2xW5/RR+ۛK=|kyY]Yfx,uW֞]t<{nxWe{<ټƓvP7\'\0W~_\0R?kQxŷ̾^T(Pq\0?w?Ԫ7QZ\\Adϒiui[^W|\ZsܡY #G5p-X)֦ޭERpQ-kﵿ&{\'z_\0ѯ]eyi?sGo{o\r-u\Zc<գ#k͵曾dxUiX8Z=?d|\0\0#O%?p\0{\0&{lJ5\0_!D8Z=?dtl5`ۼg,\n?P5-%֓~K>ÉK\0JE?8]\0=\0du_\0FyOx__h˷ɎߎtK\nKX_Ov\"#u澣=VammS2<M\Zy&\"O<b\0m_9hZ<k!i\'\'O_FDk\0趮~;ӣҬ\02>\0x?E\0c+jk\'\0Ez\\o)w&xǿ-?2J8Z=?d+\0#j_ϯU\0k~_\0R=\0ȟi\0a\0rVO\01a\0+[O%z\0\0(go\0E={w\0Oֿ?j?Pk\0\'_\0Eo\09O?\'̵|_XW\0O?\0\0Q_~QE\0QE\0QE\0/\rFII.O\"y#R=p	$zdUn?ĺVVT0\nq#\'2E<6cJWh\'=iRW_g\"<1䃃^Oz_ͪF6X\'wls[Qu{vPZAֿi{,jUm(g=)z~AV=mivIL~p\rXm\r4jLb\"h(\\`^xLWc࿍8{ :F/<rF9C8)XjGIaWw^]BLF\np/AnV{\n1%̷wL췁\n:RzIuۛ!qT4~jhF\0-=KcN6bgJM\"XQP78}jݒ2IXKkX&#ΨHw@tmZVuk:Sk\nI|+vh{oi^_K:iQO\\GswƳgx[QmhA9 @?xDeg=2Q{w_qk_fky=*erYFF.ŲKA\"3\'jȯlEF6ZoN??+W:K_`+;(((((O+\0ឿc\0/ξǄ\\&_~.^n[h׾>CV?}^<ܼ-mCOz\'+gj>aFRz޺>UwRGTy\0|?u\">͛9n8뎵^~7qTtk>NgoK.GMVUm};M,㳱1De7\0dО/2wmr\Z+ƥF~{pjML\'+RSimI<T :q]V/` }s>\'i\0nn4ď7՚TpiSJ\Z+j;NVs\Z>JoV-Z[| 	\"PRz(Z\rgw/ڶoN6\Zh[7ץjTn=8*}:iK\n74O\0iZnd;]G{c[tW*(NiFh8TIќFc>oo*yWSGWoEыqr00;Q9_|2<gGq}!Pyex/RIdDpH=sꨫb*55n{+TA9;mW4MVK;xAAW\nn.i5fpW?1<QS#HғC\'?\"\nQVU伇.?xDmq+4G{a]6fu8^u|E\\DY9>haaEEvG\0?\"3OJml!ghHPw]8zJ׹ͅIЂᖑ=J;襎:$Skj\'i.ӈSt9M?ڿ绗[7saGXwl|ga-QG01*c+ԯJwuE<\nt>j,8|#<1wZ,TJ\'u:XLα\\йB՚(c+^\\װapt0U{y(O\r\0\0c\0+Шbqr#	wQ\n((\0(\0(\0(\0mq>/&cn>Oq^&Yn5(\"i$f|9 ʸ=t~`f\nʫ[r\\dr\\[aEbdTݫO[.oRK\'kwE	G?s$enˊ񆓩h^$%G\"\'U7f1hq\r^97~9$(V5/)OoX~vy&	f>Zc*bԠt*kn$gVD*#\r4[&,1QrhN\ZGQ)sM\'q94&v@I\'GSYjm	B/.0pzcjM4Io,)>ҙ2`Urlw>x~}gG\'6Q}yc;}zF[[i崹qU1_p5O	h\rKm-6b9\rӨ|_Yue@t;$\0}sy.xJϕǫ\0HKe\02c⯀^Ib7TQsZMÞ-y7\'L<@\'9,NJ\Z$vs,\r_\r:e>\0+=(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0C4GCt 4(g_|1wo 6\0>p@)ό<ipAi	@{z@8a^LVFu<yN_m\niK~zDa$)v? 󯚓gϵ}hO1ӯٰXrzG/?ũxU֪.	w,P;:}3~z}(J$~g5fڜw8i%Ѥ񇏧6Z!]0;s^==[?-N$d_PŇBZM,Vj**\'A2|ޙhtEo_!eqFUQц7^m=_/6*0k=.5+7O;o\0/ŗTn:f\0>&FӴgDa-ӕPrkk9Ҵ KtXdq#>AYq&_᧨dD\n7RG>#Ю|3\\_m+d>/ڛDӑ&Y+x9hSj\Zv<e\0ppzWq7<9FM1(k!l\09~҅\']Kݵ<6\Z{4;Ogj\Z6\Z~#2G%@z\0\r|%2Oš{Y|+fT9#`pTƺ>(VtߌQ$oe_*4\\1IkϣcpUOU^Wn4]-䉦ෘF\nw~W/Ni.%yF,%Ii5S5ng\0\0\\XXaӿ*QEvQ@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@h//\0Ə+AsosmN=p=OgZRRɧ;եNy*E5٫zg\rKZ{\\&^Y0>e@x{VeUWY֛\02(aթAG%zGAX\rDlYchr}jjZn}=fQ#GEIkJ{])PE~\n(5\n(\n(\n(\n(\n(\n(\n(\n(\n(\n(\n(\n(\n(\n(\n(\n(\n(\n(\n(\n(\n(\n(\n(\n(\n(\n(\n(\n(?',NULL,'image/pjpeg',1,20040522150249,00000000000000,1),('278d2563469ab1dc7444e96bdd63259a','admin',NULL,'Karta sieciowa Fiberline','\0JFIF\0\0\0\0\0\0\0>CREATOR: gd-jpeg v1.0 (using IJG JPEG v62), default quality\n\0C\0		\n\r\Z\Z $.\' \",#(7),01444\'9=82<.342\0C			\r\r2!!22222222222222222222222222222222222222222222222222\0\0\0\"\0\0\0\0\0\0\0\0\0\0\0\0	\n\0\0\0\0}\0!1AQa\"q2#BR$3br	\n\Z%&\'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\0\0\0\0\0\0\0\0	\n\0\0\0w\0!1AQaq\"2B	#3Rbr\n$4%\Z&\'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\0\0\0?\0_ZL $qVAT t%B2, @#dZ\\b1-\0Yj|dI|I.b8BPgں^kk7E\0abRy݇##)Ý؉ϑ\\KMAS2((((((((((((((5j,ZP99j5r^vݰC[QݘOd6\n(\n(\n(\n(\n(\n(\n(\n(\n(\n(\n(\n(\n(\n(׉xǊ)&/cM{i \"y~#a?ҘWҖtQ@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@	^M~#bOY?^k˼r?~&*L=>3OmNHO)*j((((((((((((((2{u[vr~6nG]ɞ?ڧ-O>/f:e\0)\0HEP0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(+ξ#)7o\0BE>zc\0B!3Ҏt3\0LSUvh阭\n-(bRE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0Dn_^^yQi*Oc`:\0\r\0ٷSZ	V_\n:Fkr(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0J^g~֔|V74{Xw)0UX|5_S.4s>[[\0!ƼQJFV7nE]6.oq-H[~Xp>ḪBm\0	g7a\04\0?ƾpՖ	UwN)KC&7NFn]9\0A?\0h\0ß\0!ƾkӮbˍPw̀pjCQѯjOd}\r\0	?;\0B\0xo/RjXQ45A,tT\0i}1t_\0ӿ!ƾyӠ5v爲*}k_4EOe\0\"uP\0ciI\0	=\0B\0|-sg48RV;돴v3G(>G\0ii\0h\0\0^224ɘ>J psJƖ-dcH淋&\0xcW͋c?{ZlЍ,im˳L=3sEī_q-z/&^\0^ۀm-gXbe0qнL@rEgO1JC?3\03I\0	+^NżN\n:q*[Z\"Rd3AScc׿7?-NRDD2?>yPI&4ay֢Ue{XO#WN\0+J[m?q5%!X|շ/{XC𦿎|57ЮJ8g\nƟ6mM2^)ԃ;\Z:\nR5NmV/\\^!f>3@CFqc{}$Z	s+hey\nn$8^^qk\ny񼒴qL/t)fx|IBTqp:X4XlNr;`K{,eKi7 w=bGc($R%j{oei|bp?Ҥ>8LW/%ӱA*fYϏlqD lҒ?OexJbo(GoO⋹/gTܨ0ڱ[QR)\ZIg r?ƭkˣ+QDTO^®&Q6-EŶֳ$$;WK\ZnlDy1u1I3t7NRS)w0Qԁ^I\'7#[^NIXds1UFXT3Htc@[B0H\Z3	;<Zmi->X\02 8_Q625K56֗&%Gbj+^4\0]cV} j*|Y`zUm:;Յm,{Yny9T/0kt+K-݋gk[(<(U&Ѣiv9X:kd:/-VD|9 kQE]OVhyp\0{c=)ˑXi[@dtr@c,Vmذ<r>ѧ6!xY6<6\"cSyb-e[=@,6\0\'8W<Huj!8N+Ҵ5Sl4N:w[%ŕ6eq*9=zrEh+A2SY}zzM]n8;w\\ve;H9qְ d1\"VB8#߽6tq$YYܭA}>ux؈]ٝ#|ik\\mnY>\rOyfr:Zv9Ennms#+ڸ%yWiAk+k\\6{ߚ4Hל֖[˛+H`,lQ4Es43i*fg2HSo6U-\"H4f%dHPj-ZNf3J&y\"9;U=O\\k!c}j9^7))VY\0	{x7}y\n(W\'?GkÑkCǑt@?Р<A5	I!f\\a7n[^+XQX㼑A<\0sYsnj .zZs]Eя򪄎kMڣ({-Ì{˝klG*\'Nj?3y{\0:{4\'9=rjH7k{ix_;$w t>k\Z	ˍuZy2c$Ki(U6,>n\'\\۪@{	G󪱱ҥIdkіyV;Sw9=X`1hՈ[C$7D&כCQcOomTECr؆i̮\Z,~TqF0VT39U#mW8\"[dHOSc+M#OKmjm$%<lBŞ>n9N[Y.&+7t>guc\'|hsTp}m=]9pTF+;Fi>v<~o]	˫(R\nXO=M[-B\'.	=Umy1[6Ak7:ibiVW_12\\dpsZέ1ՍͲy\n	?j5űF?nIOTCj|G,y*o|1q=ibgrH۷T鐭8p@U,㶺0]aQ T,U:ۙ\0.N)}pM\"l>M\\}̏iʺxvfdB+[K0e7=5em14)9\\щPsS	Y(FZCm?*\0wqOU-:}v;@NXUh`u\Z5}evqȪPr;=eE<sZ:i\0JLTg\0^^)8q<g{]Dv\nQE3a+tg*2BZ쫍~\07taI^ws޳x8]*晾X݃X~ʊDY\'Oz~c\0r{.6k	}+bN5Xl٥>i8_}W5k<\0O4v5:=RAqo#ڦKK	q&LOry W7]P\0kq\0AO59j\'<\njҁRBc=sK$4\0JS\Zm?k6f*{sUqZM5%XC *ό3lxVO\\_oy8ub$tWEg:|%e\"6+[5/\nX\\C1D=Ѿ9.\"u#\ZO\\\\Dt]6W\0eb9~PXx.e@~TqM_:A,0R)iC\'z7}	uevXT$j\\`=\0hdqL$,<\nװKW@6\0:u2a#m&J}}Mu,!վU9&!{r+-߈?9(zT&7qpmfFB?Z@ӸNǭ45M@IRXAX)qzIQFrO0jG@6p>f_<&+\Zrv\0TifV咭qzHIe.x`~kV2s9$4s0$[{\0WO^²ۤSy,g\0cҹO18!1\0>v[x(܉:(`6yb64h5MV[o.us[oY\"]ˈ3PyÛt&+q2\06}G|gxrPYl_)#}WW%<.G9;V}ݛ/B$R:ҪGwJe1a\"GmX(<ƫ>ثc>[wK=XGL}h֍>;[g[6HqWNiQE\n>& SԼ\'wh$1y90>{!$Wa[hi1ryn$vyݭᥖȭ[A$XV|MIt7u*	>Z6v?^:=<R}-Rӟx>Bs[g[AdUPdF3cp(\0\"ojeV]=[z躞I>޲(\r\'*\\\0O,HW:q^|>?U\0iG&+\0nes2Kܛ?g79*MOIkۻ/^+o@s\0J<ms\0}/Ur9Fv1\'S>싽^\0_xL\0\n9f͚r6B֛ktۭF+_Kic̸\0h8x#L\0Q0>\\¾d\0IG?ڵ%.QqP>	\0R\0\nN3c۽Ղ#o\n~To+/w%( Wcw\0Rz%\n9FB#u^fDX\"geڹ1NCO\0}֍m^qpcRJ#CDmv6n<TZ~%7:ҧzq9?@;\0}坬ǒ-.![\"#b޳,t+=>O\0p#ȭ:	-Z(AX\'$hq٬D&%SF??I5CJ+¶Z!=BQEQE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0QE\0OUE^Jq@ϲW+ŭ0𦤶4\"$kF:R{\rnA1F|Fa9M6m\'ze4sȍK>8vWQEQ!EPEPEPEPEPEPEPEPEPEPEPEPEPHzQE\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(\0(',NULL,'image/pjpeg',1,20040522150015,00000000000000,1),('369fdcd404f23a8484fc2ecdbcd542e7','admin',NULL,'Switch Fiberline','\0JFIF\0\0\0\0\0\0\0>CREATOR: gd-jpeg v1.0 (using IJG JPEG v62), default quality\n\0C\0		\n\r\Z\Z $.\' \",#(7),01444\'9=82<.342\0C			\r\r2!!22222222222222222222222222222222222222222222222222\0\0p\0\"\0\0\0\0\0\0\0\0\0\0\0\0	\n\0\0\0\0}\0!1AQa\"q2#BR$3br	\n\Z%&\'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\0\0\0\0\0\0\0\0	\n\0\0\0w\0!1AQaq\"2B	#3Rbr\n$4%\Z&\'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\0\0\0?\0(\n(\n(\n(\n*)n!fYcVeϊRD͊2\0آ;\0\\c+*ލDWT\'\Z+ʮ>/͓m!\0b!\"$dDԚfsڨ|u\\dZX\0!Ǹ5k%y\0Ze>K\\]Iֲn<k_͡\0o\0A|ĻnbKw$wjvx3spGhe\\|cӔJ5S>Hɕqın	?%L\0}t9<>XIS\Zu|ӥz&٭\0VOO#[cue[<T:ml;E`i>2еm\ZcG[՘Ţ(\0(\04Q@2IRI\" ,O\0Td4{\04?/5H>#7+*⾅/& _kÞlnX6A֯W?@ȶYֲ.~-OkcFc)}i\nQqWS%_Οz{ɥ@<HIyysQ9q1BsGjijКi\ZH}0xJLs)Hǥ0bs1K@	u\Z}=QqQIP(\nwEoi>4״]m|D?\0:~qގƍzvF\0Qy^_Cp1FuP➒R3$ʺ}p]S*Zvm覡\Z\rvG\0qqhgiE2)c5)Dar@*\'O_)W|NR(BQe\\rj3CЄRh.PzR7֣>k\0	I`92ӒUch	A4r(4\n2{Ҍ\"9T@	oҗ8ҟP\Z}!&\0;Py8+#\0hK82Fa00Yj	K@[^]ļc`*6U?S[	^_dxQ	Vsj\0\n%nƷ]U#ڣ\\9!~\na%<ʿvF]sֱWڗK\ry8DڄC )\'edG=Ej4Vb4Q??Fn͏OlP	\0jBv=C̞-4Iw1;I_F|e9	kk$ڗyR1`fѱ3@+5\\j*ukπ5\\\r\Z!\0jw!X<7/svEd\'	ڤZ\ZWm\'m!I	UW v g_̗+#(<`quv]CH<[un@{W=b<A?j[df\0\n.fHO2=jd0~4MպM8\Z!O\"JwtN aGG/W,9-t͞p{^RHKcX_-6:iYRi\"I%p	cYM+Ll\Z|\0!Q5e>5Zx%ʥOCath>N\0Ң7Nq55<&Y3 iV=\')ד׊W|A\n%VDvrO\0cʦFhU\0\0N\'beܣ㓎imZwuЃs\0]YcXnMA\räBߐP奻@RIrrΥUmK>1@|z)nsҲy^8P,YwymR::ʮ$z\\0na4OIs\rY-s<H\"䢏\\?*5ۗcC72T1B\r}\"Nm>SB1|;g<Hvx~ID&Co+4l\"q\Zs\'9gAYNn\'cwOI44x\0/?+B\0TDE;/#,\\p`*rsHfi&tJ+i>	)>.>M\0{x_\0PK2?7_t?0;\nG,)*qk2]Z[sWaH@#q\\F%ft_.7ָIgnbd=~V[ߡ;@yψ<\n4s$J.#ȡ\rC*m[ZsmwMĿX]q\rVΟΝɣX\'_V#A=D@XK\0ZdB\r2\ZC58ͤGRK\'̈́7{jͬ՟OoKG8kīg9\\	u9A?.e`9+^[[ȩִZfO3GUhP9 :˥a<}>M;M	oʸ_F`OY:eZ^d\0Fq<WN.-+[lsҳj~)1S\Zp\'!`9<g[qt\"LZ:e6rE!8xޘ/¯\\9ee地KX9=V4\\׷y&Zl ~k1掝ilsK VrH簨4m/!?ZV §Ne-K˷[\'ץihv\"㺄+:\"^y\"%d\0;rX|s1ʊ˕@љ7G,݀_}9DU7V~H,h*~nO1Ugl\ZJOx\rs/Ppw\'~5rŝ䩌3#lEYx#~Nx)\'6$ڥQ#ƮLPsX1*pi$`J# U>gf`+۬8K&R7N$$ҳ]Yt6|{m*N01lRu~ˡ\\W]c+\ndҺm?!\rjpH3YKB=Fɋ<(?}q^\\ǃcyWb7\"c_κz15UZkc\n(.-bB( PxT0i y|;y\rej:47h~Q>V\'+$$n/ʟN1^ݮx]Z7howLfISeh.m6٢ʌLwjw\Z\\ܘ6\0`+}a*wT^wCv4|{Q־ƞpǽ\0qޗ\0Ҁz\n\r#ަ˷gV8ҺX,H-veGr aUU4k[E({yLi$<g؞+(Z-Va%U.KmRwc<gLt9\0O[\nK8?kN|^E-/- +Lʩnsd\n]ft+ZeXa.\'qֲ&)B)*q#M;BU#w;W,,,؉cqpг6YBIm#L=Ϧ:~PDT\n`ڵ>	g~Qb#jߧo7mn\ZTu,agpU `Ҧ<Ggw[\\1cɺOU}>x;{M¯ِϥ]J~EaZɅW\nxRxrxWNrVH@3mvs5zᯍ-\ZOx9% 8@yǽ{T)\"<Zܦm[Ļz[uOێ+v煠?(4V2UL|/DFAo[AUF\0=\0QX%-PEPIKE\0%PIKE\0W9ԫ5j\ZWĵJM0<O^z1*Oּ:.٣%3q\rk}WFJuȢli#j햏\':M׼V͏WvdskZBHT\0\0`WQEE%L0aS~謾	/[B;WQXO)R_9\rΣxO:|=8lK!#~m(iT\'rHxmd1$k\0*LRP1)h\nJZ((\n(\nJZ(\0((?',NULL,'image/pjpeg',1,20040522145853,00000000000000,1),('cf70da59dc58239bb2a61e76c88bb6b8','admin',NULL,'DVD Lite-on 1','GIF89a\0\0\0N[fˇ-zxyפs{uǨUakz:KUۣɽCR[۵˕ity餦ʪ˻ǼZgq땭dfk̴ýtblusnyBMX畖ץ|(3Bˮl⊢Â뫺ٺ錦ڽǛhpkȩ÷˾RU^ȹǸl{y١^\\e}I`hצƤ缽ηҭ͵õ侷ݵ׍էuƥstoOpluԻ˞^rwݑጕ~ҹ>DK甈?8Hojl¬¥ãR`_WrkLfpmTgzaWZTMUGm༼˨~ͽ˥×RDOѮŞg諸ǶöîîɶǮ몾±直ӟю˲ɷԯcad,\0\0\0\0\0\0\0	H*\\ȰÇ#JHŋ3jȱǏ CIɓ(S\\ɲ˗0cʜI&DKZX˦ϟ@MJ`C2]9@\"ӧP!pHU\"XI\\B(04JZkj֢TɁГfU\\^JmQ\Z`w޽#g\\uk3k\\82nHNU̺5뵘9\n!q\0Vc7 q7cJn-$Z:YBHjkN9#V%WDJ׎>֌@z&J$|·w|Hh!Gp &ua	ކ0t8BI|$h}7,bYLAN8V#=68}\'֦9YۋHj l2DN65RY%e%n`k	680e6jB&F&Fi㝘*\'#n隗Ux ^J*J䛕g4xi\'ge ©IR0+FhB\nǛV\ng	k \rP^OºQ+ʪmLRi\nx寝q^ź\'n6+;-ҨvHX2pYav,\'p+1jkr>9.X\0ִB\ZS$S-|0/k<_{gP\r}/JvL72vD,G[suPN	Ddv(R-SQnoumU[0֏^;\'<x+XCN;KܟNz\n1YJxMoxf0P}c;6su.ޤkNE_ ;-08__6;]k&-!?Kj\0XЂ6y\0ԝ\0oz$2O=C/H\Z^AA.Bw(Ӝ:guyn[ 𼙼:\0i8z]{hlJ&^Q`Y$4_̣1vz4\nikb6\'W<Tx.񒘤!x?p ,厈9έGǼPЋ̤,gqR$(9Q%A%V	آcIf:Sa.DPAyHBq|8	Z⒓.{ƶyT(Izsd56Miaw&N~Ut7bZ̧5IFEYĨHG*K?qx1M`\0$LԊ-%ҙ{S@MR3i=,X!i-tX%Bx&\0Va	BX<nƬ\0GS`J/\\>th\Z^Ť%D,#<\Z|\ZP`	H9webc-7v4AH@1T\0\0\"x8׽m\0g	@vE-B3AӦVxG^[UŮm%[7Qp[}`UfV.>@Dڕͯj[۾oWk<c\\ja8`p-nLwlk[1!ՂnpY&.\0 c-\rk\nT~oI4K0ؠ	*`\0+,8^Vh1\\F8#a7Fǒ*WB(\0H149 M~rn׶l\\\\-qZKu \01<Ώ|k vg|`8$FLA\rlښxpނC{u?;c\" x@mj\"Ҽmw;KP#\0}\0??PkL`\0x8k~%[P8 ^	C\"!J\0t6]\r\\)fZn2$l00@A,Yro4jL?2s\0AsBc?E$&U,@D\0:@15h\r`0\"\r?ܲ8vpp66 D54Qb50b?mD*1r{X1	U8#\0M \08{MnMn@<C-ߏqȻ}w[ \0`6?n`\0|=Q\0\0 \0*n2`Y\0~$]Pc%\0\0x w\Z]\0K@}&H}}UYpg`5~wA	 \nm4?_WF_e\0\'g@?@/@`v\rpw-P\0-pdn?\nPskw}woFWp~h3VcPc5mq3d=t&{\'Gh& \0uOH`Wly\r6{,o?2w~\r\0s&Dx\ry1YmЇe\\KEaE0gC\0W\0	&\0Pl5א\rJOSh8.r	dg06F}G}_y/h`GlA_AP`ƨkX`\0a\nO_	\'sxG\0\n Ʌ/p	^x@dr@`w\0^f68}xapFීp2x\\7g3COh\rP\r\r\ZbO\\(\0yZ\n@^p.fyww\'slu w30#d7x+\r8~f]^ZC x@ؔ)\'\0~ptU	h\0Ai	yx`|cdg)s1ז+on2w*0u<Ǘa6l\nPpIyYI^\\uQ]\0a$!Lyưv/\nytW[/~0n	@7	ٚdiwIy,\'sdwP#}>axhXY\0u$LO02!NY)7\0Op$Uآ\"Pop=nUP JAY fɟ	sb_X\0G\r^VV̶fm\ZCr\0 \r0@O`)j\"0Yɀa`\r09 9ڧUp8	iA0|Hzq\0N&a6Y@9М<[c4Cd*k73P\r@p06pݰ*=\0= UUP0~\ZR<BYq@diȉop\nʎ=_H6e\rJYieE\\`x^dTZPzjo Z7`\0P\njź$X\rʪ\n9\n[kRXqZrʖKz\nu;0gNV{s	Z+U)ʥj^φI870OP:\0ߠ\0\n\0%0S#XJ^}	7Z7*p` 8\00ז*,;k8Wk70[ŗ8[vҘplCYKV%G3A \0a\0\0%T[2	2`F]`[]{d 0:zVl`\0 *g\'woP:zI}H\0ƙip4imSA\00dk5G0wIK\nM6\ne[KM\0	[Pl˻+*P$|l\np	80~Ky+}\'ڜďx*+ h\"yy%Éz:,>w5:MXU\nl\0+	|w7|jq`\Zwc03ĭsYTlB5gS\069Ï*w)9\09ɛLV<ňk,r|Z([\0ɻ*\0`s,`&\0HUYِ\ruV \nY 8,\nȌ̾É\0`8êɛtF}<ʡA%\0c8P0Fo,kGۗј̙	`\Z:͏\\y<+VM\rsu\0%&bu*|šcr*P<ˏ\0|swk˽;Nk7nbx^\r]pʰ3=l/\r-0-Kk\0l \0ndk_B=5\n0q\0sǁyPww\nbLy\nd\0xd0|k&bJ\Z,\nv^P\0+[+.-}:\\i7@lOVe%Ũk\np=٧\\,Btۖ8s̷гP8sW0xmf(ako]z*F(\0y\'Ɏ1\Zpk(ճ>`sЎHU|kL]0|x*	sCl^gl0*p	c;Зu\"\0Ȣj]d^%`Ts,\0>`}n M5\nK\ng+g`\r0P7@\0^bAK{*`r{dbe\ny\n뼮eN܊¾kW}p/{Ɔ}0)(8ŵ[\rP\r\0Pɠ`\r>P^Pw,0\"@{v\Zg Iڒ\0  F0\0\0#+`\0-	Op*KMu uv2˪w>E<}_Jx`^B?j-	l\0&X[؞T&\0N6\n/@r\r\n\\\0qPn	\0p_Kkշ\n˺˘P_M|f;Pmb\'\r۰`A/\0@ɐGxʺ<W[\0\"9 w^S*bd2p\nʿqne>v_\".)i.9Ώŗwap\0zivmp?\0E$4k߾`QSXE$DI)UdK/W<Q\0R|3O?%\rtIRQW\\Ri~uN \0Y+`. [P/iզUeA2p\06\nӐ!qP\"Ę0ɒJLeʞ&4;\0}5kCd\0eϦ	<!\rmYH2uڜ*pZkXg%y}-[ItK7[}\ZG,	*VV9s1c@f̈2nX1\ZÁkB;\'l`DX6C%8 &d̈́Ztq#n8|*#*S~*4m쬳,Pd(.G\nNHbxX3tK Yb	7 %xfCX ?Z\0A8PQHA\n#S`dEc\ZoQGIztPTYºNVЀ`NT+8Ih?3,>,Hd6٣\n*P\0Hf@QFPHշPPR\0:9TO=aEԠ\n&x52,`DBHUA`-6,^ɰ~yfi?mɼ&z1&ah@^Ëp0	Z#\0xb_8>)5`m@[\raĐGiX`H@@FyגwVKT:S=Xxs+ࢇ&̍*\"28&P	H x!$EEᗮ\'88o\"t\n\Z\"0@\0g``˧1led}7\\6P\rΐp<d->\0~\08\'\n֯\Z\0l`#P4]\0p	D\r@XH@M`DXzR^\rA4C \06<A6* 3`\'2DQe(4`,f`\ZznV\Z\Zj%3P,GЩP4A<F ov2&ؠ3A\0\005\ZI6dLV\'4\0(Sk\0A`2xK+!Z	%|b\r\0Vp`\0,:.]r+#\",EDM`ݼDX`a!!$9ti7\n\0X!D%d?_>,a	|,cGKOD\"ʀ$(4<:\n#i) b6τB*USp3E*7b\0|`pD QBk$$\05Օ +P/\ZM.@(l\n \0C@	z@Wg /tĆFȂZ#E+ծ|2Fo|n{4\0Y\"d\n\\Z~4G̑2zJ\0h¦	 !(\0V䚤_d=5(pV0\0n@Ntkݟ)R0@:0{X&C@dpBp0crA~7\rV2DX*J[ )K$jG\0|^J.XgE!@6VMt[p3a\n BzHDYqdKƯ\0#_ȗ\0!H\"B;)`?j\rk`dG,:.pY-[\rtOxխ֋-מ\Z&!iŀ|)t\nLDlGf%AFVhcOT\0&`Jbx0+͊EcaA\0Z@of=:Ty\n$*@tW	O!rk7`C>y՛@p%zw7QMlb ZP\nA1 ZG D\0\0g\\VCmGve3[\"0hK³\0HBnx\nJ\0>9Puw\"Hu+\r&Y51!\'C`#XW8\nBPaRO-#mn-Dsc%<\\PJC.r\\o>y<@I\'o&a{V_\"A	h6d\0>0{o&|ZNWJg}>E!jO*jsqv\ZU2ŋ#l\"`={><A\01Wrxr\0<\0(bb\0<VJ;/N`#\0\n]\00=٣=;[د YpF\0R	\rHx/{73s60x1\0?\"\0 ?9l(zo(x@\0(67Ȁf4@2ԃ؀ee +R@9@0L\n;q@\0w-	`W89yq~ e8x>L;M;A2SX\0\030\r$pp<\'D)4>B,.4l	A`R75\0@4xfi<c=@(2{``SPkSDLDcsGOG8?ض![i<ǃx?	r5 -C_Ԃh+z:2f|ȇ\nhlF=Fll9(tDL9zGxĞOE)<1D;DqC̥H!Yx!7#H5\\\Z=VDItlzh8lD,	Ybx\0|Au;>cvKO|dYHiE{{\'@kP\ZPbllHp\'f K:K(@:XFSd\r\'ߌ˹l>TI\\sy3%, Xɑ&)N\02DekLOȤGS67\"TEd\0JWJl?Dk`?qS\0,M$[LKD/b8epNDI=>dINt9\0<딄{LўdGMA\0?!OOx|d?J?P-HRJ9\0JCeߤP3K䃕TEFe΃\rC8<I.:Q&qLLGMlLv|L~dM	\"͇/`XpJEcK\0O`?yH\nx/(TbX=0/J,_f3u,V\n@6m9x\"AsSY:1X%AQ\'aOAqǤā%\0#ԔX(<*T\' IU7Uʡo0\n`| AXY\0TUUfsa%V\'F5C\\;\rgShU\'\n<lZTdLr5T$ȄL\nр!6w5k\0m 8\0WҬWP\'loP\0Er:XZ+8(7(PxHRXX! %i=LVeMYўQ8=1`;V<0>Pnٛջџ=Nt0\0cϢ=r]mXڡI]djRkH\0m \0\0[O5,[A,*4ïБ:eVP&bٓ=1UŅS|\\TEt85	\0m:_==\Z{l#M\nɆ\'\0e\ZPAH!\r~&TY+P\"[Ah^W-f[u}N^9/CS!Eo\r+wN\0hA+Z\nx\0,>\0,\0NkBl]LMz1&cYlh28xJ`Ǌc8vUW`@mS)j\"9垥]1H\\߱V@@ON$t& ڢ=,-`:xeX`#`d1O_e`FK07O(nx,?~-xf\\Y<\ZFd\'bd:ݞ:d\"\rbKn*AFE-b:\0gg/6]zOwȡ`fpxT82X@h~goV撾a<d%L>tNNĝG< z nj^Z禵PZhM_>_~n2`P-XFfBe\"nEJA\'tirFK6_ȵiNiPTjr&\0`l:8~>\Ze\\`&6N8bf~?XI*P^lܶfE/Gm;\0,\'֚Ft8]Jx6^lne.\0˞l]_n]3`FK`NHhoHI0BP*-C&Ykv䔞k_SqBN_~Q\n5`_pmgl^ҥ`97@HXPP֮EqnfYm&\0rdmgV+kN+N#^Vn\\:¢\0n/npllVq}$ q6a>\0ko\"%&_5_ENƁ\'(v-Z8/&s3NNRW8O]\0`12por!t@u]N<g2*?\0r)d<Mp*nOso׆ppQbb3lXNuTwjL0][?eІNN`1]ߞ u`/ޖ,Rnrf\'rr<Mֻ<\0\05+Zto}.u>,eugHwxo<%v6sa_7x\0\'Jzpր38dgt?txA,n$|\'yR/sn/UWxwcҔ?+ \"6`Oמ.@7mn֖m;HIzep?U<hz7O89v\\L{/5Ej.FVlO{Gu\0p-`y+0O|_2\0/azھ\"Or ft]9Q%GovʯV\nxMPH\0_/s7,Ol\0PF\0\0$(k	18XFFk:)ÈQ\'\Z1a.E8#G\'W~<	2`N+V\\PEK2h\0RGxqɓ#\n>Y,ڴjײm-qk6myi;:&\\Ê8\"8!2\0\0(A	=p\0RltZ\'#3JţHۺY[&G7sZsg\r#kZƂ7:,zԩN]\rPB\"8$&ٷ׳o{]mƍ6}!_\\t7`e&f9PPh	]CHtp\rlщN|u4H+uq\"o/W\08WtUTD) & 8\nHA{UZ\n\nMu\'_8շ`wh&`eb&\09\0h]qC		1R#&Ȇ≶,pXq1D!R>]}g@4$B(ĕJ[cr_b\n&sV`a\"gDr\Zlvр,HipN5TtJ-\0D\0.p\0*%:z_%7	ӥ0^z9fMXUl`cdpg\0PjEjpE1#v;i/z:I#%@&5\'P\nGP@0oa	7[\"}􍙱	6iVqan/v_8\0@e	8jpHH(E=!\ZE۩dABDuZ5v}Mصu\r\0I,}$<}	sfb \"8 գ\r\n\0\0`\Z#PTQ\'whMeDX0xk(\r\0.4q\\@\0&!oH_z^ǁ|C`]\\[<m@M7(yk[\Z4U[4܀l*\0h`  N䔎f$ED\rh\0^ әbذz5X`[&rhKƗb&\'MQ`sI۲#\0\0={dECH@B(Q \nQ%>\"@h|BC\0\r	7\0@1c`ƄD+_phCސcr@-ob%tno\nѴBA>T2,i($JpԄ\n)d!%xh:ZCBu&ժ5	\\/VAK\ZcҔL		7!WdbtӋڸm@xv>7Jַ\n$0\0\0U8~ҹPVnH 0>F=Z;\n\\ 6!MDL2,l5\ryF+*7zP5,q)Yj0.nRhjo\0E*N/x:s\rdYqk7BU+`*,|YPf1\Zd kN>j8\nn,|Cw,b`\nZo*\0+֊\Zu{+a#{-RJBaXr\"bFpL7)yuu^E-uKih	T1Ǌ6ڙ\ZP7\07%3YdoIAA^\'_<A$CJ)a<s!HT$:/k\nZJI:N6	7tČ)`*pܾ3B,i\'+\Z0W˞>sEe\0`sA6DS4g/ qh\rh>\"B7h] CeMw6Hz%-\\JWZ))\0ZV0!/;cc̱Zݚ?|Ovˮ7W`ڑ\"qHot:h]\r2;P)6DGcED7I!vlCp7jKK׽~/=oZzs\nP9TϖiB7`#`xunn%<b:#!~)Vwp03jW<e9)/:\\+UA?:\n,Cʀĝ)DDR\r`K&*p[&0b8gJO<:55)v^|Z@Kc@NMs {qtV?WQ 9BoЃĻبqN{OWFXu(IO}?]`y7˾Ƭ ŎDv}2亩x{	\r`:\0		(ɴAkY\\jYОt\rt\Zm`Ue4TN%f`46䚋W885\r__ɠQ%^:1\\)մQ`\\=	Aq ;\\C؍XY)^`\r@SPE\'TAC\rbCR@t8Ȟ[\'`@t\07\0\Z\"5ܝ0IEP(@Yd!&E9My!U\0,T\0bT6t C\\t\0\r۱ \Z-ғ`\0H!Lzd4Ia,ꉢ\nΚ5\Z,B xZ\'!^!A\rD8xC-zz TqgX]PEmM]4FdEר}-Ye,\0T-D	\njjbhDDBL^!֠N^t|QՇƮ藳}eܥQ}D>Z@c8U(O vC\'4@$W.uC`7=vC9%vC7ڠM/c1ʜP)R!*dCV]}B%dRU\"X`A5݀݋e,ҥ7%\\&k\"]Ҟ;#mNa$f\"zȂ~5!;@Zq\rdCd6\'5\0%f]ffT,E$pAu,8`zkzf-\"!=*@R%LAM`shSU`ڧ7\'t?PH}Bf,vhzg{&{[a]fN\ny(އbW`BFAP8s6g0:haCpE|ȽDB[~Bkf[凲7&>z}eyE\0\0bBPlA$?^\0	4h\r(d7ADHuX<)*l]{%ᓲf9\'Ii|$~UWiÖDӮfl(tY%\0LZʞZ`Tz*ꪡznhNn&	IB\n\\kf+HMȏ{eڠj\'ꪯ\'bCVJi=}_QyupIn&tB*X+fsb\0%M&^(jzRQ{N|&}$̳&A&\",/LeW(¦lN,ZlLl^b-vzmJSOɶZǳ~*q^/,>ޓJ.m^Aў+*bNfβ_Ev#q\0mZ{jzj$nR>V磶eviܞT4IӲ_x\0.\\H\0e6-zV \ZibC\\vc6m|p6m8@^ZBTz%j^Am^6.~~h^Avޅz_oWk.p/Fn@<po.V@tC4r7r)].K\0Z`yZiRnb0/V/.6t48{-A	9պ0Od).\"BB/\Zq174nC@6IIڅӶ\0;d!;̬1R\Z1%q\ZqC4@q7h@7rQ-*wn8@]Hob{Ζoq?F\0`\0\04Ah8vtpLN3%8%,gZl1/2π@\'Atx9=G=j3@Ge@90R0.pBOl4N0#m69G/o!c4IwXBlq4[0cj?hz4GGt4Q\n0\04lL9[rC򊯑f\r-O\"!W;|\0x+C_%Ks>*8bn9p}]E\"gOW/q.75T5[L-Pߵbcv37d)a/qSB[nt9+/bKe7\'>uL5`vttgv{tU\Zi#\'7`kzt9`6vm2T?.\0o77@!`$p_m6:@g;7wE\"Ggh۶-ZBw$H]6س9t_5fs7~6JcXִy1\07_-936x\0vJX\0>9wx9\\A9`Bb{8Ws]9@]8Ǹ8׸ks@\0\0; <font face=\"Arial\" size=2>\n<p>Microsoft JScript runtime </font> <font face=\"Arial\" size=2>error \'800a138f\'</font>\n<p>\n<font face=\"Arial\" size=2>\'Response.BinaryWrite(...).Value\' is not an object</font>\n<p>\n<font face=\"Arial\" size=2>/sFoto.asp</font><font face=\"Arial\" size=2>, line 10</font> ',NULL,'image/gif',1,20040526102049,00000000000000,1),('e276b24f2f16cade8683f39d4d03816f','admin',NULL,'DVD Lite-on 2','\0JFIF\0\0\0\0C\0\n\n\n\r\r\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0	\n\0\0\0\0}\0!1AQa\"q2#BR$3br	\n\Z%&\'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\0\0\0?\0S()A3~Z\0\n4:VG6e_Α}MvUjZYowci-ljͱou(Le|T fKaȮJ2~h__Kc>_Lt37L2|٭T\0o?pltˤ`12WKc\0`-w6XB\\H贏(l9f[;r\n?ࠞ{5{\nh}ۣ\nj-fHLOJlo:هbX=xL~jxQ	sşGs4ƊNUң<ֶ-[^:Gg,Q.֢̌ps]RnnQERS%aFf`FI=\0\0jpM-\rިجGo\\jR\\\\y!1=I=V2#Tr+^\n\\32[ԱK_F}_\0-{0mt|V\05}t#ؖn~m>?	M\0֩ú!^!CM,W_ItO}h*<l=?xR*2d\"x\neYcSx$l\ZeDk9[9v\"=2L<cFHQo;n]~UV(ڈ0$\'&\0j?6q&i<KkEs[_Ol摮l4+O-9~)K\ri򲜆Y\0_~\rpV=41`;Av6_tQEU/ᱷyc0Uܚ/<f&\0{=1d+=m|.nfִcqWq\nMXM$g85j=\'=N?Cjeڤ]\'O\ZO4~Htݍ4\0O?Q=M5jR/eQ\\\0s:ݭw@Y:bH _)+1{\Z_m@ zW/U\0,s\0EGtQE!ZT[DƟī4zm?{{W;zUشҮå3S]Z4I1c,;#\\=8Sŕ,\ZH\rZ1UBÏʭ[-ZiF\0Z\\iَ:J,=J_zPt;R8z~?Jciòʘt:OϦy4v+j/iO\'{ZĺrI51I{{+6+񧍴hj\Z#N57`־=3T\r-[6aP=OB-;h1W\"ӱ5r0I*ú/2\r>+jvCۼh~,SGnXiͧCwzuİHzg,#0PiwZ8%yo_WQvd>RUhPp?fUe\nBMPnłJ>W)\0͢9%Ͱȭ[gEOh\0o2\'LձE$\04S֓xbՇʬ,y<\'u-	ls f\'Pk!Uڠ\ZU32rkO_jOA!Enk>֧IlnIiQٱ+FO\0¿P(q\0$KKS)z/%|}=)`N#pVd:f1WGsW-=I^ZfNÎs\r\Zqkq_D[qp2F	<+i4?ȋy <-r	>޻=K;|i\0G\0I}kkt.%#>֛7Pܛ8ZvWbA=@|M|P(lشf\'Xo_A[J1\\]Ȋ(`z5=]w}ڗV)me W//ҡS,w$~O$g/Uv嚃P[[g̹lvި6nBmzTokUcVfQ\'\0kɛhy\\\0dXZ@8~\r`|6/z(`{מ|KkvMе|ӫj#P\'~݇2+!sjoqcaim<3+w,ڒLqH~\Z\\[ȥpX0OҴꖤh@Wj׮$Tni!wdZͤAxe9R^X`%d+ߨ\rM_\nJȩUa[X)5À}@#V/~wKk,6سGyd>V^:ЂoMbne\r8/t\'%c2s1]=&E\';7qRy$ay?}<\0ڧ<ǹ4ƌңhy9GS}pUO4;ԗkui$2}5`knsxU:;Q%IX+	ȯ)r=!eӴYUv/x<Myq$iw<WE<hqeQV)|X{XlO%$O(c+5*@vt\0*zY1~EX[k6zε\0rGQVXe?hԋĚ|\r\"qe$%8ǙUWx2h_˥ô2ӭci^4t}7QӚڑOlOZq\\@bhʬ)A&\Z 4s**|\'j;ˉm)\03^A]e\n\r5ҡ+|C񅧁7q0<Fk\Z$\0ҵ4rPcKtg`J\'\n95|1{hms*,^eYk폃_o|@5-D=T;1bݏºGQSSYxm@*>:_|=@M@p|OMJ,lFhozݷğ0__4^W?&i\'ا)<ȏ޲z>m9\r2cJ,Oݺt\0x\Z=?Ǩ Ԃ~r}%Z\0=85\'Go ^st_b[6_Xԛ}i*F\\,,<_:N:\Z1_ڷ*֕-r Ѹ8,zZMsr)vf8ϋ2CDJvrp?z3_XM$מMlLC>yP}nޢծ!ӣMG8M}k\0I^̚Ep\\6\0;5^;-JG*qXz=_^c\n$Һ:+jN=Qm{{ϡX\0`_a\"Tx焻d_o)tf\\\nM\'GkPAO	蒌\05IaܲvZO|ǹ]cS2xS?Bj!|=CT-eraW4ֺmm\0zDmO\0<TF2iOi>ky\0ŤIrA/BL#\0|Vq\"-w,g?E|ݥǸ9kt!w»\0><)eqM)&?~;XoD5w?xC@ua%@;ۃrr\0:Uן]W#)psV\"{TjJ0?\0\Zog>UY|1NrOWS݌?ԯf;>C\n+eue+׷i?[V_&]R7s\0R\0t7_UߗUqB^wCdJ\"Hr7rFmFOh \0J$ZT-@ϰDeSxKELP\0Uv+Oj/,Vy!On.74C:/z5ڼ\Z葒S^_s_Ǉ_^`	MesoT~K3|J)xmyPWc֮Ũ~[IVOsSSRϽH[OKsC=Wvu64m%\"PRJ/~+}-0\'\"i	Io6u\0`k{[MSSm*Hcs(#5n)`{?JcGo\'ކ65NA.F$\06\0*<!BۢX[[i[B@R}26aHn\"ݐ\0TZPBm-$GW~щ#|0Fǯ5zl7s ǦMt4dȘ^AP\0?e_jvZLaW7N:G\0:\n?E[\03M<Gɚln`8S>.S#rE#ev*LGVXUÔ=\nU֣}MLoU?F:jJz^wͿĭF]CWү\Z+ONvSYGk٧.3bJ<|kF5\0Z{et2YUH9瞢Kv8^gu¹DRKr=|]S-q0\0.H=GnxcƺKsMmGOz8ָ_)#\r?#\\\0\01^Z2ח!QǹI2mozO>#|-Fq_fohd^Ua}k\riQw\0vnV9ln1~߷\0	,EOE:Em#1\0@\'\0Woi\Zfd<F׌V<WO%vљ&\"ug`\0Mf_h^,dB7AZR,4j00*vm4qV:9,`R`X0?Ǻ𕤇r^@}?Y#ϯ\"o\n7WVUo%\0S\rw\rU}F*w\0HFG*ҁDO2?\\V_ids\Zn\Z2	9>o}r|=:֞+\ZCyop9\\)_>!`߇ws~5P\0i\\z,͏κ	v,\0da_?½>\0X4osTII={2LJ1:ՏnX^WQ_i%{#6\r}KO!eNI>Ē=3^x7A4\'٭d/#ugcܓZzjHF3\\>Vb`vݎ|66hK%PFyk$E#湏~)\"~y\0\nQLZw<iz{Zu\'ڜOm+ᶯiڎV!H\0?:^-VBplу(s]V\Zj2\rQzgҦ\'%TNݮ(#ye{:yg(]&zgҥIӈ%0hs,=\\TB5Y1n?J4yo[xb}NdtT+hP?u|n~jL	G_,W9bS[[6hskQя_J0:\n}QU.4{hcA5^oiӦǲ9A֨JгFP>8DpNuV,tvrOҞ|%20-\"@1Xt\nz-l# 4ƶ&P*iʲd!SK{z9WUK/5:N4Q*Z^éI@;G^w?4J\rk~(5)NM~2vt8c\'|=AAǥ]]c/B\0GY<uIӢѮD3Zppze5oP\Z]GhH)4\n*k\")!uvk\"\"~3`7&oi%y=i\'k7JD+#Ks2_r\0C-Ic}KF,?6vw,=ڙywξ>\0c3/W/gmRZm\r҃{uxz\Z=[KQF0\0)h(@1KHFi6L@&-cz-4JA@yD/pHB8+q\Z7`+<vGQC~@=WD\02>l}*t\0CPC52N0P	gdH2>i([c/#pu\"v\rFL~FC᷇s>b-g2fvwؒMt@+3S8\0K#[R+ԍ~o~+sKEQEQEQEQEi6ڣtJcE6m8o2m*d&lm$S&P:5q Wmgxf|@`~A\07ѿ	\0׶x?Öp kn( <font face=\"Arial\" size=2>\n<p>Microsoft JScript runtime </font> <font face=\"Arial\" size=2>error \'800a138f\'</font>\n<p>\n<font face=\"Arial\" size=2>\'Response.BinaryWrite(...).Value\' is not an object</font>\n<p>\n<font face=\"Arial\" size=2>/sFoto.asp</font><font face=\"Arial\" size=2>, line 10</font> ',NULL,'image/pjpeg',0,20040526102103,00000000000000,1),('f1ab27b0d6ee3465bbc40640997a5a02','admin',NULL,'DVD Lite-on 3','\0JFIF\0\0H\0H\0\0\0C\0\n\n\n\r\r\0C		\r\r\0\0\"\0\0\0\0\0\0\0\0\0\0\0\0	\n\0\0\0\0}\0!1AQa\"q2#BR$3br	\n\Z%&\'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\0\0\0\0\0\0\0\0	\n\0\0\0w\0!1AQaq\"2B	#3Rbr\n$4%\Z&\'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\0\0\0?\0S(\0(\0(\0(\0(\0(\0YDH̪2Y\01\0AqھuKǧ	8Rh=1f=y>)xF6~\"T)I\0u?J42uv?@֔Hq[g3A\05+ѿl8U<9 ,\r\0Γ$\nY?=S[=kWm|HƼ:;7D\n\'5-nLhIFQiR1Rf\n(\n(\n(\n(\n(\n(\n(\n(\n(\n(\n(\nLFm=kOIg\ZaO4m\n:Oƛ-vw=Oϰ-|sԼxiiMė#{8<}}T&+T?{_s$<RQ[Өޑ1ؓqN-t3<DU\0qL6z\nFafD5CnStY<\r(mңs2~C$~ﲜ/@j7nu#f)l3֣{P89}s&6o5U+\0c]6d/mտ\\ןT\"EjVj^HSătq]QjmŤ:ջ*:%h%h\ZM#{a`	$QqK	\"S~ӦH0BޱHZӏbIc?|AknXs\0WP5*z?C_Nf-Gnzy\0{}6b\roq	tWFZ֌<ǬjJ3U\0ǳWQ>+ ]Ee~\ZF]~E-|\0նjZխֻ=+f\0[=aaK\\}OMkLƁ6Z{$OYTqQ.E46{SQE\0QE\0QE\0QE\0QE\'J\0ZBqP^am%ĩ1p\0~&m>vk}<=T`inu~86]jc~onwO%ԇ/,\'R!GNZO C(Ldb9+Go{a*p3׭vzv33!@)sWLCA)|\'?3-\0qGaҐ@yf#\0+q\0lsHm<~T#<qKrHqy#|NgyGg\0*kuc})qX9)L-և{֝Xnn-1\\I?X:g]h<81HPgLt^ڹd?~6H?0Ga &8R$]!m~dՋlomv\rgy\n/Nc>>L\0>1W||E45mln{>\\/H#8s^Y1l\nH֛|ֹQ\\gXQE\0QE\0QE!4\0odgXb^\0@;ċ[\':PoA_9Z|]5?&wMVK/EԼy;#ҕwhW>RFNi9\\woOºlf܊=fc+>i8=;\ZO	}Iu|[7;UI&z\04y&Yh1šxÞ%4b\r6\0v8<ku_I}i^/sk$шVV܊޻=6[^TeˍDa%\nTY2OP;V)4cEdWwsҾpQ<\"	^C`}wTIs;\"|Z}=gg<yI;B,M\r\0ʼuKKFc	RF?\0\0t<s}j$Ap]BȤv KDZuqrsǥ0jsdRF2Æ~5:a;ϵ8F0\'SveJSd@1럥m\0\'SZ,G>ʤ~ps>UPv\'ׯA\0lړ8VyҐNsJU)縠QZWc?oƂg0*\'\0Au\"[GS&	^zW%ݝRD_\0>J7v$kJo2*{z?<Ss1?W<_K/\'Ƣ}(\0\Z+iNƴ֧f1EyMŢ(RZ-bi%u4fc\0<+<{J=$ɧigsp\0/|RRtV/?zr6\0tBVg)bww%įuq&Y剪$t_䁓|:ֺV-ܦaRA$=Oˎӥ\\rl\0>(Th\"LfܱBu;߰\"[㟈z<ϧE8cpX\0H|~!~5o4v*mxQ\npPO71i<׮.Jpu?	VM2}u0>㴜ӎr]69o7jp\\|\"\0AV]yZ޽pu.Kʫa@ֺ;C4wIl6	.1\'9*Ydv% EԐrM2z8wىt4fXD\0_hU`;	\r櫩qkk\n2I{mj(oi#eU1\\;UOv\ZC[SmpC\\ !~61ӽ\rieaw=\\cOu{0~w\Zcp+6\0ZM\"D-7^\rҦm>Qd㜜Nx6ֳ9ͼSy9cF󌁜\n65[ Yz:k:C[8pZ\rd>=HDkH\re6p՗><=UQ1;GLw95|C.iM9]w0s?iz-~g.\nu;i;ncR\\pǭnI^,@!\'	z	;=Ot[oj-h*nWu܇ҹp|qc4tߚC\n6;;v][ǹms[Hr\'\\ůZ>4˥zd\'_.5Qu(_\"\r`1|*U#Yټ,9eaF3M1\Zjެy&):V)<nnעѕ20q}ir]ۓL={ڕa<䓞Ԋ6zU^3_~T 5ԣ	}h`dQk@籙aZ`\\jEebaB͒rY\r1޶зC˵f_T&u#t\0cW:\" bҾM|0 d1 Xg\"غ{Q^yA84f1%,q?^Z5=KOxu{\Z-k\r[[7\Zo_P?b08]PZOb8$Fn?Hf3T`~e[#IF1G=oFk&uG)sn0*(y߸GW;|35=t	!\0\'?vI(*1ZU3h<tq(?[9YP_8yrZOX\ZiB{jRБ=\0c^=t>MNs»lo{Ε0CI5^~G1\'\Z|ڔ(X\rxr	8x1czdo\0\0%~cR;Fii|e>Z\Zm2_d67;dI]zƑݶvj\ZEKI$L.UU\'8.:֠ӒׯD1H.\'kfH@⽇RƩM(t]BܾAy힘Os\\3ĚZeRI>?h!nQm5N\\.T=985h^Kx-.	h %`(\\KrHko.n܅. *pk:V\ZD	O~!dI!pI{I5\\A˂.lEOv_C=(?0fKlX(\nK⹖0BOA$Te漎?:κ/dMpuHLr0Ww3xΏ\0,4c\rXwyοkeeIV&qih\0ߍHEZ;vh#+lp\")|ʝǮ}G}K^*]ZOki9y#1<g0xזB^}i	Mow.I\rE⽳M,\r/pN;@$<l g<U\\\"P}SԸTʾ?γomy2x\"]}~NH9jφf>: Ťga?Öm63ǹ\",[!83wb*i:4zMy%cf=<\rᇚVY*~~g+G;5kФHÀ3V|g&>\0R^ïjI:Re#NN2V(V;hW`bziaƥlҿ\'^{}+7\'\n}|8	&^kV/{Ck6R*5y4Mn!BbwI+U=:RMi\0V&0g8,7?L,[ewc?`o Wpkǂ\nbpy7~@\0\0`ڑ\"TP\0%yBIQPQ|1iȴT75\ZvPkY-<ȃ+2dd*tEktG<n5].6#j ą *>VK,	44CNg?c\\TEY6}{\ZhB5\'o 	\n\0AGKk{2$DqZ`dC~zX+[T:?`EAwiW/oժgnqJ`ϥ4\'1L)SdWoyR^)d±.	*CT8s-3\'pj;=ѰMh:H$Lt}Zȿo,1maSacUU&͝{`\'0g?Z^~]m\Z0#4Ι3>lt[kz}ۨ`,xeו٭\0Uv22?FM2(ʭCJi\\\'\'#>9+?dќU]umI*d@JcםxwO;RLRS:aO\'S$c \0i~m1?Ȭ\'BIs	VL]<AE\"kq[ITq%\"+ikæ4ir=/+\'x*d~c)S\'^=|Y{Ѣ5/Ň70|xmŴ_1e6@\0w=0}W}GL]gڮy`U4Y2H֮xC#p*h66֐	q@9|~RSGQչvWmz1ŸjVh$Csre|zvQGFj8oJiP~F<<*I(GnN`+ۜi\0\"=mr,Seڼq^o\0ZPMM+@e._09(^k+xyB~b3?:VDkWӱ<P;Sgc\Z\'`)y#$z}O\'P\\5K%?~\0yc_*}OWG4\nɧCw@LUy=1	\Zӿj>(cP(2+R2ts]SS]h^X\0x?S+#,<o2n.m2&Ӟ9SִN^<Ѱt:GQz7{xG_>	0Ft 	:qV\0_ 8<\0gjrymƭ6ƞ;I2c;Xepx\\WK|d~q-kV֗18ul23Yw>d\ZZKv<֑0C]uC]n9uKb qepA9Bwfog\012GreTc#rҡ6O,\'[#lʼ+xz;fZ[Q&Sv!*Iz?5-IWWFp*gF@p\0\0WskoJIu[δyI\\##jοm q\0ҧ+fr\rpHkKP܏n4}2\0q8÷|l?>hRuĈN9>qҁXϺ\rLr:\0dM0|AWL9L)F\0(/!G1AsUs08KVHE\nrYx\0*-½=~fJ\0t|	\\ǜ-.q$z\'PO\0-$:Wm?4|c=&3Bscjc:Qafܓ\\[\":gEix{R%u_UU!s$GGNET\0$q#4\06,oru1\Z;)AK!Sb9g@BROiRaYdSF?:01+ <eh\'om꺄\ZUW.#%,|Y⛯jvۯ95p\\Ľ˹u;n$i%K?8#ErB`gaNc ўJ\Zr{S3lذE	7s\'PKHp83zcZXBS8rI_e|(omY Yo91:ϽcV|̨F쭭R(;#P@1RAK\\HQE\0QE\0fe62*J@B_Q@s?Ǆ>[i׾/-.0E%XʎdqVuGmm.̂,doڻ\Z-j5ēN˺9@Huظnt\"gg~1Þ$M[k,ZP\"ĆfX5q2?_<)qm#ƣyegw<H4Ql|H|~KZx\Z6E6i0,<*ISPzRTA(+qGWl Fy^[OѴ\'K \"ȍ`U#v8<uzF۩%Z :0f<<q5-6ߞ~VIp}:O$֫icupMwI}|?Z@[֚mQ&<@~2lr#I&F;b8<P3&RȞ\0o[1>9Qr?JuFA3w1],ǃ\0}/Tɪj6H\'c8oU\0U0<}(^(f#,nx hlUOEan΢Hʸ)\rgia	\0Yc^b/1BJɼqTgy0_,]ET;0L$@rG5JMc\n&81zͺF$0ҼWeݹ@vGBAA՝Oo..#`dO\0jjL,|?\0ۺXZVOB;bN1\n\0Uk\0__&yG_$(\0p+Eҽ($ih̦^xN\rīHe@+>f\Z,msZfoq>MptFbI*ߕ}#qNG*?u?)s;`_Ԣơp{ֽFMDTP\0\'\'vue`)(\0(\0CQm\"h?m/*m\Z/揘ٲ?ƺ:LP=տ&\\z\r]杧1RrcI5j	-3DO|sE9-tZΤt:t	}FǏ㎕[ v6s<dVeǆɉ_l\0JߌoukiPbsvx-nc#)PHeHSlْC~*^8U%`f-(ccUvrsRsZK.SL3\\YW8f?^ƘÊTmJ;d&xU)` #SA;©%F}b%?ZZ$8mq.73b?c\\FGoz?#@bB,=[&WMY{7`I:mvZp2	*iXmZY*qcPˊbDOWtQ;\0	pTM!\'5TwǄZT\0chzo/NfhZGZ]w2ՂU#?_λ(QsX	i(,Ŏьs\'KK6/׭ʵ9>x=$;]8)+st\0¬lU{s_|h\Zt]>!@Ԛك4?>i	k\"<_\"9%Pz(,k\0\nzF6(K\n(\n(\n(\n(\n(\n(\nLR@@#T4[w^WzQHsѹq)_M:B3@u5%rUvnƽ-0@#Њq\\|\n	\Z\0[|+	shY-\\`rٓӒ\Z<	bXjG,~socJ[owPNӑڽqmd#ny_WnBcq[݉q~Ы\ZW4z5OF%# W9ȮR7ma%e桠f0DFRA}ўyִWVڔ<\0vU\n%@!Y-HgKDp{7\"b`Xn?+VDsO![*ӖNkdO|!M:bDQF=l嘞I&FGp$1&Nsۻf6Ӂӡ)K\r%$ma\0~u\0?dHMޙ{%lpze<Md4iwHK(Yٶ8݃\Z4ˍ.=dv?\0҈\0޼㌛,ǢL}TwH|Ϫx[~:Դ/\nRjZčݿW#,xQ_>/ǎH-T[(dGFz~~^M𶭪Y5H2FOu?}:WEJ\"#5QEsQ@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@	сKE\0G$0=f<->[zlQ@m߁Hɶ\"\0ZĽn>ko5q>khDDǶ~Y1ӭb;Gm/am?nGbO3f=I}Jr\ZƼNw?#H9)a6iU\'sQ7IG\rqnCnbXX\"db{QOGswo4}iilXD{ZjNqQ@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Q@Fh\nPE\0QE\0QE\0QE\0QE\0QE <font face=\"Arial\" size=2>\n<p>Microsoft JScript runtime </font> <font face=\"Arial\" size=2>error \'800a138f\'</font>\n<p>\n<font face=\"Arial\" size=2>\'Response.BinaryWrite(...).Value\' is not an object</font>\n<p>\n<font face=\"Arial\" size=2>/sFoto.asp</font><font face=\"Arial\" size=2>, line 10</font> ',NULL,'image/pjpeg',0,20040526102114,00000000000000,1),('f6f19460bc6ac4de94ca4e964c51c90e','admin',NULL,'Router xDSL FiberLine','\0JFIF\0\0\0\0\0\0\0>CREATOR: gd-jpeg v1.0 (using IJG JPEG v62), default quality\n\0C\0		\n\r\Z\Z $.\' \",#(7),01444\'9=82<.342\0C			\r\r2!!22222222222222222222222222222222222222222222222222\0\0n\0\"\0\0\0\0\0\0\0\0\0\0\0\0	\n\0\0\0\0}\0!1AQa\"q2#BR$3br	\n\Z%&\'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\0\0\0\0\0\0\0\0	\n\0\0\0w\0!1AQaq\"2B	#3Rbr\n$4%\Z&\'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\0\0\0?\0)qE1	1K(1F)h\07S1@QH-2YK\"F0]=nôY\0m\\MċȵSZƹˑ0@=pXrO#2ʈ=YNuGYr\\+GsNh{,$ѭj;!6oќ!_SμKء\0Y*\'Uy=I^/ѯQt!s3\rJێX@񺺞NE|S!Zo\Z}F+4ߊZŬb+ސ+Ӿ\'R$wPZds$HbwKբ2XC2`5@-\0PF)qF(RLBbZ((8\0hnE!!ߐ_|ML)?!毼{eVuCri.zۡy$\0k\nGڼ\nz~Ot;?@[4+{3Ѧ?ƹykTBk&4X.[kMpؓY~uT.L~ȦdT%7\ZB\'F3v&Kk]&Fh)9*	\"\' ?3V^MO\'so0\n\rgnɵSUi~U?1\0ǳR0z\Z\01ǶN丨K#$y\0f>3|}1@V<:+\0+gOW4\"X$,m@MTYCr>*]G#Ͼxu[]<W!N>Xw=7O\rO_=~)td\'#/:&u0\rǭ!Er\r{nR[dK}bCg>:WU@I\"DuEY\0\\[ZXyJF]eߡ1u7}y<ʏ)mG:W$\0k>\'I;u<zd8(4+Z5mHu}3\0WVY5u4|xc<U9ofgUo\0\0@cv\0{5X^QA$\\=+RG*WOR\'GyԊ\07Ѿ\rfN]٣5h\09DRn\Znj)	twOJ&^W`x#߽V0׌Sc\0j\ZeX\0#ӭ1p**՞ځ9d<\0fɪLq(3Bq4}]>܏\0\n#FU2b\0\ZM\'y?3,uO?אJ4\\?[i\0*@IccjUGpJ\'0>Ո`HGOj-Ҹ@<}s-\'sUh[Fi;CcO319̍sICfy=q+s_9nOB[	eښyЫ~M\0ׯXy&+eXF[hK3kp~->|Af?yXW|[u;L$g!yG#$>t=S)ݽ4`MUopkycJ\nѰW+)gKD\0be\rve̗%8liV\\4+4V\0T3X1\'6w$\0h#4Q0N	h-Z\0-e?ǈ\0=/_\0Tv.$e6Ɛ.]\0ק Y\0!\\uݾ`[c8$ӧLXkd\Z7~zæ?w\0?S[<US(zQQњ\0\"u#JҀ\"\rl,9^~͞C*{?\0\nMsA-)E$y><N?ℵ,`D.}RTXw1Q-(Os֯pR+ت+G,}u\0PZZDF2XOQRrqBBs UV\0Qla>)R[qN$27!{XmLz\0QuB	ozI \090U6o/8ɵKx*fRYjs\0gi6tB\0b:N\"6b.>?ͭ\rzNkooӥ4-SEj7O*ȨHG*I@\0t\0t\Zc<\0❬\Z}h!vV g\0\'c*\\ ָoMg6OccȎtjPοu=ׯ}s7vӋWB}֮aK\'BEaq4Ѥ )Q~RmGYv`0Y_Fh-u0pvqidHϹ|4Ͽ.z? zlMxaufO8{p¥[ٶ\Z\0N{u+\n84\\	<ьBG<UIC?Ҥ>p!|X(KħA֎mF\'知u/ڶؠŤ!qy57%3o#yA$phʶbwhՐ+qޭ\"}2yVfɨ\\Kh\0.xC4>hڽqX19ܑTJ\\ \0j_\na@IRw2RvN\'ZSǑPeh$۝yX`2vaRӞ&}	cU$ds$\0Yh\'<]Ve\0@	lV|:^{\\Ms)ǢQtR3k7\Zdv2ɞWi\nTEmC0?\n\\Ũyu3@{(ɮL-4y+K\0-J24@ӊ*`y!.EMS#tzVdg9*dt{S`sw\nk\0\\g|Jһ-ꤖR;A|G|۹+ѵ1H+# %q[%o۝%$()ݠ<>;\r{.E3V9aJ7*9+u?$ad\0Z[E;)\nbݗ50dN?˭E,RD]\nB1MI$:?JO\"̘d7RNsZ:C#V9$l\"3aͱ0b5joͰ,(13i_݈vX\rĹTq$ixͫLĻ\0먣r(#:i5 l#\0~q3sSx7Q V5ttL\ZSum1>j巇uk(w95^\ZP\0z\n؋L\0J줒<\r̎Á]N;P6@+KE_\0;R{}&8U{USR\\ڦXLB#1OR*pOU5R\0;Z2,IZ\Z(*2n\rVڶZ1Q0$PNVvMD֊io=\r导 IyM`PzQx-΍}۞2(MCh\0j1[?*.CŢpݾ^+F7nfQװG\0Ic\Z ^cz5Z0B,`cں5QR@2i-WD`SbR}ڜ]\"N	Ra)*LR@JP(iBO\0.)E.)',NULL,'image/pjpeg',1,20040522150122,00000000000000,1),('f94ba89410fab5191730df0e31d68e92','admin',NULL,'Zima','\0JFIF\0\0`\0`\0\0JPhotoshop 3.0\08BIM\nResolution\0\0\0\0\0`\0\0\0\0\0`\0\0\0\08BIM\rFX Global Lighting Angle\0\0\0\0\0\0\0x8BIMFX Global Altitude\0\0\0\0\0\0\08BIMPrint Flags\0\0\0	\0\0\0\0\0\0\0\0\08BIM\nCopyright Flag\0\0\0\0\0\08BIM\'Japanese Print Flags\0\0\0\0\n\0\0\0\0\0\0\0\08BIMColor Halftone Settings\0\0\0H\0/ff\0\0lff\0\0\0\0\0\0\0/ff\0\0\0\0\0\0\0\0\02\0\0\0\0Z\0\0\0\0\0\0\0\0\05\0\0\0\0-\0\0\0\0\0\0\0\08BIMColor Transfer Settings\0\0\0p\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\08BIMGuides\0\0\0\0\0\0\0\0\0@\0\0@\0\0\0\08BIM\rURL overrides\0\0\0\0\0\0\08BIM\ZSlices\0\0\0\0u\0\0\0\0\0\0\0\0\0\0\0\0\0X\0\0 \0\0\0\n\0U\0n\0t\0i\0t\0l\0e\0d\0-\01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0 \0\0X\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\08BIMICC Untagged Flag\0\0\0\08BIMLayer ID Generator Base\0\0\0\0\0\08BIMNew Windows Thumbnail\0\0\0\0\0\0\0\0p\0\0\0T\0\0P\0\0n@\0\0\0\0\0JFIF\0\0H\0H\0\0\0Adobe\0d\0\0\0\0\0			\n\r\r\r\0\0T\0p\"\0\0\0?\0\0\0\0\0\0\0\0\0\0	\n\0\0\0\0\0\0\0\0\0	\n\03\0!1AQa\"q2B#$Rb34rC%Scs5&DTdE£t6UeuF\'Vfv7GWgw\05\0!1AQaq\"2B#R3$brCScs4%&5DTdEU6teuFVfv\'7GWgw\0\0\0?\0Ećjc$7ϟ\0T;qIcR?yM7oS u!#2t><;O Ɠ$ۺ!l\06јMe{X^,\08xe֞j\ZS{OL@6d	i1s	L\0~m<_3$`tM\0t1?G[v@>r;)o;g~!I\\4_Q	0Ii)щ	5E9 ʉn\'cl|u׍\"a!\0>TH>VF^	$c^fS\rkt\'5<49BE6?WcpĔ0\rL;QH\r3\'<7q\0C1+~r4\0]~IHb\\<f;!ZYqiIj	\0)\0\'@:O;c\"c{\0d:x>^DAoR4ABN=q- wi:$rh\'\\	t	nJmi~{:Ւ@v{T\0\'D\0X6Q]2Q-m4nd\Zn;ih.eڙ̶{Z`5SR4`!Oގ*uX6 4ȰuM<q\\fCR{!NOKځ:]7P/5SuS\n׸a/}ϤoV>U{umm\0}.5\07=$SXt8kwG:[\0F\\!ʭ{veEcpw[ţY	e4_6t_Tft繛ߊ.\rg>7\0Gvms.ґU~{I\r\\\0ϦOT۬V%~a_ֳzXα9/].&ٷoZq XI$Se묶[\\87Sm\0HЫ6}K5c}k\'`eZlUvpkuÓ3.|쬋ZE 4\r ]!>~0GMWM9Rqu挊\r=o7?7eQcW:\ZMc~s?FFNEz6.\ZOR}E;ݵo?v\03-V:lc(ZdSlDU4;\rT}Ec{^Oyh\r#]t{׆\0aXɦ<~swo>l\08XIn=E[k{zOT~Q¯̛>v9[nT>Ѷ/k$q{nC\0Ml=l?5(u;\'4<^Gި܆IbZC<9.cY`q@1\0An\0s\Z,&ͯsL25kw#ۙskڝxswfs2+DP1fuUeH0FOiclm7x2}G9c7k/]-$:5Veov=Pӿi~S7-^?QvinMTdo{ŔѮcux35ƹ/\\;F=֑>;}qo:ӯڲ.}[n;n;ߖXlH0O潻IZK\"$|R\\%n<t@%ɶL\0\'{&\0wv}& X[EV#nYxNDG-ɍDCl8ݱ\0R=ZH.Pn-drouhf]縷nv.g\0	~ַ?/H&Υma߼mpp 7k[\0\'ثm ׹Š̒[[P2|KH׏֟اNQxs\rs妄o5!\nxvsƵ5;]ܵߚ}q-@3\0VMb ~FnK^e;#~Q.]vƸP[ SjyPq%(Z2A>\n[5BG>IqsN\\\"m}73y1FHl~s}b,,\ZkJM@5!N?RBC^#ڷHl$$ib\\;uwj󽳵㲃O).-3oQy%2O-\"`\rt9\0փAH` =oCJ.y;O;\01Gmq>·T=Zn&\0p={Q6@{H4&b?K@3|t꽅%x\0Ef/L{ռnxVqi.:[Ɯo3۞K<>oZtvncw,?G8ջ~c~՚wQ莇mq[}=;6{mq\ry_(}Vsّ~8\0C9$l<#p	nLxJI}gb;ߦl#w-\0%b$-\0lonP߬z?cxBO]>ke8BIM!\ZVersion compatibility info\0\0\0\0U\0\0\0\0\0\0\0A\0d\0o\0b\0e\0 \0P\0h\0o\0t\0o\0s\0h\0o\0p\0\0\0\0A\0d\0o\0b\0e\0 \0P\0h\0o\0t\0o\0s\0h\0o\0p\0 \06\0.\00\0\0\0\08BIMJPEG Quality\0\0\0\0\0\0\0\0\0\0\0Adobe\0d\0\0\0\0\0\r\0X \"\0\0\02?\0\0\0\0\0\0\0\0\0\0	\n\0\0\0\0\0\0\0\0\0	\n\03\0!1AQa\"q2B#$Rb34rC%Scs5&DTdE£t6UeuF\'Vfv7GWgw\05\0!1AQaq\"2B#R3$brCScs4%&5DTdEU6teuFVfv\'7GWgw\0\0\0?\0m6\'wL^bA#0Ki3\0\"HpĕI\Z@/A+AI%	<TZaqGbÀ8\0\095KI#Ħ\r9^!=mm&%0\ri &\"zd9	OLq-xBݸ0G\'aRfGvO}V\'ѩ?4.2A\09+V髇ju ?	*G=PkH<9wf>\n#t\0BFI o}pyij	;2?u\\\0ON\\A~{oIFhZ4/qp\0W\0Ez;{|{=q-ם7&lFuLvA?ԭzan\'H:`\0i\\D\0 Lj$jp}]@=]GdLN&Aɩqh׺wZLF9 ˉ\0Q =>[闝8?oRn>?ըnD\rpN&_$߼?t>I0dp1\0=րzK\Z${ú	ԁ1\0k˷hCxi)FaJ(h-7HCIOIk$%C0ZFL64o0$ΒytǨӰ\"5:ݸVD؟\\8Dۜ\\Lj($u.\"4\0L@ ¶	\'Hdnl$@!XĴ[vey,ix>@~c[\Zݯ0jG硱y$4*	p$ΰIxӍu\"%Gv\0KvCHŖ2Id\'*[vu&L \0\0iL3sv8.4RW\np-tç@ZդKg%i\0aӯ	?\nH+1 \' -{}P:\0*n	Ν	֙9΍5uCk̇ILɑ)iO䠭ĴO:z!9Q\0RkI㶪$p&50[ƉOpn-$:@CJW!9\Z!8Kj4#GF@3\0\0͖ȆQHGCIDkLP ˶9\0S7vo43tn2G$\'pwLl\Z=\0;E{@S,s}\"~?p.:Jm]Z&%ϓ?Dϊw8Q6IRk6\'^ŖmiOH2\r	F~0vB?ײk$NLɝI\01Ko\'lm@\ZϹ`\'ۓ\ZZ]Á%>Hs_H%L}!:Ѿis\\yڡ^K\0\'H4@(,8k_î)ax)ϧhw[5pDq-\"#H *&v \0\0$\Z%1oh}& ?\"\0\'\'A ?o\0_塱i!?]F?qUcslsI\";I(\'vpG*6mHp9jiA77zH-)nv;4LQ2.	_ h/\Zׄ\0œ][d=IkFΟ$c3r75sƭ<GQyKK=oGJeŠn-):\ZCɗp{uS\0Shkh>]\'C\\C{HWLA3v㮤kBH j$#^oy=՞~L\'e\0\"fAay*q&(l?\0B\0F1\0yD\r̝\n#\\u~\r-̝	*,$LBdF-vR\r}&[@ײ$6`bRҴ7~I+s`kpf|P-oэN>Dj%?:y\"dc}<eD$BߚlI?N%#YM{&qjWV`i #4: \rm1\r0]K uxJ%D+I?|y2d@r`p#El\0˚	l	\0?k@H\'B@JN3y\0YFS۹GhhއZ$mr\Z4:55|}-\Z%#upŲ\'Hi9$Ԑ$@<Bvt7!N;ǀ9OLtcqV% ]$<{-{q=(iȑ!!\\)~͠{zRݨOcw6[fu2cؓR5bBUDJ!%I:<$@\0)Oj|4@O}bͤ6dN}mbWr3h\0I24ֈzkGr8@L{`5\0FW imd@?G%h=|`kkapIuo*h=ƒ?In-<\\1ОܧOGM(OAڛo0?i?@J!6=\'=\\ցbLq\Zs<;ha{F&kKN\rs~(Avw9ps7N;[Zv\0OU[ `ƺ҆-nyTI\0\0YVK[<w<Ob1ӿ\Zړs.>qjIHhrHNmpH=\0ud$(l[ ~M[i\'F-^>wSF6j/el\r$A/0N?&pHZӡ\'o	#Pt!3e.h\0Rn#Vt>	?-*$ꮚt^9Sl	\\!Ӭ~t*R|@\0\n{[tF=]50xY>:?d\0>b?{k;S,\08\0t<e4%;[HA1BJMVFLgxCq6\0A=HS{`sd,M@6Ԑ>9+k|?7{@\0L&4(hAO5`	?\"\\DcliQL$Z uN:-2Un\ZΚ`ȯ Ɯ*\r$3jV3~o\r>Cn0 tJv\ruų/\0PCh!BlWofMƬ\'Ƿ$fd 2!lhM] ֽ$˴x\Z3㯚0 1If\05Z,tk\"A0I恼p<d87ǐ8F$tDaf;EH\0Uqq:;:(1\\$M7apdXא&|t%H\01O,\ZxuFG!܂HEkG$4QsԉrRo	hݸ] 4dZn @ײ{ 64cZ=N\\AI@丈ܪei sB#d$&6f\ZC\0wj`p\\Fx\Z J&R0C7\\먏P 1u{`aswO	hX\0[%\n\n\r{x&GT\ZKXAr;Q\0jҢ77PA:~>Hd\0	Ar#	N\re\r\Z\0<)M;1\Zُnݵ\0D}BC!ctqQZZN?wrV\r 8Z$A442O(i_Qתk;B%lm`\\׏MkZK^!@=\0cwl]$i6v \"ww\n`L\0x	OQujf5y7)xȝ|Bhqƒ7Ho#a>o4\"H\rm2v60C\rSlō.?K?J#]aXqR\"\\wn+Iӹx@\0m-OdMz#*-\ro\"ڮ\0w\0558AտI-ai !AViHY\'[\Z\0*-&t&{(pq5~!9=KxIϓG:WU\rkk;ugiiS<̍H%4\0@	O[bO-n	{Cgx1\Z]<堸`?F`8i\'o-D \0\0o\0w<m84kL;w` hhO)z-\0<~h{YjI\'Гo$&RԆCww?hGVܺMuꦖ-T\'ʛli\0nOg?}-v˜H!3r[d6\0\"D)W\n!\Z\0iB%䖂6\"`~Oj0.x!e@tLwvVI!kbL\'!0vD>ic,9Bo]5ۚɡl2Ӻ!a\rx<\0Ƞc3%hd{?\n<nS\Zjd0AI>I[IǑ ӘNOGO%1Ā 7C)8j@&T&DF\rE$$h#-i;@LhsN#Pˬ$?Rk-\"XLđۿ53c\r\nY\\$]\0ݷB[~kv44OYI-@sg\0o^#F[$p>\0WGIIK~&w\0	3\ZhVbͮkt$wtv N	5h0v:\0ݹ..!O/ja4k:?R<h )Z4ӱJV*ת\"kl#sG J6A$#suj\\7P1QP=3\Zc?Tu;@\"!6l~rE&I4\"lV8& 硒	vh5-	7Z^\\7!)^U\nԲ\Z=9:\r\Z\r7pҟ	ѐA䙐Z	>\0ΐ>EHk\0A\Zv?\'˄&$:Grt	\" V8 w\ry*=;9;Aڈ֗`Ajv6GwydlU3l|\n\"u\Z6^%)Ȗg.g\Zh\\i\Z 5&U;<t83\nv&}	&#_E\rtHIT꛱G1Gp8L!Pkg\'vI:?fV-dz$)H2\0fGg L~r#_.$k\Z}x1c>hPx,ο;Cw@k5ΰӓ:Y6Ga~ nvHm{\0:}	x&>(]uݑ\0N\0v4Ki&	h=	KIQs><%flUG:)4?j{wѷh3vP\\C7D|w\r\'eڂd8{x璤ukb\0RNƻA:8wMcHnѠ\'jsg4ږ;gwzei/x\0(3ѓ?J\\mn9:)m-s|o\Z\0K_!\0OkKdƥ82Z@Oڋ,N!^@\'Y>#Zk7vio^û{2?{34FNip!ݩ-iϩ;#]gҒ\\-<gH6ev66ixrmC- \Z);լj7Qcof?OykEh]2qHD\r-\Zx\'$Ǝaj GwD\'QICtj.{P\0PEfw/\0}|9R.TŭiOt(\"{D~x\'J%ۀ:\0eFOgS3 \'@|\0Fk ?ġ{@.$ԍZZH\Z*t(BL8|A(U*W߶<2H 5g?vTnА7yo#ذV5i>:)ȞdnPh7i\Z6λ-q.\0A#\\qn6uX$9\"\'>)I <d>J{I r`ON壑Tl8D\n{I vM4Fvn\0igE=oCܢ9-?tDӢHUsɓx)4h?:Ni*l%%+:~*vtIRhscJ$d만I)wָ<Pi{)\0}ΐ;j~8GHQFh|}ߺGk\\A(XHPVvO{\0\0J ܨ@t\rDv4oѐNDk$d065G#]B,7c[$E56`|>gLyR[ËKc N$n8k5\05\"ynԗh? _>)KHN\Z!hBe؎$*!lh?G\"Y[]	\0M]?DzW_^RG8:3H\0#K4z?\'\01Dh\rn݂G.w	tTlړAuQ\Z3qsCLHJrV{\nMe; #wU>$3uR$X+5\0i\nF3069jdxп pF.\0&e8O>x\r\0RfѮtKè<^Z#VT,Ƿ0;GT[(5B;\\ٝ	-ݧ,T\Zu-$HLݮT[o!jI\r\0iL\'!u\n<Si߸AqsgMQ\ZO\n\"1\ZI\"xN^Yq::\\O?ʥguUm}YqPXD`jc_\"\Zu:jLC\Z-0κTB1j`y&98I=\04]_Mݭp\r	!kp d:$N9oJGCT7At5mvǟI/գV$	& 5i3NvLHl:\0I\09=ms@p[(Vݵq3jsX$ ~nv\'_4Y.:gP|F V\"y?5N-?wpv,lkEF\rF\nF)\\L$hOtn\ZC\'n0õ:\0i7kl$Xa65ݴ\07jOI\0\r{\r0\n5\02L?ѳ9\'4\rNlL&l@DIChnI)\r5?s|jv8bY3>A\0bdKI*N  A\0$Inj잶Ɏv1hQyNw` sO]N)ڑCZF{_n\0)%}!*R4JrA2X8\Z \"5)${`IݷN;)6 G\0%FF?dwpBjU\rgw1!>Ӱi	jyd4;0=NAWZ`CߏeDii!kSH>7_\0|?\nDK&`m p$5\r;u\ZM\\JXdH<ԋܑaG/GnГZ\Z=S%thڠTn!X\"I&xL7|ӂ?Nv[v.cX\09MEk<\0Hmy43Sx:&\Zc\'\'\0O\Z2yR|D#IlwNrgAǐֳi<|St4H\Z*:a0y0$מg846gx82tuAo,t u}v\\iQk2ӫ|G\r<9nΟ2ى!F|S7p=\0ȧ\r{ZxgIVeÀCL`!t%]<\0t#Fο&u3\ZQ\0O`Ag葪pj4\0hCt\0P2v6ZV.as@\0I I{&p{ Zqԓ	8A#Y=o\\!9fdv:ZmDdAtRk^+-$1\">g=h3>Lv[P4;S17<GT\r;6ƽ\0p\rHA nc?(MS{Ûߴ\0}A|׿\Z0@wcsP+Ƣ29-Ec\\{C!njGd:z/J@kRGyx#\r<x<L4CǸvtբo֨zk/PHD L~?5iLSI&ح\Zb<<Mo;踘-:	ᅛ\Z\'y-L\0T.~kZ\0$՗zfxF>;\0Fhc6\0\\t=ъ۾^	KX[	\09)48&[A?k;HҫV^\ZQ][koҙI#R9͂ScWK,tCh7XJI<f9q2<Z͐{O}0\0\ra\0U1$%\Zēv@0\0Lp4	X`p9)ւKDG4G~L@mqn`{\ZZtTxڄV5hvdǧJ`l[\noc>q \nD`D2egDV$w<|=s\0LG״OjaUNz0$vG$fX?7\ZH 7A)vV:`FFKb5܈431Q1Mud9əH5KVE熴\0n_{]cAED$Suv|p5gM2@%)R;vڟ)4~KaI$\0ٞ>׿}ɞ84lh^g\'jPﲜlh\ZSs)bcI5DkôԆďw\0i;H`H݃w\']L	 -B]H`/	-\0L\r81R7P-dsr<]y-d;@զޕ&B#K\\38L5&u\ZS@#CP,ikh<y\0Y#B7GQ1>{Q\Z\0\Z5C_m4Ų@N1n:h;zҽGT\0[R$D\0goidElA/\'A}?M葸u\0}i<pT\\^ {cU1УyοS9Y	Rl2.\\v^h;J.bI\Z\0jpG\'XJ%ܻ]#ȝWwOoyQ$Zk\r7%Mɗ]ZWu,$;kVKptgekEGk\"x-J\05́kDkZ^v;GC@4ұ#:E[+CN0rA\'\r@~JAKpKcmJӵЭ񤙔kC*.`sT*pcMr!@4n2HdN\Zyt\0ؓϚ\ZLgU3=$8eC3e\"&wJ,\0&ZKd˸<\"5y>\'OZQ$s>Дm.S\"dwN}ZAy<NU6AC]y\0RMs\0#R\Zh;dxB a~6@K\rp?DuU:*-h2Iۺa\\04ctq*·\09CG<&ȊH\Z{4\'-@-w\0\'sj!DQ(9?4Du$|9Ly&-RcW4㲁\'A\0RFAU3^ty&{\'Yi$H4Ikt\0D5!3RU`1m%>u!`4w):;\0X~h%j?~zi@;Lun;k3\'\"Td<}-\"gN\'\ZA{\0¬>Dm@#?Un s:$<\0>I\n@}5uF>w\Z]-x?`lf/\Z7&`n?DhOePh2֞`$佖\\ߢL8ߓn =\r	$\rdB:ZV;^40x?LcOi\ZuIp<p<l/:S7n:$\'@Y\0Tn&F5bZ2qţ_|P֒5 xru$y!K\'{8ՍVmx2[\Z?GfGN-Ѡ4?Ìkx}WԠzh0Q}ێlNxhS8}J\0)q4RsX\\4	PYcngƀrUØwiP\r~(WH\'^s\rtJ\0 <9ϕ67K]A<IKKOu~ᦝ96\0ipj4\"u_Ze)oHl		\']B֮78\0p~0]&C?%lAe@~#R.\rsBLA<\"7qU\r\\Aǚ|M<hu\\ײNbx	΃*;$ʌc*%v@I\'f6)JZ> [nPDG5 OAL#KQl\\m; |ݏ`t8~$vM7.f0N8Jݸ	R	\0ưq;wJ7^JJ=ÿ	}ǅo F\'kc%g_+M4\0>\Z=LliFQn#Od+~Rh^A\'=Uۤ):F~TJ @?H*Oy;̬gQ\0Ry-@)k]TuZ.h75Ĉ\"9J4\\O\0$	dzwu^:@p\'ޙ jp{GTIk>} Gl0		)u:SLnhiPZ!-`:š\nƼViKא^\0b?uO$ô\nxG뮟EoHۧiVۇM\0G\'P+D\\$=J}#Ԕ[ ɍtqqs{&G>i\n6@l[AlH/SZ0ؓ#^C\"tZg_$Vs۴SƇֿT_Z9s 7Kyi܍sX\0S 6sF\0wCR#ZIG&9s*\Z\\Ax!F4	hE5Cbׂ#)6IqE+KDvGyiB<ՑDqA\'kc^9ouABJ?41bꗚ.^Eφ59A u3U|hZ~dDsJKA-:ǲ\ZHu+ |AxAD\0d9P]$Q:\rJR7}B#RD	C\Z\Z{Bbi&t<\"0̆ %<k߉iӵ-8%KX9sQۄ``yv	תiцaʓ>=!QNpwu^`!Z?DwJ2tM1*ΐ`\0\'Sc=RZcH-#qSkwR@D>6=tnQ\Z]H#57GRԀ:%chq\ZIYh\r׺d=(۲y$$4hxSnv	#N>Pt\"\0]-v\r)ix,pi_Gake۲4C@|-7p;oұ׺6sO쩖\r-TD4  -vD2|P}~GnQ˃@vTe|=\rBC4ԙ7hˌƂv<Ω\rv\ZI;jb(	ᧂ\Z4mrD8OLm ېX{Hv=iQ#^͟vý(;p\0S-<k!dIH\0{4DS9x<%X/:xޖ\r |L{{@@֛#զ<H~@,OdB92?tZalm(0̏;X:LrTQF޶@5rI~Ѡ8	i-ΆG%	\ncCp{vsEk{@V@:1kh;TqhL͛+Elu {=]gTVc{{XO@&59N\0tlL5!A&5;tEK\"@%|č\\Fx$[Hn@|=A\rBt<$9{B$oQ\nKmpfT(/crHzE\rg|ӣ]\rВxqG򜙌7\0Z`Σ`cI1}GencZ4ӄxH2Dji\rFE	w<D}$K\Zw4;Za.;`k\0N1Z\0O$*!<*yr*R^@H(i]YQ\0\rs]a|4B{6:}Q5y.#w\'/#	왱$8\'A)\ZUꊻA-pXmy\0ڢ]=k(md%#-GTShp`YCsLbS׏7\'Z`@#TI?\0np#RkƿL$]^I:ҏmn$ Dx kk:H\\O!s\0@Qs\0<SW٭N9NIghtĸwxi_c+djh\';\nM\0{|<П$ƺxHk@\Z0]4ԧ%\ZGV\rݼ	6kN;d=1\r??t.@uv{I쉴N]wa2DB@f2{A	A@\0~StӴ4NC-L%ػ4#]u@H#Hxx;\\1H	гs\Zi<(HhyͬKb$F2$Jgn_?R\0rJPwѐP;$n$8\"@KYs`F`	ܮuvS\nLE%2sNNcT]鲉\r]eOB\Z\\Oq\0R8ؽG\0ƶ\'OB\'Q\0\r;gO\"4 lGʝ@\'$n2S{vYmS\'&qϊUVwL &\ZxJ!ii$\Z\'^D]PYbkW#2L{>HGW[Dt%@u@yV	Zx!J!1`\0r:#INH\0i<$#\']c@N{r;֚h\"H\r1h\Z~:$QvLiڈI&GiA\Z#Gп]C\r;<A:;Eߚ\Z4{``H@OvVi({\Zd]-\'4G8\rx*%<!I\ZHk-؄1fAE6C{(z%t54+[Z}I`Dc[tH#S]:$>L\0޿2UX6\rgPkŀIR{\0q[盶60Ď#k:kvN#Dxu^42I~	\0Ȥ	\0jDFh\ZH0\n#\\O:HCkCOM#Qp# m!D}ڄcK<$A;\ZP nwӀQP8K k=NEFѴ >1~\'iS,hno4=6M%<J%NxfB_IᇎI!JvKdHvBuy-h\0(Yn$GQt\n7QENrx$sJ.\ZM)4\'GvײuYDOkClhd&mn.!rI0<|S(Z4%F${ctxԦe{YOK+RgVVẗ́FB\0:B4\'BZUG]B\r^>	\\Za\0j6}TUcM&gUiO̓]W<7@Ch#Qpt84<qRZ-\"ٽ\rc|IO#A@O(v@TwuJt;f{ɝc\r\rTE	-\Z3Y{L{al3Nwru|1kPF%sƚO?AkK3ո{(XʎX]~n%>t<sXF&]odQ/\Z\0Ux&H`\Zq5ě[^Aq\0CfSYV=#Xsmpߒ;\\b}K`\'32yV$=uNKCA$\\FF\"bw7<4D0Zv?Gs`1Y3@FTO],_RO*mCyAIrʔD[ݩDk#PaY`ˣ\'C\Za}Vx4bh@N\0#㪵ݯB9iҙT/0wa&y\"5f۷t2\nCMR;]x IP\0TH2Gr)zы,`m3\\~(ohݠ\0vH?HЪ2`/;JpP\0:/䧴GJkt;@H ǏA;`;ItĐ<5J\\{Q{\r^HGh\0$Rt Zv:cB\\$ h\"O;O#<HF.t\0\'uH=jvnk q@ ?D:\\`eX\r\ncsv\0`4KD\"Y:;XՇ	^=6	DqW\09 #	n2ѯ ޘ^Dq!.!N\\\'B\rAwLsO}Zy\0|ɅX\'B%+uQHc.yS͠$׈ѯqG,C0<xN_:B$yKT18n/7w>\'LwQWh4ERhDTsI!:~߅\'|E-6`nD\0r@qlǒk=\"4;R8<\'i-Vz/5;P{L/#OH\nCHӪdCA;!DS\n3-yGlw-v\\\0n=	\0Ssժ>+uQVtv	9\'O[\\A\0XwH(C>pN;DdKy<e\Z4z#Rte*nwn\"s1\rUsߛ)v$yL!;s?wbt5;^PZ:\r(h_wF\r\'HDwDZT<TA?0Nۂ\n\\<ƃjObx\r={KuWAaLP\'3\ZO\'G#ƀ;aptQ7\ryDiyh\rz4:}5ѯtvAӺp Xn~Q\Z1 \r=kt&8l%䙍9({ן\r|1/ꢹŒ\Z\rPԋ\'c[[Hi;qJeۧ߇u48\'^hA}_w\0$n\Z!Jtw`k/)[FzL{H:4ϴx3hw\'S[\0B67BGR-6c^7bOtk&EM\Zu<%6\'wE%8 Im`ָ;wSxi8DFG\\*|5	VQ\r͂DxrPSeq=ы$;g8i	 [\Z@TCAD\0y\'΢DR @#`rIwq3vO^ޞD1⎵]\r\\k}F#潎\"5\\c~? Cj}T<(w]ƺO\nL{\Zi$8(\Z}lv$i\0ۡƲ<t2|4ړVA4K8qk [#PyGHg2hk3T!w!Du6Jhku>uLZ⼘ŬS\ZHP`{Cb~HEi\rO268`Dqn#X	:=^`xO\0\"fG~H.\Z	YE4$~w3\0(6TdV$i4e	\0\"vO([\0\r\0B$E$PF\0\0*APpg1%YdU푤OA)-];LVf`@$WTo;~D\\ uʝGfO<[_Ӊu\\2Z-4\094LIRn=E;TTϢ${P+\Z^ٞ<\'ur7\rRǃ{]↲$p%{P[Ps$Ǉ\ZFǗ2Yh79t/	̀ 䡧Dcppi^ALlq:t\'\Z$*ݭ\0\0o)ä!Sp4:Y5]݈#}˼\0d04$$1Vd?ଷkI0HcuWR4iF. h` 88Y.xQ6E]X:\Zk\0LIߝ|x#.\0ɰlqIk.3T;ƃk\"$NE=~Iq\'J7\0$thF:2\"\Z*?ߖƉfi	4<l]8h\nw<Jø\r	a]ﾬx̡\\I9;A1[LBY\0@v\0r\rM`\0ЍO?Eo晔w+ǂ#NOst);jJp|t(,;	ʜFtQ:|8h\0쭭w Mas64N=uyN0N@-}:uJ\r(n \0]\ZFRZ9s\0xInQl]4\nzDC\\$JwiH{ R,?uѝdcR;Yo*oFkvі88@B{^ZIFk G}R-F\ZHUy&;\n;{{6v\"\0x JyO\'eLƈtXc@%|(J (0\\u<T\\07v=${\0I0pDO@m\Z\\$X}sL:GR8\ZS/Z7kK~=\n/>	tMB \0OfahB[D/Stb;\'EvK\0vIMI\rh&N^Gn]ߺyVyM$4uIn-@ۤipp=P	HHd4@\0ewcBmZ|0?\'^`0G@V5UMDߡK3A\0{P\Z=u<q&Jcqwa:B.\"GA+g$k\n!G,8\'8A ǒi\"]@):UFN2t9ޣAD2\0U7H<ƀ&Zv22e@K@0Lmգ\0Zm0~ֻOw\0͞5Fh{t8Q~TZ%:&4pKk7x^_\ZwV\Zˀ#9QgfL&p^\0CS>4qh\r\'BF=Q.2E6{qp0u)5\"L($^\rD?Nk	=tA~*Un0žœ YqqgI4S/2?\"֓V 1-%(\0ֈ^Tw\n=SLPlv$x\r$)K X\03N5؁z\rn`gDЀ;\0\\N5 M$hAOrG-G\'\\]R#]ʎ/$\'\nj@\'37w1BM$\0为Rk\ZGA<υ`׹N{Iaf%Wb]E̢U{\\e@ Y,ƢH&k%E{d\0K{o2R 1~A<,\0\'MPH=ɀgXwjI \'FhxQ\r\0AN\ZHpkO$e:IrPdg=r5.l\Z4(~i2kBm\r%CDO.R\Z}ӯA̔hEZKH&Ino=ςg׈UTu\ZxKuZUa`ys(zyVUnO鹮׊d^ &>ip<d)6|8R!{7!$qtU}\ZəVvUm.d-|:Ѵ\0/p,Sl\"Jk%M~%Ket;{xi\0t&;q矏euRh.;tʐN\\T @\\e>XͺcqBcô\'XS9>?ٴh1\\=/t|uQ\rK]\'\":Pփ~ʾ.\0ƺ\\\\\\th{\\Z@#Qp0G<;Tz.\"?KmvDԦDVѤ#}:>RgN)\nk6XXw45o%}.Zө롭$%ޚ\"9K\0paLbyO(y3|L7wi\0ΔND	!#C&vhLL\0Rqh;ϲ@YH\raKngcNp$\nq\rÿ`e)@6c]Bccw\'(x\'VYhkc2G>c\'p 4?ͷa$GnCAcN\\Ҡtp=J^7\0\rki5#$\0$b>uX,4@\ZOdv$sHt\0?$~iM}d\0$\\KJ`\0OűZn7b1G*G	wYPb5 (muf4\ra@LuǄ\Z\0\0JVڦkwLEfZ\0q\Zum3ZD>JBkBx3Op*ph$w<ѹǟ&\0Iu.YdMn^fI0D;\\<	!\0ͦxR\0=\"}kuHE6ĸ0]\Z{t/TO\0%7ǿ`l\r#{D(U@[xQs\'e1c\ZHi|9P{H\Z8S4|RmO\Zkcax9`M╮K$	ȓ[ےvrQl\0<?TLN=^eZ5״8ϏKt\Z;|}+G\r+stHBc<k*$	+q`$˝%;_;ƿw1 wKeO\ZL|f@:IIA\'&)jR-&\n	_t\'tmD\nU0tD]isi?$D>ȇi%^tP6wdz@˱:L)3On@c-hA*{:|>_RHH㤃>e\0b\'6@ejvi }}\0۲y?HjxׄtM.Qd8t#xEFDj).\ZΉKRQ\'Cc\0타\'}#<*2wb[/#I6gC>Z쨽&A\Z\0r~, ָ7hGk<j8Aqciv;t5Hf`\rgZA\'4!{\0:?zQXַh<9RNj\0ݓxF4XtLl\0\r~MHufI\n3ʌ)\0Y@\09ya@I\';)Zvu=SpPC$	(8\r$pL\0PK`Ot=!:K\ZZIqkx85H8|97xx:NkYWhc[\\6ƻd{(\'^ԼLP]P9S$e&OLw@\"z&+mI$IBw4̸r{ l.$&e=. :l|<>	 7dB<dvjN߁Vmn\0w%#cDDkr+菙kk(v␰Hz\ndvF!>jFc˧Dv#}5@1\0Μ( !Ep;81P% %#Q@wd7]dkH	DRHL)4\Z]#RQv9̗I\"IQ\ZRF\Z\0D\nt@٪UPg`-\rZ	U6<\05Y\0l|	J 6ac+4lR\\\05!U$DaAhQ\\4\0HQŭ?x\nOkY8D\'\rd\"_G\0I#n1w8YK\0]CUKE:\'?̢:\06A;#\'KEެ.!#vuMIh\'<[65{5#YPM{??꿲\r.Tŕeasڛphnk^wdHEQ7qLkq;)KjgT[k:5]Ű(Xa&50q֖\rW51	DDmd4NĐ`9`\"\'E\0<|=54-UwxxlkElN~%Efwv\0RSLCG\'07WǷ}5vRZ[ws\0B4Sj];ʉaB9vS.$$nw|5\Z\0)6FGd{hqvt\\ol\rG1(A	\n\r4b5!l1ϴ3l]3 ̠:\\xOҗF]nO\nnΤ챻|\n`4ti4?%etPDG$vRs@N$koZґ]UP4iTL8#sΛOuǇ0~\0c\rͮhn	\0؟K\ZNЁ\'n/65ݗء.;7y`}=JD@敒0\nU-\Z[lO]a8Fz:4;08$V6^JMٻ\0:CPh\nXLY\\p;n\'}V<EDIl$\n^aNޣA8;;O쥍C,32#̞%S]HNO\0VK\r;B\0~*^\Z.\r$\r\'RJw[3|\0\"e֗ir@\Zi\\OZ#dLqe0]{P<u)	j5J@U;\0NA\04>ƚ-ռӴ%nB\0k-A$ΤDU\0JCDB\ZHI&q=ӒhͿB1&dx=a;II`8uo_[$iFxO\08AuJi Ek8txQOxPׂtO~	pB\'F>B)icKUi+nqGn\0	hky\'+ݾ5%H\rwDv%aAprXis΀rn9S}D4{;0<A\"5A?JOhje:vOeq\r=}u]U4<F<+&6\" V-e3nI eL9s]xLux?ξmhN2$kU74\0L>jhk\\unC~?\Z]*v6$RhRkSю<\'Wc0fJ{$*$\0i )x~Jf\0htG;^Ȟ;`.QDmC!Z$`j$83۸L\0x;~q:x+-no~cxhNh;ZF\0AE\\g3_S6oc!Wayq-nφns`(td@.	CH<!0g0	G6Ψh@c53+NbSk%ʢ$wsR76F@$ѩ+f!2y*)@A <d㠂^r5NkctÏ>Uy\'@$}_1mV@6?5;hvk\"PO_j?7O\"831:\'ٹO/h.kF:A\rLu\0>5KI+~m:W\0\"P@sDj\010Q:QQ\ZJCvƊv<4\Z	Nѣdκv !0\0)1n	y\ZX	I.;1T=;xRC})wo\".u1x\0RM;QFm`cxL_O3١05%;e5`Bk鸐[\0\"sD4mnI)A ]\0W$n 5={@U	a$:&Jw]\Z=㨇l>cRax,v\ZĈ_RFQI\ZwN0\0T[dH2%(Rִ$:e(Ɏ4tluoI// jGIHCNR4%[였;4;hH$h@^#R%)ˀ;FaR,kLIUE톷Q>Ǎ\0ԣ!_\"9.t<;6VݲK:J8Y-`/>5`_b5%ntl:k,Ԇ\0|Y>klY@i ؕkcW,xq7G2\"|SAc#asG\'to>b vi\\N>D:(U4l{OSi㐂܃5聡VT/ZlȞʨ5|;iId7y>a#GaV<\0e]d\r?\0<{r]5N|\"j\\IU7~ D,0捞3ʉ\0o?m^̜>yM\n.2o5:q`.=#FVF\\ƖvNj{5פ\0&kt@BT$D%	#Op{=	Bk,y\rTdѠ5d\Z%x$	@Qַk^KRm.\0j;Q][i4$ߓo`TI%d\'9\0#B}]^%1?%&3S$O&R!w8F.\0v*$@\"$vSh\ZxvHY\Zt+ls74/<C}En\0$ok<Z<k\"o=}6\'VI$C\Z\Z=s\"Mq5\\PK$AwRm,a8f5Ē\']?Q	kLm#wgfƤADZCIoX2\0:ϊ}:\0f5^?98DA6ة5\Zi:0aZ:;t?OϏf|CH\ZwD-Lt2ڷ@3H?=@JUM84*qsRcno5Duaܢv(KZtfӳpo\'Yh5&P\ZFY;ׄJ8L\0<K贇_\ry$˧M4SYӔύ8pkI\"|ٽ{9գ\'Ƴ~(E᧙<<uBum& }+|TCrNq?HrsM<U{	7[vZK`4}V\r2uPc[ F]CfFR$3ΚhOhG*iy7vMϴJ0s6Di-Ugi8ƿ^Ff8\0x\0h«4`u:!ȟN!%6>\nչ$~5Iq3zpIF$+eЎhUt7pbOrKv+\"\"*\'1\0*>l\ZO/\\]AWtL|<m\ZO#E\Z;׵\r1$dh jd	:.&4H	Q-CR$\r?\"\0,\Z]	EkƐh\0j*;[Edv\'S9`-\r: jA s$%;\\	anD5\r`hc_і5i$%%Ѹ#vOu,NM$#KeN J.wOqʆLNCzs4=@KOښFLj\'Rl7O\ZZhR*-L)kk9Od<1:<F[$C湻6>DpևM3]cNmчyPcv7\r%ғDu\\T7ǹ7tmq(-27FE&t	ѡgvd2hдv*շR$>:nMt\0mjl]DpjUNvÉ;YE	HH&-MGq09?q4]c?dishq\'^7	z\'mڈ$qM߾k,scDw#Pȓz}\0(_؍AªO};|qk\rIQd6~,v{b4OI{lsf\0\0m	\0t IzxzRkV]52R.-\rH׏Ka_z`hg@ŭLq`#\npZ7o;G%m5X\rßpeݞ.˧!*Kc]l;{v2Ďd8o#l\Z5wL\rfTߏX1 5Sc3\0 _DY~\0i\":$\rUǑ\0T_k\ZKZ4S$Fj$W@3Vdm2m\'݁@/QsM@5<t;tF(7\ZBaө۴ v:a&\\$@ahQ=&ǿov:Obt!1OtTkF2;5Ck4*U7uV%RѸ;#mk-ҘQpazAⴂ*I NFa3I?A;!{4KWo&G>xkE09q\0M@\" ՎD57wG#kt ǆ^ j|N!ԑ扺#\0Ppis#)PQ>c)\'&\'w3 Ge0~~HZ	qy:ÿJ++t>dDhu?D- tN(ǨI)c]yR\0~!97;pj#!ѯމ]tBxw\056*Xp-&&g\Z\0!akdÇ Wqkb\0\"`8yܣH\0z`|y\07A|{˾08\nvmwS	%ZWDgㆼ4iI{O<R7j5w\"6SP̡!\r6.y$l<GNk.u<B	٭:hc]64UBƋ_c\rfN/kA-#PHܨ1qn .);sh.oGJehtP.p9M](jwF$}\"$&DDxꑳ\nk7{)`lx4a{zb_;KP}Z{Z׵kX\ZwݳܕlHxkK<Oa&U_ 6=@~oӯTkZfcZb{*ւ?$j8Lj&Mce6A_B㽦0Ki$	ځA=\nMbI1ywKK&Hnևn˄?/5}X :	0ЦVtiz\Zd@b4)@\n@#R=Ӑ݅ЈMDG\08A\nta.$\"oq0uisb\"8	p\Zj`Ʃino\'\nmUg\n,~8(!{\ndn|Kdx.ho~߂elop8c:}p艔\'q;4R\n	wf3;\0(O\"PVN\0ir$/\\4=|Qkp{f5O\ntk?|fq&d	/G6GxED>hz#IQse{Bmn\n+-FeN VV6{@ITC4#*ѮAio᯴s䌢H*\0-,M{whb	s(8<>*2!5oP<\'I.q\'QYkI>c*\'n\r@*80\'R||eA\0O]8\'FU/P](ѵR\ZeFXy-$Ą=uQ(~w|g)XA0#O\n^\Z\09LH<F~\0 \\þmږIoJ{ꚭXݤǵ\ri#ntͮq6~%Ĩ^{#el\0\0O5Mv\ZN7A*3K+ݺG4DQ#o?`hh\0U1>\'i;I4?rL:uه\Z@\Z̨$dn~.\'Pnvɩ9=)\"JZ-;\\#0DjFejIK=!E\0ˌ\'04cOAyi\0Bp\0uxzh885>@\'5	0PK@wSOԑ[#YUy2zvUDFj<=Y1ֵѝmqt4IZHt&>|=\"$QDIn؏hP7He,Klh:\ZwLGi\ZrI\0>I[ jʃ?G9;Ɗnm&8jT:4|x@qdA\0hēq%+HEedw$&{7`y6D\'WUrK]k\'$\'\n۶L@.\\YifAF\0kBkKk\Z{\'ƶڟ5alw[wp	\\B\\}?uItsc߁z~;\08?HoD]a.#\\C3$OP}b	`[NL|Jxۣ+I&8MIl!<x\0@sˎQt#e=$[ bvƂr?lJtivVd|~0N]ioLDxDeoq:7AEN3&#AQ\Z\\iE+:&PwLv$*?c,.A\'O+XqUF	{kG\0ȱf1m%cWe=CXH]ΉQm\Z\"KJDe/lLdiLMuNb{\0ƃ#A\ZA#E?LdY[8i1OyO{(xp;#virϠ6:!}[\0VnvIn}%f96XL<KU@qnIoZ\\\0ܯIYk1 e>p3!;a$;h.[8Z%恵RgG[svaiϵ\0D*X*5X\Z\\,ѹޟ[Fi-u[l5]}ҳ?7D6[#aSiw\\kŎlw^\0h}?>\rDAkeoo1hUC)mMk[\0!۪ch;=fuU{nzCHZQ`\r}Ĵno?)^ͭ	|8CƦ[Mmt0mf\0V͏UH&\0<pgͯQ\"u&~8	\Zϻnw~\0\rW>=)9%mv͟Czk;^at0C`-}(Vppu{偭Y؜L^E~\"E[!=M~Ahku:C]?Os7m\0.6,nd\0qgz-a]ߚ#\"hW\0,͸9Ɩ][C\\n\0T3:k[i5+{tkG]\\X|nh 3rW϶%o{ or0o.\rvK~#I81s^md9սC9K[?3tCU\"Um0]zfZ5\nXg͇	]cTlCu\'NK\Z=k28nJmq%]x+<@\Z1{|{5B9݁ߢx;o<5J}hIQcK{{eO*uK7HЏcat\0 \\Y	\'?N%>7|eV}I$nG~J?Izl-f>(l\n\ZQTvid63#~.^ ?CDZhiI+u۩a~a?GUinEN5=k;_{}/b:wni\ru.hc15iAԼGw\Zv̑Z[yѼ\rJlgs9Lvֶǽճ-c::s`ct?NO=W3ւ\\A?s.\r-:A}V1\Z\0ȖF5C5uwaG}=\09	Z ʰɏj3XI\'^psC)d5\\H_˱gb\nX}ہ!ޟ}7\'\roOWf=ixa \0[7+TQast5\0jXHIݹȔ-f?ҶX.\'l4\rwأN t/(k`hx\09.vz?FCqZ,}-}{=\0ot[v!OY%qqX;~k\0	A5܇=3Z`ƴw\\756#6wHε%;um{z+MŶ5zLesG9^{|Jn	knas_fA3vu(h48	|9jka.iF\r~ksIiˬ.\rk\\\01`P}9SMVd\rHX{w	8VHF\nV5jk\ZꝤ)j+Ǣ DL\'T\\`C?vGJEFh945\0cEDCw6Z?\05_H݉qsOV\ri\0I-`m[xTi7ہw8ci%^W2kAQ\0\0\0F(1&4Ucc^Ho湄09_k7ۿ~Yi;ElIf\'ҷ}?G3P\n):d~6\Z{m=U2:}s5msX=EmE>l\"o~Fʟ\ZG\ni=&KZ>>+ܮ5mOikm&}/#~頻avSZ䍠{ٹuY	\nhm4cwՓU%Q\Zd5,yt}I9i>>r\"}H?q\\>,$@%]\0_B{?^5\Z\Z/8tflS>=U,1[j/ٝt NDd[/`p#@\"fGĎ2uIx\rp̝4R1;.Fs4litkil_ jx$*nhhAor?.b\Z>:\'̤*oWtKs\0<&ƃ2OmN8DDI\n$\r\0jt\'(tp5#Z/Z#^ CǴpܞ#Zeы\Z潰F\01D,nc<$kKN#Oڦ4o`9N\0jն\\Z;wR{h\r{xy$+LSKj\nNƻuo ܘjc{\Z\'Ǣ84	k5;ʯi#J^3^+8E,ycIm$?̡.#^#LupC\03[@o:h+{NjL;]4F>_JDlٶq;O`uSǖ`9.88O&QF =JA\')\"$B}ugh²]P`DvJ.HOuOD\0	}gvVUmq0hlj}lƀ%;sۼSntii$\nh;\0u(GŃcd+5k鵯$Wj:=NP$*|QO-Jj@hr&[]sHsZH[ǰH-hIDjӨ#־3|4^U\"KF_Fƻd<f:\r.&o\Zwr9\n\0u$c3!O>9ۈt%X@۸xƍ4s\0q)X[.$]?o>}e\0C&\0ӳ1v\Zl7؃m{`.lvjadf#A5Viqk[[4\"Iٻ79UUyCV:\0(e=2\Z<jΡYZmkA-1}ͧ(\"w?:g\0mZ8`#u-ۯ\0IDmMo.\Z=t2=\0?w2\0nv\nk$kƤ7W=~T7X;n@nǱqm̗KCߜ@q{vol\\SC.!۵lܠ[]k\\C{X=o\\M4GEeMOuNq.ss\ZrE:\"vY]ɱ\0TmWOqe^Io~[M@dM\0+߹օn%\rkt\0\'HP@+USqkq ~}oߕ[[g&?\0|`TG;YG}tRӍifc};13>In@ԉ`II)\Z=A#n-F}Cjos\rf?Mp9kۆ?bMk][a0pH3\ZVu	x{#U⦱aSs?{<?m\0R[hI$ oOqe\0e`?IwPQ%h kOJ,\nka5\0\rl\rO}<6-5	t\'궃ވCj&\\Hv~\0k5)[	.tDn3޺7dAZ$:9MEEZH>I7i<Kݤ:=\'\0(y\rw=߹}뭮xeeiW0h~=oHqkT9\"$\0;Y5jck%e{Dџ_XLɫu[Q}>Zǽi3!{\\7:\0\0}4,z4۷ݷ?ջ̡Zn{AI%o;Z,\r=ϣiL\rP\ZWZn#pEnKItWY\0Uا骧aksZY+:\0RseŤXH~uoF;Zy!5Ӻkd\rj鬶cZ	=\"0X;lD}s\0?FU\0\"?][e[X`ݥm\"A9[DwW=0ԃLdnZ.;Ek#To*pc8)bGB=\0:]Ϡ읎\00ǷfM\rٹvv\0=\ZX \Z$Niu!dKe\0]K+=Ŧ\Z^\0s\0FqKeJ?w}?}-铻׻}/b<4ْ1qhY77 h\0A?Ml\0FTX@s#O1{w0\0\0q4\r5DM%# {[zv~g}/BѰ\Z倴H[Qk\rvP~s[t7D0DZ; +p\Z/rmo\0T+ك}p{klOPZgdg5}y{rls	&8|\0FQZ֊49XE@<5Wo-hb&o\\Lq\\\0AN>]Mfp;g{۳]	̮\'MYmFtEY;Y_ٽ:m-sSßڽo\0JU̜ӑ]>!#\0QVZCrki-pt\0+uMv0k3齏J*enk}%;\Z1]~)b>_FgŶF/F茶RƼHsMdA][v=xUF[C}1_6{[~@l8\rt51,m\ZX	\0{psOh;wk}Q)ٖ=7Y`iH\0\'k=+ Uqi}5{{~5ޫ\r\r\0v d;,4F@5{cKN\0v}R	p37]~C^\0M}\\+JƱt@q8L`i,]\0mi74,d{w5ӎRxo\rGK}*\r[HYcV-sCXG9<zmXr􋼹Ü4k-nc}\02Ev>ƗRuRc&zm\"M1tnlԸ9\01YNp݄ͯQx>UUjwl+{\Z\0:\09	\rzt-s%`#rփK[M7Ryid;s@%\00\r/Aisg\0\n(z9\rtߏhK-֗Z#Y(mhsiq1uw~{2?D!i֏~^tCGJuBZژAô4w\0ln!\0>K^t\0ضEoeM͍l\05kv\0g|h3PCG6GgO􊛰lu3s[$\0d\08\0].=;]׏lmm},o,\0\"쥵ˀ\0@}ձo\0H-}Oun\Z\rpZ>+_X1ae?7Yy5j`Zo*A>f=KC{^:4	U.0\'CY\'\"*h.\Z#{r\0G\0\"\\ANRcWah\r`n@c`8}{~:%\r}nշʙ\0\\QfD\0W㆖^i:\r-GtrZs;ۛHzvLk~a{6\0cZo\rF\\CCIߡPq2psf;v^=M[g/Vm/,{-4nM~bMS5X7Ah/CS?17d*6vWS\0{k+5-$0cݛ~vlQݢC^讖sˬklbKqsf\0W,lYypÃ5{l`~:h跄n,8-s_ 74[a\0x\0I/40d i5Io1<$tV\Z7@HRfC>!}@QZ8 jU=\0Oq0ݹ|\"$e@V8%#_ڵz6-=c>KWnvN\Z9ԱW4[(!Ӹ{y53X{} c\\w4?k\rw徫`ws+{g-4]Mw	 \0RqiGT6v+%euꃙkD92dUtDhY.<bal+c.uoe!fo%a,c[a,t;=\01A]f5Ym5+x`sl~c?}G9t//~\r,~=07gwgmV)Z]Wno{1 ;z}ES9!->EՊ ~\\\0ޚ\05I\Zlչms\0R\rv=xӰN}4JYOY\0cB{ͱAC@k[o(\rSsK,_2\0\Z˃4<+ړ\Z7>JxK\'m،zW[h?EX\0tUT\'|\0\r!9=m|DL[Qڟ22kw=ᛠx{{jĳ;s汖kp;w=ovOis\0jCkÍ}tI/-k*5؈0Mԫu&8=hݛGwOz>k=:??I浙>xii妪e55ĘAٹ>^cYU\0!A>\0p,xy0ַw=\06=K\\\0vmooޯ\Z%{L<흮cyXПOی$vϾj(\'i6RA.h\'I߳whoyv8\0\Z5k?R8Tmoi:G}b7Rūз{Ռo\r?\'+\ZSCjk7{]O֛VC^߽{D7>g 招Ey56-6`=?M\0N=PE\0h5\\w+u[`8\ZnI~qVE\\Zlw,Iw?@˺KfIq:gΖ]{E$o\0%\r;(ȴ1յu,kwI{\ZI<cDrp//\Zog>潌@F\0P+6on+6sޫTr`<c{cldi}/ >\Z}X{oW\0h\'i:Wwuz?4dvڜk	\rIg\ZuH86+KZed4wWIk|K#U&,[@2=5azMm۱$|\re<F6t,\n0[mÆ\0JIfZ5Zly064Zl8\0\"síhw}/Epa5Z\Z,\'sw>?ִÐKmϾ5 oV\\H6fߢޟFٍ%\Z\rYk?1Nhe\"=:\0(de\0\n8u3s[m{1ӺnXiӰHds+\0~bW둸,p\\?\0۪mp1i*@]B\\mvL;ٴ~뾋_b*m&͗Y}:oa\r -vmNo(ZjCp~[goT-N5:eα.~\rU}v	ƭlͿI?(ͭ4\\\0d}?eM=U\r5	ѿOlF\"uuQ#`ʚY},s\ZGd	OҟڶQ}CFհXlSUPeŖ\\7&+0kgo.1 Z#ݷo\"5>PtW~Xnym;I|\ZpcRmWTj\0sz~1S6[u	cTzwq8O*qfM3cKs}[[yk_T9[.Oz*ȷm¹ni]{\\4lov~cg3Qu\\[DI4;wip$?Gdj-!Ĺcl/N&{@iA(t= oo\'m$7D\"}$wi>P>V\ZtA v{%\n+&kZ\0\0${9ERp7a\r8ō\Zݵ׺xwwn7\0\ZV6];pp֤l!׷phnl]Ps_@%Iq^Qn}kXO\0DVk\'ٽג믷nM_1=sCkt}]ߘ1mu?l0ه{vlbMk{=1o@w L\r088N_)Ѭwa\Zq{vyՌzZ\Z4/m0hi;U\Z~oDȷX;IlD\0nA~clk!ϤzS$~m>{Y$A%A,uYӼnm}m[G~Zh0>/UfkhǺ^	:@>\0= de5͍-9~<#K*6m9hs\\=Z=vݍmV\"TZ.kl>h5ښجs\rA{+;\"k``I7oQ_YpjiC6\0jnz$ϸc6{\Z\0kZI]QgW\Z8M0Q-Q-h7ս=e-1t\0;\0rǝ=\r|nnS\rMºCE`=ۧn\0Wb4FMSdNw\\ֿ)C:kݭkv\0Ws	O2>V\'\"?P\0M4ZH{\0gV(s*v^m~ַmuc\0ѫyƒ	7q\r~gږ0d-\0(tM;_[kisϱޣ:>N+#\'mY^^nWkln\0+H4Ѭ?#sm{aht{7U;\0ճ%}Q73V,8ZX\'NsޫlqcMވIyմFI\0KbYslAşMCؘR)!Ե헇j}6Aipi,piLnߞ\nY=V[i6>N?}Iawq\0\0ڪ;mF,46	лo\0Nk70ZI`\rkH\Zm\0\0:\nMT}7Yt\08S+\0Ej];p$-~km2Za\Z?,`s,pDn{̷u/|ze5k[T\0k<O}ܦ,v|FYb;{63fݣ~TvNZ\rh;髍ͼLh;@ (cYUu5ݹ$nvƹI<Wk	H?ԵR\"]\0ҞHmYe{cIt7qpufg)-esԶ7s?^kpc=[ΩT17\"Ɠ\rme^DN/.[{zj̋6c\ZKcݹָne{=\0=׏]ow?v\0>ʰ\\L>g=G~Y\n}E,AB9vn`Y^- mksjs*zgJmfFLu_B98tTo9Rhp㓱koO_VE6h*L]\0\0ec;ϱ2ZFѾֿo?֖N{qVfcmGOеާ*\0E42d$k*1\05G5+q{-sIC+g$Kﮐ7b!/A#͕ow-m9۵Ihv8UhHoT-m|ƇHe}{y:]\0іVZF4nݖ-Wst\ZǵR6DA\0!FʠX*N\\ܗۘ\0o5dqw2{2\0feh`%Ͽ\0_*Yx-9/zP6y:\07\0MRǯZÜø9=[L*$Flg\nN;11c[\'vcKnv$䵸@\"Z@s67u\0V\"I1\01GNc14vS{P\\l!sXK%5jl1@p\\\Z9>b6gqcƴlV;M]\\E<0-p6?Lpi}/KƄOu=0M]x/t폡ϤX\'=.p%`cJHJ\Z_̶B=6pkF5\nswV\"mֵDm,\0M՝Mlcdc,FݻIs=\'ؤp,nmLۨHs~q`\0`6xs\0UI5,0&ynow>\'mwi?ѴǰXK-G%knu43Y|==?\0af䚨$WdA >ױ7!-	\0\\K_v@Ѯ\ZZJ8NkwZx2\Z\r۩ea+.0ZӳoYQkK+yC#9it \rVYP>Gvzz\Z\ZF.9e%y~m?77Q\"jLz\0o.ۺU!	PWZ$qFϯw\rT\07^\0m]/Anh>%}tSnv:.~\re)qn3 7Ya11M̫o)x(5l[ӽ?L7\0{U\Z嶃\"[ߴ^kQK&ËG}5UxkqCAc&4l>ho=\0D\"vH4Y=,ZǰNs;\\2Z=i{dKs}W85Z\\jݎrykZwYO\0E P+kHvs)%[%Š\Zc\\Ӱ?[nm؄~+^ZI;_cjc]m\02%`>v̷j}ހRڤP֖/-w}Mh!gmzǒGIݻ((5H\0сQP.ɩ⫧k	MvtU320%kL\rv!Ua@\0s,q%@-N\0Y&Vn\0;H\n\0-%+rlP#BA,ܐst3}օ]ϙ2 ~ov rXُm;.q?j՗;k]ڰ1)y\\8d1y5Rzd4tǨeѐ:HkCp\0ʥdWci%	ʮvѫŚDǶ}7GrvSi۬t}!GUf]wA9Ukk/}2*Z=mn\0o719M#ld{}G[3s,f\n7\Zޒȴhnt\06\08H\0j\ZٻX\nvsw*\0\\_~k}ߟgdƇV}J ?ֵ̦Yhpk#ck{\0Ѧ0Sa~U.ckz-1W^꫱ǴZF7guoƮ\0nǇc{mFb&e\"6U$T\0mnߡ;Q\r9KZ;Wv%C[րuVS.mlsÚk[jcak渋(;黍 Qmnm{tX`-%giW˿-ח[XpklylپU̳\08[Wl9۝{vJ\Z/s:I\0L۲[OJw,z{l\'k\0-s[Yu-5s߷k\r6p:@/R6Tb&Mgdʹh+\0LBGd\ZKkH\0Pu}@ 6 }s\0=]}n_\\At~՗x-sbC\0~ϡ\0mZ%#魶ik>VON=6hK7ES9VdklfߥsHecZm6r4wM-6ֻ}l\Z8.6?I-e\rۼZwܞT;K	zi\'iO1\\@{UuCtnц(@A.l){$Nk[emmUN<\0@s\r-\rUM\'\0hmZ`5\Zn[Z\rx\0m\ZAs nFu%qkt\nG!%ItkJx&j0Wv׆\"snhsÉ{uiޟ\0AVcx\ZGJ=\nq\rXvϣ&Ql1&`Ic[]F̚]H$\rd=Նl\0	1\0>\0\'އvFK1^ }RSgzk6ڽ8\0wn56\\vTXƺ0fO\0\0ֵ\0	 \0#\0rUjnHn[C_\rSpub`g<mgA>lhɟZ;w[H,}C\r -1nqݷ4{]\'b&HmwD\r\'6`ݍ.Nֽ\0&k#m!#y&_s뱬sd0d	kgbrn%:lGЯ߷ނ!:2>R}Zq4?Z %\Z1\"=\0HrͶAUF;vIMMN\0{DUm2kd7\rw{?RfIF\nmuNdO8L\0(VU;+s5f\0M{}D\0!IZ!6~A Agv.Wma\"	i?ҭ^6o׶\\mv\"4;)aa;\\Ny\Z\\q˅9x?Pd cߺj	p߸\013o7hf0q4յ\Z\0?K7+kIN-7Mՙ\0Of=۳ I\0Voz::_Sftv\0}B,kC\0F7ߟd+\Z]_kmvg\'j35nb]ysw	S+dslH-cC@ܟpn *iCg!ۛnVOҾM!Wa1g Hҍk]pv\0gl[kD\0~\\%fch+:ґ^\"ָ9x~\0:6[^\rX}?\0Ew^۠uqnhc9cHh^?I\0D\Zȩs\\V^\ZZ6_YH`qH~\0*͢+leK-o\0=A0\0[;G1o6ŧk!6nntH?xvZ	SiZdw\"\Z٩?H&\0bÛSZzr%H?*/9u\r\Z\r~yY\0ӰvphF7M	oIIڪ-as>*a֐	Cݧ 7!{f	,kg菥ro	M5n{\0\0]/RR6k3a&d\0g՗85.GOn\0#ò3]{]鱾L\r\0oC}\\4\0ڬsI~n?o!f3&}o\\XZ\'M\Zl7apy\rmlo72ːѹp\\[nߡ?Q]s}iaqcWo_\0\\E=RY\0\0Ku6i9ƱS|Xwpjm}\0;>qٔ=/pgGnߤԪ̣ո%o?}SEk)A:~0长Z+c%f\0L며>\'c$%nODm.I=:lvp.Xp!k]=Y$3s)g?UZIL>}wܫՋsoY}an͞܏u?5VLZA0\\Z4>͹d=n3\0s].-n\ZY^Aտ=lSGت;\rMM⢚ҳ}m\Z˃v?;{_\0F7a\ZX ;ݗ6uVrkPUt,[oZuK;I 6Yc[}owoW\'*gֲ]wr7kwzhyeR6X\0{6!۫}\0h\"ͥ^@mGHs,=P0lsdNoѦDD[L9WiT9-yz.o6,9S\"^2?Z_eϐsLSCǻ܆\rf?>Y\ZpZ],lAh24Aѹ\r\0\0뉝c,\Z紑^~bԎis@&X=\'YeŖwz.\'Sm\0%Կ:suAa1n9MeEd֗L1?G=\0d9[m@i-[~\rK?An-#?7D$]V!w繎uecIT~]e36˿(7k W&.\"ʬcKC^K]Nϴa46^w6_9g_EH-kG}0~\0Eba5\0coloͮcotޅjJ=Oe	.\'o}{T]mL\"KϵVN@3Z%]=UV$4ѹ3\0ПZ@C-l\rL(f_f8e3^\\k#u$?E\0÷4\0Ѡ<iflͭ!I\0EZc<2u@֒\"g캶Snnxk~LDs{aC?FCksYW5NRͮ~!\Zݶ=jF;a8x`TֻwѲ<wYf8¥兠YS4#Ss{\0(qJ4\ZIs7+(M3i%	~^?iuOpH}جSZ\0a۴fz ;9g,cc\\^=3SI2;=cMͬzD%۫[f\nYE,w_U\"s	m\rCyKGU\0rpzW*X\\!\0ѵI~;/H%wݟEMz\\f{A\r-ڬl;{\0ޟZPoqv	KRs,.sOXXO$inbV1m-Y\rOoqhoG\Z\'QLvEC|\ro6]=7]snc=VW&ߛm]Qydݞ?+WXȪ[04=X/S+6#@IgnNw;X\0U:Y>qf=ݷ\0&}Z˭c8\0F5 X6?gkű2HQ=?ujQ19Jlm~\0=b\ZGy%ucIqOzz)9;fw6{@$Hu$4w=MՆh3?ݵYɮw2[ctﱻ\0kG^(uH!|\0~h45\086-\r=e_e`!8mk2~~Ϡ6ۛ\Z\0\'&;mԗ>&?c18H{uwzcIᵸ>I3L|\\1\ZK\0ko4sEvͯ>h$Rrnv~~=kC\'Cg׏@㰵q*N\01Vqm]kcAh#MF\rW9иkڭ;!c4-`NPt n\0?Q\00NcH)6:h<pق\ZOkcx!i\'\'k	hs\'ntnդŬ\r\'po]c-X\07]A]e5Kdm1}5MekZa5-z۟/Ս;]-n5\0ެlq/2Aq5MߘK<ْ&A~btTfKkgu7<-1{mّ`J	3wezclIwkT[Eo~pV\':~I{C?>5V>;k?5J\ZV	\0hOG@T܆li&C~\Zڞ}wT^\03hY\0n8=~}{N.1.UuyoP9\"[\rs& ?!=uU͍dH\0Pu\0Ov\0@2c*UG7\0Ea65\0\0L-k?*Ug|/p6v\"\04v/{.wwS3XAF{ [%Z׃8>wWŕlsZי;\\MEK[y;CcG~sv؞ām6*[@pcCKwV֒}?=ߟZ6zlp.;75_c	\\t\\@uAsviq?}̭Ȫ沯k[l}?M\0\0k9!;	\\-~ngͫP`	/3 /*m;%%uն^I.}?cSh\rti{\0;ڳmEwZIާ9s+fYm=M:T6lnY{?1rS\\}=ben2a\'fB~F	wn}~:ڭ,sZLIvs\r1YpvU[*`ٶuEs 5@>BXeZڜtkXZMa&4	_EǪsIϱF9ԶZ>[ܸh\0@\r_KOֵ`hs>uslϪ}6׵v~α!	J#7}=H\rTw\0Ӡ=\0G*Ucm/ttk[i$IS7ߵ\"-n)v<v5ܥh69Wݨd_s?j8Wi=peW@\r h=M}Uװ\\]UOv[$Ml\0,Ǭsx~g}\0N}ixT}kw=&tݧnރk[Opg\0OQ]W\rvYS}\rc7e~meBuWbcu2	 ?<Nq\rj?6Dl<<u62`;\\}/J:iNdA?G\0j;.6\023:i;uY4\nOO\0i;lk2Z?|{lwM&[o=*=ȵ,6-k~鲿q1sˤIA\"{]\0NK!h}O7Um,qOEnJc˃Ȃ}?q#ҔcTL}6~%/9v։.p#*lcmyah?qH\Z3Oѵvl{Ҫq뱤XӵV,D:D?Fw6k\rpcTinvYSYcm!AՅv59l`xzޫ}OcQ}yhFÏzU1\ZnvCv:?k\0qԇ]44q;mzù{;=WW_OMc*c0=~k;*Ӫ2lsIF!z{\\gc28@t\0븖klpkIZ\0oZ֫qv{\0ϳ\re/@yW߸Z\0\r.cs`P\0)ٹwޣ\r[ɧΩ\\#@2Ϣ}P[}Wk[X]tyЍ}Da\"͕\rHݽunc=Γ,w;~/oNMŴnh\Z>}{mȸ:c	li}eܥ&\r<Vk\\Y!?Ovݵ{}cës}2Lj{Y)MN %M]v=c@.-ћ[uh4@$nqs@\0{61l42@>䎽m?jXqy\\H\ZN6@k`hwoQ1ǵhݫo\0Vi{k.guq{6\nDõO5%(:\Zcٶb!miN~g_0N󷣡\"ֻi_ڤRp@3$QX#i6L;B@Z֗9hSos\0ikq\r(?w4\Z4%?eäoBOU!USZ\rps[\0,&Fvop/yvK-b\rz{%ݹv9Qh,nNNm4s??\0gkH!d{/c>\rlcnc1ء\0uhLaͶga\"~s\0U,vd^j{`t7\"c$n;?b3c\r?-DnG_)B5#dQy%\Z^.[Sz>v[i?\rT>ƴZIu^GXOeՐ\rWcemoc>5o]~\0pF+1ۧ\0H$lهHK1܀ܪXֹw2\07\\scŦǍyvoޛmos}MSe 0z\nUgSs@}{KZc3MIko\r#k̴vޢ),6;[-<~v\0Z\r-~ck~㙻|mB\"gM\0ъ6P_$A6ckkuXgwoG=\rӹĉ f\0\0bڒ_Ai96]ai>~w臭|<r,eCCq\rs\\9nOPi{^c\'ݺl \rD^QOE9\ZÞ+Ӑ+6~ӹ68,U&3@	m˩5S\\5vEgHAꞚ:Mln4[=p2!sY\0}	.l\\_\0lMeepA7(6N89,6,?9iQǪNknߺ6_Cak{\0O|V-cEEŅ64>=cjc\0v\'~n߱#=\\MKGۿH\0!/G9d{s3geCgE1iy\0?k6{\Z]meAa\Z\0j+7/߻kK\\HݞW2 9gkVm\rk]ƴ>n\0G깪s_PᬭQڑҼݠ/nk[gؑiki7حW٬2\"={\nʀqź\r~iwԑijNUcZ]́^7ݵA=\"7m?hp؋csh0H 7>IiAVv+.iiu79o{?&Ǳk_?fH/ikI2vSF<L9n6YFz{Lp?ZkocZ5{$o>!Zt-\0mPlŸ0}\"6Gn=2נVRIXt??먋>,[-v+9F\0aScŶncx:\0]X {D8~~fN\nWX\0T6\'qn;[kZbZu!XI$f=ۿ=dLHi$4\Zz%6ݮh0AϣSŴV\r\04>U>\0¶fؙԝ|ӶXI~OyO%7}th\Z%[cI\r$CL:cn?2\n,gu1\ZPvX	kbdk*ok[\"D<aJ%>@\0:5}jV9&CH;r]61vuR:#Mtsl\0D~}:\0;@}J--phѿHx}5^R4kH0ZKŮnr3-\\}k[?\np\r\08	^O}WN8}9H4HOڙ+y2Kw?\0=ZUKki4<85\r΅p)vY-=+\\J6.ee4K]4)lHB]ͫ@qZ7c[9;澗Y5765;Z$:ea?}Y9O{\\K4~\ZS&ZֺMa{$ݧ\0P2\\ I;v\0fSVYX<\rM9MzV 	oі=FtS7WZ\"68=lEjWk;οE*,翼w\0_M2[e;w1na9.phd};1JYkZ\ZK >qxmW4iۿkV|Iwh?_4Ж,5iDߤe\r\0Mm5ޠel*ۉm:.?hN\"I/;6\r}KOEh\"-hl!kvvqRƷcCF[?=$X 78Ǻ=1\\\'G<Dv5>!i-\0^c@3\\\0!b˰,LƻoQ]O,ewAhrAV }{\0)WWds5۾桷1<9y\0:{>{dl|PKm>K-m5ĎG76Hf疵p47;b!淏ϳBe7Ah?{k;c i]%q!:o\0N6ǝuoп^Sf+lkv	koEb\Zp`\nÆWk[\0\\xu@ LKϿ{q.m50\0fw3)Rnf=V][k\\ ƾ~7D46\\]t	hT2YVm7C>X@{\ZgۻٹMIXL\ZVJh-/\0[35V}$hn_utwng1PAal2KC\rm@qqc\0uy\rlm&sSQczk<[hlK[t~j6NC#sxXHmͿO	7@c{2s;\Zv3?{\Z\05D\'M1]	\0ǽƺ\r;hkf+n˱J\\u?1\0^C,n9Z	_p4$:S8~t;?}ߞ^_d4XSbGn\0\03Cr\r0cA;nSstq5<\0F\\̆ 8p;vzɀ\"?:fkMDٹX;4s\0Z5fVG\Z;API[Ԯ^7hI-JL׸HlǼi?[\\^ao5Mzs\"IͅzpuLkd=\0\0JD\0-CP9{tKv8/Iw\0ؒ#59sѧkg{-&벤au9.|qq\06TY\rknmw2`;l.t-XzzntC\\\\ZC?5ޕ~ LVOkw~rH.¶O$hCS_7o&\0yn?3fo\02ic]fe;wj>ʽ\'~g6\")1ݱ5TXImvُ\0zi{ށckl2skg5+7Sm.տVv;\0K/(ظu=;+YS6m2(f7\0\0(\0kE-aƼ~s>\0R?bƻ=2CA2m3n>+id5vgY}G綂}5Rڔ	EHkvָVj9<Gژw{@l?4VX,Xw&3*c98Ƌ\Z,o\0S-؝6kcA߷w\"&֜\rkf2C3:{12ٸyKHkk%K,>쥄\re^ba+OMLÌv<pnr>\r7m\rl Uk_۹\"-Kzo2UoYo#@?ͽߙ-]+}ck{.5׼_{-lُ{[>19uMy&\Z\\ֆSh;Zk\'{3C+?)5\r\0\nZ\"=~ݻ\0\0JR(13s2\0T׶#+J`I\0*-iGwh=[\\dQP)|w~bQ4|@.WF{]Z8<M]zsw+,\Z{x{bQensyasHfZ\\_pun\\G w6\0\"͋B[vY.sjsO2LF̝+ZM\r$vֲ6@Vm`!7\0OS&dSO?I_\"c\\6\0}ߟXw59!X{Z{6~S\0ܟ:_gs}2\Zgg.svO~Pƶ\Z8wW*+q&ۻb\\^MhnKhyxps	k=ަ\0ՌzKOs-sZ}>o@ű{6.sH-zziؐV{vkh4;mlbvA͡Yo)ۭc!ߣ\0Jb=PƸ͖0=\'i^-:}uMϏ?Qw\Zݺ9=MY\0\0˪4kCK\Z\0Hd\0G?=\Z(mC=pE\0F\0b&9uP.ct\0\0*=KnoyU7LZ?4UE`nߢZ#*)Y7eo-\0Ѕenkj-wHemo?\0(߶	ѿ͉Jhcce\r{gͪ\'{6KXw\0\0vWistAnQί[-\0c=GlIsH;O\Zinvkwh2V[a[.mjS69C䩷1sH>ΩN\no\"/mQ}gnCX}\r?F:ۤs}X@s2\Z=g=~*_k.kt\"\Zcks\r\"#Zfc\r9C\\~u`[~W\n֐i.\0\0z=TBgY%.\\`5oMȍ	hD@MX/tD87@h:AKr_.kdy{{nkS\Z 	ÈU_Dw9Y駱XC7Il\'\\#¨8=\r{\0ױ=.\'MBQ0kd )ci}:\"[>wNlݵk1\0Tk!N/.kkqaZnAMuK@s\\MsiQ\\7}UÅcS@a=C_S6{Ya}4DmWn9ȂZ@;Oc{N Y#_GGlaHolk[f;bbk>/a/h2a\0;\0-NuUMK%fѾO=U벋u-Ԉ\r~Q$잦b2!CX?߻{4񀮇:ݣ_a|A_Q+59F\0;XtnGﶷmz$cV˭cֆ=\0c9W0Smyα{[\'Vɥ.qkk}F6YXڿzAұڿ50!?TSx{\"Zʘӫ_S!\ZkȬ׽9vg]\"04۱\0\Z^d0I1Ce\0\0\\Ba%5I-&״H<I6{??)wGenXgmHR	smq}V!:ʖk\rCZ@!57{\"\0?u+\Z̽]}\nkw9@{Ë0}o5Ouu\\^^mw?~zYeͮkbaݿ]\0Уtm;:L\\=CP;\'mǻV5YXh }oCboK$\0t??5 s2M5/WYsi>g2oݑ{=My\" nZ3ФZ@%7d5}#a`;A[u!ߚ,o=mKw	$ny<ofdIl%\Z]ֺͯ{x&vChx{Go夦5Qr\Z:ݥK$sn捻\\\0n߱2k̆8sH;7sE-vUdct#;أlqm\Zii:Ω\0	\0:ַӭC\\\0UCVn41Ǹpy.M ڑjeo^?s,te\0m\Z}57ssms5ƹmh.uX}tn{FojhKfyIvlj5~znKpea\0ݤߙejv6i%Kԯ\Z6ise$͟CfKWte~`	wӖ׿\0A7*6-\r\0;og`<5tCw[s,BKm{06l\0PW[;RNWR{Qa#p^vo\0:ȮѲ7GW6Qs\rdwo\0>*EI+c}:O Gtw7Hl\n\0=jy>B~ 5?N6qW5kѫ1~t,a#mV=GmVmMs}\ru2}.obgo#3nq;R~5i`%c[eZ=IkN[yvA~nw#cj£D zյmN\0\0$W\"CXsAxo;1[r\\5;7K D 5Cӌ0yorZª:K\Z\0\Z?5ʱ`B\'sZZ_e[cd8[V;\ZdOx`\Zm{*>?=Ic6:_U]\0	x싮YۑU٦!Ňl$\0 2:Cqk_mִzg\0n,h4f0ukNT]иT9|^|k[nu\0#2eUVխO\rw\ZWﱌhj64o}=CcQֈ9.,8k\r~ߠgZ[f͡^\'vql˃)o	55cD/M4c}AOso}/z^V&Lzm>Kq2- :j{\0qGƧ6WͿCٳbVV}uY[n?BˌKmv~뿚㹶㵶VY[w4>;k6 >q 77U[,<8?6[}ޅ/\rsbG^WHz[Fw=8?G^\0wn?ֲ\nFEMLY[Au\0I]<I¿Mʝ\"\\I S\"6YC\\ӫgJ!4E,0usAe3EY}mմZ\Z=vNErX7}{q3)n~;[Mlx\rK?m~\r\"]]5}Vߑ海9p$n-mGǭi+EOmnLi֙;#!|-l8;Yd07:~y \0؟}Ͳ2c~.oe_\r4-cَ*ȹc4\rYԮzJ^-aZG?wZkj8{_:ws/6Z}̇oۣ٨\0\0ҝnzfёbÀF?63p8K#Kcȹwb߿^wzBS]}\r~|!$I:]~WFE3Vߤ-%&Z@kOe׷s?}g\0Ԝ [ğ.Ak}}\0#ݽŵ\0lY{\0l>{~)C\0hi\09}~ϼmu۷wo%O^A{42D|QG2o3s7 E0H\0_D]{(\nÉnS]?\0[:=ݶͭ\\`g;⽛?Cl8i@%K{[[?[8svps6lC\0QԛXYS@C_c9JV/BV_>ܴݹ]mOvÎ\nk\0?\" .2F0۵Ϧ\rwe>*3?r{ی 5[vz>\0;|@{\0}xɏL\0% 4lncy Vks}7ˁqgo5\0Ia\0a\'{\0]\nʹֹ1R\'_s֍l\0G[j6iposЫs\Z֝~>oB32e\Z`kHĹ_sn\0QVeG͸t\"5o}A`nk:ޛ9aP9<},\0\"վ6Z&Vp}Rq2F1}J\'@\0O4[͕_S=/ud5]s=6\0i>e٣G&69[lhִ&}\0	NtOǠ:o+pMqwq?D}61s_,3wMc803I3;Tf̟MUX=1L׼3	\0Vqi}ѧf>-G\Zk~\0@7KC6\'^\0뿣\0F/K醒 6\0!gN\r[,}MilXZZMז,l~5ߣ\0Wq쾲KhcLUoc6Cd55j.YG۽\0FQG\"4\\\"j [g,qmr^I{=&UO*V9dØW-qm$,,C}^ȳo+YYk\0)bVU\Z&hֲ\\CL>~r%>\Z5ڃ\rg~7{v\0%ah--c\\x\0jA5}:K]o+o0=a??fC^Cu,iw]h	w$6q@s3qlc\rbnk0D[goإwvUlm\0ickN~cZ]Y_DZ*Iac\ZO;>KZӣ=\nu(]`[od_c-]02T|Vlhw-wŞ=ޙ~[H;\r}:wYc=]m{YkX.3\"g_c$y[UmϩWa-%kl{ZSo\nxs%x~ͻ̦nejWَ1-;K}YExou+xD~ë\0\0QC6또]\'C?w)X;{[=/Ѩ2C =OVz|{Z ٵ>[v}7Zh\0A~(vic6=,;V۹FA^ȲZ^\rGq[)uƢKXKKÜ$6{چݵawͶkcGP0+KIKO\0nAew:8480	|8}vϯiQHnkd.?N=,rZqeNd;sT}vdCm	OU\0zVVk+tl^7c\0$oPw_SZE-cI:?b[w6l?@~wכG]vk}{=6-Vue.\0wkoctqc}&v!8vJ\Z\\ICHs~HT/sD6kF0nHf~ͯcXvd]\0Am蘁`i\\n,\Z9w}ZH-dSP7i33<5&7Xx3^	\0\'\Z=P\r;ö?0m٩#n0gSCݹAh\"3Wwvc\0sZ`}z=u-\Z0}G*7u\Z[sIu\0gdɕ&CZ	h0\\w>7֬ZM/Ҳ!QK1I99\ZW[kI|knԫ!/%	,wǷe̿k\ri$7n\0j.eĻf`ݱX]>ϧ\0[;^]._\\	Qo\0+M~=x.\\e{gnߢ~w\0ݷYn}lkvzA)8Hvփ?7;\0>!c6mNY_D4PD+S@sKZ~˿s\rFuw?h̼{^k:9o=/ڟ[5sŞE޽׻>[csO*,[/hl\'nIVi\Zf_>Owb5{۟n=zlj^JCn26<s6{WzG\"	1\'Qzv4Z\r@{P/Q_jH+{/NS[=|;gǡx\\eZ%6֣FkyvƸK@.pwulY\0[V%\r{* H-cq\0I7:N\r[e;39hW[jÉ fk\\	aMOeLy֘L<l屬Fjf7#f<+mNsԆUg±.\'pg5ʘú4kXd>\0oc^\nns]Xkxiq1NTÝg\Z589F}YYՀIs4ƻHgNX,hw \09YiM>6k6nk൥Ѵt2MO?g2GFv/CҪiQ:@$\0\01j+rh}?h\"\'o;[OgW\0oYmmulw}+6`yK?j-N>ׯ7Q\"HiҀanQ5`pkos2G?IUeYoƍkЍgJӬ{qlc#oN;\\eed&[7{]ѱ:jb[l)_nvkmi6uCiweV鲟eM88nHg=\0/u:lޛkw~\0L ׂE\r}Z籄\Zn?#Rm%0\0yH9+\rp-l7;{hi94y[(\0I`%5V?jg\0\\m\rd[KK*|InݿUGzO;Z?Ңzۈvob=Xd9[sjSqq^@=ŵ	\\ao\"Wc]\\EuhcV	؀tُ^YF{t:\0 \Z>MwV~\0ٍFdCl[7gC\'н}1S*`\'ѳi\0?J~kND7\0\\>bloPHS9ۉǻ󚘺Xhp\rׄ	.>Ft\rx;6;]\\ud4Gm@̨Zkk7PGqy;~O%81)V\0ٳӵh|\0e;\0b̷\\5Z\rmmq9kIۿ܁x;ҡ۬y\\	7eUnSݴ\r3q[@;;{N7uleI7#kX]xZf[mӫ\\gkFћs\\[K\\Ҳk&3ؐ`=_HYw~XhU	w\r18}gnǲ}j(	.x;[ѷѩ9KĂǸYlvEۻ)ճ}f}z^-f~\0KUZme;I^ͭuf@ݴˈo گFmk!}C+Aƶ㸇8x\'? Oxݰj21l ]-E`88f\0hAxV\\lKLO[bM\0m%k-7\0!Uv=Šm6;ѷe:i[[VװOY;~nJ\Ztv)}b,K絽AߦJ웨\0k\\<0X41\0gcVv[eHi,-} F]]%jin2K@ko}չCLuRu.7Zڵdw[\0_ڞM\0\\=3ժI#mݹgz\"N\\k42\\W\Z9Ut9ekC5c\Z;}&7:2Wjpm\ZFϡUȰ71\08=-V׹zn֑}o*̜>\0O`i>@؞.5lj{0/hs%gU\0!\0V>l=8n-Vz-ǱױĶvÚ1WrK0*kbCl.\ZL7ŧPl0Y]1iY{OЪNvNklA}Ng_jݠ尒},\r&N\rjQwCtݸߤj(-so\ru~wsm{ƿY\0-h:ss].r*l6Ip	?a\Zr?Gcv<}9Zݖ58ۡx\0FTR\Z6Ng󿪏]?j=Awwl6_я#`W8*~^c#_{T2I{Z\0L?ge$;eG<wc?4!e{^,k@~lGn\'6:sH!Ѐ~\0li}\rk6qqu:;I?HoΨ:#si#^\Zfp?ΰ\\/R6tT	&;c]ݏcv6Itw*ɲkp\0SYe4ojPlT)!oBEW26qlҏ[>[Pִ6ngg,O^ƾ鼻m}oL{@YKHH\0;j-ApM7z\06]gd}~\n.j\'~}A_ϬZ\Zփ:8=\0kCy\0))N{g%[P+k-:~=DaKz4;`n\rhqo?=V)ݒ1n֓mL7w޳ezeP}cWg2Z\ZƘ\"Rv`\r?X\0B8Ŷʋhwo\0\0%3ԗ\0ƽF!Ѿ\"[@}MXdin\r7Fjw,\"v\0+\04Ih?1۳7:k`nIԴ}Ԇ5v\";>}E;+ik30	c3ڜMݥW\0&O\Z8j4 wwkӎb\rāa%ΞO#i:_\0Q{su.ﲗ[kd>o5x~hc5@pdtrNs\\ף{]ݺ\r<7\0A͖\Z8<e0\0^!yinEl]?PnkX 	?f[PeՐ\0k?k^ev-ޛYs6~z}yt=wKݟOjDpՔ<;vMm;	ұ\"%A5l_W\0UQ%?nǴ5H4e-[Eu9qyùZ5k#n-c6^ooӳn=igᱵQvE\0g`\\3S7nkҷ\"U:igB}~mM_ip-;A7{?XSaʺʫx֗\rt9!PDznv\'lk~6q\\_\0\r~Զ3f.5ϠdEbk-C[ָq\0~uuC\\7߷]ԗ\'WkGj\0*ۙq{;[hc*UHk_Ȃ#S\0]@ok6ϣ;v[j\"3s麷?E^;s1=f47wKsՀ;f׍I6\0I	eR\\]MM\"4[Td	wzRU\r[^_/X2oMHv浤EA?yXl\Zm`ogK{{h?p\"ݿD~n֡\r}H_`X݅0I2qCcD#Юݚ7; n\Zæ=  >s\"\ZHrcI5?\'C``V{%Awmk/<:Z\0\rGy+֘\0LN릝C_a\ri\'.1v?klʃjH^~{An@l,t4mVmazLmr~\Z~%l{KL4E7s=.	+7iVwnӑUnHk!k_ޯUhyl{ާ7c\Z8D~{3k2AŴվч0Nnw\'loc쵾~7CD\'UR/p\0	Lm\"1-Amvz\"ǋ|` 4H֥R\"ڰYM͸C\07^^6\0\\md@@;ljs%̜z=&6HvZU>PT@\'[~oGm\\x;Ah?IsG`\ZqUqu<\Z\"H1ͳg\nbtZj\rAf?{En^}65o2:׏P9`0wmw?Gڤ[հ[+` #:>bC:5y/BC\\x e!Y`qv=o\n~S-cHt}7=0sMncZFr`K_-\rnW\\1~\0B5.siiq-Ik\ZϥDfW]61͍-iǇn;7\'z$PPc\Z}?{Np~\06\0&>\Z}?)TAuNд1dA6[:vJ>F)UU]XAv]Wz,$ːp#c[K^s5Q}q{FϷrUcj;,\rpZ*X㵒L?{vMkq\\5,iKLLwR*b1乜xv%ms\r=oolbO鏦CpLw+XyT+lvč;-,ZFfk[}^F@8V,Ǵ~sɪU-h:wVV6Ǘ\'\nAXmVKDo$VwZ={kxH&#s\0\Z7q:\'qr=q1;4/?O9/can游KC~b&]M!-l8WϠvE>8:ng]{ۿYp3$ݿ&OD%KIԘ:`:9&>pdO\',o9\ZG]$6	aa:tܞ\0Jq;]\Z浻}\0C\"\0\0P,q,qtN#W~e\'\">XYGjx9a\ZÏc{n\r}l\rw[?\06hægg\Z3x־\Z,mo(B]fSjwZ\0\07}_G,ܯ7p>~wފl*]]E{s7{=Ms)\r_cYQhͭcnڤˀ⚞&V7?H1.6?f>\r6P\"?6!>E\0/c[ulpO\0:?^.91#\0IVk.nNpOk,>52ئݰ=ů:ɰp*7d1[Ysw}\Z_vv:ǱTAz,sHmpL{YNA!l^1\09t]{3*?p`V_\0)%k{絴Xǉ-\\4Xo׳jA]eb׻e~c_K\0>\0늭9 \ZH\rwϩ	%Fi鱬Htw\0\0-g6*8`t>~b&1Zn7o֔^2\rmqiCP`ۿPk4Dxt_q0R\06؍ߤFmX=+JTW=40!8z&\rs@&4\0S-f汄:9>E\0`yF~)amu:O{\\N u\\jx\Z?_eq]]^ԭ塮?Srjm%kk7C6a.ԇ\rH!-H+Ikl\ZY`_ZL5R*nMPO{\0\\ܧ1k\\6`	WEc/̩ֵww?\0LѩCZA{\rse:.xi ok7zlǰ>oL\0(f<1[%ꂧ1nxa{O\0CgjnA?MI.̼5g{[>2\\tn\0zQQn}%8ڏoЭKnd4j7YXӉ:4Uٸ67\r]mWPۜ{PhQ}=\\:fo۽~:Z}6nz%>KG:wxUc`xnwvQ?4XCiчnU9wo}-k]BUiu{+~Ah\0[~<&[\"ޔZKml&{\0нwc%4\"gUSj~a5f;\'hm0ƃ~ߣ;X\0^5\Z~{ ukc[kh%vԳҥZCg]*XSo$m\0+ũumhg\0\'TY`jN`GIn49GWSfE:o.Y\\Y-3v[kQ֑MֲoIk渒	?(^\0uUuyRX]\ri}aؖ-ͨ4dw\0\0j}混3\rGTo\0xٵn^-Ad0p\rqi/g\0\"ķP\Zct[w&2,\0Y}ퟦw{~C7p?IPU]w;OS4nFl{g=Դ<Lv#\0TY!h>l7{bw[Ȃ #ݹ4QSYmc~;ccܚmfꈯs^$Jْnsw3}`Yo]gk5Y\0ۮǾlm-s|ǫc6w[UU;Ԯ	\rKz>;\0Bv[X֐M\ZƓ+wb.]k?Kmb6.ciۛaLs\0AvC/\nyl;?ղkͺǿoi(O`52=s?=8nuUa.ݴtm6}q6iH:o\0칅h{i+>k*F-i%;~}?(ȵݏs͊[ 4#<1՟=K:B,#huD{?Eq={w!k-uS5`\Zh^ݪc`|?{44@.8!1{@\'SZ=ط\\׵+ݠ<1p1vswoӺQ\r`y._)Vlmaw6Qps6.?HSUwXN(l$\rp^>\nLδ=>	Ǳ}L\0Tfl4N\0{;s%k\Z~cq]l623][	\'?G\0	zMfc.tkXjmazXP\"G^]+,\Z?sÃ}]_QW{xdcy^(j^Xa}Tki\\v̐d\r6RmV5 فzbIpl85\0KL.mޫhl`-#Y?3`w8Laߔ]\"h#k7Ue4@ASYm2\'I\ri\0o!>\"(mQZIltjЦ6N5%fVN+V+}[I-Fߺ=Q=%M#w7.fEw&<%5ޘ]0\'CѳrvKQk>=}d]i]?{UKEt\0o\rs?;}?{pys^C֖g?ɳ?5U0\"H~V2-ke7f{vd{)=#NCKCi[@68\\toѭHlKrewL=Q!qht-=\'û ?q8i$5\0GђNT7YՅa58A3\"ACݡ9Zp ?]6c+Qο$	:sKtiI\Zխ%Bva>\0>hcQB?(nVħK\\9(8,S5a׀ɏNMaǂ@;ڜ-hI?EMB_DH{\Zt_gH0cH܇T%u1/\nCc6܏Mg ;i_s{q])cQU\n[ʱykX×1~~]NkԬIpiG&E=ԐYe%45Ͷ9\0lHQH!KWF<C`mѲqSPn]{wmot~=)u4=X\"ݿlcqkֺIq2~\0-IH~7Y}/ûf8\Z\0dobjIxݠ(؁tHtoKb,lMuL0g\\w49-Ow5lcqkYYcc\0\0\rbSi!CMos?H~J-MIFkӞ^ƘsA߾CΒAi\0z\"I?\0Fa;	 }\rvYA-q9ϲI#}a\\`w1@\nlxt\ZmcZxn{5\Z;S\r\'6]uK0Y~g{C{kCn&5}sh\\7w\0,M$-{ߓS$~6YMuӹI 49sݹ\"	#K73ߵ\0H6S04m$s77\0vh=ֶH7?h~jFqp4\'w}=_{&vf9i> \0as\r@\r\r\Z>K0\'\n6\r֒6v\ZhF\'e$Q\Zjgn\Z\0&DN(MdZtZR,dgH.$Ff ;J}=Veͮ\r}R{ˇl\"}/deu`wL?*`c&\Zݴ;?Hc嵻^7#s-\0uy?KDwVYU~k>\0Y\"5.ʳ=/s5CKH!\0Kgף[L{Xݵ!V;CǺKH7ٹ82\Z#\0\0]R\Z15~(T?X\0Gl@T-s!\0\'F#@wY»C\\k:N\0\0E\0m9BHHm@emx~\Z7ݻDnF\"\\#m@IWVlq\0fg۳h7Z+YΤL:Ɲ͙#wD1\r`a ={\0*}uJ^\0sYviWPF	?,\0=fש/\Zۿy*tZm9OL@}dONc\Z	o?w;&x/^ic7oS[QH\rNYlrLXƎ$iuJ5*i5˜Z7L-۳xtP)g{`NOR9v;sg.k4/nk57i\Zݷ:XqUsK\0c]bh(zN-k݆\'\0_5\\1e{ דg_^A,{Zݮޚڭ?\r}\0ױߘ4mw\'Be^veg,Hc:澺l4Gwփ{qp#m`GWKllMFMV;y}uK\r	nI{\\	h\0&vnmJ˜7l}?O_Sp67s\rUt3\rk,cAhs蓩oDl}c!\0 \0c~cHz+\r<;htflٱma-:j~@\r\n#X\Z:	ޛ3\ZY,9q.6h&E{6\0JI 8\rvC߹\nV+>ɒѵ\"6af]ֶ:`&OzC{ln#i׶A-sf?Ujl\0cZ\Zg	?c}K*&EhcmgO\r%52,kj\rq]=\0\"^pih\rAť{cv<ͮk=\0E]m1Qi0>l(oX7tG]\rX4I\0	;Xw8ӥsXzpwN\Z)\0q`;F2ؗRzU}\0>\0)/|Èp:7\'-1@K;Xӷo/Qcim>?\n;t̻*\r;~Ysd=\'- ٓ\02+@vj7GU@m07nP\'nq&5>ḊGI;4˥NUVFH5ű\"d4oJUIwө~GsJhxii\07PD̨l/l>1=\"z2$L~Y죺M9%\n<g\'۹U57X,ppm!A]{\rYH^E	۞Ai{c^$F 0l57@pA=Ez:x;˝h$iS͢ēEK@:iJ6o?Nn~瑰GO11<\0KT6MC:\Z}	؇6	:9C,1clWĲ>LUqvG)\Z\0ݲדgjO)מْ~(2aӱO(̻*Ll7?A0@(C$\rnV\0NiL\0\0\'_rѱ\07*p\r G8w{2eի2\\AwP(s@͛fiJfhH\Z#\"turxأŌy{Z\Zyې\ZDd>j+v$K%U\nүѠp$qotDݰJoA:HVl!=NL~&Tglh.i\0So:\'?M {\0Jklp߾&$V0PЂ\n\Z4aKO;Í|L~wM5$Oڤ\ZֻxcVu]B]۬~kӖ;w/SsݺTBDVB\ZHӈRujbyT\\`-x\0CX\r$$}jZ\\?kНj0p{	sZ\0娼䍀#M\'>i	o<XkmJ-sM{l\Zѩmp#V\0nj,=.{bkp!@^}-QM&lv\\#Y`kCd{9!Eu. \0zYsݽӸGuOmurI\rg!=nvgpn\0M5]sIeDT\Z\'+nQVƥ8nӣM>\'Ms˚8d@3NC*`K\'Ck/b~9v9/qEoܤ\\{HwowҒm\Z6\0(wRw\\Z ?\0SɥqL=]a3cs\\Өw`?qۘl]R).-64ZYW+r{6z{uYsn\Z?ԬmvS?k7ܕ~)IFCYtCK@:/O`Av3fãE\rk~{\Z};\Zk.kK,OOwM&@MS[>Ig?Rykk׷s_ӬfH^eao\0NfYn(kl=ǖ;tUZ׾m:Z76L9k[egV^K2;J4vۼzwׇ\0)p;}k]/\0.0\rhw{FԢe2`?[C}{nys?oT\\67C۲}kTAsjSw{&#RKdB}Fd<@?p!^\Z#Ǽ$;0H\'mhݴr?$y%xWCKvx-v$.%pcl\ro8F~Iܟĺ^\r\r#ѽHTZ;4a\"DUiC\\7{A-sap~?w%y_çZ;+\ZNX%-~+Z:L~7%Gá߷u96?~vd\Z^8\0Gn#Z*R[-o.Ix}]*[Z%wo=$ѴoI\Zw<R@k6i\0/\Z.5kݫQݹ$v#wSžbu}-Q\'v>?Āwu7A8׃DǇd\'Swu]xA\0iۇI`:`)mkk^7\0\0:Ow\r\n6zcs#>75$}\r5ݱ֒I]=G~U_R9V.[acǗDLK6H&\08\0b\r{L[h1nkG{TͶ1/sc#qfXݰc\0Cg{A\0Iqm.)?a{]>+]!Ǎ=\0mE3\r8kjo~oM\\ {͞1,{v#o	w?KFj~vNY#KSyMr\\\\}Hp{\01RC2Fd%wZ\rck@qwOn5W`;ZO-Mh5\04\'\'pT9z+m\0.?j[ѰmX\">u\\AIIwnݐK\Zh[u]\rxcMNG?{i/$Ln5:8;]b	\"?ҤZbnpÛ	dun\0Ph##\0&4<..lEo~#鰘-#W1͇ *ؗgsD\0w}VEz懼k5Xޭ\'\0d}7)\Z7;{7l\0[z.W;*gmn;v𛿛\"`*~4MO;n͒gƱ\0\"Z@ޥ_\0I`ul.\0ҤC	L5DӹΟoB4[Hԏ?wT.yԐ5:@z[Ǵ<nR@\'\0#ğr\\K:t8.-\0Rv(m\"B3.2A\Z\'mJ%CcCBg|n\rߴ\0+4Txt+]4MXU}zk=kMSvtIBz]zzV[{cg[%ACP1..h>wVt\0	tO츎Ñr?\"Љ\Z}Ulk}sf{({ù\rOZ$\0S@]ҖA%\nڈtGgϸPyfIӾLED$5ӹţ\0\"S&4-;ght%N8\0iXMY=,{[@.:GpMrMiu+67k\ZNkɃ(xڤ*<1G*z?v;Xx<@&v]Bu=ޛan\ZLc:ab\ZW蠋ƈ2A{;hT	Is{|SZ#yqn\0>Y!0{Y*\0@&;w):݌!$j \r=ԭ\ZQy}`ݮ~w&\Z}\0 A{惰tNwX\rsZOHhcwRO1e;]DT2:@P?Hj|{_ {>hΚLZ`\ZAđhA:ҵVC$H#lrX}ˎxֵImR;\r>l\0WiL$\"\0/P\rgTLC&~=RE$2F>>CsZӴ{IߧS@yHN\07D\0\r-$\':?sRX\ZG0?RG3D-7<\'&U&v;ZG	83\0at0:\rtsvčvDWY.0\\gFχX{+vnnd$kvT\\洹ė?A\0UFL;\0ko@Z-dXf\0C~\0\0j$43	ؠ׽qm\"GZB\Z?Kɐ\"@\0~	9\0tZdmo\\C[`\0c\0άsee$hvvWgĝ2]ckk]{\ZG;_w_Ӱ#h&@܎[ꇶ%@ݪLC?M	-k&:H#inր3̳`^>weGn\07uؘMw_\0\"GpYMFv\"}֏\0	KƎ\r.	.4s\r׏mEqx/5>%B]$&aw B`h.☴{0\0I8(\\{6?jlpc\'IvT4馰Gq܉]8ZkO$\Z$ Bm.|w `{q0+Ul}vI2pO)\0i-5 WV=I5{ٻH\'JoM \04ws\\eѬm~k<~빐5lNoVK@#.ޫ2c6iP.6h\0ezM#O9#i/w-Ԑ4idD&SVKXK>lwwANMqg>؆^5Z]\"&\">~r@&2/sZ	LIwZcd4w\'\0X?C}Anq?IP2gk`}k.k89x4Mgy\'=mKAj[\Z*#mm^HA\'%ldȝO84R-;;N,լb8*[7Hs~;km$$\Z?rnBm5mѬrx\0TK}ƀP02NyOKt>i_`Ѝ=,۵3m;\0ۻ{N -%[S0On~n~rp\nm̽΂I.>jxvlqp:ms-<8>UH`\0gG*= CKG7:۾m&Vc#nOj!ƢӠ-ii\0;Y:Nh-3mW\Z\0d\0W܁Sh%6`oOZ]dDoVQ6ƀ&.#DsY$v`\0B#OQb;qQަpyO4n<65:?H5t%ޛ F\"Vƴ@?G{k/-HN@2 0#DUwz[R7r#ik,ٹ.a&\\\Z`ݖ\" } FLO\0UԴReXy-}m.-;oҫ\0VFw455moU1YH?hfI\0	Ϣ:ѩ24kfژ#c踚nͺ49?T?I\"=wCv\0\\gkkl@\\m\Z5Ր֤tCW,d\\5<;̔kS	ω\"d<Zk\\\0q] BO?nUqa?Cpu5`!9%aItFĠݴON5\0\Z|E\"s 5Gh]ځ<G\Z[cL\0cHwb\Z~:hR\"\rlN%*\\<~i$AT1J`\0ʼv!! r?cZFg\0G[\04I+}>a@Au/<\04T\\\Z\\N\n{ ÌH N7J{x$׼9\n&vѣO\r)HGWY!$q\nq_cp>\nN h\n9\\\ZRCC6@>H\06 LI`4h5ܙv#Ĥ{Rn+/}jI}mrΰd?S\n%Д4V\0j.LPumqqvIGM,p0x1?Qޛ^bq	2\05CaXk$\0zNd{wFzVcIkgUH\'M44FfgtHG68\Z\\1HOnӣ\Z\0E\ZD^=A{C>6AV^\0<C\\}yn\0,-Ѱc!\'uF͈- zGV1ŠwRsj=Ǿ\Z~rriװHb-k\"9Ɗm{XC`\ZBm:	H\"M{\0贅E+Bwx\Z;. ^5k\\\r\Z45\'j50KYcCh]256-i/F\0jDUKs<>p娧E\0uBIx$kuT+͓\\-sAh\ZP=˜O16~03?\Z-kwꮅ-lD֟\'F\\2,Xͯ\Z5	?B7\ZY.6A}\"w2<RVD jD\0MA²\0|GITίn-{_Q\"V]-vqv\'[[y80͸6\"wl1	wڢ}Ji\'I7Ԥ3kas觩Zk	&	ݾ}hs0`f\Z=\ZC#~\0%zU]mű^lZCͪBXhw	s\0C=~[L5;	n&ٿ	4.ah})e=Q\r{^!pg\0s`X,jP@\'ŭ=A=	k!p=Aqdk\ZMS@o\0jwwLH$OJǗj#ꋜi-:\0H\0IBG^źPt3#L$\r\0\0L7DD聳\"w`	(JwkpƂL\rc|w\0JsѤ}/&L<h䩷\Z\Z.uZ`\Zݮ:^5kߺ7i\Zk)>Μ|H&d~	ĞL@&Z{#T\rs	GkK6;V\ZxA:IOɤ}RK=&i}5vIiA!R\0e2H:\\\Z$ڢu%}ޛdwh)\\lf;襶׸>GP}p5״\0i8ިDkt%@8?ڠǸ~#LRan\r\'R`\n+2N~tVN2e̓fKΑ?83-:i1T\\w5 C$l#]kəZ5w$NQ8Uw퉀@2	n縒%Q\'̏-Z#&sAA㿗zH|E`q #Uwm\rjHIe4өk~$/:mh@\0#I洶4>Sz_iSv!KBM$8\ZU\\\rPIд?ʳv.ƒl	s\\i\0\0sSvcp nkD(lϴ \0%Fq	cĞtlQ7ph+*[wQ;h4i$wi0֖FjSAGCb͵[F\0lnzrH\0mǏHI\Z`{dO\'Abeunkā3y\0ېƻ	2=+}MUd`!͖B\\t\0@\r$4:lSs4\0~kP{cw ?7o\05CѠ=c+.v:s+@ShN;\0(Ya0Z71\ZݻT\0!\0IPc\ZC i[ T\0\Z׉Exsw?pcC9>j!;R[\0Bk_P~r],$vx=yۮ1\nLsAGb@\']QL#RP=2{q\r D]mv4jn#?ih5vH<!)Dm<A䝓T@`fIpd\'9LeWkٻh84p:M\0<$\'T=Ѯ<6[\"Hv	WKj9^d\rƀ\n \0XglOCIq~T9ۧ`\Zi(ٙ;JZFƙ$\0y#	4U)\rIٝ&H\0\"\ZOQU`G^evqIR]uvģUp=\\vw%^1ۙa4@MiF@Ž}nn\01;sf ٱ=tusIw&qw5{5=Ysܡ\r~nKkv$Jl \04PM5[m\0BHvVW<@Oh\Z5?;\01] Q@wJ$$4\0kT	:?Z:kA2	 \0\0>|?J>iw6ZM`\'Rpk!b&?{SA}ÈTέںN>IZ;mDm$tJAG:~[w4R@+pj\0 \n]cI\00HtWQ)CAs\0ր.$km\"?t+tOicX\rm\rqn!&`N߸lhbgr,0 2\'\0\\`O_.3FZǇ=kAi-I[y!ike<rj:Z%X\r\Z~rn9p!\rcj^݅6v\rLhÄN\0\\#=7慠Rg^Sր.\"@\'If\Z${b\n\r.<F8 tjaXU;.:pG\ndlXu:Ҷ$~A֟P\ZLY\";ȁ\0:\0ߜ\0Iv-[=	>#Q$ALk1\0A4bXKIRF?E\0cIl!\'5mh\Z(PnCdBo\ry혽#OPk/\Zΰ\'s>\0Ŵ(%=vhu#guio$tFsD\n,[g)V!if;h_I]}ǿCrHD\"bqm4Ln1#D\ndlIw\'Z\ZF\\JdhH?5c@\r 	:QRPKG(A\0NQcqԈd뱢*@9N\"@=p<x;${!8\ZLJf]K\'\0xkH.5\'Mz%y>(Nqw \"5rfnx`o<?Gb~H\Zy<G\n虻]\"CgC\ZFx\0 OL5\06[r6@;C ]?QsCi=#\0v}<M\Zuo.ay}-SC{R;)LΟj	k;$O]ۋ\\Au?s\\8<\rR5ACY{N5Q\0pt#CTd:k\04scO>PЅ\ripg#U.kQtm\r\0<5Ih\rnɖC0$j}T\" *pE<8bK0d1gF#HR)p?v8idn0O#LK4|(ln։kʋn>[D4%~h\r- u4*bC@%߼;uI0\r%վ_f4[\0\"#keč;nٿ,|DS\ZFsGb@;$ѵp5ǟr0z@v\Z&	:#^!1mo`}S;ǈ\0IA,xs\0YR;\rV\r6xsf0vobH0yCqkC )\Z|S՞ZgqAt6E\"[\"DHw\"{[ω;Y[CjY0OnAkg9sY%+v IS?%Z*px\0F\0(sa{t\0|QC}:qPIsAka5$ָ2dޙaI+ݫԓ#}27On>Mn\"4C@w1\Z\\D@n5Ni#HD{	綒k9ЙCuWF$ntCqh\Z	=Q N)Kd3YGNecVM`ns}Hg<N* Dedq\00+txpc)5 \Z%Gdvoq:4hi3[?lXV~\"dpq\Z&.\rQS)-@2qpRSLwSрNiuj\r#=Z~l5གt.nJ.k?7TCH\ZBt&!uZH] v]iD)x	u|t{\0\\?kco{L&;h}\0jxN	mJYXZw{<;۷jMiG\0R?%yOS-thdow*6Z#ؕAF!!ŧVJ5D*s\\Z@\0)yN\Zy\0\rq6U>i<B`Zߔjcn A#r-cV@cĹz<#P\0i&\"^)4H#KSA-w{CI!ury \"lhEyyik\\`SOeLOA[@\'kHǸ491y-\Z6?\"\"Ѩd\ZI~@\0;jI\Z\ZZXLu\Zraqe#]Y4\Z\ru;ۡBC`)!d<:-ՠ?58Р	\0}\Z릪-HMp@ӓ\"\Z]\0~q55#PIq ɏ&ڟ%\0TӴDG	+-8g2?v6װhG~w5\"	A<\'<xɛpcc#Cz=NY=k\\XϝZ\0!2ǐI\0LI -Bm$ƐSL\0e3^\Z72gR$\rz?y+U&{k#OߘHq] 8Cu-x	:L!\"rϥ.->Ng\r\Zϩ64wWsr`w`;O\"xhrԓD~@\"~k;w6^5]>}8ys#^\0F^D8?S\"\0nH:kqѤ$SK\0OÀp?)M=X\Z5>HO\n{\'pKeSsD\"tWkJ9.tø<≍Ugzck}vS<5Ӡ零i<K0؎Ű\Zϥ)f\0P.hh2#\0iBò&Yݩs\0Rs\"H{ \'ta:}\Zp\'a\Z#\ZԤ$HqN`qdO\"8x\0uBA:\Z<\0e3;!?ܟN]XKu\'YǹPmzba\0L\\kPmiԝG(8CAABtݵ\n\\3CðN\r(P솺$w\\\0Ai\r2`+7&?t!B@pwKq30	;XJA(F\Z&>IC^,p>=P]\Z\0k3BrѴCñJ7B<0=G(mn$).3$?\"IQO\n\rkwd:4%-c$mR;܅d1&LFa\Z@զ\"t\0~C\0hyH@UѓMqh<9~b-v5ׄ۶		}\0	R5\"kėi\\ H$`YAo=\0xrɄ\0e$:.\"_M@ 	~r2\Zh`Aۯ?mtĖ40S0]F5\"Rsi\'Y;E/v>sq;x)ݬ6`w} m\r{A\r\'MC7$4xRDF$i\r̀$7gpi$i?!D\r	]#_\"H[_QsH!\04\0:mA0Z{n#Yr#a3+5gXD\\\"O:fg৩_Q&ʈ0Lq3&+#JkGs>)\\@&dBAJPcH7\'I4QWVK\Z5`xۉ)$I$N~!H9$H 48|Ki<vI;	&|R3*LΞZ\nvZgBUvp=xY/q0OĎh=3$I\'tqԨkHL(ҕRI㶩H5CG)8lw<޺1cr#qL@4.䀎ֶPlms }H}H7Ȫ[O=lo\0]\ZD#\Z@0ZA?NZkL!V5vrr?6=˛c3?R0zMvOԷ!<56!=żrf?	.6;ʊ;KùGO=ŰLxZڵ?˘Sev%z:%46 ݔ3|8%H@C):-᪃DΞ%HR?&\')֐C=:(:Sn2FT-l&J\0}$Y&fr4Ph	\"{\0Y3åӷ	ԃ8e\rwpA#5iq\"OA6yJږȆSKkDGBwӱݧ3򽨛/o\ZqT\\*6Hnj\'5>ZѧtaOK#$0-N<V,D%7LT\0qhglQDa\Z]\\b|k .4Dp ̎#^P6&t*Bݭ۷i\0k@\0[C;FZZ}L&DqoA).vp:=uu\Z6@)2L\'FA}5Mmk0w;].=kXH2\Zf[[Æ_5	: )3h2:vFR\nx#o=SDǈC-Ov$sHHYMiAbם5\"M]3\"RBIk$tD4	Bƚ/Z=-y<HS\rp >ك؎AqÉD}%(ݩsa p7#q=WT=V1ODMT>\\\\5b?w.;㺷jw(;NK^Ggk5-L@}@H#t\Zh=Ўv=sr{GDqjoa\"NGJZK\Zt\0_2J=7BM{k0#|P߹K{t:<dmNÿgzqa>	.V@[I%M)D]Et^T]v߿bU|B5ms2f>Fjd곥(4UfJ: ƃ>y?Sh@#@LBw\"\r;2xؑ40~i?%KL蝮cHPe{|\"0\'S#怕?#CcOʓ$I	9#\\dqhdw-V~d(<e;]c@qՐ&;!K%N]ZfGo>%$wTK$=e1:I!k#md5\ZƛFzl>A|LkthS`֣6,`	09栵#[R&*`ڞ>[$>ECpΣw?O<q8i,\\de{$\0$*;cḗC\\>i?%x]Gth~t=8?8Q (_qZ6FRgYZ7x!\0G@\r׃(\r\n$Dh:	A<@qSnVu5?6`y·0-\rA\ZvQ\ZtVi2<u(ip\0`=Gѯ$N;CsIho/L:PB_AI\'7u6Ԉ\0Z\0L )\0\r>Nj6w \rgeq`k#Tݹ1>m֙q2OG<\0#u綟U[3$H^=lgqvcl\rΜ+.k)h֍|Jx)-7\\ݞ֑-VmqLy`v-d۝*9Nɰu;.X>(z\Z|5O!6&\\ufzKwl$~jyH1TlYV7tAk6FOl!C\0\n6\0&̏Jun:ʗGgɾw<fD/Z\rՇݤ{*۩?i]z7\Zs6}xhu\'_LǦ\'Ȗiw-vѐ[9\n6㻸;HIͯV^7i\0Ok㹎2au]Jp \0(\0-Xv18i〠;~	 ixmQ߈_Ld;pj l̞4Ru\ZmKD\"NNO=n\0\rOKqydA\0obӬt]t5 m6L\'e y	`\r;$4szVPcx0Tm8h᧗Mv}:D(t\')O=Oؒz>1K c訷gҝ3 k/ڟ4	T!\0\"a;A!8#We1K%Ix0b	KGnB\Z춯^쌻S<#>)QSiW<lw80@MB >_jS\Z|IrK6u\"u\n\"7nGܦ64u檤an]D\'inGy\04:7M&#kBD)^Q0~c\0y\Zp&4*O$Ldx\ZC#wΓsP\\4t0w([[nkgSl;8`\ZK{4 r(vh-ԏ5Ӵ%GS&o$yh]cv;.lJHn~\rT!\0 -5$}S{tZ|z[A {Gc<ōf\0ΐ͚*ւh\\cT!DcO!\Zd9o0tBBCQV<Ľ}NDi;p(1sS1;o֕Fimk7t#TEMsGUő-,]4lvj1:I+\ZQp^udiIp\r@A	;P\'QIMX-4N\0\Zp\0_(sx&!0\\@\rD~*Nuq0OJ\r\'AtBkX4|&V-H$\ryOP\\5\"Q\Zs([!^O#܇O H٨Roa{%]$I~r#mok\Z^CZ솸Xn\'\0\0Rl}Ѯ-,spTX8#)1ڽƭ)־dhFR>	Du$ĞR.nkT@a(C3EHyy>PnVn\0A>q	ll	>s@t\n5KCA\0Jh)CHѣ9h<@<\']}VC^I:@?Eml@P\\sw$4ng;IJ];uMQs:b8MD p nu#\0\"cCޢ \0] H\n{L8nӴ$BFTTl*@V0Ko6wy*LPTx(m$norx\ZƁIVG @6dk6EP-h @N\Z6Q聏xM\0I>%:)9	l#XPCQcNjcA,\"O`\0*:)F:~E$f+XbwVݎ]Itk*&{p*DDX@I 	d2#>A3; u_I\ro45\n>* tJNfH\Zh6@>I)\"To$:hg7Fx\nlU&52́k1]kߨ!8AX&U[~..!GMOzXɐ\0y;\0U[8v4n\r0~豈ᦍ  :=]r\n=SR+jkp#@ŭpkL}$) DH\'MKOrg2+NuPN,;X8ɪnp;ꦪƵuY BHv`oL\'bR\0Gat	:\\ }-xVol?4\01DTFCK\Z\0fy\0J{\0*˓r< mU,#׿\0\0RƵ@۴-it*lh0y@\n5\r{YDLN 85g):G(\n8ט\0ԩ0I*OLX:C{Y%p$r\"u_|_wdXw\'81.\\\'!\Z%(?/ꁲm\Z\0v=J\0s?2mH8nƱ@LA\0tl!1%-.3Qӷx2 ~*R\ZOSwOuEsn2LOR$6 NH\\\"H }u&\0d@ӲLii:!Fhɭ$\0H998ˤO?܃ߟ[t;`lj4AݡJ b|v[i\0#Ƿj&|QvQ#y0`Ok]y\rN[ݣ[ǚ۟GmHmX\0uv44tPˉ;K}y,OD\0k\Z5vO7AeD`3)\r:|iJ]RX!a~\0K۳V<|\Z=\0$vA	HlwZ@ nRxF{%@L:y&j_=ΑIr5Mq$vsy5e\\O?\0-qLq<{ \0numdk$G&=nB8sI=S.$t]mU\"4x4F<v:A@FqQ3%KFCJ>^%YgSU*0tlB0m1\'mF/U(i70oX%;vw@Z`ʌGغ_g)wb xi;M.hN\0҉JcCK7vkw`R\0;RX\\*P5$kg⅄?7r.V@߰je9:|&˵̩kZȗ+[mvo\'|{N\\J8G2kdM<0{vʝ\rGݣQpc^á5 6 {G-.&~3Ή?窋Z`>.<d\"%6U\0_y>͐Ӽ*F\"A:`ft03Jn ;Fƣ?u3l\"81<YLo\0IRW q<<HIۛ$tz		j/K{ JM\'-gX#^\'r=Br\nDkPġ??sEHl\'\rc㹮hHJP:#`%=E|GGѐ ܩc`,~\'U!Bħi`Gsvf*U.\0k?Q`$hSG#BwI@IE:819kX z<7U\rptSkOGҸiO#ql[\0FHOJ8z~m3vcqtXdO9A1ۺU^;&/ Ii@G*UkJǰ<2]v?@\n\0IM5M\\cOYA>8	wsu&?Iv`KMlV=4,DYQ`FUߤOdBL/rdWc%<=¢$;\0cCH;ڢ:\'duD\0ţTMmQ dt \r0qBcB\'HQ\n<EG=Oc>\"@#F&b<U3G\0TyH]ay\'BT$\0䆐7W4l\0`vmVYUi~jls\ZK7QXcmuo#F~r2f0Ɂ{]̢Z\0iwl|gTTa\0#ڝYHQQiPuQ.O\Z|SlRzy	O\ZDsZ6h=Ο樴Xt\'O6A@:S]hˢ7@\'9c7h؏$\"ׇt8Du`\Z?}@Hwʒ;iP҆c]tLXY:\'(Kꆚ\\=1CyhmCkC*><wN ]@:[ vIDH\03@6\0):\rJ$8r[_ȝޡD nq	<Á)\0-,w<頞`r $KpJ`\ZL\Zj9~$ݸ4@<Lwn){QS߸QTsNtTPPCxH8Sw~!a`wh4$֡\0Ln3#w@a\'aZ\"K`AȄ\'M\0	b8($j@$`|LZ%7*dOL\'MO.L\0%FI?7X^e)Nr{J\Zd\Zw	 H2IuГ7&{[n}th\0\0.MOK*;Kԃ6t:R4ý\0Kc^Hn`3x.4<xҋ@\r\'[rK]\0rh`g]zwHS\r:\'(-2	PO\"u$jaӠ5m4A1\0/+	^K kI\0KB~68ikfhˏKH&\'EXjX}c\rh>C.i?Hc_e	pZZ:	\r\nkS;Olq$摧cۄBΰFu?N|.eNT`h2f#*\'II%fOPN%Ho7ǉq ԧy:ǸlZؘ(cW&1؏ŏ{axisX=l\n 4q%CDv*la\0\0餒\' JDH{kc{.a;#󿶪45?P6w,yDuo:Rt\0~;YԒB.MdyP>aG?~l?/ \n\ZCG=H\0>bQJ:v$%8I͎*d5N~fy\05#z}W\Z<3I^g?z\rtLv1?Is |4 \ZFޭ=Yg`\"\05*p[${>w5*{\Z@ k=Gu6_KM4\'`mvV	۩ !HٹsT[_EKpMAWLrĶ;}LxBv-_2\'_Ы7y0c1M-ypQ\"\Z/;߂[~)i$eJ%tMSnC]@yd\'(βkt#v]]51ʕo; xx~:2)j%\"P:7\\!@\'ySA Qљ$BiFf\r2&<9Rp-\Z)4)ïH\n llhCtGsPvA1^5;A8v!lPN빺<&ら|JODM2T4OV]G\'~;we(C`RPI5t1&p\0$,3=7&8Gף\0KG&4	4ge_̀A> [Ki1,H%=?U	Y &O^4纷U8;!8`#g#c=V7i\Zv\0H\"E#X\0a2ؑ! w*l:馑*Ý#nZײ\r@28=KxR\r0ϙ?N\"4\\ZF02unҝ\r#k~	5bA{@(a6ec].X92%X!+k8e)!IvDo\"qa#7\"pyF;|G!K|%G(-G+˺y%Ct!Hvy<T^C#J;$I[Vt\\홍ZtvӰ\'\0\"X|y(iVq4x\0_Kn3Liڝ8OOar9x\"|4*kC#	K<vhB{K滑Q3^O4;]<N5+eD݀\r]v\nd\Z	k৺YdNmfX\ZW-8Blβ%\"dGFҖ׊iHE\'dCt<x&u2\Z{w%6 \rH\0_j[)vU74m\Z?ɛxKf~	\0	촛(\02:FJ[I~բ^kbS4%	1^(6 QH5Z? |~j.ׇ|HsLλ!<b	hJwH\'a|;Q/6	RO\0Dq\Z\'F8@i-\03l}n\Zkuw?faj\'rmKOŠ3 3=k`x3jVz^TF>s\0%ι \rv栽t׀<Q4.@4+\"J-bc|ACt6~$[lGr0Wm_ečTIn|B\"5&`w BV\rtåˇ@j R\0\Zkx$O1\0U\0I*5\'G\0rwo]{}80O*}G?aIDgwdV\rnkCHd%-MW\0af˴$fR>k;赮c;9-u[DsRԪ4YF(Dx}\"/Ԑ.\\0@sK\\7$kY\Z\rn!5	$\0{	7\Z!kt\0~Ft*.-iA?\\c5\ZvzD{<$1\0EBxRoOAܨ;g<53T\0sPZ\'~PM;[cZM.kÛ%D~k]ƠZ袶4hbG^pEƂ\\]s?rB׹g50mN{5=cMD->]U~h_[Cy\"V 0wqJN>aNzd\rKA(	vu*ws$D>\"=\rk\Z\0~N:QrcHw̦#:lr*\\&wqP#%F2\'!4ۈZa#e,Tֵ	tL䪩w,s6Fg!n=Smd{y{j<G};-6g{6q*Е!؎Y%oU\r#D\0y\nE@#)]:XGPek>Cdj\rN\\BSƕEֶ;vJKA\0OeVٷi$4&@׿\nGo-<{$R;W䞬L:sLR죽J+\Zo\Z+ =ʱ~1m960<mV9muNrmp-5}5dT1./b7)hj:04	Yd7{\'Ef%M=d(L?WJ\ZPչ}4rͬ$\r;wjh\0EH|ϒgKGI^QրH	yk	$(Ooaw\'%IJT\ZAcOi\"$\r\nvuf \0۹5ha#6~*;Tah\r\0EB7*UK|{kOx/h:	CS.u`XC$L[\0\ZY5e/ۼ?b9NXvu#U+,q\0o8[zVQ}`ƈs~MX->@p#P# waЍ53p;#\'-IW6ƀI>@t@<wX5<xQq%71BcMj	VǴ\0Gr<\09XCvh>\0$(#B>i>DElwPO	\0c~ɀ\rWT%\'l:1xn*\'I|#O|S6 \'Ôи)\0]R:7Rúx\Zm`yDq\0g%4{#rJ2<\rI8	73=Hȣ-?Ck65 WAê(lZ@gP\0=杰C~$ȺYL\"*;[:8q?*vI;[@G]hAyAϑyN5$$(dS\'\"4uOMceĆNrE%$W\r< ¼V<Gc*|4~j\"#M6Ve2fP沢֍dr57E5;	h|$ͤZG6I:C`\\{wFzQT\Z6?DTKۤ5;EI46@=8CmEOmGE;5	й \\)\'d[c_4jS+\\\Z!w4ܻdl\0\0=ZTTH&ؾd4>\\	O\Zn	\\k*tpպ|B)zʀm&j eQП;UBp9k$|@cݨh:	@,wk3!Fif::~<ܡb\09Wv_8F%9`8	N V4έ%A:;W\0Totmԇ\0~S$>\\(8C`i<as}G#B@R-{*Fѫn\0RamdE;c[akbǰ]ch}?A4w跈\ZsdD^:	#W6Kbbd?0AAi	nˤ><2}l6u2~i D|\ntAv Kv(@I$\0\'|C`h_9_$^i)Jvm\"UQKb6%%]$ӺvBCp^6>\09TVez][VޞAQ$o\\:STH(6OD\nI5=[β%E4EU$TiCŶӠ	_5M$[:&.\nIKءNֹ\rhL\0$;꽼SK#VՍKjƇj}}X+0WN/	\\Z_(xNǉl?sH\Z=4g|t˅xL|l-7ko#]rJmxcu?ӈ[׃{F=+%:8(.$ʚI/&5]:SI!k~$A8+\n|_-FQ$*(ӧm\';k\Z4תU*ncv3D8URKN=.:q  5%8nkFOr,\Za>՞fͮiGN2Hh\ZǉTNF@\"#¢ot1\"8_EhhU$EWЮ;[i;|JSKzjjAxp$Mn:pGq\nIJFᵶ\0*axTHpJ6DaTRRyv>\Z{Z$2\Z<Ь_Ik*J	2OCD?F\\`;rIO?vcq[+Fݠ<O5\'oOo]sǟ}?!t	Bd[Sp<wۢަz{Zac\'Q˼JIK?;	f%Hoi+1$pߊ]\"wZLG^s@hsߩݻZI+\0»7썌)ms嚒W\0TB\0+s+}^%EG9]!W\0,$1?/S\'HZH~;]kiD;.h$rI(]UϺYR{픞NO\'X)5\0%{Aβ\nI:.]؎q\Z\ZwX$WiLs)1\0k+-%C滨',NULL,'image/pjpeg',1,20040629204127,00000000000000,1);
UNLOCK TABLES;
/*!40000 ALTER TABLE Image ENABLE KEYS */;

--
-- Table structure for table `ImageType`
--

DROP TABLE IF EXISTS ImageType;
CREATE TABLE ImageType (
  ITP_Id varchar(32) NOT NULL default '',
  USR_Id varchar(32) default NULL,
  ITP_Name varchar(50) NOT NULL default '',
  ITP_Desc text,
  ITP_CreateDate timestamp(14) NOT NULL,
  ITP_LastModifyDate timestamp(14) NOT NULL,
  ITP_Active tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (ITP_Id),
  KEY usr_add_itp_FK (USR_Id),
  CONSTRAINT `0_690` FOREIGN KEY (`USR_Id`) REFERENCES `Users` (`USR_Id`)
) TYPE=InnoDB;

--
-- Dumping data for table `ImageType`
--


/*!40000 ALTER TABLE ImageType DISABLE KEYS */;
LOCK TABLES ImageType WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE ImageType ENABLE KEYS */;

--
-- Table structure for table `Item`
--

DROP TABLE IF EXISTS Item;
CREATE TABLE Item (
  ITM_Id varchar(32) NOT NULL default '',
  USR_Id varchar(32) default NULL,
  ITM_Name varchar(50) NOT NULL default '',
  ITM_DescShort text,
  ITM_DescLong text,
  ITM_CreateDate timestamp(14) NOT NULL,
  ITM_LastModifyDate timestamp(14) NOT NULL,
  ITM_Active tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (ITM_Id),
  KEY usr_add_itm_FK (USR_Id),
  CONSTRAINT `0_692` FOREIGN KEY (`USR_Id`) REFERENCES `Users` (`USR_Id`)
) TYPE=InnoDB;

--
-- Dumping data for table `Item`
--


/*!40000 ALTER TABLE Item DISABLE KEYS */;
LOCK TABLES Item WRITE;
INSERT INTO Item VALUES ('09295dda63a513599565fa9aef0d9881','admin','Panasonic TX-32PD30F P','TX 32 PD 30 F P - Luksusowy telewizor cyfrowy klasy TAU z ekranem 32\"','TX 32 PD 30 F P - Luksusowy telewizor cyfrowy klasy TAU z ekranem 32\", technologia acuity, rozdzielczo 2200 pikseli, 833 linie obrazu, paski kineskop Quintrix SR (super resolution), cyfrowy system 100Hz, nowy ukad estymacji i kompensacji ruchu DDM, wejcia wizyjne typu component i progressive, cyfrowy filtr grzebieniowy 3D, progresywne skanowanie, virtual dolby z wbudowanym subwooferem, multiplikacja obrazw (PIP, POP, PAP, PAT), telegazeta z pamici 2000 stron, podwjny system stereo nicam i A2, ukad kontroli ostroci, ukad wyostrzania krawdzi kolorowych obrazu (CTI)',20040605090810,00000000000000,1),('2ddbc0322c35602c9f4c5e476bc0ff1a','admin','Router xDSL','szerokopasmowe urzdzenie dostpowe do internetu z czterema (4) portami N-Way switch 10/100 Mb/s','Jeden port WAN do czenia z modemem kablowym lub xDSL \r\nCztero portowy switch 10/100 ze zczami RJ-45 \r\nCakowicie zarzdzany przez www z wykorzystaniem standardowej przegldarki \r\nProtok dynamicznej konfiguracji hosta (DHCP) \r\nDzielenie Internetu - statyczne IP, Dynamiczne IP, PPPeE \r\nObsuga Protokow TCP/IP, PPTP, IPSec \r\nMaksymalnie 253 uytkownikw (komputerw) \r\nWsppraca z systemami Win 95/98/ME/NT/2000/XP, Unix, Linux, MAC\r\n',20040522192817,00000000000000,1),('4d546e666db5ec52ea7e601346c4def3','admin','Drukarka Epson 640','Kolorowa drukarka ','Bardzo dobra jako wydruku \r\n',20040627151337,00000000000000,0),('6b7590d207e114adf0bb2e734ca79fbc','admin','DVD LITE-ON','DVD-ROM 16x (6,4x~16x), CD-ROM 48x (20x~48x, rednio 36X','',20040526101605,00000000000000,1),('8c2189c3c39997e0d6b27e1801ac66bf','admin','Monitor Samtron 5Bi','15 \' kolorowy monitor','2 lata gwarancji , oprogramowanie , instrukcja w jzyku polskim',20040627151034,00000000000000,1),('d8175e84d5298e4ba313c86cb8c834dc','admin','Platforma thorEngine','Platforma aplikacyjna thorEngine.','Podstawowy rdze platformy thorEngine, stanowi mechanizmy autoryzacji uytkownika oraz zaawansowana kontrola dostpu do obiektw oraz skryptw. Mechanizmy te wykorzystuj koncepcj uytkownikw systemowych, grup uytkownikw systemowych oraz koncepcji uprawnie uytkownikw. W platformie thorEngine uprawnienia uytkownikw zawsze okrelaj prawa dostpu uytkownika lub grupy uytkownika do obiektu lub grupy obiektw.\r\n\r\nPlatforma thorEngine jest systemem otwartym, posiadajcym budow moduow. Owa cecha pozwala na dowolne rozszerzanie funkcjonalnoci platformy i tym samym tworzenie aplikacji internetowej dowolnego typu. Z punktu widzenia programisty platforma thorEngine udostpnia zbir interfejsw w postaci szeregu klas, ktre stanowi czysty rdze platformy oraz moduy rozszerzajce funkcjonalno systemu.\r\n\r\nPlatforma thorEngine udostpniona bdzie na licencji GNU GPL, co oznacza, i mona bdzie j wykorzystywa bezpatnie w celu stworzenia zarwno komercyjnych jak i niekomercyjnych aplikacji internetowych. Ju wkrtce udostpniona zostanie pierwsza wersja platformy thorEngine wraz z kompletn specyfikacj funkcjonalno-techniczn projektu.',20040522193315,00000000000000,1),('d8d9fa123bd227cff7b48eb28ad84645','admin','Karta sieciowa','Karta sieciowa 10/100 Mb/s PCI ','\r\n\r\n\r\nJedno-chipowa karta Fast Ethernet PCI 100BASE-TX (RTL8139D) \r\nW peni zgodna ze standardami IEEE 802.3u, oraz IEEE 802.3 \r\nTryb Full-Duplex dziaa przy obu prdkociach &#8211; pasmo do 200Mb/s \r\nOptymalna prdko ustanawiana automatycznie dziki funkcji Auto-Negocjacji \r\nSpenia wymogi PCI 2.2, ACPI 1.0, i PCI Bus Power Management 1.1 \r\nSpenia standardy emisji FCC B i znak CE \r\nEkranowany wtyk RJ-45 \r\nFunkcja PCI-Bus &#8220;Plug and Play\" \r\nSpenia standardy bezpieczestwa UL i CUL',20040522192125,00000000000000,1),('e987b2d2cb4331ca79f8297978753172','admin','Switch Fiberline','Super switch do zastosowan korporacyjnych','Comply IEEE 802.3 (10BASE-T), 802.3u (100BASE-TX) standards \r\n* Full Duplex or Half Duplex operations with auto-detection \r\n* Auto-negotiation 10BASE-T and 100BASE-TX connection \r\n* Integrated address Look-up Engine, support 8K MAC Address \r\n* Automatic address learning, address aging and address migration \r\n* 2M bit memory \r\n* Store-and-Forward transmission mode \r\n* IEEE 802.3x Flow Control \r\n* Back Pressure Flow Control \r\n',20040524220844,00000000000000,1);
UNLOCK TABLES;
/*!40000 ALTER TABLE Item ENABLE KEYS */;

--
-- Table structure for table `OrderProduct`
--

DROP TABLE IF EXISTS OrderProduct;
CREATE TABLE OrderProduct (
  ORP_Id varchar(32) NOT NULL default '',
  ORD_Id varchar(32) default NULL,
  PRD_Id varchar(32) default NULL,
  ITM_Name varchar(50) NOT NULL default '',
  PRD_Price decimal(10,2) NOT NULL default '0.00',
  PRD_FinalPrice decimal(10,2) NOT NULL default '0.00',
  TAX_Value decimal(5,4) NOT NULL default '0.0000',
  ORP_Quantity int(11) NOT NULL default '0',
  ORP_CreateDate timestamp(14) NOT NULL,
  ORP_LastModifyDate timestamp(14) NOT NULL,
  ORP_Active tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (ORP_Id),
  KEY orp_isin_ord_FK (ORD_Id),
  KEY orp_is_prd_FK (PRD_Id),
  CONSTRAINT `0_696` FOREIGN KEY (`ORD_Id`) REFERENCES `Orders` (`ORD_Id`),
  CONSTRAINT `0_694` FOREIGN KEY (`PRD_Id`) REFERENCES `Product` (`PRD_Id`)
) TYPE=InnoDB;

--
-- Dumping data for table `OrderProduct`
--


/*!40000 ALTER TABLE OrderProduct DISABLE KEYS */;
LOCK TABLES OrderProduct WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE OrderProduct ENABLE KEYS */;

--
-- Table structure for table `OrderStatus`
--

DROP TABLE IF EXISTS OrderStatus;
CREATE TABLE OrderStatus (
  ORS_Id varchar(32) NOT NULL default '',
  USR_Id varchar(32) default NULL,
  ORS_Name varchar(50) NOT NULL default '',
  ORS_Desc text,
  ORS_CreateDate timestamp(14) NOT NULL,
  ORS_LastModifyDate timestamp(14) NOT NULL,
  ORS_Active tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (ORS_Id),
  KEY usr_add_ors_FK (USR_Id),
  CONSTRAINT `0_698` FOREIGN KEY (`USR_Id`) REFERENCES `Users` (`USR_Id`)
) TYPE=InnoDB;

--
-- Dumping data for table `OrderStatus`
--


/*!40000 ALTER TABLE OrderStatus DISABLE KEYS */;
LOCK TABLES OrderStatus WRITE;
INSERT INTO OrderStatus VALUES ('937ddfeaed5cfd46653e2ecb90e5c805','admin','Zlecenie zamwienia','',20040525160311,20040525160311,1);
UNLOCK TABLES;
/*!40000 ALTER TABLE OrderStatus ENABLE KEYS */;

--
-- Table structure for table `Orders`
--

DROP TABLE IF EXISTS Orders;
CREATE TABLE Orders (
  ORD_Id varchar(32) NOT NULL default '',
  ORS_Id varchar(32) default NULL,
  DLT_Id varchar(32) default NULL,
  USR_Id varchar(32) default NULL,
  CUR_Id varchar(32) default NULL,
  PYT_Id varchar(32) default NULL,
  ORD_CreateDate timestamp(14) NOT NULL,
  ORD_LastModifyDate timestamp(14) NOT NULL,
  ORD_RealisationDate timestamp(14) NOT NULL,
  ORD_Comment text,
  USR_Name varchar(50) NOT NULL default '',
  USR_LastName varchar(50) NOT NULL default '',
  USR_Email varchar(96) NOT NULL default '',
  ADDR_StreetName varchar(50) NOT NULL default '',
  ADDR_StreetNr varchar(5) NOT NULL default '',
  ADDR_HomeNr varchar(5) default NULL,
  ADDR_City varchar(50) NOT NULL default '',
  ADDR_Zip varchar(5) NOT NULL default '',
  ORD_Price decimal(10,2) NOT NULL default '0.00',
  ORD_Active tinyint(1) NOT NULL default '0',
  ST_Id varchar(32) default NULL,
  CRY_Id varchar(32) default NULL,
  PRIMARY KEY  (ORD_Id),
  KEY usr_has_ord_FK (USR_Id),
  KEY ord_isin_cur_FK (CUR_Id),
  KEY ord_has_dlt_FK (DLT_Id),
  KEY ord_has_ors_FK (ORS_Id),
  KEY ord_has_pyt_FK (PYT_Id),
  CONSTRAINT `0_700` FOREIGN KEY (`DLT_Id`) REFERENCES `DeliveryType` (`DLT_Id`),
  CONSTRAINT `0_702` FOREIGN KEY (`ORS_Id`) REFERENCES `OrderStatus` (`ORS_Id`),
  CONSTRAINT `0_704` FOREIGN KEY (`PYT_Id`) REFERENCES `PaymentType` (`PYT_Id`),
  CONSTRAINT `0_706` FOREIGN KEY (`CUR_Id`) REFERENCES `Currency` (`CUR_Id`),
  CONSTRAINT `0_708` FOREIGN KEY (`USR_Id`) REFERENCES `Users` (`USR_Id`)
) TYPE=InnoDB;

--
-- Dumping data for table `Orders`
--


/*!40000 ALTER TABLE Orders DISABLE KEYS */;
LOCK TABLES Orders WRITE;

UNLOCK TABLES;
/*!40000 ALTER TABLE Orders ENABLE KEYS */;

--
-- Table structure for table `Parameter`
--

DROP TABLE IF EXISTS Parameter;
CREATE TABLE Parameter (
  PAR_Id varchar(32) NOT NULL default '',
  USR_Id varchar(32) default NULL,
  PAR_Name varchar(50) NOT NULL default '',
  PAR_Desc text,
  PAR_Type varchar(10) default NULL,
  PAR_CreateDate timestamp(14) NOT NULL,
  PAR_LastModifyDate timestamp(14) NOT NULL,
  PAR_Active tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (PAR_Id),
  KEY usr_add_par_FK (USR_Id),
  CONSTRAINT `0_710` FOREIGN KEY (`USR_Id`) REFERENCES `Users` (`USR_Id`)
) TYPE=InnoDB;

--
-- Dumping data for table `Parameter`
--


/*!40000 ALTER TABLE Parameter DISABLE KEYS */;
LOCK TABLES Parameter WRITE;
INSERT INTO Parameter VALUES ('0802efe8d933478a8690fbd07677da7b','admin','Gwarancja','Gwarancja',NULL,20040526101502,00000000000000,1),('269e35b4f66306210a6b6cf0e1296396','admin','Obsugiwane formaty','Obsugiwane formaty',NULL,20040526101451,00000000000000,1),('3d7005c2c90ba103b8ac600833cb29f7','admin','Zarzdzanie energi','Zarzdzanie energi',NULL,20040522192006,00000000000000,1),('5b5130618f447a47c5651efc39f42d4d','admin','Wymagania','Wymagania niezbdne do prawidowego dziaania oprogramowania',NULL,20040522150451,00000000000000,1),('636d9c841f48d003383e114b9c24f50b','admin','Opakowanie','Opakowanie',NULL,20040629201621,00000000000000,1),('8ec40948655062a13670450da59a8b69','admin','ISBN','ISBN',NULL,20040522150716,00000000000000,1),('ab931e88c6ed375cb2a56a4c322166a7','admin','Box/OEM','Sposb dystrybucji',NULL,20040522150653,00000000000000,1),('bc5f43f67acb6c56e4b769b28e4ea2f2','admin','Ilo stron','Ilo stron',NULL,20040522150704,00000000000000,1),('be07fb67391792374fbb198a85f05c1d','admin','Autor','Autor',NULL,20040522150729,00000000000000,1),('be9951dfc92a324b0c0530e27a83ca93','admin','Interfejs','Interfejs',NULL,20040526101429,00000000000000,1),('cc08830af9a304e0163eccc099fad7e8','admin','Standard','Standard',NULL,20040522191939,00000000000000,1),('d21b7ac83de9a22d1443a6c25332ea16','admin','Transfer danych','Transfer danych',NULL,20040526101439,00000000000000,1),('d719024574fb71067e8ee4c9d4407ed6','admin','Twrca','Twrca',NULL,20040522150740,00000000000000,1),('d7d3bb6c7c48d2a377dc54b0152eac78','admin','Wersja','Wersja oprogramowania',NULL,20040522150506,00000000000000,1),('d8e39ea06d50831497a176b272663d76','admin','Tryb pracy','Tryb przesyania danych',NULL,20040522191856,00000000000000,1);
UNLOCK TABLES;
/*!40000 ALTER TABLE Parameter ENABLE KEYS */;

--
-- Table structure for table `PaymentType`
--

DROP TABLE IF EXISTS PaymentType;
CREATE TABLE PaymentType (
  PYT_Id varchar(32) NOT NULL default '',
  USR_Id varchar(32) default NULL,
  PYT_Name varchar(50) NOT NULL default '',
  PYT_Desc text,
  PYT_CreateDate timestamp(14) NOT NULL,
  PYT_LastModifyDate timestamp(14) NOT NULL,
  PYT_Price decimal(10,2) NOT NULL default '0.00',
  PYT_Active tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (PYT_Id),
  KEY usr_add_pyt_FK (USR_Id),
  CONSTRAINT `0_712` FOREIGN KEY (`USR_Id`) REFERENCES `Users` (`USR_Id`)
) TYPE=InnoDB;

--
-- Dumping data for table `PaymentType`
--


/*!40000 ALTER TABLE PaymentType DISABLE KEYS */;
LOCK TABLES PaymentType WRITE;
INSERT INTO PaymentType VALUES ('2e8586419d9c4933c8af0bdfab3379ea','admin','Gotwka','',20040525160341,20040525160341,"0.00",1),('4de18c9ab7bbac5e4f990dde93a86e9c','admin','Za pobraniem','',20040525160457,20040525160457,"5.00",1),('f047955e86af65f49ba6b6caed980928','admin','Przelew','',20040525160421,20040525160421,"3.00",1);
UNLOCK TABLES;
/*!40000 ALTER TABLE PaymentType ENABLE KEYS */;

--
-- Table structure for table `Producer`
--

DROP TABLE IF EXISTS Producer;
CREATE TABLE Producer (
  PRC_Id varchar(32) NOT NULL default '',
  USR_Id varchar(32) default NULL,
  PRC_Name varchar(50) NOT NULL default '',
  PRC_Desc text,
  PRC_CreateDate timestamp(14) NOT NULL,
  PRC_LastModifyDate timestamp(14) NOT NULL,
  PRC_Url varchar(255) default NULL,
  PRC_Email varchar(96) default NULL,
  PRC_Active tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (PRC_Id),
  KEY usr_add_prc_FK (USR_Id),
  CONSTRAINT `0_714` FOREIGN KEY (`USR_Id`) REFERENCES `Users` (`USR_Id`)
) TYPE=InnoDB;

--
-- Dumping data for table `Producer`
--


/*!40000 ALTER TABLE Producer DISABLE KEYS */;
LOCK TABLES Producer WRITE;
INSERT INTO Producer VALUES ('591e768c02327cf2ffbd5bb5142a3629','admin','Lite-on','',20040629220817,20040629200817,'www.liteon.com','',1),('846563c9e1ba3657c83061b8c51cf0e0','admin','Planet','Planet to profesjonalny dostawca sprztu sieciowego LAN/WAN z siedzib na Tajwanie. Firma specjalizuje si w opracowywaniu sprztu PC/LAN-WAN oraz produktw sucych do komunikacji. ',20040522145548,00000000000000,'http://www.planet.a.pl','planet@a.pl',1),('eacbb6b657f4ab0f4a6a047a40fa4802','admin','pentagram','',20040629200852,00000000000000,'www.pentagram.com','',1);
UNLOCK TABLES;
/*!40000 ALTER TABLE Producer ENABLE KEYS */;

--
-- Table structure for table `Product`
--

DROP TABLE IF EXISTS Product;
CREATE TABLE Product (
  PRD_Id varchar(32) NOT NULL default '',
  PRC_Id varchar(32) default NULL,
  TAX_Id varchar(32) default NULL,
  USR_Id varchar(32) default NULL,
  CUR_Id varchar(32) default NULL,
  ITM_Id varchar(32) default NULL,
  PRD_Price decimal(10,2) NOT NULL default '0.00',
  PRD_Quantity int(11) default NULL,
  PRD_CreateDate timestamp(14) NOT NULL,
  PRD_LastModifyDate timestamp(14) NOT NULL,
  PRD_AvailableDate timestamp(14) NOT NULL,
  PRD_ViewCount int(11) default NULL,
  PRD_Active tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (PRD_Id),
  KEY prc_has_prd_FK (PRC_Id),
  KEY prd_has_tax_FK (TAX_Id),
  KEY usr_add_prd_FK (USR_Id),
  KEY itm_has_prd_FK (ITM_Id),
  KEY prd_isin_cur_FK (CUR_Id),
  CONSTRAINT `0_724` FOREIGN KEY (`USR_Id`) REFERENCES `Users` (`USR_Id`),
  CONSTRAINT `0_716` FOREIGN KEY (`ITM_Id`) REFERENCES `Item` (`ITM_Id`),
  CONSTRAINT `0_718` FOREIGN KEY (`PRC_Id`) REFERENCES `Producer` (`PRC_Id`),
  CONSTRAINT `0_720` FOREIGN KEY (`TAX_Id`) REFERENCES `TaxRate` (`TAX_Id`),
  CONSTRAINT `0_722` FOREIGN KEY (`CUR_Id`) REFERENCES `Currency` (`CUR_Id`)
) TYPE=InnoDB;

--
-- Dumping data for table `Product`
--


/*!40000 ALTER TABLE Product DISABLE KEYS */;
LOCK TABLES Product WRITE;
INSERT INTO Product VALUES ('0dd073e76206f94d52590ed3a1b85268','846563c9e1ba3657c83061b8c51cf0e0','cb8bec5db851aa0bdb611a3251ebbaf3','admin',NULL,'e987b2d2cb4331ca79f8297978753172',"73.20",4,20040524221015,00000000000000,20040524000000,0,1),('1c60e25e8aa9616c125f02e6866d0f6b','846563c9e1ba3657c83061b8c51cf0e0',NULL,'admin',NULL,'2ddbc0322c35602c9f4c5e476bc0ff1a',"346.20",22,20040522192949,00000000000000,20040301195000,0,1),('265c8f3cc67111fcd39733e707871e37','846563c9e1ba3657c83061b8c51cf0e0',NULL,'admin',NULL,'d8d9fa123bd227cff7b48eb28ad84645',"46.59",37,20040522192537,00000000000000,20040501000000,0,1),('8af6d5f56f5639954df68ebe543a4e42','591e768c02327cf2ffbd5bb5142a3629','4a16ecec095ae0997259884b20e47e4b','admin',NULL,'6b7590d207e114adf0bb2e734ca79fbc',"75.00",16,20040526102205,00000000000000,20040525110000,0,1),('d8ed9e601ff3404807d136ccfc495490','591e768c02327cf2ffbd5bb5142a3629','cb8bec5db851aa0bdb611a3251ebbaf3','admin',NULL,'d8d9fa123bd227cff7b48eb28ad84645',"55.00",15,20040628202324,00000000000000,20280620040000,0,1),('e368951a34df027f7992e613683f4452','acbd9f46c790ce5c9d904cc111dd47e7',NULL,'admin',NULL,'d8175e84d5298e4ba313c86cb8c834dc',"1899.00",5,20040522193428,00000000000000,20040601090000,0,1);
UNLOCK TABLES;
/*!40000 ALTER TABLE Product ENABLE KEYS */;

--
-- Table structure for table `Special`
--

DROP TABLE IF EXISTS Special;
CREATE TABLE Special (
  SPC_Id varchar(32) NOT NULL default '',
  SPT_Id varchar(32) default NULL,
  PRD_Id varchar(32) default NULL,
  USR_Id varchar(32) default NULL,
  SPC_DateFrom timestamp(14) NOT NULL,
  SPC_DateTo timestamp(14) NOT NULL,
  SPC_Price decimal(10,2) NOT NULL default '0.00',
  SPC_CreateDate timestamp(14) NOT NULL,
  SPC_LastModifyDate timestamp(14) NOT NULL,
  SPC_Active tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (SPC_Id),
  KEY prd_is_spc_FK (PRD_Id),
  KEY usr_add_spc_FK (USR_Id),
  KEY spc_is_spt_FK (SPT_Id),
  CONSTRAINT `0_730` FOREIGN KEY (`USR_Id`) REFERENCES `Users` (`USR_Id`),
  CONSTRAINT `0_726` FOREIGN KEY (`PRD_Id`) REFERENCES `Product` (`PRD_Id`),
  CONSTRAINT `0_728` FOREIGN KEY (`SPT_Id`) REFERENCES `SpecialType` (`SPT_Id`)
) TYPE=InnoDB;

--
-- Dumping data for table `Special`
--


/*!40000 ALTER TABLE Special DISABLE KEYS */;
LOCK TABLES Special WRITE;
INSERT INTO Special VALUES ('19eab3268cdb2cb0fd7f85d1600a0f5b',NULL,'8af6d5f56f5639954df68ebe543a4e42','admin',20040629000000,20040710000000,"15.00",20040628223321,20040628223321,1),('55b5947002cc0c71d2cbc1b665824873',NULL,'0dd073e76206f94d52590ed3a1b85268','admin',20040530000000,20040701000000,"52.45",20040525001151,20040628223000,1);
UNLOCK TABLES;
/*!40000 ALTER TABLE Special ENABLE KEYS */;

--
-- Table structure for table `SpecialType`
--

DROP TABLE IF EXISTS SpecialType;
CREATE TABLE SpecialType (
  SPT_Id varchar(32) NOT NULL default '',
  USR_Id varchar(32) default NULL,
  SPT_Name varchar(50) NOT NULL default '',
  SPT_Desc text,
  SPT_CreateDate timestamp(14) NOT NULL,
  SPT_LastModifyDate timestamp(14) NOT NULL,
  SPT_Active tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (SPT_Id),
  KEY usr_add_spt_FK (USR_Id),
  CONSTRAINT `0_732` FOREIGN KEY (`USR_Id`) REFERENCES `Users` (`USR_Id`)
) TYPE=InnoDB;

--
-- Dumping data for table `SpecialType`
--


/*!40000 ALTER TABLE SpecialType DISABLE KEYS */;
LOCK TABLES SpecialType WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE SpecialType ENABLE KEYS */;

--
-- Table structure for table `State`
--

DROP TABLE IF EXISTS State;
CREATE TABLE State (
  ST_Id varchar(32) NOT NULL default '',
  USR_Id varchar(32) default NULL,
  ST_Name varchar(50) NOT NULL default '',
  ST_CreateDate timestamp(14) NOT NULL,
  ST_LastModifyDate timestamp(14) NOT NULL,
  ST_Active tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (ST_Id),
  KEY usr_add_st_FK (USR_Id),
  CONSTRAINT `0_734` FOREIGN KEY (`USR_Id`) REFERENCES `Users` (`USR_Id`)
) TYPE=InnoDB;

--
-- Dumping data for table `State`
--


/*!40000 ALTER TABLE State DISABLE KEYS */;
LOCK TABLES State WRITE;
INSERT INTO State VALUES ('124942f6818e878a19991dbafff07335','admin','zachodniopomorskie',20040629194801,00000000000000,1),('3ba9299257c1146f146f592528594fab','admin','pomorskie',20040629194813,00000000000000,1),('53b3a8c8b63a1e1763599194f7c9000c','admin','dolnolskie',20040629195036,00000000000000,1),('6a5597b4009d617364516223fef38666','admin','opolskie',20040629222740,20040629202740,0),('8597fa12b7d0b73ac858ff438adea2a0','admin','warmisko-mazurskie',20040629194832,00000000000000,1),('880a90de97bfce9ade7e94fb1c8eb216','admin','kujawsko-pomorskie',20040629194846,00000000000000,1),('8ed51d309053e9ac9d0cbb9648b36a41','admin','witokrzyskie',20040629195105,00000000000000,1),('9161dbc00fcc323eb005b9939621de06','admin','mazowieckie ee',20040629222752,20040629202752,0),('9ea12e799bba83271de97c0d226138bc','admin','dzkie',20040629194933,00000000000000,1),('a525d7a81b6c026a5b04f0a5a75e54ef','admin','maopolskie 2',20040629203929,00000000000000,1),('b65bf75729d40fccddeb8a2ea2fa2682','admin','lubelskie',20040629194945,00000000000000,1),('c5ee2573c46722f2864c46844b9837d4','admin','lubuskie ee',20040629223642,20040629203642,0),('dcf0da138d42015931764d452d711277','admin','lskie',20040522145152,00000000000000,1),('e2201c738d09a5cbfc2fd155d8e8fb5f','admin','podlaskie',20040629222724,20040629202724,0),('e48889eded8be83352f07882cf43e586','admin','maopolskie eee',20040629222300,20040629202300,0),('ed303a6a872f67122d7fb51fabd3c267','admin','wielkopolskie',20040629194922,00000000000000,1),('f588676baceb8957558eb8d48d4d00ee','admin','podkarpackie',20040629195118,00000000000000,1);
UNLOCK TABLES;
/*!40000 ALTER TABLE State ENABLE KEYS */;

--
-- Table structure for table `TaxRate`
--

DROP TABLE IF EXISTS TaxRate;
CREATE TABLE TaxRate (
  TAX_Id varchar(32) NOT NULL default '',
  USR_Id varchar(32) default NULL,
  TAX_Desc text,
  TAX_Value decimal(5,4) NOT NULL default '0.0000',
  TAX_Default tinyint(1) NOT NULL default '0',
  TAX_CreateDate timestamp(14) NOT NULL,
  TAX_LastModifyDate timestamp(14) NOT NULL,
  TAX_Active tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (TAX_Id),
  KEY usr_add_tax_FK (USR_Id),
  CONSTRAINT `0_736` FOREIGN KEY (`USR_Id`) REFERENCES `Users` (`USR_Id`)
) TYPE=InnoDB;

--
-- Dumping data for table `TaxRate`
--


/*!40000 ALTER TABLE TaxRate DISABLE KEYS */;
LOCK TABLES TaxRate WRITE;
INSERT INTO TaxRate VALUES ('39fd51a417a409f6e6c8ce20e0b5aded','admin','',"0.0000",0,20040629195722,00000000000000,1),('42c25a4f9de71f856a85f9b53f536770','admin','sdfsdfsdfs',"7.0000",0,20040525000014,20040524220014,1),('4a16ecec095ae0997259884b20e47e4b','admin','1212',"22.0000",1,20040629224707,20040629204707,1),('50f541581ec7ce7ee8158a4b6549b554','admin','',"12.0000",0,20040629224657,20040629204657,0),('cb8bec5db851aa0bdb611a3251ebbaf3','admin','',"17.0000",0,20040629224732,20040629204732,0);
UNLOCK TABLES;
/*!40000 ALTER TABLE TaxRate ENABLE KEYS */;

--
-- Table structure for table `UserInfo`
--

DROP TABLE IF EXISTS UserInfo;
CREATE TABLE UserInfo (
  UINFO_Email varchar(96) NOT NULL default '',
  UINFO_Name varchar(50) default NULL,
  UINFO_LastName varchar(50) default NULL,
  UINFO_NIP varchar(10) default NULL,
  UINFO_Regon varchar(14) default NULL,
  UINFO_PESEL varchar(11) default NULL,
  UINFO_CellPhone varchar(25) default NULL,
  UINFO_Active tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (UINFO_Email)
) TYPE=InnoDB;

--
-- Dumping data for table `UserInfo`
--


/*!40000 ALTER TABLE UserInfo DISABLE KEYS */;
LOCK TABLES UserInfo WRITE;
INSERT INTO UserInfo VALUES ('admin@thornet.net','Administrator sklepu',NULL,NULL,NULL,NULL,NULL,1),('public@public','Uytkownik publiczny',NULL,NULL,NULL,NULL,NULL,1);
UNLOCK TABLES;
/*!40000 ALTER TABLE UserInfo ENABLE KEYS */;

--
-- Table structure for table `Users`
--

DROP TABLE IF EXISTS Users;
CREATE TABLE Users (
  USR_Id varchar(32) NOT NULL default '',
  UINFO_Email varchar(96) NOT NULL default '',
  USR_Type char(1) default NULL,
  USR_Password varchar(32) NOT NULL default '',
  USR_CreateDate timestamp(14) NOT NULL,
  USR_LastModifyDate timestamp(14) NOT NULL,
  USR_LastLoginDate timestamp(14) NOT NULL,
  USR_LoginFailedDate timestamp(14) NOT NULL,
  USR_WrongPasswordCount int(2) NOT NULL default '0',
  USR_MustChangePassword tinyint(1) NOT NULL default '0',
  USR_ActivateByUser char(1) NOT NULL default '',
  USR_Active tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (USR_Id),
  KEY usr_has_uinfo_FK (UINFO_Email),
  CONSTRAINT `0_738` FOREIGN KEY (`UINFO_Email`) REFERENCES `UserInfo` (`UINFO_Email`)
) TYPE=InnoDB COMMENT='Table of application users';

--
-- Dumping data for table `Users`
--


/*!40000 ALTER TABLE Users DISABLE KEYS */;
LOCK TABLES Users WRITE;
INSERT INTO Users VALUES ('admin','admin@thornet.net','A','4c9184f37cff01bcdc32dc486ec36961',20040627000848,20040514171933,20040630231918,20040630155504,0,0,'0',1),('public','public@public','P','4c9184f37cff01bcdc32dc486ec36961',20040514172214,20040514171933,20040630234630,20040514172158,0,0,'0',1);
UNLOCK TABLES;
/*!40000 ALTER TABLE Users ENABLE KEYS */;

--
-- Table structure for table `active_session`
--

DROP TABLE IF EXISTS active_session;
CREATE TABLE active_session (
  SESS_Id varchar(32) NOT NULL default '',
  SESS_Value text,
  SESS_LastUpdate timestamp(14) NOT NULL,
  PRIMARY KEY  (SESS_Id)
) TYPE=InnoDB;

--
-- Dumping data for table `active_session`
--


/*!40000 ALTER TABLE active_session DISABLE KEYS */;
LOCK TABLES active_session WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE active_session ENABLE KEYS */;

--
-- Table structure for table `cat_has_img`
--

DROP TABLE IF EXISTS cat_has_img;
CREATE TABLE cat_has_img (
  CAT_Id varchar(32) NOT NULL default '',
  IMG_Id varchar(32) NOT NULL default '',
  PRIMARY KEY  (CAT_Id,IMG_Id),
  KEY cat_has_img_FK (CAT_Id),
  KEY cat_has_img2_FK (IMG_Id),
  CONSTRAINT `0_742` FOREIGN KEY (`IMG_Id`) REFERENCES `Image` (`IMG_Id`),
  CONSTRAINT `0_740` FOREIGN KEY (`CAT_Id`) REFERENCES `Category` (`CAT_Id`)
) TYPE=InnoDB;

--
-- Dumping data for table `cat_has_img`
--


/*!40000 ALTER TABLE cat_has_img DISABLE KEYS */;
LOCK TABLES cat_has_img WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE cat_has_img ENABLE KEYS */;

--
-- Table structure for table `itm_has_par`
--

DROP TABLE IF EXISTS itm_has_par;
CREATE TABLE itm_has_par (
  PAR_Id varchar(32) NOT NULL default '',
  ITM_Id varchar(32) NOT NULL default '',
  PAR_Value text NOT NULL,
  PRIMARY KEY  (PAR_Id,ITM_Id),
  KEY itm_has_par_FK (PAR_Id),
  KEY itm_has_par2_FK (ITM_Id),
  CONSTRAINT `0_746` FOREIGN KEY (`ITM_Id`) REFERENCES `Item` (`ITM_Id`),
  CONSTRAINT `0_744` FOREIGN KEY (`PAR_Id`) REFERENCES `Parameter` (`PAR_Id`)
) TYPE=InnoDB;

--
-- Dumping data for table `itm_has_par`
--


/*!40000 ALTER TABLE itm_has_par DISABLE KEYS */;
LOCK TABLES itm_has_par WRITE;
INSERT INTO itm_has_par VALUES ('0802efe8d933478a8690fbd07677da7b','09295dda63a513599565fa9aef0d9881','24 lata'),('0802efe8d933478a8690fbd07677da7b','6b7590d207e114adf0bb2e734ca79fbc','24 miesice'),('269e35b4f66306210a6b6cf0e1296396','6b7590d207e114adf0bb2e734ca79fbc','UDF, wszystkie DVD single/dual layer (PTP, OTP)'),('3d7005c2c90ba103b8ac600833cb29f7','09295dda63a513599565fa9aef0d9881','jest'),('3d7005c2c90ba103b8ac600833cb29f7','d8d9fa123bd227cff7b48eb28ad84645','PCI 2.2, ACPI 1.0, i PCI Bus Power Management 1.1'),('5b5130618f447a47c5651efc39f42d4d','2ddbc0322c35602c9f4c5e476bc0ff1a','Win 95/98/ME/NT/2000/XP, Unix, Linux'),('5b5130618f447a47c5651efc39f42d4d','d8175e84d5298e4ba313c86cb8c834dc','PHP + MySQL + serwer WWW'),('ab931e88c6ed375cb2a56a4c322166a7','6b7590d207e114adf0bb2e734ca79fbc','OEM'),('be07fb67391792374fbb198a85f05c1d','d8175e84d5298e4ba313c86cb8c834dc','Sebastian Marek, Daniel Bargie'),('be9951dfc92a324b0c0530e27a83ca93','6b7590d207e114adf0bb2e734ca79fbc','ATAPI-E/IDE'),('cc08830af9a304e0163eccc099fad7e8','09295dda63a513599565fa9aef0d9881','asdads'),('cc08830af9a304e0163eccc099fad7e8','d8d9fa123bd227cff7b48eb28ad84645','IEEE 802.3u oraz IEEE 802.3 '),('d21b7ac83de9a22d1443a6c25332ea16','6b7590d207e114adf0bb2e734ca79fbc','Ultra-DMA/33 33.3 MB/s'),('d7d3bb6c7c48d2a377dc54b0152eac78','d8175e84d5298e4ba313c86cb8c834dc','0.5b'),('d8e39ea06d50831497a176b272663d76','d8d9fa123bd227cff7b48eb28ad84645','Full-Duplex ');
UNLOCK TABLES;
/*!40000 ALTER TABLE itm_has_par ENABLE KEYS */;

--
-- Table structure for table `par_has_img`
--

DROP TABLE IF EXISTS par_has_img;
CREATE TABLE par_has_img (
  PAR_Id varchar(32) NOT NULL default '',
  IMG_Id varchar(32) NOT NULL default '',
  PRIMARY KEY  (PAR_Id,IMG_Id),
  KEY par_has_img_FK (PAR_Id),
  KEY par_has_img2_FK (IMG_Id),
  CONSTRAINT `0_750` FOREIGN KEY (`IMG_Id`) REFERENCES `Image` (`IMG_Id`),
  CONSTRAINT `0_748` FOREIGN KEY (`PAR_Id`) REFERENCES `Parameter` (`PAR_Id`)
) TYPE=InnoDB;

--
-- Dumping data for table `par_has_img`
--


/*!40000 ALTER TABLE par_has_img DISABLE KEYS */;
LOCK TABLES par_has_img WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE par_has_img ENABLE KEYS */;

--
-- Table structure for table `prc_has_addr`
--

DROP TABLE IF EXISTS prc_has_addr;
CREATE TABLE prc_has_addr (
  PRC_Id varchar(32) NOT NULL default '',
  ADDR_Id varchar(32) NOT NULL default '',
  PRIMARY KEY  (PRC_Id,ADDR_Id),
  KEY prc_has_addr_FK (PRC_Id),
  KEY prc_has_addr2_FK (ADDR_Id),
  CONSTRAINT `0_754` FOREIGN KEY (`ADDR_Id`) REFERENCES `Address` (`ADDR_Id`),
  CONSTRAINT `0_752` FOREIGN KEY (`PRC_Id`) REFERENCES `Producer` (`PRC_Id`)
) TYPE=InnoDB;

--
-- Dumping data for table `prc_has_addr`
--


/*!40000 ALTER TABLE prc_has_addr DISABLE KEYS */;
LOCK TABLES prc_has_addr WRITE;
INSERT INTO prc_has_addr VALUES ('acbd9f46c790ce5c9d904cc111dd47e7','c53f4b0bc494aa28d74b9ce715a26fb7');
UNLOCK TABLES;
/*!40000 ALTER TABLE prc_has_addr ENABLE KEYS */;

--
-- Table structure for table `prd_has_img`
--

DROP TABLE IF EXISTS prd_has_img;
CREATE TABLE prd_has_img (
  PRD_Id varchar(32) NOT NULL default '',
  IMG_Id varchar(32) NOT NULL default '',
  PRIMARY KEY  (PRD_Id,IMG_Id),
  KEY prd_has_img_FK (PRD_Id),
  KEY prd_has_img2_FK (IMG_Id),
  CONSTRAINT `0_758` FOREIGN KEY (`IMG_Id`) REFERENCES `Image` (`IMG_Id`),
  CONSTRAINT `0_756` FOREIGN KEY (`PRD_Id`) REFERENCES `Product` (`PRD_Id`)
) TYPE=InnoDB;

--
-- Dumping data for table `prd_has_img`
--


/*!40000 ALTER TABLE prd_has_img DISABLE KEYS */;
LOCK TABLES prd_has_img WRITE;
INSERT INTO prd_has_img VALUES ('0dd073e76206f94d52590ed3a1b85268','369fdcd404f23a8484fc2ecdbcd542e7'),('1c60e25e8aa9616c125f02e6866d0f6b','f6f19460bc6ac4de94ca4e964c51c90e'),('265c8f3cc67111fcd39733e707871e37','278d2563469ab1dc7444e96bdd63259a'),('8af6d5f56f5639954df68ebe543a4e42','cf70da59dc58239bb2a61e76c88bb6b8'),('8af6d5f56f5639954df68ebe543a4e42','e276b24f2f16cade8683f39d4d03816f'),('8af6d5f56f5639954df68ebe543a4e42','f1ab27b0d6ee3465bbc40640997a5a02'),('d8ed9e601ff3404807d136ccfc495490','23c42e76d82ca33dde6c84ec6d893c2b'),('e368951a34df027f7992e613683f4452','23c42e76d82ca33dde6c84ec6d893c2b');
UNLOCK TABLES;
/*!40000 ALTER TABLE prd_has_img ENABLE KEYS */;

--
-- Table structure for table `prd_isin_cat`
--

DROP TABLE IF EXISTS prd_isin_cat;
CREATE TABLE prd_isin_cat (
  CAT_Id varchar(32) NOT NULL default '',
  PRD_Id varchar(32) NOT NULL default '',
  PRIMARY KEY  (CAT_Id,PRD_Id),
  KEY prd_isin_cat_FK (CAT_Id),
  KEY prd_isin_cat2_FK (PRD_Id),
  CONSTRAINT `0_762` FOREIGN KEY (`PRD_Id`) REFERENCES `Product` (`PRD_Id`),
  CONSTRAINT `0_760` FOREIGN KEY (`CAT_Id`) REFERENCES `Category` (`CAT_Id`)
) TYPE=InnoDB;

--
-- Dumping data for table `prd_isin_cat`
--


/*!40000 ALTER TABLE prd_isin_cat DISABLE KEYS */;
LOCK TABLES prd_isin_cat WRITE;
INSERT INTO prd_isin_cat VALUES ('25737420ed4d41bf0f466ad2bd03c6ac','e368951a34df027f7992e613683f4452'),('720fd64717053f38783e20dd80db6369','0dd073e76206f94d52590ed3a1b85268'),('720fd64717053f38783e20dd80db6369','1c60e25e8aa9616c125f02e6866d0f6b'),('720fd64717053f38783e20dd80db6369','265c8f3cc67111fcd39733e707871e37'),('e770d25e00d3f0d6cc1346dad6007336','8af6d5f56f5639954df68ebe543a4e42');
UNLOCK TABLES;
/*!40000 ALTER TABLE prd_isin_cat ENABLE KEYS */;

--
-- Table structure for table `usr_has_addr`
--

DROP TABLE IF EXISTS usr_has_addr;
CREATE TABLE usr_has_addr (
  UINFO_Email varchar(96) NOT NULL default '',
  ADDR_Id varchar(32) NOT NULL default '',
  PRIMARY KEY  (UINFO_Email,ADDR_Id),
  KEY usr_has_addr_FK (UINFO_Email),
  KEY usr_has_addr2_FK (ADDR_Id),
  CONSTRAINT `0_766` FOREIGN KEY (`ADDR_Id`) REFERENCES `Address` (`ADDR_Id`),
  CONSTRAINT `0_764` FOREIGN KEY (`UINFO_Email`) REFERENCES `UserInfo` (`UINFO_Email`)
) TYPE=InnoDB;

--
-- Dumping data for table `usr_has_addr`
--


/*!40000 ALTER TABLE usr_has_addr DISABLE KEYS */;
LOCK TABLES usr_has_addr WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE usr_has_addr ENABLE KEYS */;

SET FOREIGN_KEY_CHECKS=1;