<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+

//Zaadowanie niezbdnych moduw
global $appCore;
if (PEAR::isError($err = $appCore->loadModule('Product'))){echo($appCore->getLastErrorMessage()); exit;}
		
/**
 * Klasa Special opisujca obiekt promocji
 * Dziedziczy po klasie Object
 */
class Special extends Object {
	/**#@+
   	 * @access protected
   	 */
	/**
	 * @var string Identyfikator produktu, ktry 
	 */
	var $_ProdId;
	/**
	 * @var string Data rozpoczcia promocji
	 */
	var $_DateFrom;
	/**
	 * @var string Data zakoczenia promocji
	 */
	var $_DateTo;
	/**
	 * @var float Cena produktu w promocji
	 */
	var $_Price;
	/**
	 * @var string Data ostatniej modyfikacji obiektu
	 */
	var $_LastModifyDate;
    /**#@-*/
	
	/**#@+
   	 * @access public
   	 */
	/**
   	 * Konstruktor klasy
	 *
   	 * @param array $specdata Tablica z danymi obiektu promocji
   	 */
	function Special($specdata = array()) {
	
		// Okrelenie domylnej metody obsugi bdw
		$this->setErrorHandling(PEAR_ERROR_CALLBACK, array(&$this, 'errorHandlerSpecial'));
		
		//Tworzenie obiektu
		foreach ($specdata as $key => $value) { 
			switch (strtolower($key)) {
				case 'spc_id':
					$this->setId($value);
				break;
				case 'prd_id':
					$this->setProductId($value);
				break;
				case 'spc_datefrom':
					$this->setDateFrom($value);
				break;
				case 'spc_dateto':
					$this->setDateTo($value);
				break;
				case 'spc_price':
					$this->setSpecPrice($value);
				break;
				case 'spc_createdate':
					$this->setCreateDate($value);
				break;
				case 'spc_lastmodifydate':
					$this->setLastModifyDate($value);
				break;
				case 'spc_active':
					$this->setActive($value);
				break;
			}
		}

	}
	/**
	 * Metoda ustawia identyfikator produktu, ktrego ma dotyczy promocja
	 *
	 * @param string $_prodId Identyfikator produktu
	 * @return bool
	 */
	function setProductId($_prodId) {
		//Sprawdzenie czy produkt o podanym identyfikatorze istnieje
		if(!Product::doesProductExist($_prodId)) {return FALSE;}
		
		//Przypisanie produktu
		$this->_ProdId = $_prodId;
		
		//Operacja wykonana pomylnie
		return TRUE;
	}
	/**
	 * Metoda ustawia dat, od ktrej powinna obowizywa promocja
	 *
	 * @param string $dateFrom rozpoczcia obowizywania promocji
	 * @return bool
	 */
	function setDateFrom($dateFrom) {
		//echo($dateFrom.);
		//Sprawdzenie czy warto jest poprawn dat
		//if(!Object::parseVar($dateFrom, 'date')) {return FALSE;}
		
		//Przypisanie daty
		$this->_DateFrom = $dateFrom;
		
		//Operacja wykonana pomylnie
		return TRUE;
	}
	/**
	 * Metoda ustawia dat, do ktrej powinna obowizywa promocja
	 *
	 * @param string $dateTo zakoczenia obowizywania promocji
	 * @return bool
	 */
	function setDateTo($dateTo) {
		//Sprawdzenie czy warto jest poprawn dat
		//if(!Object::parseVar($dateTo, 'date')) {return FALSE;}
		
		//Przypisanie daty
		$this->_DateTo = $dateTo;
		
		//Operacja wykonana pomylnie
		return TRUE;
	}
	/**
	 * Metoda ustawia cen produktu w promocji
	 *
	 * @param float $price Cena produktu w promocji
	 * @return bool
	 */
	function setSpecPrice($price) {
		//Sprawdzenie czy warto jest poprawn cen
		if(!Object::parseVar($price, 'price')) {return FALSE;}
		
		//Ustawiania ceny
		$this->_Price = $price;
		
		//Operacja wykonana pomylnie
		return TRUE;
	}
	/**
	 * Metoda ustawia dat, ostatniej modyfikacji obiektu promocji
	 *
	 * @param string $lastmoddate data ostatniej modyfikacji obiektu promocji
	 * @return bool
	 */
	function setLastModifyDate($lastmoddate) {
		//Sprawdzenie czy warto jest poprawn dat
		if(!Object::parseVar($lastmoddate, 'date')) {return FALSE;}

		//Przypisanie daty
		$this->_LastModifyDate = $lastmoddate;
		
		//Operacja wykonana pomylnie
		return TRUE;
	}
	/**
	 * Metoda zwraca warto daty, od ktrej obowizyje promocja
	 *
	 * @return string
	 */
	function getDateFrom() {return $this->_DateFrom;}
	/**
	 * Metoda zwraca warto daty, do ktrej obowizyje promocja
	 *
	 * @return string
	 */
	function getDateTo() {return $this->_DateTo;}
	/**
	 * Metoda zwraca warto ceny produktu w promocji
	 *
	 * @return float
	 */
	function getSpecialPrice() {return $this->_Price;}
	/**
	 * Metoda zwraca warto daty, ostatniej modyfikacji obiektu promocji
	 *
	 * @return string
	 */
	function getLastModifyDate($lastmoddate) {return $this->_LastModifyDate;}
	/**
	 * Metoda zwraca tablic zawierajc wszystkie obiekty promocji
	 *
	 * Metoda moe by wywoywana statycznie
	 *
	 * @param bool Okrela czy maj by zwracane obiekty aktywne czy te wszystkie
	 * @return mixed Tablica obiektw promocji lub obiektu PEAR_Error
	 */
	function getSpecialsList($active='active') {
		//Rdze aplikacji
		global $appCore;
		//Tablica obiektw do zwrcenia
		$specialList = NULL;
		//Budowa zapytania SQL
		$sqlquery = 'SELECT SPC_Id, SPT_Id, USR_Id, PRD_Id, UNIX_TIMESTAMP(SPC_DateFrom) as SPC_DateFrom, UNIX_TIMESTAMP(SPC_DateTo) as SPC_DateTo, SPC_Price, UNIX_TIMESTAMP(SPC_CreateDate) as SPC_CreateDate, UNIX_TIMESTAMP(SPC_LastModifyDate) as SPC_LastModifyDate, SPC_Active FROM Special ';
		switch($active) {
			case 'present': 
				$sqlquery .= ' WHERE SPC_Active = 1 AND SPC_DateFrom <= CURRENT_TIMESTAMP(0) AND SPC_DateTo > CURRENT_TIMESTAMP(0)';
			break;
			case 'ended':
				$sqlquery .= ' WHERE SPC_Active = 1 AND SPC_DateTo < NOW()';
			break;
			case 'notstarted':
				$sqlquery .= ' WHERE SPC_Active = 1 AND SPC_DateFrom > NOW()';
			break;
			case 'unactive':
				$sqlquery .= ' WHERE SPC_Active = 0';
			break;
			case 'all';
			break;
			default:
				$sqlquery .= ' WHERE SPC_Active = 1';
			break;
		}
		//Wykonanie zapytania SQL
		if (DB::isError($result = $appCore->Query($sqlquery))) {
			$err = PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
			if (!isset($this)) {$appCore->handleError($err);}
			return $err;
		}
		
		while ($specdata = $result->fetchRow(DB_FETCHMODE_ASSOC)) {
			$specialList[] = new Special($specdata);
		}
		
		return $specialList;
	}
	/**
	 * Metoda zwraca obiekt produktu, na ktrego dotyczy promocja
	 */
	function getProduct() {
		//Rdzen aplikacji
		global $appCore; 
		
		//Metoda nie moe by wywoywana statycznie
		if(!isset($this)) {
			$err = PEAR::raiseError('getProduct;Special', -5003, null, null, PEAR_LOG_ERR);
			$appCore->handleError($err);
			return $err;
		}
		
		//Zwracanie listy produktw
		if(Product::doesProductExist($this->_ProdId)) {return Product::getData(NULL, $this->_ProdId);}
		
		//Zwracanie obiektu pustego
		return NULL;
	}
	/**
	 * Metoda sprawdza, czy pomidzy promocjami dotyczcymi jednego 
	 * produktu wystpuje konflikt dat
	 *
	 * Metoda jes metod prywatn powinna by wywoywana jedynie
	 * przez metod saveData
	 *
	 * @access private
	 * @return mixed Wartoci TRUE, FALSE lub PEAR_Error
	 */
	function _isConflict() {
		//Rdze aplikacji
		global $appCore;
		
		//Metoda nie moe by wywoywana statycznie
		if(!isset($this)) {$err = PEAR::raiseError('saveData;Special', -5003, null, null, PEAR_LOG_ERR); $appCore->handleError($err); return $err;}
				
		//Przyotowanie zapytania SQL
		$sqlquery = 'SELECT SPC_Id FROM Special WHERE PRD_Id="'.$this->_ProdId.'"';
		if (DB::isError($result = $appCore->Query($sqlquery))) {return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);}
		
		
		//Istnieje konflikt dat
		if($result->numROws()>0) {return TRUE;}
		
		//Konflikt dat nie wystpuje
		return FALSE;
	}
	/**
	 * Tworzy i zwraca obiekt Special
	 *
	 * Metoda moe by wywoywana statycznie
	 *
	 * @param string $specid Identyfikator
	 * @param bool $active Parametr informuje czy zwrci obiekt o dowolnym statusie czy tylko obiekt aktywny
	 * @return mixed Obiekt Special lub PEAR_Error
	 */
	function getData($specid, $active = TRUE) {
		//Rdze aplikacji
		global $appCore;
		
		if ($active) {$activestat = ' AND SPC_Active=1';} else {$activestat = '';}
		//Budowa zapytania SQL
		$sqlquery  = 'SELECT SPC_Id, SPT_Id, USR_Id, PRD_Id, UNIX_TIMESTAMP(SPC_DateFrom) as SPC_DateFrom, '; 
		$sqlquery .= 'UNIX_TIMESTAMP(SPC_DateTo) as SPC_DateTo, SPC_Price, UNIX_TIMESTAMP(SPC_CreateDate) as SPC_CreateDate, UNIX_TIMESTAMP(SPC_LastModifyDate) as SPC_LastModifyDate, SPC_Active';
		$sqlquery .= ' FROM Special WHERE SPC_id="'.$specid.'"'.$activestat;
		
		//Wykonanie zapytania SQL
		if (DB::isError($result = $appCore->Query($sqlquery))) {
			$err = PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
			if (!isset($this)) {$appCore->handleError($err);} 
			return $err;
		}
		if($specdata = $result->fetchRow(DB_FETCHMODE_ASSOC)) {return new Special($specdata);}
	}
	/**
	 * Zwraca losowo produkt, ktry posiada aktywn i obowizujc promocj
	 *
	 * Metoda powinna by wywoywana jedynie statycznie
	 */
	function getRandomProductIdInSpecial() {
		//Rdze aplikacji
		global $appCore;

		//Metoda moe by wywoywana jedynie statycznie
		if(isset($this)) {$err = PEAR::raiseError('getRandomProductInSpecial;Special', -5004, null, null, PEAR_LOG_ERR); $appCore->handleError($err); return $err;}
		
		//Przygotowanie zapytanie SQL
		$sqlquery = 'SELECT PRD_Id FROM Special WHERE SPC_Active=1 AND SPC_DateFrom<=NOW() AND NOW()<=SPC_DateTo';
		//Wykonanie zapytania SQL
		if (DB::isError($result = $appCore->Query($sqlquery))) {
			$err = PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
			$appCore->handleError($err); return $err;
		}
		
		//Liczba wierszy
		$numRows = $result->numRows();
		
		if($numRows > 1) {
			//Liczna produktw w promocji jest wiksza ni 1
			$randNum = rand(1, $numRows);
			$iter=1;
			while ($row = $result->fetchRow()) {
				if ($randNum == $iter) {return $row[0];}
				$iter++;
			}
		} else if ($numRows == 1){
			//Istnieje tylko jeden obiekt w promocji
			$row = $result->fetchRow();  return $row[0];
		} else {
			//Brak obiektw w promocji
			return NULL;
		}
	}
	/**
	 * Tworzy obiekt Special na podstawie identyfikatora producenta
	 *
	 * Metoda moe by wywoywana statycznie
	 *
	 * @param string $prodid Identyfikator producenta
	 * @param bool $avail Ustawienie na TRUE powoduje zwrcenie aktywnego obiektu obowizyjcej promocji.
	 * 					  Ustawienie na FALSE powoduje zwrcenie dowolnego obiektu.
	 * @return mixed Obiekt Special lub PEAR_Error
	 */	
	function getSpecialByProductId($prodid, $avail=TRUE) {
		//Rdze aplikacji
		global $appCore;
				
		//Przygotowywanie zapytania SQL
		$sqlquery = 'SELECT SPC_Id, SPT_Id, PRD_Id, SPC_Price FROM Special WHERE PRD_Id="'.$prodid.'"';
		if ($avail) {$sqlquery .= ' AND SPC_Active=1 AND SPC_DateFrom<=NOW() AND NOW()<=SPC_DateTo';}
	
		//Wykonanie zapytania SQL
		if (DB::isError($result = $appCore->Query($sqlquery))) {
			$err = PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
			if (!isset($this)) {$appCore->handleError($err);} return $err;
		}
		if($specdata = $result->fetchRow(DB_FETCHMODE_ASSOC)) {return new Special($specdata);}
	}
	/**
	 * Usuwa dane obiektu promocji
	 *
	 * @param string $specid Identyfikator promocji
	 */
	function deleteData($specid = NULL) {
		//Rdze aplikacji
		global $appCore;
		if (!$specid) {$specid = $this->_Id;}
		
		//Spraedzenie czy promocja, ktra ma zosta usunita istnieje
		if(!Special::doesSpecialExist($specid)) {
			$err = PEAR::raiseError($specid, -1603, null, null, PEAR_LOG_NOTICE);
			if (!isset($this)) {Special::errorHandlerSpecial($err);}
			return $err;
		}
		
		//Zerowanie zmiennej transakcyjnej
		$appCore->setTransactionStatus(FALSE);
		
		//Rozpoczcie transakcji
		if (PEAR::isError($err = Transaction('BEGIN'))) {return $err;}
		//Transakcja zostaa rozpoczta
		$appCore->setTransactionStatus(TRUE);
				
		//Usuwanie danych z bazy danych------------------------------
			$sqlquery = 'DELETE FROM Special WHERE SPC_Id="'.$specid.'"';
			if (DB::isError($result = $appCore->Query($sqlquery))) {
				$err = PEAR::raiseError($specid, -1603, null, null, PEAR_LOG_NOTICE);
				if (!isset($this)) {$appCore->errorHandlerSpecial($err);}
				return $err;
			}
		//Usuwanie danych z bazy danych------------------------------
		
		if (PEAR::isError($err = Transaction('COMMIT'))) {return $err;}
		//Transakcja zostaa zakoczona pomylnie
		$appCore->setTransactionStatus(FALSE);
	}
	/**
	 * Metoda zapisuje dane obiektu promocji do bazy danycj
	 *
	 * @return PEAR_Error Obiekt bdu jest zwracany w razie niepowodzenia operacji zapisu
	 */
	function saveData($userId) {
		//Rdze aplikacji
		global $appCore;
		
		//Metoda nie moe by wywoywana statycznie
		if(!isset($this)) {$err = PEAR::raiseError('saveData;Special', -5003, null, null, PEAR_LOG_ERR); $appCore->handleError($err); return $err;}
		
		//Walidacja danych----------------------
			//Sprawdzenie czy produkt istnieje
			if (!Product::doesProductExist($this->_ProdId)) { return PEAR::raiseError($this->_ProdId, -1500, null, null, PEAR_LOG_NOTICE);}
			//Walidacja daty rozpoczcia obowizywania promocji
			if (!Object::parseVar($this->_DateFrom, 'date')) {return PEAR::raiseError($this->_DateFrom, -11, null, null, PEAR_LOG_NOTICE);}
			//Walidacja daty zakoczenia obowizywania promocji
			if (!Object::parseVar($this->_DateTo, 'date')) {return PEAR::raiseError($this->_DateTo, -11, null, null, PEAR_LOG_NOTICE);}
			//Badanie poprawnoci obowizywania dat rozpoczcia i zakoczenia promocji
			if (strtotime($this->_DateFrom)>=strtotime($this->_DateTo)) {return PEAR::raiseError($this->_DateFrom.';'.$this->_DateTo, -1600, null, null, PEAR_LOG_NOTICE);}
			//Sprawdzenie czy cena promocji jest poprawna
			if (!Object::parseVar($this->_Price, 'price')) {return PEAR::raiseError($this->_Price, -12, null, null, PEAR_LOG_NOTICE);}
			//Sprawdzenie czy cena w promocji jest mniejsza, ni rzeczywista cena produktu
			$obj = $this->getProduct(); //Obiekt, ktrego dotyczy promocja
			if ($obj[0]->getPrice() <= $this->_Price) {return PEAR::raiseError($this->_Price.';'.$obj[0]->getPrice(), -1601, null, null, PEAR_LOG_NOTICE);}			
		//Walidacja danych----------------------
		
		//Walidacja danych przebiega pomylnie
		//Rozpoczyna si zapis danych
		
		//Zerowanie zmiennej transakcyjnej
		$appCore->setTransactionStatus(FALSE);
		
		//Rozpoczcie transakcji
		if (PEAR::isError($err = Transaction('BEGIN'))) {return $err;}
		//Transakcja zostaa rozpoczta
		$appCore->setTransactionStatus(TRUE);
		
		//Wprowadzanie danych do bazy------------------------------
		
			//Sprawdzenie czy istnieje odpowiedni identyfikator obiektu prmocji
			$sqlquery = 'SELECT SPC_Id from Special where SPC_Id="'.$this->_Id.'"';
			//Wykonanie zapytania SQL
			if (DB::isError($result = $appCore->Query($sqlquery))) {return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);}
			if ($result->numRows()==0) {
				//Sprawdzenie czy nie wystpuje konflikt midzy promocjami dotyczcymi tego samego produktu
				if ($this->_isConflict()) {return PEAR::raiseError($obj[0]->_Item->getName(), -1602, null, null, PEAR_LOG_NOTICE);}			
				//Nie istnieje podany identyfikator. Obiekt Promocji jest tworzony
				$this->generateId();

				//Tworzenie obiektu promocji
				$sqlquery  = 'INSERT INTO Special (SPC_Id, SPT_Id, USR_Id, PRD_Id, SPC_DateFrom, SPC_DateTo, SPC_Price, SPC_CreateDate, SPC_LastModifyDate, SPC_Active) VALUES ';
				$sqlquery .= '("'.$this->_Id.'", NULL, "'.$userId.'", "'.$this->_ProdId.'", "'.$this->_DateFrom.'", "'.$this->_DateTo.'", "'.$this->_Price.'", CURRENT_TIMESTAMP(0), NULL, ';
				if ($this->_Active) {$sqlquery .= '1)';} else {$sqlquery .= '0)';}

				//Wykonanie zapytania SQL
				if (DB::isError($result = $appCore->Query($sqlquery))) {return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);}
				
			} else { //Promocja jest modyfikowana
				
				$sqlquery = 'UPDATE Special set SPC_Price="'.$this->_Price.'", SPC_DateFrom="'.$this->_DateFrom.'", SPC_DateTo="'.$this->_DateTo.'", SPC_LastModifyDate=CURRENT_TIMESTAMP(0), SPC_CreateDate=SPC_CreateDate, ';
				if ($this->_Active) {$sqlquery .= 'SPC_Active=1';} else {$sqlquery .= 'SPC_Active=0';}
				$sqlquery .= ' WHERE SPC_Id="'.$this->_Id.'"';
				
				//Wykonanie zapytania SQL
				if (DB::isError($result = $appCore->Query($sqlquery))) {return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);}
			}
		
		//Wprowadzanie danych do bazy------------------------------
		
		//Zakoczenie transakcji
		if (PEAR::isError($err = Transaction('COMMIT'))) {return $err;}
		//Transakcja zostaa zakoczona pomylnie
		$appCore->setTransactionStatus(FALSE);
	}
	/**
	 * Metoda sprawdza czy promocja o wskazanym identyfikatorze istnieje
	 *
	 * @param string $_specid Identyfikator obiektu promocji
	 * @return bool
	 */
	function doesSpecialExist($_specid = NULL) {
		//Rdzea plikacji
		global $appCore;
		
		//Przygotowywanie zapytania SQL
		if(!$_specid) {$_specid = $this->_Id;}
		$sqlquery = 'SELECT SPC_Id FROM Special WHERE SPC_Id="'.$_specid.'"';
		if (DB::isError($result = $appCore->Query($sqlquery))) {
			$err = PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
			if (!isset($this)) {$appCore->errorHandlerSpecial($err);}
			return $err;
		}
		
		//Obiekt promocji istnieje
		if ($result->numRows()==1) {return TRUE;}
		
		//Obiekt promocji nie istnieje
		return FALSE;
	}
	/**
	 * Metoda zawaca status promocji 
	 * (0 - Przedawniona)
	 * (1 - Aktywny okres obowizywania)
	 * (2 - Jeszcze nie obowizuje)
	 *
	 * Metoda nie moe by wywoywana statycznie 
	 */
	function getSpecialStatus() {
		//Rdze aplikacji
		global $appCore;
		
		//Metoda nie moe by wywoywana statycznie
		if(!isset($this)) {$err = PEAR::raiseError('getRandomProductInSpecial;Special', -5003, null, null, PEAR_LOG_ERR); $appCore->handleError($err); return $err;}
		
		//Status
		$now = getdate();		
		if (intval($this->_DateFrom)>intval($now['0'])) {
			return 2;
		} else if (intval($this->_DateTo)<intval($now['0'])) {
			return 0;
		} else {
			return 1;
		}
	}
	/**
   	 * Domylna metoda obsugi bdw dla obiektw tej klasy
	 * @param PEAR_Error $error Kod bdu
   	 * @access public
   	 */
	function errorHandlerSpecial($error) {
		//Rdze aplikacji
	    global $appCore;
		
		//Odwoanie transakcji
		if ($appCore->getTransactionStatus()) {
			Transaction('ROLLBACK');
			$appCore->setTransactionStatus(FALSE);
		}
		//Obsuga bdu z poziomu rdzenia aplikacji
		$appCore->handleError($error);
	}	
}
?>