<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+

require_once('query_parser.inc.php');
/**
 * Modu wyszukiwania Search
 * Dziedziczy po klasie Object
 */
class Search extends Object {
	/**#@+
   	 * @access protected
   	 */
  	/**
   	 * @var array Tablica nazw tabel bazy danych, w ktrych bdziemy szuka
   	 */
  	var  $_dbTableName;
  	/**
   	 * @var array Tablica nazw pl tabel bazy danych, w ktrych bdziemy szuka
   	 */
  	var  $_dbTableFieldName;
  	/**
   	 * @var array Tablica okrelajca cig znakw do wyszukania oraz tablic pl
   	 *			  w ktrych naley szuka
   	 */
  	var  $_searchCriteria;
  	/**
   	 * @var array Tablica asocjacyjna wynikw wyszukania
   	 */
  	var  $_searchResult;
  	/**
   	 * @var string Zapytanie SQL do bazy danych
   	 */
  	var  $_sqlQuery;
    /**#@-*/
	 
  	/**
   	 * Domylna metoda wywoywana podczas inicjalizacji obiektw tej klasy
   	 * @access public
   	 * @param array $surveydata Tablica z danymi o ankiecie
   	 * @return mixed
   	 */
	function Search($searchdata = NULL)
	{
		// Okrelenie domylnej metody obsugi bdw
		$this->setErrorHandling(PEAR_ERROR_CALLBACK, array(&$this, 'errorHandlerThorSearch'));		
	}
  	/**
   	 * Ustawia tablic nazw tabeli bazy danych
   	 * @access public
   	 * @param array $tablename Nazwy tabel
   	 * @return mixed
   	 */
	function setTableName($tablename)
	{
		if (is_array($tablename) && sizeof($tablename) > 0) {
			$this->_dbTableName = $tablename;
			return TRUE;
		} else { return PEAR::raiseError($tablename, -2, null, null, PEAR_LOG_NOTICE);}
	}
  	/**
   	 * Ustawia tablic nazw pl tabel bazy danych
   	 * @access public
   	 * @param array $tablefield Nazwy pl tabel
   	 * @return mixed
   	 */
	function setTableFieldName($tablefieldname)
	{
		if (is_array($tablefieldname) && sizeof($tablefieldname) > 0) {
			$this->_dbTableFieldName = $tablefieldname;
			return TRUE;
		} else { return PEAR::raiseError($tablefieldname, -2, null, null, PEAR_LOG_NOTICE);}
	}
  	/**
   	 * Ustawia cig znakw do wyszukania
   	 * @access public
   	 * @param array $searchcriteria Tablica okrelajca cig znakw do wyszukania
	 *				oraz tablic pl, w ktrych naley szuka
   	 * @return mixed
   	 */
	function setSearchCriteria($searchcriteria)
	{
		if (is_array($searchcriteria) && sizeof($searchcriteria) > 0) {
			$this->_searchCriteria = $searchcriteria;
			return TRUE;
		} else { return PEAR::raiseError($searchcriteria, -2, null, null, PEAR_LOG_NOTICE);}
	}
  	/**
   	 * Ustawia tablic wyniku wyszukiwania w bazie danych
   	 * @access public
   	 * @param array $searchresult Tablica asocjacyjna wyniku wyszukiwania
   	 * @return mixed
   	 */
	function setSearchResult($searchresult)
	{
		if (is_array($searchresult) && sizeof($searchresult) > 0) {
			$this->_searchResult = $searchresult;
			return TRUE;
		} else { return PEAR::raiseError($searchresult, -2, null, null, PEAR_LOG_NOTICE);}
	}
  	/**
   	 * Ustawia zawarto zapytania SQL do bazy danych 
   	 * @access public
   	 * @param array $sqlquery Zapytanie SQL
   	 * @return mixed
   	 */
	function setSQLQuery($sqlquery)
	{
		if ($sqlquery <> NULL) {
			$this->_sqlQuery = $sqlquery;
			return TRUE;
		} else { return PEAR::raiseError($sqlquery, -2, null, null, PEAR_LOG_NOTICE);}
	}
  	/**
   	 * Zwraca tablic nazw tabel bazy danych
   	 * @access public
   	 * @return string
   	 */
	function getTableName(){ return $this->_dbTableName;}
  	/**
   	 * Zwraca tablic nazw pl tabel bazy danych
   	 * @access public
   	 * @return string
   	 */
	function getTableFieldName(){ return $this->_dbTableFieldName;}
  	/**
   	 * Zwraca tablic znakw do wyszukania w bazie danych oraz list pl, w ktrych
   	 * naley szuka
   	 * @access public
   	 * @return array
   	 */
	function getSearchCriteria(){ return $this->_searchCriteria;}
  	/**
   	 * Zwraca tablic wyniku wyszukiwania w bazie danych
   	 * @access public
   	 * @return string
   	 */
	function getSearchResult(){ return $this->_searchResult;}
  	/**
   	 * Zwraca zawato zapytania SQL do bazy danych
   	 * @access public
   	 * @return string
   	 */
	function getSQLQuery(){ return $this->_sqlQuery;}
  	/**
   	 * Tworzy zapytanie SQL na podstawie uzyskanych danych
   	 * @access public
   	 * @return mixed
   	 */
	function makeSQLQuery() {
		// Okrelenie pl tabel do wyszukania
		$sqlfields = '';
		$i = 0;
		$tablefield = $this->getTableFieldName();
		reset($tablefield); 
		foreach ($tablefield as $key1 => $value1) { 
			$j = 0;
			foreach ($tablefield[$key1] as $key2 => $value2) { 
				if ($i < (sizeof($tablefield) - 1) || ($i + 1 == sizeof($tablefield) && $j < (sizeof($tablefield[$key1]) - 1))) {
					$sqlfields .= $key1 . '.' . $value2 . ', '; 
				} else {
					$sqlfields .= $key1 . '.' . $value2;
				}
				$j++;
			} 			
			$i++;
		}
		// Okrelenie tabel, wrd ktrych bdziemy wyszukiwa
		$tables = '';
		$i = 0;
		$table = $this->getTableName();
		reset($table);

		foreach ($table as $key1 => $value1) {
			if ($i < (sizeof($table) - 1)) {
				$tables .= $value1 . ', ';
			} else {
				$tables .= $value1;			
			}
			$i++;
		}
		// Okrelenie kryteriw wyszukiwania
		$criterias = '';
		$parsed_string = new SearchstringParser();
		$criteria = $this->getSearchCriteria();
		$k = 0;

		foreach ($criteria as $key2 => $value2) {
			$j = 0;
			$result = $parsed_string->parse($value2);
			$criterias .= '(';
			foreach($value2[0] as $key => $value) {
				$i = 0;
				foreach ($result as $key1 => $value1) {
					// Sprawdzamy czy nie trzeba czego z zapytania wykluczy
					if ($value1['operator'] == 'not') {
						$eq_operator = ' NOT LIKE ';
						$join_operator = ' AND ';
						$token = '\'%' . $value1['token'] . '%\'';
					} else { 
						if ($value1['comparetype'] == 'eq') {
							$eq_operator = ' = ';
							$token = '\'' . $value1['token'] . '\'';
						} else {
							$eq_operator = ' LIKE ';
							$token = '\'%' . $value1['token'] . '%\'';
						}
						$join_operator = ' ' . $value1['operator'] . ' ';
					}

					if ($i == 0) {
				   		$criterias .= '(' . $value . $eq_operator . $token;
				   		if (sizeof($result) == 1) { $criterias .= ')';}
					} else {
						if ($value1['operator'] == 'or') {
				   			$criterias .= $join_operator . $value . $eq_operator . $token;
						} else {
				   			$criterias .= ')' . $join_operator . '(' . $value . $eq_operator . $token;
						}
						if (sizeof($result) == $i + 1) {
							$criterias .= ')';
						}
					}
					$i++;
				}
				if ($j < sizeof($value2[0]) - 1) {
					$criterias .= ' OR ';
				}
				$j++; 
			}
			$criterias .= ')';
			if ($k < sizeof($criteria) - 1) {
				$criterias .= ' AND ';
			}
			$k++; 
		}
		// Skonstruowanie zapytania SQL
		$query =  'SELECT ' . $sqlfields . ' FROM ' . $tables . ' WHERE ' . $criterias;
		$this->setSQLQuery($query);
	}
  	/**
   	 * Zwraca wynik wykonania zapytania SQL
   	 * @access public
   	 * @return mixed
   	 */
	function fetchQueryResult() {

		global $appCore;
		$queryresult = array(); // Tablica z wynikami wyszukiwania

		if (DB::isError($result = &$appCore->Query($this->getSQLQuery()))) {
   			return $result;
   		}

		while ($resultdata = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
			//if (parent::checkObjectAccess($user, $surveydata['srv_id'], 'r')) {
				$queryresult[] = $resultdata;
			//}
		}
		
		if (is_array($queryresult) && sizeof($queryresult) > 0 ) {
			return $queryresult;
		} else {
			return PEAR::raiseError($queryresult, -2, null, null, PEAR_LOG_NOTICE);
		}
	} 
  	/**
   	 * Metoda rejestrujca now ankiet
   	 *
   	 * @access public
   	 * @param mixed $survey Obiekt thorSurvey
   	 * @param mixed $user
   	 * @return mixed
   	 */
   	function saveSurveyData(&$survey, &$user)
   	{
		global $appCore;
		
   		// Zapisanie nowej ankiety w bazie danych
		$sqlquery = "INSERT INTO Survey (SRV_Id, SRV_Title, SRV_Desc, SRV_Active) VALUES ('" . $survey->getId() . "', '" . $survey->getSurveyTitle() . "', '" . $survey->getDesc() . "', '" . $survey->getActive() . "')";
		
		if (DB::isError($result = $appCore->Query($sqlquery))) {
			return FALSE;
		} else {
			$dbObject = &$appCore->getConnection(); 
	 		if ($dbObject->affectedRows() > 0) {
	   			return TRUE;
			} else { return PEAR::raiseError($survey->getId(), -5001, null, null, PEAR_LOG_NOTICE);}
		}
	}
  	/**
   	 * Zwraca list pyta w ankiecie
   	 * @access public
   	 * @return mixed
   	 */
	function getQuestions() {

		global $appCore;

   		// Pobranie listy odpowiedzi na pytanie
   		$sqlquery = "SELECT SRQ_Id, SurveyQuestion.SRV_Id, SRQ_Text, SRQ_Active FROM SurveyQuestion, Survey WHERE SurveyQuestion.SRV_Id = Survey.SRV_Id";

		if (DB::isError($result = &$appCore->Query($sqlquery))) {
   			return $result;
   		}

		while ($questionsdata = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
			//if (parent::checkObjectAccess($user, $questionsdata['srq_id'], 'r')) {
				$question_list[] = new thorSurveyQuestion($questionsdata);
			//}
		}

		if (isSet($question_list) && sizeof($question_list) > 0) {
			return $question_list;	
		} else { return -3;}		
	}
  	/**
   	 * Ustawia list odpowiedzi na pytanie
   	 * @access public
   	 * @return mixed
   	 */
	function setQuestions($questionlist) { 
		if (is_array($questionlist)) { 
			$this->_questions = $questionlist;
		} else {
			return -1;
		}
	}
  	/**
   	 * Domylna metoda obsugi bdw dla obiektw tej klasy
	 * @param mixed $error Kod bdu
   	 * @access public
   	 * @return mixed
   	 */
	function errorHandlerThorSearch($error) {
	    global $appCore;
		$appCore->handleError($error);
	}
} // Koniec klasy thorSurvey

?>