<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+
global $appCore;
if (PEAR::isError($err = $appCore->loadModule('Product'))){echo($appCore->getLastErrorMessage()); exit;}
if (PEAR::isError($err = $appCore->loadModule('DeliveryType'))){echo($appCore->getLastErrorMessage()); exit;}
if (PEAR::isError($err = $appCore->loadModule('OrderStatus'))){echo($appCore->getLastErrorMessage()); exit;}
if (PEAR::isError($err = $appCore->loadModule('PaymentType'))){echo($appCore->getLastErrorMessage()); exit;}
if (PEAR::isError($err = $appCore->loadModule('Currency'))){echo($appCore->getLastErrorMessage()); exit;}

//Klasa obsugujca koszyk
class Order extends Object {
   /**#@+
    * @access protected
   	*/
   /**
	* @var string identyfikator typu dostawy 
	*/
   var $_DltId;
   /**
    * @var string Identyfikator typu patnoci
	*/
   var $_PytId;
   /**
    * @var string Identyfikator uytkownika, wysa zamwienie
	*/
   var $_UserId;
   /**
    * @var string Identyfikator waluty, w jakiej zostao wykonane zlecenie
    */
   var $_CurId;
   /**
	* @var string Identyfikator statusu zamwienia
	*/
   var $_OrdId;
   /**
    * @var string Identyfikator wojewdztwa
    */
   var $_StateId;
   /**
    * @var string Identyfikator kraju
    */
   var $_CountryId;
   /**
    * @var string Data ostatniej modyfikacji
    */
   var $_LastModifyDate;
   /**
    * @var string Data realizacji zamwienia
    */
   var $_RealisationDate;
   /**
    * @var string Imi odbiorcy
    */
   var $_UsrName;
   /**
    * @var string Nazwisko odbiorcy
    */
   var $_UsrLastName;
   /**
    * @var string Adres e-mail odbiorcy
    */
   var $_UsrEmail;
   /**
    * @var string Nazwa ulicy, na ktr maj zosta dostrczone produkty z zamwienia
    */
   var $_AddrStreetName;
   /**
    * @var string Numer domu , do ktrego maj zosta dostrczone produkty z zamwienia
    */
   var $_AddrStreetNr;
   /**
    * @var string Numer mieszkania, do ktrego maj zosta dostrczone produkty z zamwienia
    */
   var $_AddrHomeNr;
   /**
    * @var string Miasto
    */
   var $_AddrCity;
   /**
    * @var string Kod ZIP
    */
   var $_AddrZip;
   /**
    * @var float Cakowita warto zmwienia Brutto
    */
   var $_Price;
   /**
    * @var Array Lista produktw w zamwieniu
    */
   var $_OrderedProduct;
   /**#@-*/
   
   /**#@+
    * @access public
   	*/
   /**
    * Konstruktor obiektu zamwienia
	*
	* @param array $orderdata Dane dla konstruktora
    */
   function Order($orderdata=array()) {
		// Okrelenie domylnej metody obsugi bdw
		$this->setErrorHandling(PEAR_ERROR_CALLBACK, array(&$this, 'errorHandlerOrder'));

		//Tworzenie obiektu
		foreach ($orderdata as $key => $value) { 
			switch (strtolower($key)) {
				case 'ord_id':
					$this->setId($value);
				break;
				case 'dlt_id':
					$this->setDeliveryTypeId($value);
				break;
				case 'pyt_id':
					$this->setPaymentType($value);
				break;
				case 'usr_id':
					$this->setUserId($value);
				break;
				case 'cur_id':
					$this->setCurencyId($value);
				break;				
				case 'ors_id':
					$this->setOrderStatusId($value);
				break;
				case 'st_id':
					$this->setAddrState($value);
				break;
				case 'cry_id':
					$this->setAddrCountry($value);
				break;
				case 'ord_createdate':
					$this->setCreateDate($value);
				break;
				case 'ord_lastmodifydate':
					$this->setLastModifyDate($value);
				break;
				case 'ord_realisationdate':
					$this->setRealisationDate($value);
				break;
				case 'ord_comment':
					$this->setDesc($value);
				break;
				case 'usr_name':
					$this->setUserName($value);
				break;
				case 'usr_lastname':
					$this->setUserLastName($value);
				break;
				case 'usr_email':
					$this->setUserEmail($value);
				break;
				case 'addr_streetname':
					$this->setAddrStreetName($value);
				break;
				case 'addr_streetnr':
					$this->setAddrStreetNr($value);
				break;
				case 'addr_homenr':
					$this->setAddrHomeNr($value);
				break;
				case 'addr_city':
					$this->setAddrCity($value);
				break;
				case 'addr_zip':
					$this->setAddrZip($value);
				break;
				case 'ord_price':
					$this->setPrice($value);
				break;
				case 'ord_active':
					$this->setActive($value);
				break;
			}
		}
		
	}
	/**
	 * Ustawia identyfikator sownika DeliveryType
	 */
	function setDeliveryTypeId($value) {$this->_DltId = $value;}
	/**
	 * Ustawia identyfikator sownika PaymentType
	 */
	function setPaymentType($value) {$this->_PytId = $value;}
	/**
	 * Ustawia identyfikator usera
	 */
	function setUserId($value) {$this->_UserId = $value;}
	/**
	 * Ustawia identyfikator sownika Currency
	 */
	function setCurencyId($value) {$this->_CurId = $value;}
	/**
	 * Ustawia identyfikator sownika OrderStatus
	 */
	function setOrderStatusId($value) {$this->_OrdId = $value;}
	/**
	 * Ustawia wojewdztwo
	 */
	function setAddrState($value) {$this->_StateId = $value;}
	/**
	 * Ustawia kraj
	 */
	function setAddrCountry($value) {$this->_CountryId = $value;}
	/**
	 * Ustawia dat realizacji zamwienia
	 */	
	function setRealisationDate($value) {$this->_RealisationDate = $value;}
	/**
	 * Ustawia imi zamawiajcego
	 */
	function setUserName($value) {$this->_UsrName = $value;}
	/**
	 * Ustawia nazwisko zamawiajcego
	 */
	function setUserLastName($value) {$this->_UsrLastName = $value;}
	/**
	 * Ustawia e-mail zamawiajcego
	 */
	function setUserEmail($value) {$this->_UsrEmail = $value;}
	/**
	 * Ustawia nazw ulicy adresu dostawy
	 */
	function setAddrStreetName($value) {$this->_AddrStreetName = $value;}
	/**
	 * Ustawia numer ulicy adresu dostawy
	 */
	function setAddrStreetNr($value) {$this->_AddrStreetNr = $value;}
	/**
	 * Ustawia numer domu adresu dostawy
	 */
	function setAddrHomeNr($value) {$this->_DltId = $value;}
	/**
	 * Ustawia miastoadresu dostawy
	 */
	function setAddrCity($value) {$this->_AddrCity = $value;}
	/**
	 * Ustawia kod pocztowy adresu dostawy
	 */
	function setAddrZip($value) {$this->_AddrZip = $value;}
	/**
	 * Ustawia cen zamwienia
	 */
	function setPrice($value) {$this->_Price = $value;}
	/**
	 * Ustawia tablic zamwionych produktw
	 */
	function setOrderedProducts(&$ordprod) {$this->_OrderedProduct = &$ordprod;}
	/**
	 * Zwraca idetyfikator sownika DeliveryType
	 */
	function getDeliveryTypeId() {return $this->_DltId;}
	/**
	 * Zwraca idetyfikator sownika PaymentType
	 */
	function getPaymentType() {return $this->_PytId;}
	/**
	 * Zwraca idetyfikator uytkownika
	 */
	function getUserId() {return $this->_UserId;}
	/**
	 * Zwraca identyfikator sownika Curency
	 */
	function getCurencyId() {return $this->_CurId;}
	/**
	 * Zwraca idetyfikator sownika OrderStatus
	 */
	function getOrderStatusId() {return $this->_OrdId;}
	/**
	 * Zwraca wojwedztwo adresu dostawy
	 */
	function getAddrState() {return $this->_StateId;}
	/**
	 * Zwraca kraj adresu dostawy
	 */
	function getAddrCountry() {return $this->_CountryId;}
	/**
	 * Zwraca dat realizacji zamwienia
	 */
	function getRealisationDate() {return $this->_RealisationDate;}
	/**
	 * Zwraca imi zamawiajcego
	 */
	function getUserName() {return $this->_UsrName;}
	/**
	 * Zwraca nazwisko zamawiajcego
	 */
	function getUserLastName() {return $this->_UsrLastName;}
	/**
	 * Zwraca e-mail zamawiajcego
	 */
	function getUserEmail() {return $this->_UsrEmail;}
	/**
	 * Zwraca nazw ulicy adresu dostawy
	 */
	function getAddrStreetName() {return $this->_AddrStreetName;}
	/**
	 * Zwraca numer ulicy adresu dostawy
	 */
	function getAddrStreetNr() {return $this->_AddrStreetNr;}
	/**
	 * Zwraca numer domu adresu dostawy
	 */
	function getAddrHomeNr() {return $this->_DltId;}
	/**
	 * Zwraca miasto adresu dostawy
	 */
	function getAddrCity() { return $this->_AddrCity;}
	/**
	 * Zwraca kod pocztowy adresu dostawy
	 */
	function getAddrZip() {return $this->_AddrZip;}
	/**
	 * Zwraca warto zamwienia
	 */
	function getPrice() {return $this->_Price;}
	/**
	 * Zwraca tablic zamwionych produktw
	 */
	function getOrderedProduct() {return $this->_OrderedProduct;}
	/**
	 * aduje dane o zamwionych produktach z bazy danych
	 * 
	 * Metoda nie moe by wywoywana statycznie
	 *
	 * @return PEAR_Error
	 */
	function getOrderedProductData() {
		//Rdze aplikacji
		global $appCore;
	
		//Metoda nie moe by wywoywana statycznie
		if(!isset($this)) {return PEAR::raiseError('getProductNumber;Order', -5003, null, null, PEAR_LOG_ERR);}
		$this->_OrderedProduct = array();
		//Przygotowanie i wykonanie zapytania SQL
		$sqlquery  = 'SELECT ORP_Id, ORD_Id, PRD_Id, ITM_Name, PRD_Price, PRD_FinalPrice, TAX_Value, ORP_Quantity, ORP_CreateDate, ORP_LastModifyDate, ORP_Active FROM OrderProduct';
		$sqlquery .= ' WHERE ORD_Id="'.$this->getId().'" AND ORP_Active=1';
		if (DB::isError($result = $appCore->Query($sqlquery))) {return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);}
		while ($proddate = $result->fetchRow(DB_FETCHMODE_ASSOC)) {
			$this->_OrderedProduct[] = array(new Product($proddate), $proddate['ORP_Quantity']);
		}
		
	}
	/**
	 * Zwraca obiekt zamwienia
	 */
	function getData($ordid) {
		//Rdze aplikacji
		global $appCore;
				
		//
		//Przygorowanie i wykonanie zapytania SQL
		$sqlquery = 'SELECT ORD_Id, DLT_Id, PYT_Id, USR_Id, CUR_Id, ORS_Id, ST_Id, CRY_Id, UNIX_TIMESTAMP(ORD_CreateDate) as ORD_CreateDate, UNIX_TIMESTAMP(ORD_LastModifyDate) as ORD_LastModifyDate, UNIX_TIMESTAMP(ORD_RealisationDate) as ORD_RealisationDate, ORD_Comment, USR_Name, USR_LastName, USR_Email, ADDR_StreetName, ADDR_StreetNr, ADDR_HomeNr, ADDR_City, ADDR_Zip, ORD_Price, ORD_Active FROM Orders WHERE ORD_Id="'.$ordid.'"';
		if (DB::isError($result = $appCore->Query($sqlquery))) {return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);}
		if ($orddata= $result->fetchRow(DB_FETCHMODE_ASSOC)) {
			return new Order($orddata);
		}
		return new PEAR_Error;
		
	}
	/**
	 * Zwaraca list obiektw zamwie
	 *
	 * @param strign $userId Identyfikator uytkownika, ktrego zamwienia powinny 
	 *                       by zwrcone
     * @param string $filter Parametr filtrujcy
	 * @return mixed Tablica obiektw Order lub obiekt PEAR_Error
	 */
	function getOrdersList($userId=NULL, $filter=NULL) {
		//Rdze aplikacji
		global $appCore;
		
		//Obiekt zawierajcy tablic wynikw
		$resArray = NULL;
		
		//Przygorowanie i wykonanie zapytania SQL
		$sqlquery = 'SELECT ORD_Id, DLT_Id, PYT_Id, USR_Id, CUR_Id, ORS_Id, ST_Id, CRY_Id, UNIX_TIMESTAMP(ORD_CreateDate) as ORD_CreateDate, UNIX_TIMESTAMP(ORD_LastModifyDate) as ORD_LastModifyDate, UNIX_TIMESTAMP(ORD_RealisationDate) as ORD_RealisationDate, ORD_Comment, USR_Name, USR_LastName, USR_Email, ADDR_StreetName, ADDR_StreetNr, ADDR_HomeNr, ADDR_City, ADDR_Zip, ORD_Price, ORD_Active FROM Orders';
		if($userId) {$sqlquery .= ' WHERE USR_Id="'.$userId.'"';}
		$sqlquery .= ' ORDER BY ORD_CreateDate DESC';
		if (DB::isError($result = $appCore->Query($sqlquery))) {
			$err =  PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
			if(!isset($this)) {Order::errorHandlerOrder($err);}
			return $err;
		}
		
		//Tworzenie listy obiektw
		while ($orderdata = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {$resArray[] = new Order($orderdata);}
		
		//Waracanie obiektu zawierajcego tablic wynikw
		return $resArray;
	}
	/**
	 * Zwraca liczb produktw w zamwieniu
	 *
	 * Metoda nie moe by wywoywana statycznie
	 *
	 * @return mixed Integer lub PEAR_Error
	 */
	function getProductNumber() {
		//Rdze aplikacji
		global $appCore;
		
		//Metoda nie moe by wywoywana statycznie
		if(!isset($this)) {return PEAR::raiseError('getProductNumber;Order', -5003, null, null, PEAR_LOG_ERR);}
		
		//Zaadowanie listy prroduktw jeeli nie zostao to do tej pory zrobione
		if (!$this->_OrderedProduct) {$this->getOrderedProductData();}
		
		//Zwracanie liczby produktw
		return count($this->_OrderedProduct);
	}
	/**
	 * Zapisuje dane obiektu
	 */
	function saveData() {	
		//Rdzea plikacji
		global $appCore; 
		
		//Przygowanie do zapisu
		$appCore->setTransactionStatus(FALSE);
		if (PEAR::isError($err = Transaction('BEGIN'))) {return $err;}
		$appCore->setTransactionStatus(TRUE);
		
		if (Order::doesOrderExist($this->_Id)) {
			//Obiekt zamwienia istnieje, wic bdzie modyfikacja
		
		} else {
			//Generowanie identyfikatora
			$this->generateId();
			
			//Obiekt zamwienia bdzie tworzony
			$sqlquery =  'INSERT INTO Orders (ORD_Id, DLT_Id, PYT_Id, USR_Id, CUR_Id, ORS_Id, ST_Id, CRY_Id, ORD_CreateDate, ORD_LastModifyDate, ORD_RealisationDate, ORD_Comment, USR_Name, USR_LastName, USR_Email, ADDR_StreetName, ADDR_StreetNr, ADDR_HomeNr, ADDR_City, ADDR_Zip, ORD_Price, ORD_Active) ';
			$sqlquery .= 'VALUES ("'.$this->getId().'", NULL, NULL, "'.$this->getUserId().'", NULL, NULL, "'.$this->getAddrState().'", "'.$this->getAddrCountry().'",CURRENT_TIMESTAMP(0), NULL, NULL, "'.$this->getDesc().'", "'.$this->getUserName().'", "'.$this->getUserLastName().'", "'.$this->getUserEmail().'", "'.$this->getAddrStreetName().'", "'.$this->getAddrStreetNr().'", "'.$this->getAddrHomeNr().'", "'.$this->getAddrCity().'", "'.$this->getAddrZip().'", "'.$this->getPrice().'", ';
			if ($this->getActive()) {$sqlquery .= '1)';} else {$sqlquery .= '0)';}
			if (DB::isError($result = $appCore->Query($sqlquery))) {return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);}
			
			//Wpisywanie do tabeli produktw zamwionych 
			if($this->_OrderedProduct) {
				foreach($this->_OrderedProduct as $Product) {
					//Przygotowanie zapytania SQL
					$prodId = $Product[0]->getId();
					$Product[0]->generateId(); //Zmiana domylnego identyfikatora
					$sqlquery  = 'INSERT INTO OrderProduct (ORP_Id, ORD_Id, PRD_Id, ITM_Name, PRD_Price, PRD_FinalPrice, TAX_Value, ORP_Quantity, ORP_CreateDate, ORP_LastModifyDate, ORP_Active)';
					$sqlquery .= 'VALUES ("'.$Product[0]->getId().'", "'.$this->getId().'", "'.$prodId.'", "'.$Product[0]->_Item->getName().'", "'.$Product[0]->getPriceNetto().'", "'.$Product[0]->getPriceBrutto().'", "'.$Product[0]->_Tax->getValue().'", "'.$Product[1].'", NOW(), NULL, 1)';
					if (DB::isError($result = $appCore->Query($sqlquery))) {return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);}					
				}
			}
		
		}
		
		//Proces zapisywania danych zakoczony pomylnie
		if (PEAR::isError($err = Transaction('COMMIT'))) {return $err;}
		$appCore->setTransactionStatus(FALSE);
	
	}
	/**
	 * Sprawdza czy obiekt istnieje w bazie danych
	 *
	 * @param string $id Identyfikator obiektu
	 * @return mixed Obiekt bool lub PEAR_Error
	 */
	function doesOrderExist($id) {
		//Rdze aplikacji
		global $appCore;
		
		//Przygotowanie zapytania SQL
		$sqlquery = 'SELECT ORD_Id FROM Orders WHERE ORD_Id="'.$id.'"';
		if (DB::isError($result = $appCore->Query($sqlquery))) {
			$err =  PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
			if(!isset($this)) {Order::errorHandlerOrder($err);}
			return $err;
		}
		
		//Zwracanie wyniku warunku logicznego
		return ($result->numRows()==1);
	}
	/**
	 * Zwraca liczb zamwie zoonychj przez wybranego uytkownika
	 *
	 * @param string $usrId Identyfikator uytkownika
	 * @return mixed Obiekt integer lub PEAR_Error
	 */
	function getUserOrderCount($usrId) {
		//Rdze aplikacji
		global $appCore;
		
		//Przygotowywanei zapytania SQL
		$sqlquery = 'SELECT Count(ORD_Id) FROM Orders WHERE USR_Id="'.$usrId.'"';
		if (DB::isError($result = $appCore->Query($sqlquery))) {
			$err =  PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
			if(!isset($this)) {Order::errorHandlerOrder($err);}
			return $err;
		}
		$countRow = $result->fetchRow();
		//Zwracanie liczby wierszy
		return $countRow[0];
	} 
	/**
   	 * Domylna metoda obsugi bdw dla obiektw tej klasy
	 * @param PEAR_Error $error Kod bdu
   	 * @access public
   	 */
	function errorHandlerOrder($error) {
		//Rdze aplikacji
		global $appCore;

		//Odwoanie transakcji
		if ($appCore->getTransactionStatus()) {
			Transaction('ROLLBACK');
			$appCore->setTransactionStatus(FALSE);
		}
		
		//Standardowa obsuga bdu
		$appCore->handleError($error);
	}
}
?>