<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+
/**
 * Klasa Tax opisujca stawki podatku VAT
 * Dziedziczy po klasie Object
 */
class Tax extends Object {
	/**#@+
   	 * @access protected
   	 */
  	/**
   	 * @var int Stawka podatku
   	 */
  	var  $_Value;
  	/**
   	 * @var bool Domylna warto
   	 */
  	var  $_Default;
    /**#@-*/
	 
  	/**
   	 * Domylna metoda wywoywana podczas inicjalizacji obiektw tej klasy
   	 * @access public
   	 * @param array $countrydata Tablica z danymi o kraju
   	 * @return mixed
   	 */
	function Tax($taxdata = array())
	{
		// Okrelenie domylnej metody obsugi bdw
		$this->setErrorHandling(PEAR_ERROR_CALLBACK, array(&$this, 'errorHandlerTax'));
		foreach ($taxdata as $key => $value) { 
			switch (strtolower($key)) {
				case 'tax_id':
					$this->setId($value);
					break;
				case 'usr_id':
					$this->setOwner($value);
					break;
				case 'tax_value':
					$this->setValue($value);
					break;
				case 'tax_desc':
					$this->setDesc($value);
					break;
				case 'tax_default':
					$this->setDefault($value);
					break;
				case 'tax_createdate':
					$this->setCreateDate($value);
					break;
				case 'tax_lastmodifydate':
					$this->setLastModifyDate($value);
					break;
				case 'tax_active':
					$this->setActive($value);
					break;
			}
		}
	}
  	/**
   	 * Ustawia stawk podatku VAT
   	 * @access public
   	 * @param int $value Stawka podatku
   	 * @return mixed
   	 */
	function setValue($value)
	{
		if (PEAR::isError($result = $this->parseVar($value,'numeric'))) {
			return $result;
		} else {
			$this->_Value = $value;
		}	
	}
  	/**
   	 * Ustawia domylno danej stawki podatku
   	 * @access public
   	 * @param string $default Domylno
   	 * moliwe wartoci true:false, t:f, 1:0, yes:no
   	 * (parametry niewraliwe na wielko liter)
   	 * @return bool
   	 */
	function setDefault($default)
	{
		switch (strtolower($default)) {
			case 'true':
			case 't':
			case 1:
			case 'yes':
				$this->_Default = 1;
				return TRUE;
			case 'false':
			case 'f':
			case 0:
			case 'no':
				$this->_Default = 0;
				return TRUE;
			default: return -4;
		}
	}
  	/**
   	 * Zwraca stawk podatku
   	 * @access public
   	 * @return int
   	 */
	function getValue(){ return $this->_Value;}
  	/**
   	 * Zwraca domylno danej stawki podatku
   	 * @access public
	 * @param string $mode Format zwracanej wartoci:
	 * ('basic' - dane zwracane w taki sposb, w jaki zapisane s w bazie danych;
	 *  'extended' (domylny) - zwraca wartoci typu boolean - TRUE albo FALSE)
	 *  'verbose' - zwraca wartoci w postaci dajcej si wywietli na ekranie)
   	 * @return mixed
   	 */
	function getDefault($mode = 'extended') { 
		switch ($mode) {
			case 'basic': return $this->_Default;
			case 'extended':
				switch (strval($this->_Default)) {
					case TRUE:
					case 1:
					case 'true':
					case 't':
					case 'T': return 1;
					case 0: 
					case FALSE:
					case 'false':
					case 'f':
					case 'F': return 0;
					default: return NULL;
				}
			case 'verbose':
				switch ($this->_Default) {
					case 1:
					case TRUE:
					case 'true':
					case 't':
					case 'T': return 'Tak';
					case 0:
					case FALSE:
					case 'false':
					case 'f':
					case 'F': return 'Nie';
					default: return NULL;
				}
			default: return NULL;
		}
	}
  	/**
   	 * Zwraca podstawowe informacje o stawce podatku
	 * @param string $taxid Identyfikator stawki podatku, ktrego dane chcemy 
	 *                      uzyska.
	 * Warto domylna NULL (pobrane zostan dane wszystkich stawek podatku)
	 * @param string $filter Filtr wyboru danych:
	 *						 - 'active' - aktywne wiersze (warto domylna)
	 *						 - 'nonactive' - nieaktywne wiersze
	 *						 - 'all' - wszystkie wiersze
   	 * @access public
   	 * @return mixed
   	 */
	function getData($taxid = NULL, $filter = 'active') {

		global $appCore; 
		$tax_list = array();
		// Ustawienie poprawnego identyfikatora stawki podatku oraz kryteriw 
		// wyszukiwania
		switch ($filter) {
			case 'active':
				$where_active = 'TaxRate.TAX_Active = 1';
				break;
			case 'nonactive':
				$where_active = 'TaxRate.TAX_Active = 0';
				break;
			case 'all':
				$where_active = '(TaxRate.TAX_Active = 0 OR TaxRate.TAX_Active = 1)';
				break;
			default:
				$where_active = 'TaxRate.TAX_Active = 1';
		}

		if (isSet($taxid)) {
			if (PEAR::isError($result = Object::parseVar($taxid,'id'))) { return $result;}
			$where_statement = " WHERE TaxRate.TAX_Id = '$taxid' AND $where_active";
		} else { 
			$where_statement = " WHERE $where_active";
		}
		
   		// Pobranie podstawowych informacji o stawkach podatku
   		$sqlquery = "SELECT * FROM TaxRate $where_statement ORDER BY TAX_Value";
		if (DB::isError($result = &$appCore->Query($sqlquery))) {
   			return $result;
   		}

		while ($taxdata = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
			$tax_list[] = new Tax($taxdata);
		}

		return $tax_list;	
	}
  	/**
   	 * Metoda zapisujca dan stawk podatku w bazie danych
   	 *
   	 * @access public
   	 * @param mixed $tax Obiekt Tax
   	 * @return mixed
   	 */
   	function saveData($tax = NULL)
   	{
		global $appCore;

		if ($tax == NULL) { $tax = &$this;}
		$tax->setCreateDate(date(DATE_FORMAT_DBSAVE));

   		// Zapisanie danych
   		if (PEAR::isError($result = saveTax($tax))) {
			return $result;
   		} else {
   			return TRUE;
   		}
	} 
  	/**
   	 * Metoda uaktualniajca dan stawk podatku VAT w bazie danych
   	 *
   	 * @access public
   	 * @param mixed $tax Obiekt Tax
   	 * @return mixed
   	 */
   	function updateData($tax = NULL)
   	{
		global $appCore;

		if ($tax == NULL) { $tax = &$this;}
		$tax->setLastModifyDate(date(DATE_FORMAT_DBSAVE));

   		// Zaktualizowanie danych
   		if (PEAR::isError($result = updateTax($tax))) {
			return $result;
   		} else {
   			return TRUE;
   		}
	} 
  	/**
   	 * Metoda usuwajca dan stawk podatku VAT z bazy danych
   	 *
   	 * @access public
   	 * @param string $taxid Identyfikator obiektu
   	 * @return mixed
   	 */
   	function deleteData($taxid = NULL)
   	{
		global $appCore;

		if ($taxid == NULL) { $taxid = &$this->getId();}

   		// Usunicie danych
   		if (PEAR::isError($result = deleteTax($taxid))) {
			return $result;
   		} else {
   			return TRUE;
   		}
	} 
  	/**
   	 * Domylna metoda obsugi bdw dla obiektw tej klasy
	 * @param mixed $error Kod bdu
   	 * @access public
   	 * @return mixed
   	 */
	function errorHandlerTax($error) {
	    global $appCore;
		$appCore->handleError($error);
	}
} // Koniec klasy Tax

?>