<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+

/**
 * Klasa thorParam opisujca oglnie parametry obiektu w sklepie
 * Dziedziczy po klasie ThorObject
 */
class Param extends Object {
	/**#@+
   	 * @access protected
   	 */
  	/**
   	 * @var string Nazwa parametru
   	 */
  	var  $_Name;
  	/**
   	 * @var string Warto parametru
   	 */
  	var  $_Value;
    /**#@-*/

  	/**
   	 * Domylna metoda wywoywana podczas inicjalizacji obiektw tej klasy
   	 * @access public
   	 * @param array $itemdata Tablica z danymi o obiekcie
   	 * @return mixed
   	 */
	function Param($paramdata = NULL)
	{
		// Okrelenie domylnej metody obsugi bdw
		$this->setErrorHandling(PEAR_ERROR_CALLBACK, array(&$this, 'errorHandlerThorParam'));
		foreach ($paramdata as $key => $value) {
			switch (strtolower($key)) {
				case 'par_id':
					$this->setId($value);
					break;
				case 'usr_id':
					$this->setOwner($value);
					break;
				case 'par_name':
					$this->setName($value);
					break;
				case 'par_desc':
					$this->setDesc($value);
					break;
				case 'par_type':
					$this->setObjectType($value);
					break;
				case 'par_createdate':
					$this->setCreateDate($value);
					break;
				case 'par_lastmodifydate':
					$this->setLastModifyDate($value);
					break;
				case 'par_active':
					$this->setActive($value);
					break;
			}
		}
		$this->getParamValue($this->getId());
	}
  	/**
   	 * Ustawia nazw parametru
   	 * @access public
   	 * @param string $name Nazwa parametru
   	 * @return mixed
   	 */
	function setName($name)
	{
		if (PEAR::isError($result = $this->parseVar($name,'string', array(array('not_null'), array('striptags'))))) {
			return $result;
		} else {
			$this->_Name = $name;
		}
	}
  	/**
   	 * Ustawia warto parametru
   	 * @access public
   	 * @param string $value Warto parametru
   	 * @return mixed
   	 */
	function setValue($value)
	{
		if (PEAR::isError($result = $this->parseVar($value,'string', array(array('striptags'))))) {
			return $result;
		} else {
			$this->_Value = $value;
		}
	}
  	/**
   	 * Zwraca nazw parametru
   	 * @access public
   	 * @return string
   	 */
	function getName(){ return $this->_Name;}
  	/**
   	 * Zwraca warto parametru
   	 * @access public
   	 * @return string
   	 */
	function getValue(){ return $this->_Value;}
  	/**
   	 * Zwraca podstawowe informacje o parametrach obiektu
	 * @param object $user Obiekt typu ThorUser, wskazujca na uytkownika
	 * pobierajcego te dane.
	 * @param string $id Identyfikator parametru, ktrego dane chcemy uzyska.
	 * Warto domylna NULL (pobrane zostan dane wszystkich parametrw)
   	 * @access public
   	 * @return mixed
   	 */
	function getParamData(&$user, $id = NULL) {

		global $appCore;

		// Ustawienie poprawnego identyfikatora parametru oraz kryteriw
		// wyszukiwania
		if (isSet($id)) {
			if (PEAR::isError($result = Object::parseVar($id,'id'))) { return $result;}
			$where_statement = " WHERE Parameter.PAR_Id = '$id' AND Parameter.PAR_Active = 1";
		} else {
			$where_statement = " WHERE Parameter.PAR_Active = 1";
		}

   		// Pobranie podstawowych informacji o parametrach
   		$sqlquery = "SELECT * FROM Parameter $where_statement ORDER BY Parameter.PAR_Name";

		if (DB::isError($result = &$appCore->Query($sqlquery))) {
   			return $result;
   		}

		while ($paramdata = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
			//if (parent::checkObjectAccess($user, $surveydata['srv_id'], 'r')) {
			$param_list[] = new Param($paramdata);
			//}
		}

		if (isSet($param_list) && sizeof($param_list) > 0) {
			return $param_list;
		} else { return PEAR::raiseError($id, -3, null, null, PEAR_LOG_NOTICE);}
	}
  	/**
   	 * Zwraca podstawowe informacje o parametrach obiektu
	 * @param string $id Identyfikator parametru, ktrego dane chcemy uzyska.
	 * Warto domylna NULL (pobrane zostan dane wszystkich parametrw)
	 * @param string $filter Filtr wyboru danych:
	 *						 - 'active' - aktywne wiersze (warto domylna)
	 *						 - 'nonactive' - nieaktywne wiersze
	 *						 - 'all' - wszystkie wiersze
   	 * @access public
   	 * @return mixed
   	 */
	function getData($paramid = NULL, $filter = 'active') {

		global $appCore;
		$param_list  = array();
		// Ustawienie poprawnego identyfikatora parametru oraz kryteriw
		// wyszukiwania
		switch ($filter) {
			case 'active':
				$where_active = 'Parameter.PAR_Active = 1';
				break;
			case 'nonactive':
				$where_active = 'Parameter.PAR_Active = 0';
				break;
			case 'all':
				$where_active = '(Parameter.PAR_Active = 0 OR Parameter.PAR_Active = 1)';
				break;
			default:
				$where_active = 'Parameter.PAR_Active = 1';
		}
		if (isSet($paramid)) {
			if (PEAR::isError($result = Object::parseVar($paramid,'id'))) { return $result;}
			$where_statement = " WHERE Parameter.PAR_Id = '$paramid' AND $where_active";
		} else {
			$where_statement = " WHERE $where_active";
		}

   		// Pobranie podstawowych informacji o parametrach
   		$sqlquery = "SELECT * FROM Parameter $where_statement ORDER BY Parameter.PAR_Name";
		if (DB::isError($result = &$appCore->Query($sqlquery))) {
   			return $result;
   		}

		while ($paramdata = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
			$param_list[] = new Param($paramdata);
		}

		return $param_list;
	}
  	/**
   	 * Pobiera warto parametru z bazy danych
	 * @param string $id Identyfikator obiektu, ktrego warto parametru chcemy
	 * pobra.
   	 * @access public
   	 * @return mixed
   	 */
	function getParamValue($itemid) {

		global $appCore;

		if (PEAR::isError($result = Object::parseVar($itemid,'id'))) {
			return $result;
		} else {
			$where_statement = " WHERE itm_has_par.ITM_Id = '$itemid' AND itm_has_par.PAR_Id = '" . $this->getId() . "'";
		}

   		// Pobranie podstawowych informacji o parametrach
   		$sqlquery = "SELECT itm_has_par.PAR_Value FROM itm_has_par $where_statement";
		if (DB::isError($result = &$appCore->Query($sqlquery))) {
   			return $result;
   		}

		if ($paramvalue = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
			$this->setValue(current($paramvalue));
		}
	}
  	/**
   	 * Metoda zapisujca danego parametru w bazie danych
   	 *
   	 * @access public
   	 * @param mixed $param Obiekt thorParam
   	 * @return mixed
   	 */
   	function saveParamData($param = NULL)
   	{
		global $appCore;

		if ($param == NULL) { $param = &$this;}
		$param->setCreateDate(date(DATE_FORMAT_DBSAVE));

   		// Zapisanie nowego parametru w bazie danych
		$sqlquery = "INSERT INTO Parameter (PAR_Id, USR_Id, PAR_Name, PAR_Desc, PAR_CreateDate, PAR_Active) VALUES ('" . $param->getId() . "', '" . $param->getOwner() . "', '" . $param->getName() . "', '" . $param->getDesc() . "', '" . $param->getCreateDate() . "', '" . $param->getActive() . "')";
		if (DB::isError($result = $appCore->Query($sqlquery))) {
			return $result;
		} else {
			$dbObject = &$appCore->getConnection();
	 		if ($dbObject->affectedRows() > 0) {
	   			return TRUE;
			} else { return PEAR::raiseError($param->getId(), -5001, null, null, PEAR_LOG_NOTICE);}
		}
	}
  	/**
   	 * Metoda uaktualniajca dane parametrow w bazie danych
   	 *
   	 * @access public
   	 * @param mixed $param Obiekt Param
   	 * @return mixed
   	 */
   	function updateData($param = NULL)
   	{
		global $appCore;

		if ($param == NULL) { $param = &$this;}
		$param->setLastModifyDate(date(DATE_FORMAT_DBSAVE));

   		// Zaktualizowanie danych
   		if (PEAR::isError($result = updateParam($param))) {
			return $result;
   		} else {
   			return TRUE;
   		}
	}
  	/**
   	 * Metoda usuwajca dany parametr z bazy danych
   	 *
   	 * @access public
   	 * @param string $paramid Identyfikator obiektu
   	 * @return mixed
   	 */
   	function deleteData($paramid = NULL)
   	{
		global $appCore;

		if ($paramid == NULL) { $paramid = &$this->getId();}

   		// Usunicie danych
   		if (PEAR::isError($result = deleteParam($paramid))) {
			return $result;
   		} else {
   			return TRUE;
   		}
	}
  	/**
   	 * Domylna metoda obsugi bdw dla obiektw tej klasy
	 * @param mixed $error Kod bdu
   	 * @access public
   	 * @return mixed
   	 */
	function errorHandlerThorParam($error) {
	    global $appCore;
		$appCore->handleError($error);
	}
} // Koniec klasy thorParam

?>