<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+
/**
 * Klasa thotItem opisujca oglnie obiekt w sklepie
 * Dziedziczy po klasie ThorObject
 */
class Item extends Object {
	/**#@+
   	 * @access protected
   	 */
  	/**
   	 * @var string Nazwa obiektu
   	 */
  	var  $_Name;
  	/**
   	 * @var string Krtki opis obiektu
   	 */
  	var  $_DescShort;
  	/**
   	 * @var string Dugi opis obiektu
   	 */
  	var  $_DescLong;
  	/**
   	 * @var array Parametry obiektu
   	 */
  	var  $_Param = array();
    /**#@-*/
	 
  	/**
   	 * Domylna metoda wywoywana podczas inicjalizacji obiektw tej klasy
   	 * @access public
   	 * @param array $itemdata Tablica z danymi o obiekcie
   	 * @return mixed
   	 */
	function Item($itemdata = NULL)
	{
		// Okrelenie domylnej metody obsugi bdw
		$this->setErrorHandling(PEAR_ERROR_CALLBACK, array(&$this, 'errorHandlerItem'));
		
		//Zaadowanie niezbdnych moduw
		global $appCore;
		if (PEAR::isError($err = $appCore->loadModule('Producer'))){echo($appCore->getLastErrorMessage()); exit;}
		
		if (!$itemdata) {return;}
		foreach ($itemdata as $key => $value) { 
			switch (strtolower($key)) {
				case 'itm_id':
					$this->setId($value);
					break;
				case 'usr_id':
					$this->setOwner($value);
					break;
				case 'itm_name':
					$this->setName($value);
					break;
				case 'itm_descshort':
					$this->setDescShort($value);
					break;
				case 'itm_desclong':
					$this->setDescLong($value);
					break;
				case 'itm_createdate':
					$this->setCreateDate($value);
					break;
				case 'itm_lastmodifydate':
					$this->setLastModifyDate($value);
					break;
				case 'itm_active':
					$this->setActive($value);
					break;
			}
		}
		$this->getParamData($_SESSION['CurrentUser']);
	}
  	/**
   	 * Ustawia nazw obiektu
   	 * @access public
   	 * @param string $name Nazwa obiektu
   	 * @return mixed
   	 */
	function setName($name)
	{
		if (PEAR::isError($result = $this->parseVar($name,'string', array(array('not_null'), array('striptags'))))) {
			return $result;
		} else {
			$this->_Name = $name;
		}
	}
  	/**
   	 * Ustawia krtki opis obiektu
   	 * @access public
   	 * @param string $descshort Krtki opis
   	 * @return mixed
   	 */
	function setDescShort($descshort)
	{
		if (PEAR::isError($result = $this->parseVar($descshort,'string', array(array('striptags'))))) {
			return $result;
		} else {
			$this->_DescShort = $descshort;
		}
	}
  	/**
   	 * Ustawia dugi opis obiektu
   	 * @access public
   	 * @param string $desclong Dugi opis
   	 * @return mixed
   	 */
	function setDescLong($desclong)
	{
		if (PEAR::isError($result = $this->parseVar($desclong,'string', array(array('striptags'))))) {
			return $result;
		} else {
			$this->_DescLong = $desclong;
		}
	}
  	/**
   	 * Dodaje nowy parametr do listy parametrw obiektu
   	 * @access public
   	 * @param object $param Parametr obiektu
   	 * @return mixed
   	 */
	function addParam(&$param)
	{
			$param->getParamValue($this->getId());
			$this->_Param[] = $param;
	}
  	/**
   	 * Zwraca nazw obiektu
   	 * @access public
   	 * @return string
   	 */
	function getName(){ return $this->_Name;}
  	/**
   	 * Zwraca krtki opis obiektu
   	 * @access public
   	 * @return string
   	 */
	function getDescShort(){ return $this->_DescShort;}
  	/**
   	 * Zwraca dugi opis obiektu
   	 * @access public
   	 * @return string
   	 */
	function getDescLong(){ return $this->_DescLong;}
  	/**
   	 * Zwraca tablic parametrw obiektu
   	 * @access public
   	 * @return string
   	 */
	function getParams(){ return $this->_Param;}
  	/**
   	 * Zwraca podstawowe informacje o obiekcie
	 * @param object $user Obiekt typu ThorUser, wskazujca na uytkownika
	 * pobierajcego te dane.
	 * @param string $id Identyfikator obiektu, ktrego dane chcemy uzyska.
	 * Warto domylna NULL (pobrane zostan dane wszystkich obiektw)
   	 * @access public
   	 * @return mixed
   	 */
	function getItemData(&$user, $id = NULL) {

		global $appCore; 
		$item_list = array();
		// Ustawienie poprawnego identyfikatora uytkownika oraz kryteriw 
		// wyszukiwania
		if (isSet($id)) {
			if (PEAR::isError($result = Object::parseVar($id,'id'))) { return $result;}
			$where_statement = " WHERE Item.ITM_Id = '$id' AND Item.ITM_Active = 1";
		} else { 
			$where_statement = " WHERE Item.ITM_Active = 1";
		}
		
   		// Pobranie podstawowych informacji o obiektach
   		$sqlquery = "SELECT * FROM Item $where_statement";

		if (DB::isError($result = &$appCore->Query($sqlquery))) {
   			return $result;
   		}

		while ($itemdata = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
			$item_list[] = new Item($itemdata);
		}

		return $item_list;	
	}
  	/**
   	 * Zwraca informacje o parametrach obiektu
	 * @param object $user Obiekt typu ThorUser, wskazujca na uytkownika
	 * pobierajcego te dane.
	 * @param string $paramid Identyfikator parametru, ktrego parametry chcemy 
	 * uzyska.
	 * Warto domylna NULL (pobrane zostan dane wszystkich parametrw obiektu)
   	 * @access public
   	 * @return mixed
   	 */
	function getParamData(&$user, $paramid = NULL) {

		global $appCore; 

		// Ustawienie poprawnego identyfikatora parametru oraz kryteriw 
		// wyszukiwania
		if (isSet($paramid)) {
			if (PEAR::isError($result = Object::parseVar($paramid,'id'))) { return $result;}
			$where_statement = " WHERE itm_has_par.PAR_Id = Parameter.PAR_Id AND itm_has_par.ITM_Id = '" . $this->getId() . "' AND itm_has_par.PAR_Id = '$paramid'";
		} else { 
			$where_statement = " WHERE itm_has_par.PAR_Id = Parameter.PAR_Id AND itm_has_par.ITM_Id = '" . $this->getId() . "'";
		}
		
   		// Pobranie informacji o parametrach obiektu
   		$sqlquery = "SELECT itm_has_par.PAR_Id FROM itm_has_par, Parameter $where_statement";
		if (DB::isError($result = &$appCore->Query($sqlquery))) {
   			return $result;
   		}

		while ($paramid = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
			//if (parent::checkObjectAccess($user, $surveydata['srv_id'], 'r')) {
			if (PEAR::isError($param = Param::getParamData($this, current($paramid)))) { return $param;}
			$this->addParam(current($param));
			//}
		}
		return TRUE;
	}

  	/**
   	 * Metoda zapisujca danego obiektu w bazie danych
   	 *
   	 * @access public
   	 * @param mixed $item Obiekt Item
   	 * @return mixed
   	 */
   	function saveData($item = NULL)
   	{
		global $appCore;

		if ($item == NULL) { $item = &$this;}
		$item->setCreateDate(date(DATE_FORMAT_DBSAVE));

   		// Zapisanie danych
   		if (PEAR::isError($result = saveItem($item))) {
			return $result;
   		} else {
   			return TRUE;
   		}
	} 
  	/**
   	 * Domylna metoda obsugi bdw dla obiektw tej klasy
	 * @param mixed $error Kod bdu
   	 * @access public
   	 * @return mixed
   	 */
	function errorHandlerItem($error) {
	    global $appCore;
		$appCore->handleError($error);
	}
} // Koniec klasy Item

?>