<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+

//Klasa obsugujca sownik symboli walut - Currency
class Currency extends Object {
   /**#@+
   	* @access protected
   	*/
	/**
	 * @var string Identyfikator uytkownika, ktry doda pozycj sownika
	 */
	var $_UserId;
	/**
	 * @var string Nazwa pozycji sownikowej
	 */
	var $_Name;
	/**
	 * @var string Symbol waluty
	 */
	var $_Symbol;
	/**
	 * @var bool Identyfikator domylnoci
	 */
	var $_Default;
	/**
	 * @var string Data ostatniej modyfikacji
	 */
	var $_LastModifyDate;
	/**#@-*/
	 
	/**#@+
   	 * @access public
   	 */
	/**
	 * Konstruktor klasy typw dostaw
	 *    	 
	 * @param array $dictdata Tablica z danymi obiektu sownikowego
	 */
	function Currency($dictdata=array()) {
		// Okrelenie domylnej metody obsugi bdw
		$this->setErrorHandling(PEAR_ERROR_CALLBACK, array(&$this, 'errorHandlerCurrency'));
		//Tworzenie obiektu
		foreach ($dictdata as $key => $value) { 
			switch (strtolower($key)) {
				case 'cur_id':
					$this->setId($value);
				break;
				case 'usr_id':
					$this->setUser($value);
				break;
				case 'cur_name':
					$this->setName($value);
				break;
				case 'cur_symbol':
					$this->setSymbol($value);
				break;
				case 'cur_default':
					$this->setDefault($value);
				break;
				case 'cur_createdate':
					$this->setCreateDate($value);
				break;				
				case 'cur_lastmodifydate':
					$this->setLastModifyDate($value);
				break;
				case 'cur_active':
					$this->setActive($value);
				break;
			}
		}
	}
	/**
	 * Ustawia identyfikator uytkownika, ktry jest wacicielem pozycji sownika
	 *
	 * @param string $userid
	 */
	function setUser($userid) {$this->_UserId = $userid;}
	/**
	 * Ustawia nazw pozycji sownika
	 *
	 * @param string $name
	 */
	function setName($name) {$this->Name = $name;}
	/**
	 * Ustawia symbol waluty
	 *
	 * @param string $symbol
	 */
	function setSymbol($symbol) {$this->_Symbol = $symbol;}
	/**
	 * Ustawia flag domylnoci pozycji sownika
	 *
	 * @param mix $def
	 */
	function setDefault($def) {
		switch (strtolower($def)) {
			case 'true':
			case 't':
			case 1:
			case 'yes':
				$this->_Default = TRUE;
			default: $this->_Default = FALSE;
		}
	}
	/**
	 * Ustawia dat ostatniej modyfikacji
	 *
	 * @param string $lmdate 
	 */
	function setLastModifyDate($lmdate) {$this->_LastModifyDate = $lmdate;}
	/**
	 * Zwraca identyfikator uytkownika, ktry jest wacicielem pozycji sownika
	 *
	 * @return string
	 */
	function getUser() {return $this->_UserId;}
	/**
	 * Zwraca nazw pozycji sownika
	 *
	 * @return string
	 */
	function getName() {return $this->Name;}
	/**
	 * Zwraca symbol waluty
	 *
	 * @return string
	 */
	function getSymbol() {return $this->_Symbol;}
	/**
	 * Zwraca flag domylnoci pozycji sownika
	 *
	 * @ return bool
	 */
	function getDefault() {return $this->_Default;}
	/**
	 * Zwraca dat ostatniej modyfikacji
	 *
	 * @return string
	 */
	function getLastModifyDate() {return $this->_LastModifyDate;}
	/**
	 * Zwraca koszt typu patnoci
	 *
	 * @return float
	 */
	function getPrice() {return $this->_Price;}
	/**
	 * Zwraca obiekt lub obiekty repezentujce pozycje sownika
	 *
	 * @param string $podid Identyfikator pozycji sownika
	 */
	function getData($posid = NULL) {
		//Rdze aplikacji
		global $appCore;
		
	}
	/**
	 * Sprawdza czy obiekt jest obiektem klasy PaymentType
	 *
	 * @param &objectn $object
	 */
	function isCurrencyObject(&$object) {return Object::isClassObject($object, 'Currency');}
	/**
	 * Zapisuje dane obiektu do bazy
	 *
	 * Metoda nie moe by wywoywana statycznie
	 */
	function saveData() {
		//Rdze aplikacji
		global $appCore;
		
		//Przygowanie do zapisu
		$appCore->setTransactionStatus(FALSE);
		if (PEAR::isError($err = Transaction('BEGIN'))) {return $err;}
		$appCore->setTransactionStatus(TRUE);
		
		//Zapisywanie danych ---------------------------------------------
			
			if (Currency::doesCurrencyExist($this->_Id)) {
				//Pozycja sownika istnieje wic bdzie modyfikacja
			} else {
				//Pozycja sownika nie istnieje wic bdzie tworzona od podstaw
				//Generowanie identyfikatora
				$this->generateId();
				
				//Przygotowanie i wykonanie zapytania SQL
				$sqlquery  = 'INSERT INTO Currency (CUR_Id, USR_Id, CUR_Name, CUR_Symbol, CUR_Default, CUR_CreateDate, CUR_LastModifyDate, CUR_Active) ';
				$sqlquery .= 'VALUES ("'.$this->getId().'", "'.$this->getUser().'", "'.$this->getName().'", "'.$this->getSymbol().'", ';
				if ($this->getDefault()) {$sqlquery .= '1';} else {$sqlquery .= '0';} 
				$sqlquery .= ',  CURRENT_TIMESTAMP(0), NULL, ';
				if ($this->getActive()) {$sqlquery .= '1)';} else {$sqlquery .= '0)';}
				if (DB::isError($result = $appCore->Query($sqlquery))) {
					$err =  PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
					if(!isset($this)) {Currency::errorHandlerCurrency($err);}
					return $err;
				}
			}
			
		//Zapisywanie danych ---------------------------------------------
		
		//Proces zapisywania danych zakoczony pomylnie
		if (PEAR::isError($err = Transaction('COMMIT'))) {return $err;}
		$appCore->setTransactionStatus(FALSE);
	}
	/**
	 * Usuwa obiekt z bazy danych
	 *
	 * @param string $id Identyfikator obiektu do usunicia
	 */
	function deleteData($id = NULL) {

		if (!$id) {$id = $this->_Id;}
		//Rdze aplikacji
		global $appCore;
		
		//Sprawdzenie czy obiekt moe by usunity
		Currency::canBeDeleted($id);
	}
	/**
	 * Sprawdza czy obiekt moe by usunity z bazy danych
	 *
	 * Metoda moe by wywoywana tylko statycznie
	 *
	 * @param string $id Identyfikator obiektu do usunicia
	 */
	function canBeDeleted($id) {

		//Rdze aplikacji
		global $appCore;
	}
	/**
	 * Sprawdza czy obiekt istnieje w bazie danych
	 *
	 * @param string $id Identyfikator obiektu
	 * @return mixed Obiekt bool lub PEAR_Error
	 */
	function doesCurrencyExist($id) {
		//Rdze aplikacji
		global $appCore;
		
		//Przygotowanie zapytania SQL
		$sqlquery = 'SELECT CUR_Id FROM Currency WHERE CUR_Id="'.$id.'"';
		if (DB::isError($result = $appCore->Query($sqlquery))) {
			$err =  PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
			if(!isset($this)) {Currency::errorHandlerCurrency($err);}
			return $err;
		}
		
		//Zwracanie wyniku warunku logicznego
		return ($result->numRows()==1);
	}
	
	/**
   	 * Domylna metoda obsugi bdw dla obiektw tej klasy
	 * @param PEAR_Error $error Kod bdu
   	 * @access public
   	 */
	function errorHandlerCurrency($error) {
		//Rdze aplikacji
		global $appCore;

		//Odwoanie transakcji
		if ($appCore->getTransactionStatus()) {
			Transaction('ROLLBACK');
			$appCore->setTransactionStatus(FALSE);
		}
		
		//Standardowa obsuga bdu
		$appCore->handleError($error);
	}
    /**#@-*/
}
?>