<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+

//Niezbdne obiekty i formuje
require_once('../application/user.inc.php'); //Bazowa klasa aplikacji
require_once('address.inc.php');
/**
 * Rozszerzenie klasy ThorUser platformy thorEngine
 * Dziedziczy po klasie ThorUser
 */
class CustomUser extends User {
	/**#@+
   	 * @access protected
   	 */
  	/**
   	 * @var string Numer Identyfikacji Podatkowej (NIP)
   	 */
  	var  $_NIP;
  	/**
   	 * @var string Numer REGON
   	 */
  	var  $_REGON;
  	/**
   	 * @var string Numer PESEL
   	 */
  	var  $_PESEL;
  	/**
     * @var string Telefon komrkowy
     */
  	var  $_cellPhone;
  	/**
     * @var array Tablica obiektw thorAddress (adresw uytkownika)
     */
  	var  $_address = array();
	/**
	 * Liczba zamwie zoonych przez wybranego uytkownika
	 */
	var $_orderCount;
    /**#@-*/
	 
  	/**
   	 * Domylna metoda wywoywana podczas inicjalizacji obiektw tej klasy
   	 * @access public
   	 * @param array $customuserdata Tablica z danymi uytkownika
   	 * @return mixed
   	 */
	function CustomUser($customuserdata = array())
	{	
		// Okrelenie domylnej metody obsugi bdw
		$this->setErrorHandling(PEAR_ERROR_CALLBACK, array(&$this, 'errorHandlerCustomUser'));
		
		//adowanie niezbdnych moduw
		global $appCore;
		if (PEAR::isError($err = $appCore->loadModule('Order'))){echo($appCore->getLastErrorMessage()); exit;}
		
		$this->User(&$customuserdata);
		foreach ($customuserdata as $key => $value) { 
			switch (strtolower($key)) {
				case 'uinfo_email':
					$this->setEmail($value);
					break;
				case 'uinfo_name':
					$this->setName($value);
					break;
				case 'uinfo_lastname':
					$this->setLastName($value);
					break;
				case 'uinfo_nip':
					$this->setNIP($value);
					break;
				case 'uinfo_regon':
					$this->setREGON($value);
					break;
				case 'uinfo_pesel':
					$this->setPESEL($value);
					break;
				case 'uinfo_cellphone':
					$this->setCellPhone($value);
					break;
			}
		}
		$this->getAddressData($this);
		$this->getOrderCount();
	}
  	/**
   	 * Metoda logujca uytkownika w serwisie
   	 *
   	 * @access public
   	 * @param string $login
   	 * @param string $password
   	 * @return mixed
   	 */
   	function Logon($login, $password)
   	{
		//Rdze aplikacji
		global $appCore;
			
   		// Autoryzowanie uytkownika	
   		if (PEAR::isError($result = autorize($login, $password))) {
			switch ($result->getCode()) {
				case '-505':
				case '-503':
				case '-504':
				case '-509':
					if (!isset($this)) {$appCore->handleError($result);} 
					return $result;
				break;
			}
			//return //PEAR::raiseError($result->getMessage(), -508, null, null, PEAR_LOG_NOTICE);
   		}
		// Pobranie danych zautoryzowanego uytkownika
   		$sqlquery =  "SELECT USR_Id, USR_Type, Users.UINFO_Email, USR_Password, ";
		$sqlquery .= "UNIX_TIMESTAMP(USR_CreateDate) as USR_CreateDate, ";
		$sqlquery .= "UNIX_TIMESTAMP(USR_ActivateByUser) as USR_ActivateByUser, ";
		$sqlquery .= "UNIX_TIMESTAMP(USR_LastModifyDate) as USR_LastModifyDate, ";
		$sqlquery .= "UNIX_TIMESTAMP(USR_LastLoginDate) as USR_LastLoginDate, ";
		$sqlquery .= "UNIX_TIMESTAMP(USR_LoginFailedDate) as USR_LoginFailedDate, ";
		$sqlquery .= "USR_WrongPasswordCount, USR_MustChangePassword, USR_Active, UINFO_Name, UINFO_LastName, UINFO_NIP, UINFO_Regon, UINFO_PESEL, UINFO_CellPhone, UINFO_Active  ";
		$sqlquery .= "FROM Users, UserInfo WHERE USR_Id='$login' AND Users.UINFO_Email = UserInfo.UINFO_Email";
		if (DB::isError($result = $appCore->Query($sqlquery))) {
			return PEAR::raiseError($result->getMessage(), -500, null, null, PEAR_LOG_NOTICE);
		}
		if ($customuserdata = $result->fetchRow(DB_FETCHMODE_ASSOC)) {
			// Utworzenie obiektu CustomUser i zalogowanie uzytkownika
			$currentUser = new CustomUser($customuserdata);
			return $currentUser;			
		} else {
			return PEAR::raiseError($userLogin, -3, null, null, PEAR_LOG_NOTICE);
		}			
   	}
  	/**
   	 * Metoda rejestrujca nowe konto uytkownika w serwisie
   	 *
   	 * @access public
   	 * @param mixed $account
   	 * @param string $password
   	 * @return mixed
   	 */
   	function Register(&$account, &$password) {return registerUser($account, $password);}
	/**
	 * Metoda uaktywniajca konto istniejce w serwisie typu C
	 *
	 * @param string $_activate Identyfikator aktywujcy
	 * @return mixed Identyfikator uytkownika lub obiekt PEAR_Error
	 */
	function ActivateAccount($_activate) { return activateUser($_activate);}
	/**
	 * Sprtawdza czy konto usera zosto aktywowane
	 */
	function isUserAccountActivted() {
		//Rdze aplikacji
		global $appCore;
		
		//Tworzenie i wykonanie zapytania SQL
		$sqlquery = 'SELECT USR_ActivateByUser FROM Users WHERE USR_Id="'.$this->_Id.'"';
		if (DB::isError($result = $appCore->Query($sqlquery))) {
			return PEAR::raiseError($result->getMessage(), -500, null, null, PEAR_LOG_NOTICE);
		}
		if ($data = $result->fetchRow()) {
			return $data[0];
		}
		return 0;
	}
  	/**
   	 * Ustawia numer NIP uytkownika
   	 * @access public
   	 * @param string $nip Numer NIP
   	 * @return mixed
   	 */
	function setNIP($nip)
	{
		$this->_NIP = $nip;
	}
  	/**
   	 * Ustawia numer REGON uytkownika
   	 * @access public
   	 * @param string $regon Numer REGON
   	 * @return mixed
   	 */
	function setREGON($regon)
	{
		$this->_REGON = $regon;
	}
  	/**
   	 * Ustawia numer PESEL uytkownika
   	 * @access public
   	 * @param string $pesel Numer PESEL
   	 * @return mixed
   	 */
	function setPESEL($pesel)
	{
		$this->_PESEL = $pesel;
	}
  	/**
   	 * Ustawia numer telefonu komrkowego uytkownika
   	 * @access public
   	 * @param string $cellphone Numer telefonu komrkowego
   	 * @return mixed
   	 */
	function setCellPhone($cellphone)
	{
		$this->_CellPhone = $cellphone;
	}
  	/**
   	 * Dodaje nowy adres do listy adresw uytkownika
   	 * @access public
   	 * @param object $address Adres uytkownika
   	 * @return mixed
   	 */
	function addAddress($address)
	{
		$this->_address[] = $address;
	}
  	/**
   	 * Zwraca numer NIP uytkownika
   	 * @access public
   	 * @return string
   	 */
	function getNIP(){ return $this->_NIP;}
  	/**
   	 * Zwraca numer REGON uytkownika
   	 * @access public
   	 * @return string
   	 */
	function getREGON(){ return $this->_REGON;}
  	/**
   	 * Zwraca numer PESEL uytkownika
   	 * @access public
   	 * @return string
   	 */
	function getPESEL(){ return $this->_PESEL;}
  	/**
   	 * Zwraca numer telefonu komrkowego uytkownika
   	 * @access public
   	 * @return string
   	 */
	function getCellPhone(){ return $this->_cellPhone;}
	/**
	 * Zwraca liczb zamwie uytkownika
	 * 
	 * @param bool $refresh Ustawienie na TRUE powoduje zaadowanie informacji z bazy danych
	 * @return integer
	 */
 	function getUsersList($status = 'all') {
		//Rdze aplikacji
		global $appCore;

		//Tablica uytkownikw
		$usrList = NULL;
		
		//Przygotowywanie zapytania SQL		
		$sqlquery = 'SELECT USR_Id, UINFO_Email, USR_CreateDate, USR_LastModifyDate, USR_LastLoginDate, USR_Active FROM Users WHERE USR_Type="C"';
		switch($status) {
			case 'active':
				$sqlquery .= ' AND USR_Active=1';
			break;
			case 'unactive':
				$sqlquery .= ' AND USR_Active=0';
			break;
			case 'unactiveregistered':
				$sqlquery .= ' AND USR_ActivateByUser=0';
			break;
		}
		$sqlquery .= ' ORDER BY USR_CreateDate';
		//Wykonanie zapytania SQL
		if (DB::isError($result = $appCore->Query($sqlquery))) {
			return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
		}
		while($usrdata = $result->fetchRow(DB_FETCHMODE_ASSOC)) {
			$usrList[] = new CustomUser($usrdata);
		}
		
		return $usrList;
	}
	/**
	 * Zwraca liczb zamwie uytkownika
	 */
	function getOrderCount($refresh=FALSE) {
		if ($refresh) {
			$this->getDataOrderCount();
			return $this->_orderCount;
		} else {
			if(!$this->_orderCount) {
				$this->getDataOrderCount();
				return $this->_orderCount;
			} else {
				return $this->_orderCount;
			}
		}
	}
  	/**
   	 * Zwraca podstawowe informacje o uytkowniku
	 * @param object $user Obiekt typu ThorUser, wskazujca na uytkownika
	 * pobierajcego te dane.
	 * @param string $id Identyfikator uytkownika, ktrego dane chcemy uzyska.
	 * Warto domylna NULL (pobrane zostan dane wszystkich uytkownikw)
   	 * @access public
   	 * @	return mixed
   	 */
	function getUserData($id) {

		//Rdze aplikacji
		global $appCore; 

   		// Pobranie podstawowych informacji o uytkowniku
   		$sqlquery = 'SELECT USR_Id, USR_Type, Users.UINFO_Email, UNIX_TIMESTAMP(USR_CreateDate) as USR_CreateDate, UNIX_TIMESTAMP(USR_LastModifyDate) as USR_LastModifyDate, UNIX_TIMESTAMP(USR_LastLoginDate) as USR_LastLoginDate, USR_Active, UINFO_Name, UINFO_LastName, UINFO_NIP, UINFO_Regon, UINFO_PESEL, UINFO_CellPhone FROM Users, UserInfo WHERE Users.UINFO_Email = UserInfo.UINFO_Email AND Users.USR_Id = "'.$id.'"';
		if (DB::isError($result = $appCore->Query($sqlquery))) {return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);}
		$users_list = NULL;
		if ($userdata = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
			$users_list = new CustomUser($userdata);
		}

		return $users_list;	
	}
  	/**
   	 * Zwraca informacje o adresach uytkownika
	 * @param object $user Obiekt typu ThorUser, wskazujca na uytkownika
	 * pobierajcego te dane.
	 * @param string $addressid Identyfikator adresu, ktrego dane chcemy uzyska.
	 * Warto domylna NULL (pobrane zostan dane wszystkich adresw uytkownika)
   	 * @access public
   	 * @return mixed
   	 */
	function getAddressData(&$user, $addressid = NULL) {

		global $appCore; 

		// Ustawienie poprawnego identyfikatora adresu oraz kryteriw 
		// wyszukiwania
		if (isSet($addressid)) {
			if (PEAR::isError($result = thorObject::parseVar($addressid,'id'))) { return $result;}
			$where_statement = " WHERE usr_has_addr.ADDR_Id = Address.ADDR_Id AND usr_has_addr.UINFO_Email = '" . $this->getEmail() . "' AND usr_has_addr.ADDR_Id = '$addressid'";
		} else { 
			$where_statement = " WHERE usr_has_addr.ADDR_Id = Address.ADDR_Id AND usr_has_addr.UINFO_Email = '" . $this->getEmail() . "'";
		}
		
   		// Pobranie informacji o adresach uytkownika
   		$sqlquery = "SELECT usr_has_addr.ADDR_Id FROM usr_has_addr, Address $where_statement";

		if (DB::isError($result = &$appCore->Query($sqlquery))) {
   			return $result;
   		}

		while ($addressid = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
			//if (parent::checkObjectAccess($user, $surveydata['srv_id'], 'r')) {
			if (PEAR::isError($address = Address::getAddressData($this, current($addressid)))) { return $address;}
			$this->addAddress($address);
			//}
		}
		return TRUE;
	}
	
	function deleteUserData() {
		//Rdze aplikacji
		global $appCore;
				
		//Zabezpieczenie przed prb usunicia uytkownika publicznego
		if ($this->_Type!='C') {return PEAR::raiseError(NULL, -531, null, null, PEAR_LOG_ERR);}
		
		//Zerowanie zmiennej transakcyjnej
		$appCore->setTransactionStatus(FALSE);
		
		//Rozpoczcie transakcji
		if (PEAR::isError($err = Transaction('BEGIN'))) {return $err;}
		//Transakcja zostaa rozpoczta
		$appCore->setTransactionStatus(TRUE);
		
		//Proces usuwania danych uytkownika z systemu------------------------
		
			//Usunicie danych z tabeli powizanej
			$sqlquery = 'DELETE FROM usr_has_addr WHERE UINFO_Email="'.$this->getEmail().'"';
			if (DB::isError($result = $appCore->Query($sqlquery))) {return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);}			
			
			//Usunicie adressu
			if($this->_address[0]) {
				$sqlquery = 'DELETE FROM Address WHERE ADDR_Id="'.$this->_address[0]->getId().'"';
				if (DB::isError($result = $appCore->Query($sqlquery))) {return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);}
			}
		
			//Usunicie uytkownika z tabeli users
			$sqlquery = 'DELETE FROM Users WHERE USR_Id="'.$this->_Id.'"';
			if (DB::isError($result = $appCore->Query($sqlquery))) {return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);}
			
			//Usunicie uytkownika z tabeli userinfo
			$sqlquery = 'DELETE FROM UserInfo WHERE UINFO_Email="'.$this->getEmail().'"';
			if (DB::isError($result = $appCore->Query($sqlquery))) {return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);}

		//Proces usuwania danych uytkownika z systemu------------------------
		
		//Zakoczenie transakcji
		if (PEAR::isError($err = Transaction('COMMIT'))) {return $err;}
		//Transakcja zostaa zakoczona pomylnie
		$appCore->setTransactionStatus(FALSE);
	}
	/**
	 * Zwraca liczb zamwie zoonych przez wybranego uytkownika pobierajc dane z bazy danych
	 */
	function getDataOrderCount() {
		if (!PEAR::isError($ordCount = Order::getUserOrderCount($this->_Id))) {
			$this->_orderCount = $ordCount;
		} else {
			$this->_orderCount = NULL;
		}
	}
	/**
	 * Zachowanie danych uytkownika (zmiana aktywnoci)
	 */
	function saveData() {
		//Rdzen aplikacji
		global $appCore;
		
		$sqlquery = 'UPDATE Users SET USR_CreateDate=USR_CreateDate, USR_LastModifyDate=CURRENT_TIMESTAMP(0), USR_Active="'.$this->_Active.'" WHERE USR_Id="'.$this->_Id.'"';
		if (DB::isError($result = $appCore->Query($sqlquery))) {return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);}		
	}
  	/**
   	 * Domylna metoda obsugi bdw dla obiektw tej klasy
	 * @param mixed $error Kod bdu
   	 * @access public
   	 * @return mixed
   	 */
	function errorHandlerCustomUser($error) {
	    //Rdze aplikacji
		global $appCore;
		
		//Odwoanie transakcji
		if ($appCore->getTransactionStatus()) {
			Transaction('ROLLBACK');
			$appCore->setTransactionStatus(FALSE);
		}
		
		$appCore->handleError($error);
	}
}
?>