<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+

//Zaadowanie niezbdnych moduw
global $appCore;
if (PEAR::isError($err = $appCore->loadModule('State'))){echo($appCore->getLastErrorMessage()); exit;}
if (PEAR::isError($err = $appCore->loadModule('Country'))){echo($appCore->getLastErrorMessage()); exit;}

/**
 * Klasa adresu uytkownika
 * Dziedziczy po klasie ThorObject
 */
class Address extends Object {
	/**#@+
   	 * @access protected
   	 */
  	/**
   	 * @var object Typ adresu - obiekt klasy thorAddressType
   	 */
  	var  $_addressType;
  	/**
   	 * @var object Wojewdztwo - obiekt klasy thorAddressState
   	 */
  	var  $_state;
  	/**
   	 * @var object Kraj - obiekt klasy thorAddressCountry
   	 */
  	var  $_country;
  	/**
     * @var string Miasto
     */
  	var  $_city;
  	/**
     * @var string Kod pocztowy
     */
  	var  $_ZIP;
  	/**
     * @var string Nazwa ulicy
     */
  	var  $_streetName;
  	/**
     * @var string Numer ulicy
     */
  	var  $_streetNr;
  	/**
     * @var string Numer domu
     */
  	var  $_homeNr;
  	/**
     * @var string Numer telefonu
     */
  	var  $_phone;
  	/**
     * @var string Numer faxu
     */
  	var  $_fax;
    /**#@-*/
	 
  	/**
   	 * Domylna metoda wywoywana podczas inicjalizacji obiektw tej klasy
   	 * @access public
   	 * @param array $addressdata Tablica z danymi o adresie
   	 * @return mixed
   	 */
	function Address($addressdata = NULL)
	{
		// Okrelenie domylnej metody obsugi bdw
		$this->setErrorHandling(PEAR_ERROR_CALLBACK, array(&$this, 'errorHandlerAddress'));
		
		if(!$addressdata) {return;}
		foreach ($addressdata as $key => $value) { 
			switch (strtolower($key)) {
				case 'addr_id':
					$this->setId($value);
					break;
				case 'adt_id':
					$this->setAddressType($value);
					break;
				case 'st_id':
					$this->setState($value);
					break;
				case 'cry_id':
					$this->setCountry($value);
					break;
				case 'addr_streetname':
					$this->setStreetName($value);
					break;
				case 'addr_streetnr':
					$this->setStreetNr($value);
					break;
				case 'addr_homenr':
					$this->setHomeNr($value);
					break;
				case 'addr_city':
					$this->setCity($value);
					break;
				case 'addr_zip':
					$this->setZIP($value);
					break;
				case 'addr_phone':
					$this->setPhone($value);
					break;
				case 'addr_fax':
					$this->setFax($value);
					break;
				case 'addr_createdate':
					$this->setCreateDate($value);
					break;
				case 'addr_lastmodifydate':
					$this->setLastModifyDate($value);
					break;
				case 'addr_active':
					$this->setActive($value);
					break;
			}
		}
	}
  	/**
   	 * Ustawia typ adresu
   	 * @access public
   	 * @param object $addresstype Typ adresu
   	 * @return mixed
   	 */
	function setAddressType($addresstype)
	{
		$this->_addressType = current(AddressType::getData($addresstype));
	}
  	/**
   	 * Ustawia wojewdztwo
   	 * @access public
   	 * @param object $addressstate Wojewdztwo
   	 * @return mixed
   	 */
	function setState($addressstate)
	{
		$this->_state = current(State::getData($addressstate));
	}
  	/**
   	 * Ustawia kraj
   	 * @access public
   	 * @param object $addresscountry Kraj
   	 * @return mixed
   	 */
	function setCountry($addresscountry)
	{
		$this->_country = current(Country::getData($addresscountry));
	}
  	/**
   	 * Ustawia nazw ulicy
   	 * @access public
   	 * @param string $streetname Nazwa ulicy
   	 * @return mixed
   	 */
	function setStreetName($streetname)
	{
		$this->_streetName = $streetname;
	}
  	/**
   	 * Ustawia numer ulicy
   	 * @access public
   	 * @param string $streetnr Numer ulicy
   	 * @return mixed
   	 */
	function setStreetNr($streetnr)
	{
		$this->_streetNr = $streetnr;
	}
  	/**
   	 * Ustawia numer domu
   	 * @access public
   	 * @param string $homenr Numer domu
   	 * @return mixed
   	 */
	function setHomeNr($homenr)
	{
		$this->_homeNr = $homenr;
	}
  	/**
   	 * Ustawia nazw miasta
   	 * @access public
   	 * @param string $city Nazwa miasta
   	 * @return mixed
   	 */
	function setCity($city)
	{
		$this->_city = $city;
	}
  	/**
   	 * Ustawia kod pocztowy
   	 * @access public
   	 * @param string $zip Kod pocztowy
   	 * @return mixed
   	 */
	function setZIP($zip)
	{
		$this->_ZIP = $zip;
	}
  	/**
   	 * Ustawia numer telefonu
   	 * @access public
   	 * @param string $phone Numer telefonu
   	 * @return mixed
   	 */
	function setPhone($phone)
	{
		$this->_phone = $phone;
	}
  	/**
   	 * Ustawia numer faxu
   	 * @access public
   	 * @param string $fax Numer faxu
   	 * @return mixed
   	 */
	function setFax($fax)
	{
		$this->_fax = $fax;
	}
  	/**
   	 * Zwraca typ adresu
   	 * @access public
   	 * @return object
   	 */
	function getAddressType(){ return $this->_addressType;}
  	/**
   	 * Zwraca wojewdztwo
   	 * @access public
   	 * @return object
   	 */
	function getState(){ return $this->_state;}
  	/**
   	 * Zwraca kraj
   	 * @access public
   	 * @return object
   	 */
	function getCountry(){ return $this->_country;}
  	/**
   	 * Zwraca nazw ulicy
   	 * @access public
   	 * @return string
   	 */
	function getStreetName(){ return $this->_streetName;}
  	/**
   	 * Zwraca numer ulicy
   	 * @access public
   	 * @return string
   	 */
	function getStreetNr(){ return $this->_streetNr;}
  	/**
   	 * Zwraca numer domu
   	 * @access public
   	 * @return string
   	 */
	function getHomeNr(){ return $this->_homeNr;}
  	/**
   	 * Zwraca miasto
   	 * @access public
   	 * @return string
   	 */
	function getCity(){ return $this->_city;}
  	/**
   	 * Zwraca kod pocztowy
   	 * @access public
   	 * @return string
   	 */
	function getZIP(){ return $this->_ZIP;}
  	/**
   	 * Zwraca numer telefonu
   	 * @access public
   	 * @return string
   	 */
	function getPhone(){ return $this->_phone;}
  	/**
   	 * Zwraca numer faxu
   	 * @access public
   	 * @return string
   	 */
	function getFax(){ return $this->_fax;}
  	/**
   	 * Zwraca podstawowe informacje o adresie
	 * @param object $user Obiekt typu ThorUser, wskazujca na uytkownika
	 * pobierajcego te dane.
	 * @param string $addressid Identyfikator adresu, ktrego dane chcemy uzyska.
   	 * @access public
   	 * @return mixed
   	 */
	function getAddressData(&$user, $addressid) {

		global $appCore; 

		// Ustawienie poprawnego identyfikatora adresu oraz kryteriw 
		// wyszukiwania
		if (PEAR::isError($result = Object::parseVar($addressid,'id'))) { return $result;}
		$where_statement = " WHERE Address.ADDR_Id = '$addressid' AND Address.ADDR_Active = 1";
		
   		// Pobranie podstawowych informacji o uytkowniku
   		$sqlquery = "SELECT * FROM Address $where_statement";

		if (DB::isError($result = &$appCore->Query($sqlquery))) {
   			return $result;
   		}

		if ($addressdata = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
			$address = new Address($addressdata);
		}

		if (isSet($address)) {
			return $address;	
		} else { return PEAR::raiseError($addressid, -3, null, null, PEAR_LOG_NOTICE);}
	}
  	/**
   	 * Metoda zapisujca dane adresu w bazie danych
   	 *
   	 * @access public
   	 * @param mixed $address Obiekt Address
   	 * @return mixed
   	 */
   	function saveData($address = NULL)
   	{
		global $appCore;

		if ($address == NULL) { $address = &$this;}
		$address->setCreateDate(date(DATE_FORMAT_DBSAVE));

   		// Zapisanie danych
   		if (PEAR::isError($result = saveAddress($address))) {
			return $result;
   		} else {
   			return TRUE;
   		}
	} 
  	/**
   	 * Metoda uaktualniajca dane adresu w bazie danych
   	 *
   	 * @access public
   	 * @param mixed $address Obiekt Address
   	 * @return mixed
   	 */
   	function updateData($address = NULL)
   	{
		global $appCore;

		if ($address == NULL) { $address = &$this;}
		$address->setLastModifyDate(date(DATE_FORMAT_DBSAVE));

   		// Zaktualizowanie danych
   		if (PEAR::isError($result = updateAddress($address))) {
			return $result;
   		} else {
   			return TRUE;
   		}
	} 
  	/**
   	 * Metoda usuwajca dany adres z bazy danych
   	 *
   	 * @access public
   	 * @param string $addressid Identyfikator obiektu
   	 * @return mixed
   	 */
   	function deleteData($addressid = NULL)
   	{
		global $appCore;

		if ($addressid == NULL) { $addressid = &$this->getId();}

   		// Usunicie danych
   		if (PEAR::isError($result = deleteAddress($addressid))) {
			return $result;
   		} else {
   			return TRUE;
   		}
	} 
  	/**
   	 * Domylna metoda obsugi bdw dla obiektw tej klasy
	 * @param mixed $error Kod bdu
   	 * @access public
   	 * @return mixed
   	 */
	function errorHandlerAddress($error) {
	    global $appCore;
		$appCore->handleError($error);
	}
} // Koniec klasy thorAddress

/**
 * Klasa typu adresu
 * Dziedziczy po klasie Object
 * @package thorSklep
 * @author Sebastian Marek <sebastian@thornet.net>
 * @version $Id: address.inc.php,v 1.2 2004/06/25 06:54:42 proofek Exp $
 * @copyright Copyright &copy; 2004, thorNET
 */
class AddressType extends Object {
	/**#@+
   	 * @access protected
   	 */
  	/**
   	 * @var string Nazwa typu
   	 */
  	var  $_Name;
    /**#@-*/
	 
  	/**
   	 * Domylna metoda wywoywana podczas inicjalizacji obiektw tej klasy
   	 * @access public
   	 * @param array $addressdata Tablica z danymi o adresie
   	 * @return mixed
   	 */
	function AddressType($addresstypedata = NULL)
	{
		// Okrelenie domylnej metody obsugi bdw
		$this->setErrorHandling(PEAR_ERROR_CALLBACK, array(&$this, 'errorHandlerAddressType'));
		if(!$addresstypedata) {return;}
		foreach ($addresstypedata as $key => $value) { 
			switch (strtolower($key)) {
				case 'adt_id':
					$this->setId($value);
					break;
				case 'usr_id':
					$this->setOwner($value);
					break;
				case 'adt_name':
					$this->setName($value);
					break;
				case 'adt_createdate':
					$this->setCreateDate($value);
					break;
				case 'adt_lastmodifydate':
					$this->setLastModifyDate($value);
					break;
				case 'adt_active':
					$this->setActive($value);
					break;
			}
		}
	}
  	/**
   	 * Ustawia nazw typu adresu
   	 * @access public
   	 * @param string $name Nazwa typu
   	 * @return mixed
   	 */
	function setName($name)
	{
		$this->_Name = $name;
	}
  	/**
   	 * Zwraca nazw typu adresu
   	 * @access public
   	 * @return string
   	 */
	function getName(){ return $this->_Name;}
  	/**
   	 * Zwraca informacje o typie adresu
	 * @param string $typeid Identyfikator typu adresu, ktrego dane chcemy uzyska.
	 * Warto domylna NULL (pobrane zostan dane wszystkich typw)
	 * @param string $filter Filtr wyboru danych:
	 *						 - 'active' - aktywne wiersze (warto domylna)
	 *						 - 'nonactive' - nieaktywne wiersze
	 *						 - 'all' - wszystkie wiersze
   	 * @access public
   	 * @return mixed
   	 */
	function getData($typeid = NULL, $filter = 'active') {

		global $appCore; 
		$type_list = array();
		// Ustawienie poprawnego identyfikatora typu adresu oraz kryteriw 
		// wyszukiwania
		switch ($filter) {
			case 'active':
				$where_active = 'AddressType.ADT_Active = 1';
				break;
			case 'nonactive':
				$where_active = 'AddressType.ADT_Active = 0';
				break;
			case 'all':
				$where_active = '(AddressType.ADT_Active = 0 OR AddressType.ADT_Active = 1)';
				break;
			default:
				$where_active = 'AddressType.ADT_Active = 1';
		}
		if (isSet($typeid)) {
			if (PEAR::isError($result = Object::parseVar($typeid,'id'))) { return $result;}
			$where_statement = " WHERE AddressType.ADT_Id = '$typeid' AND $where_active";
		} else {
			$where_statement = " WHERE $where_active";
		}
		
   		// Pobranie podstawowych informacji o typie adresu
   		$sqlquery = "SELECT * FROM AddressType $where_statement ORDER BY ADT_Name";
		if (DB::isError($result = &$appCore->Query($sqlquery))) {
   			return $result;
   		}

		while ($typedata = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
			$type_list[] = new AddressType($typedata);
		}
		return $type_list;
	}
  	/**
   	 * Metoda zapisujca dane typu adresu w bazie danych
   	 *
   	 * @access public
   	 * @param mixed $addresstype Obiekt AddressType
   	 * @return mixed
   	 */
   	function saveData($addresstype = NULL)
   	{
		global $appCore;

		if ($addresstype == NULL) { $addresstype = &$this;}
		$addresstype->setCreateDate(date(DATE_FORMAT_DBSAVE));

   		// Zapisanie danych
   		if (PEAR::isError($result = saveAddressType($addresstype))) {
			return $result;
   		} else {
   			return TRUE;
   		}
	} 
  	/**
   	 * Metoda uaktualniajca dane typu adresu w bazie danych
   	 *
   	 * @access public
   	 * @param mixed $adt Obiekt AddressType
   	 * @return mixed
   	 */
   	function updateData($adt = NULL)
   	{
		global $appCore;

		if ($adt == NULL) { $adt = &$this;}
		$adt->setLastModifyDate(date(DATE_FORMAT_DBSAVE));

   		// Zaktualizowanie danych
   		if (PEAR::isError($result = updateAddressType($adt))) {
			return $result;
   		} else {
   			return TRUE;
   		}
	} 
  	/**
   	 * Metoda usuwajca dany typ adresu z bazy danych
   	 *
   	 * @access public
   	 * @param string $adtid Identyfikator obiektu
   	 * @return mixed
   	 */
   	function deleteData($adtid = NULL)
   	{
		global $appCore;

		if ($adtid == NULL) { $adtid = &$this->getId();}

   		// Usunicie danych
   		if (PEAR::isError($result = deleteAddressType($adtid))) {
			return $result;
   		} else {
   			return TRUE;
   		}
	} 
	/**
	 * Przygotowuje tablica parametrw dla pola comboBox moduu formularza
	 *
	 * @param &array &$resArray Tablica, ktra bdzie zawiera list pozycji 
	 * sownikowych
	 * @param string $filter Filtr wyboru danych:
	 *						 - 'active' - aktywne wiersze (warto domylna)
	 *						 - 'nonactive' - nieaktywne wiersze
	 *						 - 'all' - wszystkie wiersze
	 * @param string $selId
	 */
	function prepareComboBoxValues(&$resArray, $filter = 'active', $selId=NULL) {
		//Rdze aplikacji
		global $appCore;
				
		// Ustawienie poprawnych kryteriw wyszukiwania
		switch ($filter) {
			case 'active':
				$where_active = 'AddressType.ADT_Active = 1';
				break;
			case 'nonactive':
				$where_active = 'AddressType.ADT_Active = 0';
				break;
			case 'all':
				$where_active = '(AddressType.ADT_Active = 0 OR AddressType.ADT_Active = 1)';
				break;
			default:
				$where_active = 'AddressType.ADT_Active = 1';
		}

		//Przygotowanie zapytania SQL
		$sqlquery = 'SELECT ADT_Id, ADT_Name FROM AddressType $where_active';

		if (DB::isError($result = $appCore->Query($sqlquery))) {
			$err =  PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
			if(!isset($this)) {AddressType::errorHandlerAddressType($err);}
			return $err;
		}

		//Tworzenie tablicy 
		while($row = $result->fetchRow()) {
			if ($selId == $row[0]) {
				$resArray[] = array($row[0], $row[1], TRUE);
			} else {
				$resArray[] = array($row[0], $row[1]);
			}
		}
	}
  	/**
   	 * Domylna metoda obsugi bdw dla obiektw tej klasy
	 * @param mixed $error Kod bdu
   	 * @access public
   	 * @return mixed
   	 */
	function errorHandlerAddressType($error) {
	    global $appCore;
		$appCore->handleError($error);
	}
} // Koniec klasy AddressType

?>