<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+
require_once(APP_CORE_PATH.'object.inc.php');
class Catalog extends Object {
	/**
	 * Identyfikator kategorii nadrzdnej
	 */
	var $_Parent;
	/**
	 * Nazwa kategorii
	 */
	var $_Name;
	/**
	 * Tablica podkategorii
	 */
	var $_SubCategory;
	
	/**
	 * Konstruktor
	 */
	function Catalog($catdata = array()) {
	
		// Okrelenie domylnej metody obsugi bdw
		$this->setErrorHandling(PEAR_ERROR_CALLBACK, array(&$this, 'errorHandlerCatalog'));
			
		$this->_SubCategory = NULL;
		//Tworzenie obiektu
		foreach ($catdata as $key => $value) { 
			switch (strtolower($key)) {
				case 'cat_id':
					$this->setId($value);
				break;
				case 'cat_parent':
					$this->setParent($value);
				break;
				case 'cat_name':
					$this->setName($value);
				break;
				case 'cat_desc':
					$this->setDesc($value);
				break;
				case 'cat_createdate':
					$this->setCreateDate($value);
				break;
				case 'cat_lastmodifydate':
					$this->setLastModifyDate($value);
				break;
				case 'cat_active':
					$this->setActive($value);
				break;
			}
		}

	}

	/**
	 * Ustawia identyfikator katregorii nadrzdnej
	 */
	function setParent($parent) {$this->_Parent = $parent;}
	/**
	 * Ustawia nazw kategorii
	 */
	function setName($name) {$this->_Name = $name;}
	/**
	 * Ustawia tbalic podkategorii
	 */
	function setSubCategory($subcat) {$this->_SubCategory = $subcat;}
	/**
	 * Zwraca identyfgikator kategorii nadrzdnej
	 */
	function getParent() { return $this->_Parent;}
	/**
	 * Zwraca nazw kategorii
	 */
	function getName() { return $this->_Name;}
	/**
	 * Zwraca tablic podkategorii
	 */
	function getSubCategory() {return $this->_SubCategory;}
	/**
	 * Metoda zwraca liczb produktw znajdujcych si w kategori
	 * oraz jej podkategoriach
	 *
	 * @return Integer
	 */
	function getCategoryProductsNumber() {
		//Rdze aplikacji
		global $appCore;
				
		$tempPrd = new Product();
		if (PEAR::isError($er = $tempPrd->getProductNumber($this->_Id))) {return 0;}
		return $er;
	}
	
	/**
	 * Zwraca obiekt kategorii
	 */
	function getCategoryData($catId, $cols = NULL) {
		//Rdze aplikacji
		global $appCore;
		
		//Budowa zapytania SQL
		$sqlquery = 'SELECT ';
		if(!$cols || count($cols)==0) {$cols = array('CAT_Id', 'CAT_Parent', 'CAT_Name', 'CAT_Desc', 'CAT_CreateDate', 'CAT_LastModifyDate', 'CAT_Active');}
		for($iter=0; $iter<count($cols)-1; $iter++) {
			$sqlquery .= $cols[$iter].', ';
		}
		$sqlquery .= $cols[count($cols)-1];
		$sqlquery .= ' FROM Category WHERE CAT_id="'.$catId.'"';
		
		//Wykonanie zapytania SQL
		if (DB::isError($result = $appCore->Query($sqlquery))) {return PEAR::raiseError($result->getMessage().';'.$sqlquery.';'.$user->getId(), -500, null, null, PEAR_LOG_ERR);}
		if($catdata = $result->fetchRow(DB_FETCHMODE_ASSOC)) {
			return new Catalog($catdata);
		}
		
	}
	/**
	 * Zwraca podkategorie
	 */
	function getCatalogSubStructure($parent, $active = 'active', $substruct=FALSE) {
		//Rdze aplikacji
		global $appCore;
		
		
		//Tablica obiektw katalogrii
		$strArray = array();
		
		$sqlquery = 'SELECT CAT_Id, CAT_Parent, CAT_Name, CAT_Desc, CAT_CreateDate, CAT_LastModifyDate, CAT_Active FROM Category WHERE ';
		if(!$parent) {
			$sqlquery .= 'CAT_Parent is NULL';
		} else {
			$sqlquery .= 'CAT_Parent = "'.$parent.'"';
		}
		if ($active=='active') { 
			$sqlquery .= ' AND CAT_Active=1';
		} else if ($active=='unactive') {
			$sqlquery .= ' AND CAT_Active=0';
		}
		$sqlquery .= ' ORDER BY CAT_Name';
			
		//Wykonanie zapytania SQL
		if (DB::isError($result = $appCore->Query($sqlquery))) {
			return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, NULL, NULL, PEAR_LOG_ERR);
		}
		
		while ($catdata = $result->fetchRow(DB_FETCHMODE_ASSOC)) {
			$strObj = new Catalog($catdata);
			if($substruct) {$strObj->setSubCategory($strObj->getCatalogSubStructure($strObj->getId(), $active));}
			$strArray[] = $strObj;
		}		
		return $strArray;
	}
	/**
	 * Zwraca struktur katalogow
   	 */
	function getCatalogStructure($active = 'active', $substruct=TRUE) {
		return $this->getCatalogSubStructure(NULL, $active, $substruct);
	}
	/**
	 *  Zwraca liczb podkategorii
	 */	
	function getCategorySubCategoriesNumer($catId = NULL) {
		//Rdze aplikacji
		global $appCore;
		
		//Tworzenie zapytania SQL
		if (!$catId) { $catId = $this->_Id;}
		$sqlquery = 'SELECT Count(CAT_Id) FROM Category where CAT_Parent="'.$catId.'"';
		
		//Wykonanie zapytania SQL
		if (DB::isError($result = $appCore->Query($sqlquery))) {
			return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
		}
		$catdata = $result->fetchRow();
		return $catdata[0];
	}
	
	/**
	 * Usuwa kategori
	 */
	function deleteData() {
		//Rdze aplikacji
		global $appCore;
		
		//Zerowanie zmiennej transakcyjnej
		$appCore->setTransactionStatus(FALSE);
		
		//Rozpoczcie transakcji
		if (PEAR::isError($err = Transaction('BEGIN'))) {return $err;}
		//Transakcja zostaa rozpoczta
		$appCore->setTransactionStatus(TRUE);
		
		//Usuwanie danych z bazy danych------------------------------
			$sqlquery = 'DELETE FROM Category WHERE CAT_Id="'.$this->_Id.'"';
			if (DB::isError($result = $appCore->Query($sqlquery))) {return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);}
		//Usuwanie danych z bazy danych------------------------------
		
		
		//Zakoczenie transakcji
		if (PEAR::isError($err = Transaction('COMMIT'))) {return $err;}
		//Transakcja zostaa zakoczona pomylnie
		$appCore->setTransactionStatus(FALSE);
	}
	/**
	 * Zapisuje kategori
	 */
	function saveData() {
		//Rdze aplikacji
		global $appCore;
		
		//Zerowanie zmiennej transakcyjnej
		$appCore->setTransactionStatus(FALSE);
		
		//Rozpoczcie transakcji
		if (PEAR::isError($err = Transaction('BEGIN'))) {return $err;}
		//Transakcja zostaa rozpoczta
		$appCore->setTransactionStatus(TRUE);
		
		//Wprowadzanie danych do bazy------------------------------
		
			//Sprawdzenie czy istnieje odpowiedni identyfikator kategorii
			$sqlquery = 'SELECT CAT_Id from Category where Cat_Id="'.$this->_Id.'"';
			//Wykonanie zapytania SQL
			if (DB::isError($result = $appCore->Query($sqlquery))) {return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);}
			
			if ($result->numRows()==0) {
				//Nie istnieje podany identyfikator. Kategoria jest tworzona
				$this->generateId();
				//Tworzenie kategorii
				$sqlquery = 'INSERT INTO Category (CAT_Id, CAT_Parent, CAT_Name, CAT_Desc, CAT_CreateDate, CAT_LastModifyDate, CAT_Active) VALUES ("'.$this->_Id.'", ';
				if($this->_Parent!='main') {$sqlquery .= '"'.$this->_Parent.'"';} else {$sqlquery .= 'NULL';}
				$sqlquery .= ', "'.$this->_Name.'", "'.$this->_Desc.'", CURRENT_TIMESTAMP(0), CURRENT_TIMESTAMP(0), ';
				if ($this->_Active) {$sqlquery .= '1)';} else {$sqlquery .= '0)';}

				//Wykonanie zapytania SQL
				if (DB::isError($result = $appCore->Query($sqlquery))) {return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);}
				
			} else { //Kategoria jest modyfikowana
				
				$sqlquery = 'UPDATE Category set CAT_Name="'.$this->_Name.'", CAT_Desc="'.$this->_Desc.'", CAT_LastModifyDate=CURRENT_TIMESTAMP(0), CAT_CreateDate=CAT_CreateDate, ';
				if ($this->_Active) {$sqlquery .= 'CAT_Active=1';} else {$sqlquery .= 'CAT_Active=0';}
				$sqlquery .= ' WHERE CAT_Id="'.$this->_Id.'"';
				
				//Wykonanie zapytania SQL
				if (DB::isError($result = $appCore->Query($sqlquery))) {return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);}
			}
		
		//Wprowadzanie danych do bazy------------------------------
		
		
		//Zakoczenie transakcji
		if (PEAR::isError($err = Transaction('COMMIT'))) {return $err;}
		//Transakcja zostaa zakoczona pomylnie
		$appCore->setTransactionStatus(FALSE);
	}
	/**
	 * Metoda sprawdza czy kategoria istnieje
	 */
	function categoryExists($catid) {
		//Rdze aplikacji
		global $appCore;
		
		$sqlquery = 'SELECT CAT_Id from Category where CAT_Id = "'.$catid.'"';
		//Wykonanie zapytania SQL
		if (DB::isError($result = $appCore->Query($sqlquery))) {PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR); return FALSE;}
		if($result->numRows() >0) {return TRUE;}
		return FALSE;
		
	}
	/**
   	 * Domylna metoda obsugi bdw dla obiektw tej klasy
	 * @param PEAR_Error $error Kod bdu
   	 * @access public
   	 */
	function errorHandlerCatalog($error) {
		//Rdze aplikacji
	    global $appCore;

		
		//Odwoanie transakcji
		if ($appCore->getTransactionStatus()) {
			Transaction('ROLLBACK');
			$appCore->setTransactionStatus(FALSE);
		}
		
		$appCore->handleError($error);
	}
}
?>