<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+
require_once('xml_element.php');
/**
 * Klasa reprezentujca obiekt dokumentu XML
 */
class XML_DomDoc extends PEAR {
    
	/**#@+
	 * @access private
	 */
    /**
	 * @var resource(xml_parser) Standardowy parser XML
	 */
	var $_pXML;
	/**
	 * @var int Uchwyt pliku
	 */
	var $_fileHandler;
	/**
	 * @var &XML_Element Obiekt wykorzystywany przy generowaniu struktury dokumentu XML
	 */
	var $_actElem;
	/**#@-*/
	/**#@+
	 * @access protected
	 */
	/**
	 * @var string Nazwa pliku
	 */
	var $_fileName;
	/**
	 * @var XML_Element Gowny element obiektu dokumentu XML (tzw. element dokumentu)
	 */
	var $documentElement;
	/**#@-*/
//-------------------------------------------------
//Konstruktor i destruktor-------------------------
//-------------------------------------------------
	/**
	 * Konstruktor klasy
	 */
	function XML_DomDoc($enc = null) {
	    //Tworzenie i inicjacja parsera XML
	    $this->_pXML = xml_parser_create($enc);
		xml_set_object($this->_pXML, &$this);
		xml_set_element_handler($this->_pXML, '_startTagFunc', '_endTagFunc');
	}	
//-------------------------------------------------
//Metody prywatne----------------------------------
//-------------------------------------------------
    /**#@+
	 * @access private
	 */ 
    /**
     * Metoda obsugujca zdarzenie otwarcia elementu XML
	 * 
	 * Metoda w parametrze $_name otrzymuje nazw elementu, natomiast w
	 * parametrze $_attrs otrzymuje tablic zawieraj atrybuty elementu
	 *
	 * @param xml_parser $_parser
	 * @param string $_name
	 * @param array $_attrs
     */
    function _startTagFunc($_parser, $_name, $_attrs) {
	    if(!$this->documentElement) {
	        //Tworzenie gownego obiektu dokumentu XML
	        $this->documentElement = new XML_Element($_name, $_attrs);
			$this->_actElem = &$this->documentElement;
	    } else if($this->_actElem) {
		    //Tworzenie pozostaych elementw dokumentu XML
		    $this->_actElem->childNodes[] = new XML_Element($_name, $_attrs);
			$tCount = count($this->_actElem->childNodes)-1;
			$this->_actElem->childNodes[$tCount]->parentNode = &$this->_actElem;
			$this->_actElem = &$this->_actElem->childNodes[$tCount];
		}
    }
    /**
     * Metoda obsugujca zdarzenie zamknicia elementu XML
	 *
	 * Metoda w parametrze $_name otrzymuje nazw elementu
	 *
	 * @param xml_parser $_parser
	 * @param string $_name
     */
    function _endTagFunc($_parser, $_name) {
	   $this->_actElem = &$this->_actElem->parentNode;
    }
	/**
	 * Metoda wykonujca parsowanie dokumentu XML z pliku
	 */
	function _parseXML () {
	    while ($data = fread($this->_fileHandler, 4096)) {
            if (!xml_parse($this->_pXML, $data, feof($this->_fileHandler))) {
			   return PEAR::raiseError(xml_error_string(xml_get_error_code($this->_pXML)).', '.xml_get_current_line_number($this->_pXML));
            }
        }
	}
	/**
	 * Metoda wykorzystywana przy zapisie pliku XML
	 *
	 * Metoda zapisuje do pliku dane elemetu XML, ktry jest przekazywany jako parametr przy wywoaniu metody
	 *
	 * @param XML_Element $xmlElem
	 */
	function writeElem($xmlElem) {
	   fwrite($this->_fileHandler, '<'.strtolower($xmlElem->name));
	   for($iter = 0; $iter < count($xmlElem->attributes); $iter++) {
	       fwrite($this->_fileHandler, ' '.strtolower($xmlElem->attributes[$iter][0]).'="'.strtolower($xmlElem->attributes[$iter][1]).'"');
	   }
	   if(count($xmlElem->childNodes)>0) {
	       fwrite($this->_fileHandler,'>');
		   foreach($xmlElem->childNodes as $obj) {
		       $this->writeElem($obj);
		   }
	       fwrite($this->_fileHandler, '</'.strtolower($xmlElem->name).'>');
	   } else {
	       fwrite($this->_fileHandler, '/>');
	   }
	   
	}
	/**#@-*/
//-------------------------------------------------
//Metody publiczne---------------------------------
//-------------------------------------------------	
   /**#@+
	 * @access public
	 */ 
	/**
	 * Metoda tworzy XMLa na bazie stringu
	 */
	function createDOMXML($xmlString) {
			if (!xml_parse($this->_pXML, $xmlString)) {
			   return PEAR::raiseError(xml_error_string(xml_get_error_code($this->_pXML)).', '.xml_get_current_line_number($this->_pXML));
            }
	}
	/**
	 * Metoda adujca dokument XML z pliku i tworzca obiekt dokumentu
	 *
	 * @param string $fileName
	 */
	function loadFromFile($fileName) {
	    
		$this->_fileName = $fileName;
	    
		//Zabezpieczenie przed bdem
		if (!file_exists($fileName)) {return PEAR::raiseError($fileName, -401, null, null, PEAR_LOG_ERR);}
        if (!($this->_fileHandler = fopen($fileName, "r"))) {return PEAR::raiseError($fileName, -402, null, null, PEAR_LOG_ERR);}
	 
		//Uruchomienie parsowania
		$err = $this->_parseXML();
		xml_parser_free($this->_pXML);
		fclose($this->_fileHandler);
		return $err;
	}
	/**
	 * Metoda zwraca nazw pliku XML
	 */
	function getFileName() {
	    return $this->_fileName;
	}
	/**
	 * Metoda zapisuje dokument XML do pliku na dysku
	 *
	 * Metoda (przy wywoaniu metody prywatnej writeElem) tworzy plik XML
	 * na podstawie obiektu dokumentu XML
	 *
	 * @param string fileName
	 */
	function saveToFile($fileName) {

		//Otwarcie pliku do zapisu
        //if (!($this->_fileHandler = fopen($fileName, "w"))) {return PEAR::raiseError('Nie mona otworzy pliku');}
		$this->_fileHandler = fopen($fileName, "w");
		
		//Deklaracja pliku XML
		fwrite($this->_fileHandler, '<?xml version="1.0" encoding="utf-8"?>');
		
		//Wywoanie dla elementu dokumentu
		$this->writeElem($this->documentElement);
		
		//Zamknicie
		fclose($this->_fileHandler);
	}
	/**#@-*/
}
?>