<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+
require_once('PEAR.php');
require_once('object.inc.php');

/**
 * Klasa uytkownika platformy thorEngine
 * Dziedziczy po klasie Object
 */
class User extends Object {
	/**#@+
   	 * @access protected
   	 */
	/**
	 * @var String Typ uytkownika
	 */
	var $_Type;
  	/**
   	 * @var string Nazwisko uytkownika
   	 */
  	var  $_LastName;
  	/**
   	 * @var string Imi uytkownika
   	 */
  	var  $_Name;
  	/**
     * @var string Haso uytkownika
     */
  	var  $_Password;
  	/**
   	 * @var string Adres e-mail uytkownika
   	 */
  	var  $_Email;
  	/**
   	 * @var string Data utworzenia konta
   	 */
  	var  $_CreateDate;
  	/**
   	 * @var string Data ostatniej modyfikacji konta
   	 */
  	var  $_LastModifyDate;
  	/**
   	 * @var string Data ostatniego poprawnego logowania
   	 */
  	var  $_LastLoginDate;
  	/**
   	 * @var string Data ostatniego niepoprawnego logowania
   	 */
  	var  $_LoginFailedDate;
  	/**
   	 * @var int Liczba niepoprawnych logowa
   	 */
  	var  $_WrongPasswordCount;
  	/**
   	 * @var bool Flaga zmuszajca uytkownika do zmiany hasa
   	 */
  	var  $_MustChangePassword;
  	/**
   	 * @var bool Tablica z uprawnieniami
   	 */
    /**#@-*/
	 
  	/**
   	 * Domylna metoda wywoywana podczas inicjalizacji obiektw tej klasy
   	 * @access public
   	 * @param array $userdata Tablica z danymi uytkownika
   	 * @return mixed
   	 */
	function User($userdata = NULL)
	{
		// Okrelenie domylnej metody obsugi bdw
		$this->setErrorHandling(PEAR_ERROR_CALLBACK, array(&$this, 'errorHandlerUser'));
		
		//adowanie niezbdnych moduw
		global $appCore;
		if (PEAR::isError($err = $appCore->loadModule('Order'))){echo($appCore->getLastErrorMessage()); exit;}
		
		if (!$userdata) {return;}
		foreach ($userdata as $key => $value) { 
			switch (strtolower($key)) {
				case 'usr_id':
					$this->setId($value);
					break;
				case 'usr_type':
					$this->setType($value);
					break;
				case 'uinfo_email':
					$this->setEmail($value);
					break;
				case 'usr_createdate':
					$this->setCreateDate($value);
					break;
				case 'usr_lastmodifydate':
					$this->setLastModifyDate($value);
					break;
				case 'usr_lastlogindate':
					$this->setLastLoginDate($value);
					break;
				case 'usr_loginfaileddate':
					$this->setLoginFailedDate($value);
					break;
				case 'usr_wrongpasswordcount':
					$this->setWrongPasswordCount($value);
					break;
				case 'usr_mustchangepassword':
					$this->setMustChangePassword($value);
					break;
				case 'usr_active':
					$this->setActive($value);
					break;
			}
		}
	}
  	/**
   	 * Metoda logujca uytkownika w serwisie
   	 *
   	 * Domylnie tworzony jest nowy obiekt z pustymi wasnociami. Jeeli parametrem 
   	 * konstruktora bdzie istniejca w bazie danych nazwa uytkownika, z bazy danych
   	 * zostana pobrane wszystkie dane na jego temat.
   	 * @access public
   	 * @param string $login
   	 * @param string $password
   	 * @param mixed $user
   	 * @return mixed
   	 */
   	function Logon($login, $password, &$user)
   	{
		//Rdze aplikacji
		global $appCore;

   		// Autoryzowanie uytkownika	
   		if (PEAR::isError($result = $appCore->autorize($login, $password))) {
   			return $result;
   		}
		
		if (current($user_autorized = $result->fetchRow()) != '') {
			// Pobranie danych zautoryzowanego uytkownika
	   		$sqlquery = "SELECT USR_Id, USR_Type, UINFO_Email, USR_Password, UNIX_TIMESTAMP(USR_CreateDate) as USR_CreateDate, UNIX_TIMESTAMP(USR_ActivateByUser) as USR_ActivateByUser, UNIX_TIMESTAMP(USR_LastModifyDate) as USR_LastModifyDate, UNIX_TIMESTAMP(USR_LastLoginDate) as USR_LoginFailedDate, USR_WrongPasswordCount, USR_MustChangePassword, USR_Active FROM Users WHERE USR_Id='$login'";
   			if (DB::isError($result = $appCore->Query($sqlquery))) {
   				return $result;
   			}
			if ($userdata = $result->fetchRow(DB_FETCHMODE_ASSOC)) {
				// Utworzenie obiektu User i zalogowanie uzytkownika
				$currentUser = new ThorUser($userdata);
   				return $currentUser;			
			} else {
				return PEAR::raiseError($login, -3, null, null, PEAR_LOG_NOTICE);
			}			
		} else {
			return PEAR::raiseError($login, current($user_autorized), null, null, PEAR_LOG_INFO);
		}
   	}
  	/**
   	 * Metoda rejestrujca nowe konto uytkownika w serwisie
   	 *
   	 * @access public
   	 * @param mixed $account
   	 * @param string $password
   	 * @param mixed $user
   	 * @return mixed
   	 */
   	function Register(&$account, &$password, &$user)
   	{
		//Rdze aplikacji
		global $appCore;
		
		
   		// Rejestracja nowego konta uytkownika
   		if (PEAR::isError($result = $appCore->registerUser(&$account, &$password))) {
   			return $result;
   		}
		if (current($account_created = $result->fetchRow()) != '') {
			if (current($account_created) == -506) {
				return PEAR::raiseError($account->getId(), -506, null, null, PEAR_LOG_NOTICE);
			}	
			$localErrObj = $appCore->getErrorObject();

			if (mail($account->getEmail(), $localErrObj->getCustomMsg('reg_mail','title'), $localErrObj->getCustomMsg('reg_mail','message'), $localErrObj->getCustomMsg('reg_mail','headers'))) {
				return TRUE;
			} else {
				return PEAR::raiseError($account->getId(), -5000, null, null, PEAR_LOG_NOTICE);
			}

		} else {
			return PEAR::raiseError($account->getId(), -3, null, null, PEAR_LOG_NOTICE);
		}			
		$result->free();
	}
	/**
	 * Ustawia typ uytkownika. A - administrator, P - Uytkownik pybliczny, C - Klient
	 * Jeeli warto atrybutu podanego w wywoaniu nie jest jedn z powyszych, to domylnie przyjmowana jest warto C
	 *
	 * @param $userType String Typ uytkownika
	 */
	function setType($userType) {
		switch ($userType) {
			case 'A':
				$this->_Type = 'A';
			break;
			case 'P':
				$this->_Type = 'P';
			break;
			default:
				$this->_Type = 'C';
			break;
		}
	}
  	/**
   	 * Ustawia nazwisko uytkownika
   	 * @access public
   	 * @param string $lastname Nazwisko
   	 * @return mixed
   	 */
	function setLastName($lastname)
	{
		if ($lastname <> NULL) {
			$this->_LastName = $lastname;
			return TRUE;
		} else { return -2;}
	}
  	/**
   	 * Ustawia imi uytkownika
   	 * @access public
   	 * @param string $name Imi
   	 * @return mixed
   	 */
	function setName($name)
	{
		if ($name <> NULL) {
			$this->_Name = $name;
			return TRUE;
		} else { return -2;}
	}
  	/**
   	 * Ustawia haso uytkownika
   	 * @access public
   	 * @param string $password Haso
   	 * @return mixed
   	 */
	function setPassword($password)
	{
		if ($password <> NULL) {
			$this->_Password = $password;
			return TRUE;
		} else { return -2;}
	}
  	/**
   	 * Ustawia adres e-mail uytkownika
   	 * @access public
   	 * @param string $email Adres e-mail
   	 * @return mixed
   	 */
	function setEmail($email)
	{
		if ($email <> NULL) {
			$this->_Email = $email;
			return TRUE;
		} else { return -2;}
	}
  	/**
   	 * Ustawia dat utworzenia konta
   	 * @access public
   	 * @param string $createdate Data
   	 * @return mixed
   	 */
	function setCreateDate($createdate)
	{
		if ($createdate <> NULL) {
			$this->_CreateDate = $createdate;
			return TRUE;
		} else { return -2;}
	}
  	/**
   	 * Ustawia dat ostatniej modyfikacji konta
   	 * @access public
   	 * @param string $lastmodifydate Data
   	 * @return mixed
   	 */
	function setLastModifyDate($lastmodifydate)
	{
		if ($lastmodifydate <> NULL) {
			$this->_LastModifyDate = $lastmodifydate;
			return TRUE;
		} else { return -2;}
	}
  	/**
   	 * Ustawia dat ostatniego poprawnego logowania uytkownika
   	 * @access public
   	 * @param string $lastlogindate Data
   	 * @return mixed
   	 */
	function setLastLoginDate($lastlogindate)
	{
		if ($lastlogindate <> NULL) {
			$this->_LastLoginDate = $lastlogindate;
			return TRUE;
		} else { return -2;}
	}
  	/**
   	 * Ustawia dat ostatniego niepoprawnego logowania uytkownika
   	 * @access public
   	 * @param string $loginfaileddate Data
   	 * @return mixed
   	 */
	function setLoginFailedDate($loginfaileddate)
	{
		if ($loginfaileddate <> NULL) {
			$this->_LoginFailedDate = $loginfaileddate;
			return TRUE;
		} else { return -2;}
	}
  	/**
   	 * Ustawia liczb niepoprawnych logowa uytkownika
   	 * @access public
   	 * @param int $wrongpasswdcount Liczba niepoprawnych logowa
   	 * @return mixed
   	 */
	function setWrongPasswordCount($wrongpasswordcount)
	{
		if ($wrongpasswordcount <> NULL) {
			$this->_WrongPasswordCount = $wrongpasswordcount;
			return TRUE;
		} else { return -2;}
	}
  	/**
   	 * Ustawia flag wymuszajc zmian hasa
   	 * @access public
   	 * @param bool $mustchangepassword Flaga TRUE albo FALSE
   	 * @return mixed
   	 */
	function setMustChangePassword($mustchangepassword)
	{
		switch (strtolower($mustchangepassword)) {
			case 'true':
			case 't':
			case 1:
			case 'yes':
				$this->_MustChangePassword = 't';
				return TRUE;
			case 'false':
			case 'f':
			case 0:
			case 'no':
				$this->_MustChangePassword = 'f';
				return TRUE;
			default: return -4;
		}
	}
	/**
	 * Metoda zwraca typ uytkownika
	 *
	 * @return string
 	 */
	function getType() { return $this->_Type;}
   	/**
   	 * Zwraca nazwisko uytkownika
   	 * @access public
   	 * @return string
   	 */
	function getLastName(){ return $this->_LastName;}
  	/**
   	 * Zwraca imi uytkownika
   	 * @access public
   	 * @return string
   	 */
	function getName(){ return $this->_Name;}
  	/**
   	 * Zwraca haso uytkownika
   	 * @access public
   	 * @return string
   	 */
	function getPassword(){ return $this->_Password;}
  	/**
   	 * Zwraca adres e-mail uytkownika
   	 * @access public
   	 * @return string
   	 */
	function getEmail(){ return $this->_Email;}
  	/**
   	 * Zwraca dat utworzenia konta
	 *
	 * @param bool $timestamp Ustawnienie na TRUE powiduje zwrcenie daty, bez formatowania
   	 * @return string
   	 */
	function getCreateDate($timestamp=FALSE){
		if ($timestamp) {return $this->_CreateDate;} 
		return strftime(DATE_FORMAT_DISP, $this->_CreateDate);
	}
  	/**
   	 * Zwraca dat ostatniej modyfikacji konta
   	 * @return string
   	 */
	function getLastModifyDate(){return strftime(DATE_FORMAT_DISP, $this->_LastModifyDate);}
  	/**
   	 * Zwraca dat ostatniego poprawnego logowania uytkownika
   	 * @return string
   	 */
	function getLastLoginDate(){ return strftime(DATE_FORMAT_DISP, $this->_LastLoginDate);}
	/**
   	 * Zwraca dat ostatniego niepoprawnego logowania uytkownika
   	 * @access public
   	 * @return string
   	 */
	function getLoginFailedDate(){return strftime(DATE_FORMAT_DISP, $this->_LoginFailedDate);}
  	/**
   	 * Zwraca liczb niepoprawnych logowa uytkownika
   	 * @access public
   	 * @return int
   	 */
	function getWrongPasswordCount(){ return $this->_WrongPasswordCount;}
  	/**
   	 * Zwraca flag zmuszajc uytkownika do zmiany hasa
   	 * @access public
	 * @param string $mode Format zwracanej wartoci:
	 * ('basic' - dane zwracane w taki sposb, w jaki zapisane s w bazie danych;
	 *   'boolean' (domylny) - zwraca wartoci typu boolean - TRUE albo FALSE;
 	 *   'extended' - zwraca opis wartoci - 'Tak' albo 'Nie')
   	 * @return mixed
   	 */
	function getMustChangePassword($mode = 'boolean')
	{ 
		// Zgodnosc ze Smarty
		if (is_array($mode)) { $mode = current($mode);}

		switch($mode) {
			case 'basic': return $this->_MustChangePassword;
			case 'boolean':
				switch ($this->_MustChangePassword) {
					case 't':
					case 'T': return TRUE;
					case 'f':
					case 'F': return FALSE;
					default: return NULL;
				}
			case 'extended':
				switch ($this->_MustChangePassword) {
					case 't':
					case 'T': return 'Tak';
					case 'f':
					case 'F': return 'Nie';
					default: return NULL;
				}
			default: return NULL;
		}
	}
  	/**
   	 * Zwraca podstawowe informacje o uytkowniku
	 * @param object $user Obiekt typu ThorUser, wskazujca na uytkownika
	 * pobierajcego te dane.
	 * @param string $id Identyfikator uytkownika, ktrego dane chcemy uzyska.
	 * Warto domylna NULL (pobrane zostan dane wszystkich uytkownikw)
   	 * @access public
   	 * @return mixed
   	 */
	function getUserData($id) {
		//Rdze aplikacji
		global $appCore;
	
   		// Pobranie podstawowych informacji o uytkowniku
   		$sqlquery = 'SELECT USR_Id, UINFO_Email, UNIX_TIMESTAMP(USR_CreateDate) as USR_CreateDate, UNIX_TIMESTAMP(USR_LastModifyDate) as USR_LastModifyDate, UNIX_TIMESTAMP(USR_LastLoginDate) as USR_LastLoginDate, USR_Active FROM Users WHERE USR_Id="'.$id.'"';

   		if (DB::isError($result = $appCore->Query($sqlquery))) {
   			return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
   		}
		$users_list = NULL;
		while ($userdata = $result->fetchRow(DB_FETCHMODE_ASSOC)) {
			$userData = new User($userdata);
		}
		return $userData;	
	}
	/**
	 * Zaraca list uytkownikw
	 *
	 * @param bool $customer Warto TRUE powoduje, e zwracani s jedynie uytkownicy tyypu C
	 */
	function getUsersList($customer = TRUE) {
		//Rdze aplikacji
		global $appCore;
		
		//Tablica uytkownikw
		$usrList = NULL;
		
		//Przygotowywanie zapytania SQL		
		$sqlquery = 'SELECT USR_Id, UINFO_Email, USR_CreateDate, USR_LastModifyDate, USR_LastLoginDate, USR_Active FROM Users';
		if ($customer) {$sqlquery .= ' WHERE USR_Type="C" ';} $sqlquery .= ' ORDER BY USR_CreateDate';
		//Wykonanie zapytania SQL
		if (DB::isError($result = $appCore->Query($sqlquery))) {
			return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
		}
		while($usrdata = $result->fetchRow(DB_FETCHMODE_ASSOC)) {
			$usrList[] = new User($usrdata);
		}
		
		return $usrList;
	}
	/**
	 * Metoda sprawdza czy uytkownik o podanym identyfikatorze istnieje
	 */
	function doesUserExists($userId=NULL, $usrEmail = NULL) {
		//Rdze aplikacji
		global $appCore;
		
		if ($userId) {
			$sqlquery = 'SELECT USR_Id FROM Users WHERE USR_Id="'.$userId.'"';
			if (DB::isError($result = $appCore->Query($sqlquery))) {return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);}
			if ($result->numROws()>0) {return TRUE;} else {return FALSE;}
		} else if ($usrEmail) {
			$sqlquery = 'SELECT UINFO_Email FROM Users WHERE UINFO_Email="'.$usrEmail.'"';
			if (DB::isError($result = $appCore->Query($sqlquery))) {return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);}
			if ($result->numROws()>0) {return TRUE;} else {return FALSE;}
		}
		return FALSE;
	}
	/**
	 * Sprawdza czy uytkownik moe by usunity
	 * 
	 * @param string $usrId Identyfikator uytkownika do usunicia
	 */
	function canBeUserDeleted($usrId) {
		//Rdze aplikacji
		global $appCore;
		
		//Pobranie obiektu uytkownika
		$userToDelete = User::getUserData($usrId);
		if ($userToDelete->getType() != 'C') {
			//Tylko uytkownicy Customers mog by usnici
			return FALSE;
		}
		
		//Sprawdzanie czy uytkownik nie zoy jakiego zamwienia
		if (PEAR::isError($err = $appCore->loadModule('Order'))){echo($appCore->getLastErrorMessage()); exit;}
		if (Order::getUserOrderCount($usrId)>0) {
			//Uytkownik nie moe by usunity poniewa zoy zamwienia
			//w systemie
			return FALSE;
		}
		//Uytkownik moe by usunity
		return TRUE;
	}
  	/**
   	 * Domylna metoda obsugi bdw dla obiektw tej klasy
	 * @param mixed $error Kod bdu
   	 * @access public
   	 * @return mixed
   	 */
	function errorHandlerUser($error) {
	    global $appCore;
		$appCore->handleError($error);
	}
}
?>