<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+

require_once('PEAR.php');
/**
 * Klasa bazowa dla wszystkich obiektw uywanych do obsugi platformy thorEngine
 * dziedziczca z klasy PEAR'a
 */
class Object extends PEAR
{
	/**#@+
   	 * @access protected
   	 */
  	/**
   	 * @var string Unikalny identyfikator obiektu (32 znaki).
   	 */
  	var  $_Id;
  	/**
   	 * @var string Identyfikator waciciela obiektu.
   	 */
  	var  $_Owner;
  	/**
   	 * @var string Typ obiektu (wszystkie typy przechowywane s w bazie danych)
   	 */
  	var  $_Type;
  	/**
   	 * @var string Opis obiektu
   	 */
  	var  $_Desc;
  	/**
   	 * @var string Data utworzenia obiektu
   	 */
  	var  $_CreateDate;
  	/**
   	 * @var string Data ostatniej modyfikacji obiektu
   	 */
  	var  $_LastModifyDate;
  	/**
   	 * @var bool Aktywno obiektu
   	 * (TRUE - obiekt jest aktywny
   	 *  FALSE - obiekt jest niekatywny)
   	 */
  	var  $_Active;
    /**#@-*/

  	/**
   	 * Domylna metoda wywoywana podczas inicjalizacji obiektw tej klasy
   	 * @access public
   	 */
	function Object()
	{
		// Okrelenie domylnej metody obsugi bdw
		$this->setErrorHandling(PEAR_ERROR_CALLBACK, array(&$this, 'errorHandlerObject'));
	}
  	/**
   	 * Ustawia unikalny identyfikator obiektu
   	 * @access public
   	 * @param string $id Unikalny identyfikator
   	 * @return bool
   	 */
	function setId($id){$this->_Id = $id;}
  	/**
   	 * Ustawia identyfikator waciciela obiektu
   	 * @access public
   	 * @param string $id Identyfikator
   	 * @return bool
   	 */
	function setOwner($id)
	{
		if ($id <> NULL) {
			$this->_Owner = $id;
			return TRUE;
		} else { return FALSE;}
	}
  	/**
   	 * Ustawia typ obiektu. Lista dostpnych typw zdefiniowana jest w bazie danych
   	 * @access public
   	 * @param string $type_name Nazwa typu
   	 * @return bool
   	 */
	function setObjectType($type_name)
	{
		if ($type_name <> NULL) {
			$this->_Type = $type_name;
			return TRUE;
		} else { return FALSE;}
	}
  	/**
   	 * Ustawia opis obiektu
   	 * @access public
   	 * @param string $desc Tre opisu
   	 * @return bool
   	 */
	function setDesc($desc)
	{
		if (PEAR::isError($result = $this->parseVar($desc,'string', array(array('htmlspecialchars'), array('striptags'))))) {
			return $result;
		} else {
			$this->_Desc = $desc;
		}
	}
  	/**
   	 * Ustawia dat utworzenia obiektu
   	 * @access public
   	 * @param string $createdate Data
   	 * @return mixed
   	 */
	function setCreateDate($createdate)
	{
		if ($createdate <> NULL) {
			$this->_CreateDate = $createdate;
			return TRUE;
		} else { return -2;}
	}
  	/**
   	 * Ustawia dat ostatniej modyfikacji obiektu
   	 * @access public
   	 * @param string $lastmodifydate Data
   	 * @return mixed
   	 */
	function setLastModifyDate($lastmodifydate)
	{
		if ($lastmodifydate <> NULL) {
			$this->_LastModifyDate = $lastmodifydate;
			return TRUE;
		} else { return -2;}
	}
  	/**
   	 * Ustawia aktywno obiektu
   	 * @access public
   	 * @param string $active Aktywno
   	 * moliwe wartoci true:false, t:f, 1:0, yes:no
   	 * (parametry niewraliwe na wielko liter)
   	 * @return bool
   	 */
	function setActive($active)
	{
		switch (strtolower($active)) {
			case 'true':
			case 't':
			case 1:
			case 'yes':
				$this->_Active = 1;
				return TRUE;
			case 'false':
			case 'f':
			case 0:
			case 'no':
				$this->_Active = 0;
				return TRUE;
			default: return -4;
		}
	}
  	/**
   	 * Zwraca unikalny identyfikator obiektu
   	 * @access public
   	 * @return string
   	 */
	function getId(){ return $this->_Id;}
  	/**
   	 * Zwraca identyfikator waciciela obiektu
   	 * @access public
   	 * @return string
   	 */
	function getOwner(){ return $this->_Owner;}
  	/**
   	 * Zwraca typ obiektu
   	 * @access public
   	 * @return string
   	 */
	function getObjectType(){ return $this->_Type;}
  	/**
   	 * Zwraca opis obiektu
   	 * @access public
   	 * @return string
   	 */
	function getDesc(){ return $this->_Desc;}
  	/**
   	 * Zwraca dat utworzenia obiektu
   	 * @access public
   	 * @return string
   	 */
	function getCreateDate($formDate = FALSE){ 
		if($formDate) {
			return strftime(DATE_FORMAT_DISP, $this->_CreateDate);
		} else {
			return $this->_CreateDate;
		}
	}
  	/**
   	 * Zwrac	a dat ostatniej modyfikacji obiektu
   	 * @access public
   	 * @return string
   	 */
	function getLastModifyDate(){ 
		///if (($ts = strtotime ($this->_LastModifyDate)) > 0) {
		//	return strftime('%d-%m-%Y %H:%M', strtotime ($this->_LastModifyDate));	 
		//} else { return NULL;}
		return $this->_LastModifyDate;
	}
  	/**
   	 * Zwraca aktywno obiektu
   	 * @access public
	 * @param string $mode Format zwracanej wartoci:
	 * ('basic' - dane zwracane w taki sposb, w jaki zapisane s w bazie danych;
	 *  'extended' (domylny) - zwraca wartoci typu boolean - TRUE albo FALSE)
	 *  'verbose' - zwraca wartoci w postaci dajcej si wywietli na ekranie)
   	 * @return mixed
   	 */
	function getActive($mode = 'extended') { 
		switch ($mode) {
			case 'basic': return $this->_Active;
			case 'extended':
				switch (strval($this->_Active)) {
					case TRUE:
					case 1:
					case 'true':
					case 't':
					case 'T': return 1;
					case 0: 
					case FALSE:
					case 'false':
					case 'f':
					case 'F': return 0;
					default: return NULL;
				}
			case 'verbose':
				switch ($this->_Active) {
					case TRUE:
					case 'true':
					case 't':
					case 'T': return 'Tak';
					case FALSE:
					case 'false':
					case 'f':
					case 'F': return 'Nie';
					default: return NULL;
				}
			default: return NULL;
		}
	}
	/**
	 * Metoda generuje losow warto identyfikatora obiektu
	 */
	function generateId() {
		$this->_Id = md5(uniqid(rand()));
	}
	/**
	 * Sprawdza czy obiekt jest obiektem danej klasy
	 *
	 * @param object $object
	 * @param string $className
	 */
	function isClassObject(&$object, $className) {return is_a($object, $className);}
  	/**
   	 * Sprawdza i zwraca zmienn pozbawion niebezpiecznych znakw
	 * @param mixed $variable Zmienna, ktr chcemy sprawdzi
	 * @param mixed $variable_type Typ, jaki zmienna powinna mie
	 * - array - tablica
	 * - boolean - warto logiczna
	 * - double - liczba zmiennoprzecinkowa
	 * - integer - liczba staoprzecinkowa
	 * - object - obiekt
	 * - string - cig znakw
	 * - id - identyfikator (cig znakw alfanumerycznych o dugoci 32 znakw)
	 * @param array $param Tablica z wytycznymi jak sprawdza zmienn
	 * - not_null - brak wartoci pustej
	 * - addslashes - 'ubezpiecza' niebezpieczne znaki
	 * - stripslashes - usuwa znaki dodane przez addslashes
	 * - striptags - wycina znaczniki HTML
   	 * @access public
   	 * @return mixed
   	 */
	function parseVar(&$variable, $variable_type, $param = NULL) {
		switch ($variable_type){
			case 'array':
				if (is_array($variable)) {
					foreach ($param as $key => $value) {
						switch ($value[0]) {
							case 'not_null':
								if (sizeof($variable) < 1) return PEAR::raiseError($variable, -8, null, null, PEAR_LOG_NOTICE);
								break;
						}
					}
				} else { return PEAR::raiseError($variable, -1, null, null, PEAR_LOG_NOTICE);}
				return TRUE;
				break;
			case 'boolean':
				if (is_bool($variable)) {
				} else { return PEAR::raiseError($variable, -4, null, null, PEAR_LOG_NOTICE);}
				return TRUE;
				break;
			case 'numeric':
				if (is_numeric($variable)) {
				} else { return PEAR::raiseError($variable, -9, null, null, PEAR_LOG_NOTICE);}
				return TRUE;
				break;
			case 'double':
			case 'float':
				if (is_float($variable)) {
				} else { return PEAR::raiseError($variable, -9, null, null, PEAR_LOG_NOTICE);}
				return TRUE;
				break;
			case 'integer':
			case 'int':
				if (is_int($variable)) {
				} else { return PEAR::raiseError($variable, -10, null, null, PEAR_LOG_NOTICE);}
				return TRUE;
				break;
			case 'object':
				return TRUE;
				break;
			case 'date':
				//echo(strtotime('%Y', str_replace('-', '', $variable)).'<p/>');
				//if (strtotime(strftime('%Y%m%d', $variable)) == -1) {return FALSE;}
				if (strtotime($variable) == -1) {return FALSE;}
				return TRUE;
				break;
			case 'string':
				if (is_string($variable)) {
					foreach ($param as $key => $value) {
						switch ($value[0]) {
							case 'not_null':
								if (is_null($variable)) return PEAR::raiseError($variable, -2, null, null, PEAR_LOG_NOTICE);
								break;
							case 'addslashes':
								$variable = addslashes($variable);
								break;
							case 'stripslashes':
								$variable = stripslashes($variable);
								break;
							case 'striptags':
								$variable = strip_tags($variable);
								break;
							case 'htmlspecialchars':
								$variable = htmlspecialchars($variable, ENT_QUOTES);
								break;
						}
					}
				} else { return PEAR::raiseError($variable, -10, null, null, PEAR_LOG_NOTICE);}
				return TRUE;
				break;
			case 'id':
				return ereg('^([a-fA-F0-9]{32})$', $variable);
				break;
			case 'price':
				return ereg('^([0-9])+(\.([0-9]{2})$){0,1}$', $variable);
				break;
			default:
				return PEAR::raiseError($variable, -7, null, null, PEAR_LOG_NOTICE);
		}
	}
  	/**
   	 * Domylna metoda obsugi bdw dla obiektw tej klasy
	 * @param mixed $error Kod bdu
   	 * @access public
   	 * @return mixed
   	 */
	function errorHandlerObject($error) {
	    global $appCore;
		$appCore->handleError($error);
	}
 
}// Koniec klasy Object
?>