<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+
//Niezbdne klasy obiektw 
require_once('appcore.php'); //Rdze aplikacji
require_once('../config/smarty.cfg.php');//Obsuga szablonw Smarty

//Inicjacja rdzenia aplikacji
if (PEAR::isError($appCore->initializeApplication('../config/pl.language.xml'))) {echo($appCore->getLastErrorMessage()); exit;}
if (PEAR::isError($err = $appCore->loadConfigFile('../config/module.cfg.xml'))) { echo($appCore->getLastErrorMessage()); exit;}

//Zaadowanie niezbdnych moduw
if (PEAR::isError($err = $appCore->loadModule('Basket'))){echo($appCore->getLastErrorMessage()); exit;}
if (PEAR::isError($err = $appCore->loadModule('Catalog'))){echo($appCore->getLastErrorMessage()); exit;}
if (PEAR::isError($err = $appCore->loadModule('Special'))){echo($appCore->getLastErrorMessage()); exit;}
if (PEAR::isError($err = $appCore->loadModule('Product'))){echo($appCore->getLastErrorMessage()); exit;}
if (PEAR::isError($err = $appCore->loadModule('CustomUser'))){echo($appCore->getLastErrorMessage()); exit;}
if (PEAR::isError($err = $appCore->loadModule('Image'))){echo($appCore->getLastErrorMessage()); exit;}
if (PEAR::isError($err = $appCore->loadModule('Param'))){echo($appCore->getLastErrorMessage()); exit;}

//Rozpoczcie sesji
session_start();

//Obiekt koszyka tworzony jest na pocztku
if (!isset($_SESSION['Basket'])) {
	session_register('Basket');
	$_SESSION['Basket'] = new Basket();
}
//Stworzenie tymczasowego uytkownika publicznego
if (!isset($_SESSION['CurrentUser'])) {
	$user = new CustomUser(array('USR_Id'=>'public','USR_Password'=>'public','USR_Active'=>'TRUE'));
	if (PEAR::isError($user = CustomUser::Logon($user->getId(), 'public', $user))) {$appCore->handleError($user); echo ($appCore->getLastErrorMessage());	 exit;}
	session_register('CurrentUser');
	$_SESSION['CurrentUser'] = $user;
} else if($_SESSION['CurrentUser']->getType() == 'A') {
	$user = new CustomUser(array('USR_Id'=>'public','USR_Password'=>'public','USR_Active'=>'TRUE'));
	if (PEAR::isError($user = CustomUser::Logon($user->getId(), 'public', $user))) {$appCore->handleError($user); echo ($appCore->getLastErrorMessage());	 exit;}
	session_register('CurrentUser');
	$_SESSION['CurrentUser'] = $user;
}

//Inicjacja klasy obiektw Smarty
$smarty = new Smarty_Template();
$smarty->assign_by_ref('Basket', $_SESSION['Basket']); //Przypisanie dla wygody
$tplToDisplay  = 'public.tpl'; //Dokument uytkownika publicznego
$publicContent = 'product.tpl';
$selectedCategory = FALSE;

//Zaadowanie moduu obsugujacego kategorie produktw
if (PEAR::isError($err = $appCore->loadModule('Catalog'))){echo($appCore->getLastErrorMessage()); exit;}

//Analizowanie akcji uytkownika
if (isset($_GET['menu'])) {
	switch ($_GET['menu']) {
		case 'ca7d9f5c71e4ab4c478ea25923e248f0': //Wyloguj
			$user = new CustomUser(array('USR_Id'=>'public','USR_Password'=>'public','USR_Active'=>'TRUE'));
			if (PEAR::isError($user = CustomUser::Logon($user->getId(), 'public', $user))) {$appCore->handleError($user); echo ($appCore->getLastErrorMessage()); exit;}
			$_SESSION['CurrentUser'] = $user;
		break;
		case 'b0d38b05c7d6424d24a9549c1cdd8b42': //Moje konto
			include('public/myaccount/myaccount.php');
		break;
		case 'd853812937d3c73a9613db55229c4230': //logonform
			include('public/logonform.php');
		break;
		case '238dae548b72eedb2ead85e5f96bd840': //Wywietlenie zawartoci katalogu
			if (isset($_GET['catid'])) {
				if (Catalog::categoryExists($_GET['catid'])) {
					$selectedCategory = Catalog::getCategoryData($_GET['catid'], array('CAT_id', 'CAT_Parent'));					
					if ($selectedCategory->getParent() == NULL) {
						$smarty->assign('selectedParent', $selectedCategory->getId());
					} else {
						$smarty->assign('selectedParent', $selectedCategory->getParent());
						$smarty->assign('selectedCategory', $selectedCategory->getId());
					}
				}
			}
			$publicContent = 'product.tpl';
		break;
		case '5af2b19552bc85d42e31d592cb0f151d': //Rejestracja uytkownika
			session_unregister('NewCustomer');
		case '1fd45eb0c0f50ea21481cf24be600f22':
			include('public/registeruser.php'); //
		break;
		case '18d77eb9f30375f23c68c919f7ba8d30': //Dodanie do koszyka
			include('public/basket/addtobasket.php');
		break;
		case '1679e7b1b297c07de53ee3651f4c759': //Wywietlenie koszyka
			include('public/basket/displaybasket.php');
		break;
		case 'ca490eb669d44e400dba9ed3142c328f': //Skadanie zamwienia
			include ('public/basket/createorder.php');
		break;
		case '74418876d69e6fe9a04612d2f0ebc36b': //?menu=74418876d69e6fe9a04612d2f0ebc36b&active=fa97d931738dbdad5b47c76a04eb361a
			include ('public/myaccount/activateaccount.php');
		break;
		case 'ca490eb669d44e400dba9ed3142c3281': //Wyszukiwanie
			include ('public/search_2.php');
		break;
		default:
			$publicContent = 'product.tpl';
		break;
	}
}


//Sprawdzanie czy uytkownik jest zalogowany
if ($_SESSION['CurrentUser']->getType()=='C') {
	//Uytkownik jest zalogow2any
	$smarty->assign('isUserACustomer', TRUE);
} else {
	$smarty->assign('isUserACustomer', FALSE);
}

// Wyszukiwanie ---------------------------------------
include ('public/search_1.php');
// Wyszukiwanie ---------------------------------------

//Kategorie produktw ---------------------------------------
	//Tworzenie  obiektu katalogu
	$catalog = new Catalog();
	//Pobranie struktury katalogowej i przypisanie jej 
	//przez referencj do obiektu Smarty
	$catStruct = $catalog->getCatalogStructure();
	$smarty->assign_by_ref('catStruct', $catStruct);
//Kategorie produktw ---------------------------------------

if (isset($_GET['prodid']) && !isset($_GET['menu'])) {
	if (!PEAR::isError($prod = Product::getData(NULL, $_GET['prodid']))) {
		$smarty->assign_by_ref('product', $prod[0]);
		$publicContent = 'productinfo.tpl';
	}
}

//Lista produktw ---------------------------------------
if ($publicContent == 'product.tpl') {
	//Pobranie listy produktw i przypisanie jej 
	//przez referencj do obiektu Smarty
	if (isSet($_GET['catid'])) {
		$catid = $_GET['catid'];
	} else { $catid = NULL;}
	
	if (!isSet($_POST['searchstart'])) {
	    $products = array();
		$products = Product::getDatabyCategory($catid);	
	}
	$smarty->assign_by_ref('products', $products);
}
//Lista produktw ---------------------------------------

//Produkt, ktry bdzie wywietlany w promocji
$randprodid = NULL;
$randprodid = Special::getRandomProductIdInSpecial();
if($randprodid) {
	if (PEAR::isError($randSpec = Product::getData(NULL, $randprodid))) {
		$smarty->assign('randSpecial', NULL);
	} else {
		$smarty->assign_by_ref('randSpecial', $randSpec[0]);
	}
} else {
	$smarty->assign('randSpecial', NULL);
}

//Cakowita liczba produktw
$totprod = $appCore->getMessage('public', 'totalprod', array(Product::getTotalProductCount()));
$smarty->assign('totprod', $totprod['VALUE']);

//Wywietlenie zawartoci formularza
$smarty->assign('publicContent', $publicContent);
$smarty->display($tplToDisplay);
?>