<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+
require_once('PEAR.php');
require_once(APP_CORE_PATH.'common.inc.php');
/**
 * Funkcja przeprowadza proces autoryzacji uytkownika w bazie danych
 *
 * @access public
 * @param string $userLogin Identyfikator uytkownika
 * @param string $userPassword Haso uytkownika 
 * @return mixed
 */
 function autorize($userLogin, $userPassword) {
 	//Rdze aplikacji
	global $appCore;
			
	//Hash'owanie hasa
	$userPassword = md5($userPassword);
	// Rozpoczcie transakcji 
    if (PEAR::isError($result = Transaction('BEGIN'))) return $result;
	// Sprawd, czy istnieje konto uytkownika
 	$sqlquery = "SELECT * FROM Users WHERE Users.USR_Id = '$userLogin'";
	if(DB::isError($result = $appCore->Query($sqlquery))) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
	}
	// Pobranie wynikw zapytania
	if ($userid = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
		if (!$userid['USR_Active']) {
			// Odwoanie transakcji
			Transaction('ROLLBACK');
			return PEAR::raiseError($userLogin, -503, null, null, PEAR_LOG_ERR);
		}
		
		//Jeeli uytkownik jest klientem jego konto musi by aktywowane
		if ($userid['USR_Type'] == 'C') {
			if ($userid['USR_ActivateByUser']!=1) {
				// Odwoanie transakcji
				Transaction('ROLLBACK');
				return PEAR::raiseError($userLogin, -509, null, null, PEAR_LOG_ERR);
			}
		}
		
		// Autoryzacja przebiega pomylnie
		if ($userid['USR_Password'] == $userPassword) {

			// Konto jest aktywne
			if ($userid['USR_Active'] == 1) {
				$sqlquery = "UPDATE Users SET Users.USR_LastLoginDate = CURRENT_TIMESTAMP(0), Users.USR_WrongPasswordCount = 0, Users.USR_CreateDate=Users.USR_CreateDate WHERE Users.USR_Id='$userLogin'";
				if (DB::isError($result = $appCore->Query($sqlquery))) {
					// Odwoanie transakcji
					Transaction('ROLLBACK');
					return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
				} else {
					$dbObject = &$appCore->getConnection(); 
	 				if ($dbObject->affectedRows() < 1) {
						// Odwoanie transakcji
						Transaction('ROLLBACK');
				   		return new PEAR_Error($userLogin, -651, null, null, PEAR_LOG_NOTICE);
				   	}
				    if (PEAR::isError($result = Transaction('COMMIT'))) return $result;
					return TRUE;
				}
			// Konto jest zablokowane
			} else {
				// Odwoanie transakcji
				Transaction('ROLLBACK');
				return new PEAR_Error($userLogin, -503, null, null, PEAR_LOG_NOTICE);
			}
		// Autoryzacja nie powioda si
		} else {
			// Ilo niepoprawnych zalogowa przekroczona
			if ($userid['USR_WrongPasswordCount'] >= MAXWRONGPASSWORD) {
				// Zablokowanie konta
				
				if ($userid['USR_Active'] == 1) {
					$sqlquery = "UPDATE Users SET Users.USR_Active = 0 WHERE Users.USR_Id='$userLogin'";
					if (DB::isError($result = $appCore->Query($sqlquery))) {
						// Odwoanie transakcji
						Transaction('ROLLBACK');
						return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
					} else {
						$dbObject = &$appCore->getConnection(); 
		 				if ($dbObject->affectedRows() < 1) {
							// Odwoanie transakcji
							Transaction('ROLLBACK');
							return new PEAR_Error($userLogin, -651, null, null, PEAR_LOG_NOTICE);
						}
						// Zakoczenie transakcji
						if (PEAR::isError($result = Transaction('COMMIT'))) return $result;
						return new PEAR_Error($userLogin, -502, null, null, PEAR_LOG_NOTICE);
					}
				}
			// Zwikszenie iloci niepoprawnych zalogowa
			} else {
				$sqlquery = "UPDATE Users SET Users.USR_WrongPasswordCount = Users.USR_WrongPasswordCount + 1, Users.USR_CreateDate=Users.USR_CreateDate, Users.USR_LoginFailedDate=CURRENT_TIMESTAMP(0) WHERE Users.USR_Id='$userLogin'";

				if (DB::isError($result = $appCore->Query($sqlquery))) {
					// Odwoanie transakcji
					Transaction('ROLLBACK');
					return $result;
				} else {
					$dbObject = &$appCore->getConnection(); 
		 			if ($dbObject->affectedRows() < 1) {
						// Odwoanie transakcji
						Transaction('ROLLBACK');
						return new PEAR_Error($userLogin, -651, null, null, PEAR_LOG_NOTICE);
					}
	   				// Zakoczenie transakcji
	   				if (PEAR::isError($result = Transaction('COMMIT'))) return $result;
					return new PEAR_Error($userLogin, -504, null, null, PEAR_LOG_NOTICE);
				}
			}
		}
	// Konto nie istnieje
	} else {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($userLogin, -505, null, null, PEAR_LOG_NOTICE);
	}
 }

/**
 * Funkcja rejestruje nowego uytkownika w bazie danych
 *
 * @access public
 * @param object $account Obiekt klasy ThorCustomUser
 * @param string $password Haso do konta
 * @return mixed
 */
 function registerUser(&$account, &$password) {
 	
	//Rdze aplikacji
	global $appCore;

	// Rozpoczcie transakcji 
    if (PEAR::isError($result = Transaction('BEGIN'))) return $result;
	
	// Sprawd, czy istnieje email uytkownika
 	$sqlquery = "SELECT UserInfo.UINFO_Email FROM UserInfo WHERE UserInfo.UINFO_Email = '" . $account->getEmail() . "'";
	if(DB::isError($result = $appCore->Query($sqlquery))) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return $result;
	}
	
	// Bd - email ju istnieje
	if ($useremail = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($account->getEmail(), -507, null, null, PEAR_LOG_NOTICE);
	// Zapisanie danych o uytkowniku
	} else {
		$sqlquery = "INSERT INTO UserInfo (UINFO_Email, UINFO_Name, UINFO_LastName, UINFO_NIP, UINFO_REGON, UINFO_PESEL, UINFO_CellPhone, UINFO_Active) VALUES ('" . $account->getEmail() . "', '" . $account->getName(). "', '" . $account->getLastName() . "', '" . $account->getNip() . "', '" . $account->getRegon() . "', '" . $account->getPesel() . "', '" . $account->getCellPhone() . "', ";
		if ($account->getActive()) {$sqlquery .= "1)";} else {$sqlquery .= "0)";}
	
		if (DB::isError($result = $appCore->Query($sqlquery))) {
			// Odwoanie transakcji
			Transaction('ROLLBACK');
			return $result;
		} else {
			$dbObject = &$appCore->getConnection(); 
			if ($dbObject->affectedRows() < 1) {
				// Odwoanie transakcji
				Transaction('ROLLBACK');
				return new PEAR_Error($userLogin, -650, null, null, PEAR_LOG_NOTICE);
			}
			// Sprawd, czy istnieje konto uytkownika
	 		$sqlquery = "SELECT Users.USR_Id FROM Users WHERE Users.USR_Id = '" . $account->getId() . "'";
			if(DB::isError($result = $appCore->Query($sqlquery))) {
				// Odwoanie transakcji
				Transaction('ROLLBACK');
				return $result;
			}
		
			// Pobranie wynikw zapytania
	
			// Bd - konto ju istnieje
			if ($userid = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
				// Odwoanie transakcji
				Transaction('ROLLBACK');
				return new PEAR_Error($account->getId(), -506, null, null, PEAR_LOG_NOTICE);
			// Zaoenie nowego konta
			} else {
				$sqlquery =  'INSERT INTO Users (USR_Id, USR_Type, UINFO_Email, USR_Password, USR_CreateDate, USR_ActivateByUser, USR_LastModifyDate, USR_LastLoginDate, USR_LoginFailedDate, USR_WrongPasswordCount, USR_MustChangePassword, USR_Active) ';
				$sqlquery .= 'VALUES ("'.$account->getId().'", "'.$account->getType().'", "'.$account->getEmail().'", "'.md5($account->getPassword()).'", CURRENT_TIMESTAMP(0), 0, NULL, NULL, NULL, 0, 0, ';
				if ($account->getActive()) {$sqlquery .= '1)';} else {$sqlquery .= '0)';}
				if (DB::isError($result = $appCore->Query($sqlquery))) {
					// Odwoanie transakcji
					Transaction('ROLLBACK');
					return $result;
				} else {

					$dbObject = &$appCore->getConnection(); 
					if ($dbObject->affectedRows() < 1) {
						// Odwoanie transakcji
						Transaction('ROLLBACK');
						return new PEAR_Error($userLogin, -650, null, null, PEAR_LOG_NOTICE);
					}
					
					//Prba zapisania adresu
					if ($account->_address[0]) {
						//Prba zapisania adresu
						$myAdd = $account->_address[0];
						$myAdd->generateId();

						//Tworzenie zapytania SQL
						$sqlquery = "INSERT INTO Address (ADDR_Id, ADT_Id, CRY_Id, ST_Id, ADDR_StreetName, ADDR_StreetNr, ADDR_HomeNr, ADDR_City, ADDR_Zip, ADDR_Phone, ADDR_Fax, ADDR_CreateDate, ADDR_Active) VALUES ('" . $myAdd->getId() . "', '" . $myAdd->_addressType->getId() . "', '" . $myAdd->_country->getId() . "', '" . $myAdd->_state->getId() . "', '" . $myAdd->getStreetName() . "', '" . $myAdd->getStreetNr() . "', '" . $myAdd->getHomeNr() . "', '" . $myAdd->getCity() . "', '" . $myAdd->getZIP() . "', '" . $myAdd->getPhone() . "', '" . $myAdd->getFax() . "', '" . $myAdd->getCreateDate() . "', 1)";
						if(DB::isError($result = $appCore->Query($sqlquery))) {
							// Odwoanie transakcji
							Transaction('ROLLBACK');
							return $result;
						}
						
						$sqlquery = "INSERT INTO usr_has_addr (UINFO_Email, ADDR_Id) VALUES ('" . $account->getEmail() . "', '" . $myAdd->getId() . "')";
						if(DB::isError($result = $appCore->Query($sqlquery))) {
							// Odwoanie transakcji
							Transaction('ROLLBACK');
							return $result;
						}
					
					}
					
					// Zakoczenie transakcji
					Transaction('COMMIT');
				}
			} // Koniec zakadania nowego konta
		}
	} // Koniec zapisywania danych uytkownika
 }
 
/**
 * Aktywuje konto istniejce w serwisie typu C
 *
 * @param string $_activate Identyfikator aktywujcy
 * @return mixed Identyfikator uytkownika lub obiekt PEAR_Error
 */
function activateUser($_activate) {
	//Rdze aplikacji
	global $appCore;
		
	//Przygotowanie i wykonanie zapytania SQL
	$sqlquery = 'SELECT USR_Id FROM Users WHERE MD5(CONCAT(MD5(USR_Id), MD5(UNIX_TIMESTAMP(USR_CreateDate))))="'.$_activate.'" AND USR_Type="C" AND USR_ActivateByUser=0';
	if(DB::isError($result = $appCore->Query($sqlquery))) {
		$err = PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
		$appCore->handleError($err);
		return $err;
	}
	
	//Sprawdzenie czy istnieje user, ktrego mona aktywowa
	if ($result->numRows()==0) {
		$err = PEAR::raiseError($_activate, -510, null, null, PEAR_LOG_NOTICE);
		$appCore->handleError($err);
		return $err;
	}
	
	//Login Usera
	$login = $result->fetchRow(); $login = $login[0];
	
	//Prba aktywacji konta uytkownika
	$sqlquery = 'UPDATE Users set USR_ActivateByUser=1 WHERE USR_Id="'.$login.'"';
	if(DB::isError($result = $appCore->Query($sqlquery))) {
		$err = PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
		$appCore->handleError($err);
		return $err;
	}
	
	//Autoryzacja si powioda
	return $login;
		
}
?>