<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+
require_once('appcore.php'); //Rdze aplikacji
require_once('../config/smarty.cfg.php');//Obsuga szablonw Smarty

//Inicjacja rdzenia aplikacji
if (PEAR::isError($appCore->initializeApplication('../config/pl.language.xml'))) {echo($appCore->getLastErrorMessage()); exit;}
if (PEAR::isError($err = $appCore->loadConfigFile('../config/module.cfg.xml'))) { echo($appCore->getLastErrorMessage()); exit;}

//Zaadowanie niezbdnych moduw
if (PEAR::isError($err = $appCore->loadModule('CustomUser'))){echo($appCore->getLastErrorMessage()); exit;}
if (PEAR::isError($err = $appCore->loadModule('Product'))){echo($appCore->getLastErrorMessage()); exit;}
if (PEAR::isError($err = $appCore->loadModule('Param'))){echo($appCore->getLastErrorMessage()); exit;}
if (PEAR::isError($err = $appCore->loadModule('Image'))){echo($appCore->getLastErrorMessage()); exit;}
if (PEAR::isError($err = $appCore->loadModule('Catalog'))){echo($appCore->getLastErrorMessage()); exit;}


//Rozpoczcie sesji
session_start();

//Inicjacja klasy obiektw Smarty
$smarty = new Smarty_Template();

//Stworzenie tymczasowego uytkownika publicznego
if (!isset($_SESSION['CurrentUser']) || $_SESSION['CurrentUser']->getType() != 'A') {

	$adminContent = 'adminlogonform.tpl'; //Zawarto kolumny gownej	
	$beamContent = 'beam_logon.tpl'; // Zawarto belki gwnej
	
	if (PEAR::isError($err = $appCore->loadModule('Forms'))){echo($appCore->getLastErrorMessage()); exit;}

	//Czyszczenie ostatniego bdu aby sprawdzi czy podczas tworzenia obiektu 
	//formularza nie zosta wygenrowany bd
	$appCore->clearLastErrorMessage();
	$formObj = new Forms('admin/logonform.xml');
	if($appCore->getLastErrorMessage()!='') {echo($appCore->getLastErrorMessage()); exit;}
	
	//Sprawdzenie czy dane z formularza nie zostay ju przesane
	if (isset($_GET['menu'])) {
		if ($_GET['menu']=='013f9627f29838c7be865f3465c6740a') {
		
			//Walidacja danych z formularza
			$resultArray = array();
			$formObj->checkForm($resultArray);
			if(count($resultArray)==0) {
							
				//Walidacja przebiega pomylnie

					if (PEAR::isError($user = CustomUser::Logon('admin', $_POST['passwd']))) {
						//$appCore->handleError($user); echo ($appCore->getLastErrorMessage());	 exit;
						$adminContent = 'failedlogin.tpl'; 
					} else {
						if (!isSet($_SESSION['CurrentUser'])) session_register('CurrentUser');
						$_SESSION['CurrentUser'] = $user;
						header("Location: ?");					
					}
			}
			
		}
	}
	
	$smarty->assign_by_ref('form', $formObj);
} else {
	$adminContent = 'adminwelcome.tpl';
	$adminAction = 'welcomecontent.tpl';
	$beamContent = 'beam_main.tpl';
	//Obsuga menu
	if (isset($_GET['menu'])) {
		switch($_GET['menu']) {
			case '1f2dd94a5c7f3133f16ce4a05ed71467': // Wyloguj
				session_unregister('CurrentUser');
				session_destroy();
				header("Location: ?");
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71468': // Sowniki
				include('admin/dict/dict.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71469': // Asortyment sklepu
				include('admin/item/item.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71470': // Produkty w sklepie
				include('admin/product/product.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71471': // Nowy asortyment
				include('admin/item/item_new.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71472': // Modyfikuj asortyment
				include('admin/item/item_modify.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71473': // Zablokuj asortyment
				include('admin/item/item_desactivate.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71474': // Sownik parametrw 
													 // asortymentu
				include('admin/dict/dict_param.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71475': // Nowy parametr asortymentu (w 
													 // sowniku)
				include('admin/dict/dict_param_new.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71476': // Modyfikacja parametru 
													 //asortymentu (w sowniku)
				include('admin/dict/dict_param_update.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71477': // Nowy parametr asortymentu
													 // (przypisanie do item)
				include('admin/item/item_param_new.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71478': // Nowy produkt
				include('admin/product/product_new.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71479': // Modyfikuj produkt
				include('admin/product/product_modify.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71480': // Zablokuj produkt
				include('admin/product/product_desactivate.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71481': // Dodanie produktu do kategorii
				include('admin/product/product_category_new.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71491': // Dodanie producenta do 
													 // produktu
				include('admin/product/product_producer_new.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71496': // Przypisanie zdjcia do 
													 // produktu 
				include('admin/product/product_image_new.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71483': // Sownik producentw 
													 // asortymentu
				include('admin/dict/dict_producer.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71482': // Nowy producent (w sowniku)
				include('admin/dict/dict_producer_new.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71500': // Nowy adres producenta (w 
													 // sowniku)
				include('admin/dict/dict_producer_address_new.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71504': // Modyfikacja adresu 
													 // producenta (w sowniku)
				include('admin/dict/dict_producer_address_update.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71484': // Modyfikacja producenta ( w 
													 // sowniku)
				include('admin/dict/dict_producer_update.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71485': // Sownik krajw
				include('admin/dict/dict_country.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71487': // Nowy kraj (w sowniku)
				include('admin/dict/dict_country_new.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71488': // Modyfikacja kraju ( w 
													 // sowniku)
				include('admin/dict/dict_country_update.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71486': // Sownik wojewdztw
				include('admin/dict/dict_state.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71489': // Nowe wojewdztwo (w sowniku)
				include('admin/dict/dict_state_new.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71490': // Modyfikacja wojewdztwa ( w 
													 // sowniku)
				include('admin/dict/dict_state_update.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71492': // Biblioteka zdj
				include('admin/dict/dict_image.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71493': // Nowe zdjcie (w bibliotece)
				include('admin/dict/dict_image_new.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71494': // Modyfikacja zdj 
													 //(w sowniku)
				include('admin/dict/dict_image_update.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71495': // Wywietlenie zdjcia 
													 // pobranego z bazy danych
				include('admin/dict/dict_image_display.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71497': // Typy adresw
				include('admin/dict/dict_addresstype.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71498': // Nowy typ adresu (w sowniku)
				include('admin/dict/dict_addresstype_new.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71499': // Modyfikacja typw adresu ( w 
													 // sowniku)
				include('admin/dict/dict_addresstype_update.php');
			break;
			case 'efcfe755debad10919b919b6b2be112f': //Kategorie
				include('admin/catalog/category.php');
			break;
			case '08972786cba6f92679ecce219f0d7817': //Nowa kategoria
				include('admin/catalog/newcategory.php');
			break;
			case '67f58a8636e2fd844a1904355ffe0eee': //Zachowanie kategorii
				include('admin/catalog/savecategory.php');
			break;
			case '7217c8fac67d0ee6639b40f58cf57d8c': //Usunicie kategorii
				include('admin/catalog/deletecategory.php');
			break;
			case '77b33000350500167ada7a91a24f806e': //Zarejestrowani klienci 
				include('admin/customers/customermngr.php');
			break;
			case '92dc467a343209033dfe5d6312ca8181': //Formularz edycji klienta
				include('admin/customers/modifycustomer.php');
			break;
			case '24c0bae3dd8bc9481ce2ea88a274e04e':  //Usuwanie klienta
				include('admin/customers/deletecustomer.php');
			break;
			case '51d9a87ceb513de9363d548dc1bee90d': //Promocja
				include('admin/specials/specials.php');
			break;
			case '77c58ce34779cfc647ab176c99c63500': //Nowa promocja
				include('admin/specials/newspecial.php');
			break;
			case '158333899499a0f42ed1a147794e3cfc': //Usunicie promocji
				include('admin/specials/deletespecial.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71501': // Sownik stawek VAT 
				include('admin/dict/dict_tax.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71502': // Nowa stawka VAT ( w sowniku)
				include('admin/dict/dict_tax_new.php');
			break;
			case '1f2dd94a5c7f3133f16ce4a05ed71503': // Modyfikacja stawki VAT ( w 
													 // sowniku)
				include('admin/dict/dict_tax_update.php');
			break;
			case 'e1816f503728a5df977673009f784a05': //Zarzdzanie zamwieniami
				include ('admin/orders/orders.php');
				//echo(md5('magageorders'));
			break;
		}
	}
	
	$smarty->assign('adminAction', $adminAction);
}

//Okrelenie zawartoci belki gwnej
$smarty->assign('beamContent', $beamContent);
//Wywietlenie zawartoci formularza
$smarty->assign('adminContent', $adminContent);
$smarty->display('admin.tpl');
?>