<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+

//Zaadowanie moduu formularza
//Pliki PEARA do wysyania miaila
if (PEAR::isError($err = $appCore->loadModule('Forms'))){echo($appCore->getLastErrorMessage()); exit;}

//Pobranie komunikatw tytuu strony
$titleMsg = $appCore->getMessage('customer_register', 'title');

//Funkcja przygotowuje sowniki dla formularzy
function prepareDictionary() {
	//Rdze aplikacji
	global $formObj, $appCore;
	
	//Uzyskiwanie referencji do adresu
	if 	(isset($_SESSION['NewCustomer']->_address[0])) {
		$myAdd = &$_SESSION['NewCustomer']->_address[0];
	} else {
		$myAdd = NULL;
	}
	
	//Przygotowywanie sownikw
	
			//Sownik typw adresw
			$msg = $appCore->getMessage('customer_register', 'addrestype1stlabel');
			$addtype[] = array('null', $msg['VALUE']);
			if ($myAdd) {$atsel = &$myAdd->getAddressType();} else {$atsel=NULL;}
			if ($atsel) {AddressType::prepareComboBoxValues($addtype, TRUE, $atsel->getId());
			} else {AddressType::prepareComboBoxValues($addtype, TRUE);}
			$formObj->setValueArray('address_type', $addtype);

			//Sownik wojewdztw
			$msg = $appCore->getMessage('customer_register', 'state1stlabel');
			$state[] = array('null', $msg['VALUE']);
			if ($myAdd) {$stsel = &$myAdd->getState();} else {$stsel=NULL;}
			if ($stsel) {State::prepareComboBoxValues($state, TRUE, $stsel->getId());
			} else {State::prepareComboBoxValues($state, TRUE);}
			$formObj->setValueArray('address_state', $state);
			
			//Sownik krajw
			$msg = $appCore->getMessage('customer_register', 'country1stlabel');
			$country[] = array('null', $msg['VALUE']);
			if ($myAdd) {$ctrsel = &$myAdd->getCountry();} else {$ctrsel=NULL;}
			if ($ctrsel) {Country::prepareComboBoxValues($country, TRUE, $ctrsel->getId());
			} else {Country::prepareComboBoxValues($country, TRUE);}
			$formObj->setValueArray('address_country', $country);
}

//Sprawdzenie czy istnieje sesja rejestracyjna
if (isset($_POST['step1'])) {

	//Nastpi powrt do kroku pierwszego
	//Tworzenie formularza w drugim kroku rejestacji
	$appCore->clearLastErrorMessage();
	$formObj = new Forms('registeruser/registeruser_step1.xml');
	if($appCore->getLastErrorMessage()!='') {echo($appCore->getLastErrorMessage()); exit;}

	//Przypisanie parametrw formularza ustawionych wczeniej
	if (isset($_SESSION['NewCustomer'])) {
		//Zapamitanie tego co byo w formularzu 2 bez wzgldu na to czy byo poprawne czy nie
		//Walidacja formularza 2
		//Zabezpieczenie danych przed "NIEBEZPIECZNYMI WARTOCIAMI"	
		if (isset($_POST['name'])) {$_SESSION['NewCustomer']->setName($_POST['name']);}
		if (isset($_POST['lastname'])) {$_SESSION['NewCustomer']->setLastName($_POST['lastname']);}
		if (isset($_POST['nip'])) {$_SESSION['NewCustomer']->setNip($_POST['nip']);}
		if (isset($_POST['regon'])) {$_SESSION['NewCustomer']->setRegon($_POST['regon']);}
		if (isset($_POST['pesel'])) {$_SESSION['NewCustomer']->setPesel($_POST['pesel']);}
		if (isset($_POST['cellphone'])) {$_SESSION['NewCustomer']->setCellPhone($_POST['cellphone']);}
		
		//Wywietlenie ostatnich wynikw
		$formObj->setValueArray('login', $_SESSION['NewCustomer']->getId());
		$formObj->setValueArray('passwd', $_SESSION['NewCustomer']->getPassword());
		$formObj->setValueArray('passwdrep', $_SESSION['NewCustomer']->getPassword());
		$formObj->setValueArray('email', $_SESSION['NewCustomer']->getEmail());
	}
					
	//Wywietlanie treci
	$publicContent = 'registeruserform.tpl';
	$smarty->assign('title', $titleMsg['VALUE'].' (1/4)');

} else if (isset($_POST['step2'])) {
	
	//Walidacja formularza 1
	//Zabezpieczenie danych przed "NIEBEZPIECZNYMI WARTOCIAMI"
	$_POST['login']     = htmlspecialchars($_POST['login']);
	$_POST['passwd']    = htmlspecialchars($_POST['passwd']);
	$_POST['passwdrep'] = htmlspecialchars($_POST['passwdrep']);
	$_POST['email']     = htmlspecialchars($_POST['email']);
		
	//Tytu dla pierwszego formularza
	$smarty->assign('title', $titleMsg['VALUE'].' (1/4)');
	$publicContent = 'registeruserform.tpl'; //Wstpnie zakadamy, e walidacja si niepowioda
	
	//Utworzenie pierwszego obiektu formularza do celw walidacyjnych
	$appCore->clearLastErrorMessage();
	$formObj = new Forms('registeruser/registeruser_step1.xml');
	if($appCore->getLastErrorMessage()!='') {echo($appCore->getLastErrorMessage()); exit;}

	$result = array(); $formObj->checkForm($result);
	if (count($result)==0) {
		//Wstpna walidacja pierwszego formularza przebiega pomylnie
		//Sprawdzenie czy uytkownik o wskazanym ID oraz adresie E-mail istniej
		
		if(User::doesUserExists($_POST['login'])) {
			//Bd uytkownik o okrelonej nazwie ju istnieje
			$msg = $appCore->getMessage('customer_register', 'usridexists');
			$formObj->setConditionError($msg['VALUE']);				
		} else if (User::doesUserExists(NULL, $_POST['email'])) {
	        //Bd uytkownik o okrelonym adresie e-mail ju istnieje
			$msg = $appCore->getMessage('customer_register', 'usremailexists');
			$formObj->setConditionError($msg['VALUE']);
		} else {
			//Dane z pierwszego formularza zostay zakwalifikowane pomylnie
				
			//Tworzenie obiektu uytkownika w sesji jeeli nie istnieje
			if (!isset($_SESSION['NewCustomer'])) {
				session_register('NewCustomer');
				$_SESSION['NewCustomer'] = new CustomUser();
			}
			$_SESSION['NewCustomer']->setId($_POST['login']);
			$_SESSION['NewCustomer']->setPassword($_POST['passwd']);
			$_SESSION['NewCustomer']->setEmail($_POST['email']);
			
			//Wywietlanie drugiego formularza
			//Tworzenie formularza w drugim kroku rejestacji
			$appCore->clearLastErrorMessage();
			$formObj = new Forms('registeruser/registeruser_step2.xml');
			if($appCore->getLastErrorMessage()!='') {echo($appCore->getLastErrorMessage()); exit;}
			
			//Wywietlenie poprzednich danych jeeli takowe zostay wczeniej wprowadzone
			$formObj->setValueArray('name', $_SESSION['NewCustomer']->getName());
			$formObj->setValueArray('lastname', $_SESSION['NewCustomer']->getLastName());
			$formObj->setValueArray('nip', $_SESSION['NewCustomer']->getNip());
			$formObj->setValueArray('regon', $_SESSION['NewCustomer']->getRegon());
			$formObj->setValueArray('pesel', $_SESSION['NewCustomer']->getPesel());
					
			//Wywietlanie tytuu
			$smarty->assign('title', $titleMsg['VALUE'].' (2/4)');
		}
	}
} else if (isset($_POST['backstep2'])) {

	//Zapamitanie danych z formularza 3
	//Wykonano ostatni krok rejestracji
	if (isset($_POST['address_type']))      {$_POST['address_type']       = htmlspecialchars($_POST['address_type']);}
	if (isset($_POST['address_streetname'])){$_POST['address_streetname'] = htmlspecialchars($_POST['address_streetname']);}
	if (isset($_POST['address_streetnr']))  {$_POST['address_streetnr']   = htmlspecialchars($_POST['address_streetnr']);}
	if (isset($_POST['address_homenr']))    {$_POST['address_homenr']     = htmlspecialchars($_POST['address_homenr']);}
	if (isset($_POST['address_city']))      {$_POST['address_city']       = htmlspecialchars($_POST['address_city']);}
	if (isset($_POST['address_zip']))       {$_POST['address_zip']        = htmlspecialchars($_POST['address_zip']);}
	if (isset($_POST['address_state']))     {$_POST['address_state']      = htmlspecialchars($_POST['address_state']);}
	if (isset($_POST['address_country']))   {$_POST['address_country']    = htmlspecialchars($_POST['address_country']);}
	if (isset($_POST['address_phone']))     {$_POST['address_phone']      = htmlspecialchars($_POST['address_phone']);}
	if (isset($_POST['address_fax']))       {$_POST['address_fax']        = htmlspecialchars($_POST['address_fax']);}
	
	//Walidacja ostatniego kroku przebiega pomylnie
	//
	if (!isset($_SESSION['NewCustomer']->_address[0])) {
		$adrObj = new Address();		
		$_SESSION['NewCustomer']->addAddress($adrObj);
	}
	
	$_SESSION['NewCustomer']->_address[0]->setAddressType($_POST['address_type']);
	$_SESSION['NewCustomer']->_address[0]->setStreetName($_POST['address_streetname']);
	$_SESSION['NewCustomer']->_address[0]->setStreetNr($_POST['address_streetnr']);
	$_SESSION['NewCustomer']->_address[0]->setHomeNr($_POST['address_homenr']);
	$_SESSION['NewCustomer']->_address[0]->setCity($_POST['address_city']);
	$_SESSION['NewCustomer']->_address[0]->setZip($_POST['address_zip']);
	$_SESSION['NewCustomer']->_address[0]->setState($_POST['address_state']);
	$_SESSION['NewCustomer']->_address[0]->setCountry($_POST['address_country']);
	$_SESSION['NewCustomer']->_address[0]->setPhone($_POST['address_phone']);
	$_SESSION['NewCustomer']->_address[0]->setFax($_POST['address_fax']);

	
	//Tytu dla pierwszego formularza
	$smarty->assign('title', $titleMsg['VALUE'].' (2/4)');
	$publicContent = 'registeruserform.tpl'; //Wstpnie zakadamy, e walidacja si niepowioda
	
	//Utworzenie pierwszego obiektu formularza do celw walidacyjnych
	$appCore->clearLastErrorMessage();
	$formObj = new Forms('registeruser/registeruser_step2.xml');
	if($appCore->getLastErrorMessage()!='') {echo($appCore->getLastErrorMessage()); exit;}
	
	//Wywietlenie poprzednich danych jeeli takowe zostay wczeniej wprowadzone
	$formObj->setValueArray('name', $_SESSION['NewCustomer']->getName());
	$formObj->setValueArray('lastname', $_SESSION['NewCustomer']->getLastName());
	$formObj->setValueArray('nip', $_SESSION['NewCustomer']->getNip());
	$formObj->setValueArray('regon', $_SESSION['NewCustomer']->getRegon());
	$formObj->setValueArray('pesel', $_SESSION['NewCustomer']->getPesel());

} else if (isset($_POST['step3'])) {

	//Walidacja formularza 2
	//Zabezpieczenie danych przed "NIEBEZPIECZNYMI WARTOCIAMI"
	$_POST['name']     = htmlspecialchars($_POST['name']);
	$_POST['lastname'] = htmlspecialchars($_POST['lastname']);
	$_POST['nip']      = htmlspecialchars($_POST['nip']);
	$_POST['regon']    = htmlspecialchars($_POST['regon']);
	$_POST['pesel']    = htmlspecialchars($_POST['pesel']);
	
	//Tytu dla pierwszego formularza
	$smarty->assign('title', $titleMsg['VALUE'].' (2/4)');
	$publicContent = 'registeruserform.tpl'; //Wstpnie zakadamy, e walidacja si niepowioda
	
	//Utworzenie pierwszego obiektu formularza do celw walidacyjnych
	$appCore->clearLastErrorMessage();
	$formObj = new Forms('registeruser/registeruser_step2.xml');
	if($appCore->getLastErrorMessage()!='') {echo($appCore->getLastErrorMessage()); exit;}

	//Walidacja formularza w kroku rejstracyjnym 2
	$result = array(); $formObj->checkForm($result);
	if (count($result)==0) {
		//Wstpna walidacja drugiego formularza przebiega pomylnie
		
		$_SESSION['NewCustomer']->setName($_POST['name']);
		$_SESSION['NewCustomer']->setLastName($_POST['lastname']);
		$_SESSION['NewCustomer']->setNip($_POST['nip']);
		$_SESSION['NewCustomer']->setRegon($_POST['regon']);
		$_SESSION['NewCustomer']->setPesel($_POST['pesel']);
			
		//Wywietlanie trzeciego formularza
		//Tworzenie formularza w trzecim kroku rejestacji
		$appCore->clearLastErrorMessage();
		$formObj = new Forms('registeruser/registeruser_step3.xml');
		if($appCore->getLastErrorMessage()!='') {echo($appCore->getLastErrorMessage()); exit;}
		prepareDictionary();
		
		//Wywietlenie poprzednich danych jeeli takowe zostay wczeniej wprowadzone
		if (isset($_SESSION['NewCustomer']->_address[0])) {
			$formObj->setValueArray('address_streetname', $_SESSION['NewCustomer']->_address[0]->getStreetName());
			$formObj->setValueArray('address_streetnr', $_SESSION['NewCustomer']->_address[0]->getStreetNr());
			$formObj->setValueArray('address_homenr', $_SESSION['NewCustomer']->_address[0]->getHomeNr());
			$formObj->setValueArray('address_city', $_SESSION['NewCustomer']->_address[0]->getCity());
			$formObj->setValueArray('address_zip', $_SESSION['NewCustomer']->_address[0]->getZip());
			$formObj->setValueArray('address_phone', $_SESSION['NewCustomer']->_address[0]->getPhone());
			$formObj->setValueArray('address_fax', $_SESSION['NewCustomer']->_address[0]->getFax());
			prepareDictionary();
		}
			
		//Wywietlanie tytuu
		$smarty->assign('title', $titleMsg['VALUE'].' (3/4)');
	}
} else if (isset($_POST['backstep3'])) {
	
	//Tytu dla pierwszego formularza
	$smarty->assign('title', $titleMsg['VALUE'].' (3/4)');
	$publicContent = 'registeruserform.tpl'; //Wstpnie zakadamy, e walidacja si niepowioda
	
	//Utworzenie pierwszego obiektu formularza do celw walidacyjnych
	$appCore->clearLastErrorMessage();
	$formObj = new Forms('registeruser/registeruser_step3.xml');
	if($appCore->getLastErrorMessage()!='') {echo($appCore->getLastErrorMessage()); exit;}
	
	//Wywietlenie poprzednich danych jeeli takowe zostay wczeniej wprowadzone
	$formObj->setValueArray('address_streetname', $_SESSION['NewCustomer']->_address[0]->getStreetName());
	$formObj->setValueArray('address_streetnr', $_SESSION['NewCustomer']->_address[0]->getStreetNr());
	$formObj->setValueArray('address_homenr', $_SESSION['NewCustomer']->_address[0]->getHomeNr());
	$formObj->setValueArray('address_city', $_SESSION['NewCustomer']->_address[0]->getCity());
	$formObj->setValueArray('address_zip', $_SESSION['NewCustomer']->_address[0]->getZip());
	$formObj->setValueArray('address_phone', $_SESSION['NewCustomer']->_address[0]->getPhone());
	$formObj->setValueArray('address_fax', $_SESSION['NewCustomer']->_address[0]->getFax());
	prepareDictionary();
	
} else if (isset($_POST['step4'])) {
	//Wykonano ostatni krok rejestracji
	if (isset($_POST['address_type']))      {$_POST['address_type']       = htmlspecialchars($_POST['address_type']);}
	if (isset($_POST['address_streetname'])){$_POST['address_streetname'] = htmlspecialchars($_POST['address_streetname']);}
	if (isset($_POST['address_streetnr']))  {$_POST['address_streetnr']   = htmlspecialchars($_POST['address_streetnr']);}
	if (isset($_POST['address_homenr']))    {$_POST['address_homenr']     = htmlspecialchars($_POST['address_homenr']);}
	if (isset($_POST['address_city']))      {$_POST['address_city']       = htmlspecialchars($_POST['address_city']);}
	if (isset($_POST['address_zip']))       {$_POST['address_zip']        = htmlspecialchars($_POST['address_zip']);}
	if (isset($_POST['address_state']))     {$_POST['address_state']      = htmlspecialchars($_POST['address_state']);}
	if (isset($_POST['address_country']))   {$_POST['address_country']    = htmlspecialchars($_POST['address_country']);}
	if (isset($_POST['address_phone']))     {$_POST['address_phone']      = htmlspecialchars($_POST['address_phone']);}
	if (isset($_POST['address_fax']))       {$_POST['address_fax']        = htmlspecialchars($_POST['address_fax']);}
	
	//Tytu dla pierwszego formularza
	$smarty->assign('title', $titleMsg['VALUE'].' (3/4)');
	$publicContent = 'registeruserform.tpl'; //Wstpnie zakadamy, e walidacja si niepowioda
	
	//Utworzenie pierwszego obiektu formularza do celw walidacyjnych
	$appCore->clearLastErrorMessage();
	$formObj = new Forms('registeruser/registeruser_step3.xml');
	if($appCore->getLastErrorMessage()!='') {echo($appCore->getLastErrorMessage()); exit;}

	//Walidacja formularza w kroku rejstracyjnym 2
	$result = array(); $formObj->checkForm($result);
	if (count($result)==0) {
		//Walidacja ostatniego kroku przebiega pomylnie

		//
		if (!isset($_SESSION['NewCustomer']->_address[0])) {
			$adrObj = new Address();		
			$_SESSION['NewCustomer']->addAddress($adrObj);
			
		}
		
		$_SESSION['NewCustomer']->_address[0]->setAddressType($_POST['address_type']);
		$_SESSION['NewCustomer']->_address[0]->setStreetName($_POST['address_streetname']);
		$_SESSION['NewCustomer']->_address[0]->setStreetNr($_POST['address_streetnr']);
		$_SESSION['NewCustomer']->_address[0]->setHomeNr($_POST['address_homenr']);
		$_SESSION['NewCustomer']->_address[0]->setCity($_POST['address_city']);
		$_SESSION['NewCustomer']->_address[0]->setZip($_POST['address_zip']);
		$_SESSION['NewCustomer']->_address[0]->setState($_POST['address_state']);
		$_SESSION['NewCustomer']->_address[0]->setCountry($_POST['address_country']);
		$_SESSION['NewCustomer']->_address[0]->setPhone($_POST['address_phone']);
		$_SESSION['NewCustomer']->_address[0]->setFax($_POST['address_fax']);

		
		//Wywietlanie trzeciego formularza
		//Tworzenie formularza w trzecim kroku rejestacji
		$appCore->clearLastErrorMessage();
		$formObj = new Forms('registeruser/registeruser_step4.xml');
		if($appCore->getLastErrorMessage()!='') {echo($appCore->getLastErrorMessage()); exit;}
			
		//Wywietlanie tytuu
		$publicContent = 'registeruserfinish.tpl'; //Wstpnie zakadamy, e walidacja si niepowioda
		$smarty->assign('title', $titleMsg['VALUE'].' (4/4)');
		$smarty->assign_by_ref('newuser', $_SESSION['NewCustomer']);
		
	} else {prepareDictionary();}
} else if (isset($_POST['save'])) {
	
		//Prba zapisania danych uytkownika
		$publicContent = 'operationresult.tpl';
		$smarty->assign('operationTitle', $titleMsg['VALUE'].' - Wynik operacji');
		
		//Prba zarejestrowania klienta
		if (isset($_SESSION['NewCustomer'])) {
			$_SESSION['NewCustomer']->setType('C');
			$_SESSION['NewCustomer']->setActive(1);
			if (PEAR::isError($err = CustomUser::Register($_SESSION['NewCustomer'], $_SESSION['NewCustomer']->getPassword()))) {
				//Rejestracja nie powioda si
				$appCore->handleError($err);
				$smarty->assign('message', '<span style="color:#FF0000">Bd: '.$appCore->getLastErrorMessage().'</span>');
			} else {
				//Klient zarejestrowany.
				//Wysyany jest mail do klienta
				
				//Pobranie danych uytkownika
				$user = CustomUser::getUserData($_SESSION['NewCustomer']->getId());
				
				//Budowanie treci wiadomoci e-mail
				$params[] = $user->getName();
				$params[] = $user->getId();
				$params[] = APPLICATION_NAME;
				$params[] = 'http://'.$_SERVER['HTTP_HOST'].'/?menu=74418876d69e6fe9a04612d2f0ebc36b&activate='.md5(md5($user->getId()).md5($user->getCreateDate(TRUE)));
				$params[] = '<a href="mailto:'.ADMIN_EMAIL.'">'.ADMIN_EMAIL.'</a>';
				$emailMsg = $appCore->getMessage('customer_register', 'emailmsg', $params);
				
				//Tytu wiadomoci e-mail
				$emailSubject = $appCore->getMessage('customer_register', 'emailsubject', array(APPLICATION_NAME)); 
				
				echo('Oto tre wiadomoci e-mail, ktr powinien otrzyma uytkownik po zarejestrowaniu konta w systemie:</p>'.$emailMsg['VALUE']);
				
				//Niezbdne pliki umoliwiajce wysanie wiadomoci
				//e-mail poprzez pakiety klasy PEAR
				require_once ('Mail/mime.php'); //Mail_mime
				require_once ('Mail.php'); //Mail
				
				//Tre maila jako kod HTML
				$html = '<html><head><meta http-equiv="Content-Type" content="text/html; charset=iso-8859-2"><style> * {font-family:tahoma; font-size:12px;} </style></head><body>'.$emailMsg['VALUE'].'</body></html>';
				
				//Nagwki wiadomoci e-mail
				$hdrs = array('From' => APPLICATION_EMAIL, 'Subject' => $emailSubject['VALUE']);
	
				//Obiekt Mail_mime pozwala na atwe tworzenie
				//zoonych wiadomoci e-maili
				$mime = new Mail_mime("\r\n");
				$mime->setHTMLBody($html); //Tre wiadomoci jako kod HTML
				
				$body = $mime->get(array('html_charset' => 'iso-8859-2')); //Ciao wiadomoci e-mail
				$hdrs = $mime->headers($hdrs); //Nagwki wiadomoci e-mail

				//Obiekt Mail zawiera interfejs, dziki ktremu
				//w prosty sposb mona wysya dowolnie zoone wiadomoci e-mail
				if(PEAR::isError($mail = &Mail::factory('mail'))) {
					//Utworzenie obiektu Mail nie powido si
					$errmsg = $appCore->getMessage('customer_register', 'emailfailed', array('<b>'.$user->getId().'</b>', '<a href="mailto:'.ADMIN_EMAIL.'">'.ADMIN_EMAIL.'</a>'));
					$smarty->assign('message', '<span style="color:#FF0000">'.$errmsg['VALUE'].'</span>');
				} else if(PEAR::isError($err = $mail->send($user->getEmail(), $hdrs, $body))) {
					//Wysanie wiadomoci e-mail nie powiodo si
					$errmsg = $appCore->getMessage('customer_register', 'emailfailed', array('<b>'.$user->getId().'</b>', '<a href="mailto:'.ADMIN_EMAIL.'">'.ADMIN_EMAIL.'</a>'));
					$smarty->assign('message', '<span style="color:#FF0000">'.$errmsg['VALUE'].'</span>');
				} else {
					//Wysanie wiadomoci e-mail powiodo si
		   			$regok = $appCore->getMessage('customer_register', 'reguserok', array('<b>'.$user->getId().'</b>', '<i>'.$user->getEmail().'</i>'));
					$smarty->assign('message', $regok['VALUE']);
				}
			}
			session_unregister('NewCustomer');
		} else {
			$smarty->assign('message', 'Brak danych uytkownika');
		}
	
} else {
	//Sesja nie istnieje, wic obsugiwany jest pierwszy formularz.
	//Czyszczenie ostatniego bdu aby sprawdzi czy podczas tworzenia obiektu 
	//formularza nie zosta wygenrowany bd

	$appCore->clearLastErrorMessage();
	$formObj = new Forms('registeruser/registeruser_step1.xml');
	if($appCore->getLastErrorMessage()!='') {echo($appCore->getLastErrorMessage()); exit;}
	
	//Nie istnieje zmienna step1 wiec zakadamy uytkownik pierwszy raz
	//wywietla formularz
	
	//Dokument zawierajcy szablon
	$publicContent = 'registeruserform.tpl';

	$smarty->assign('title', $titleMsg['VALUE'].' (1/4)');
}

//Przypisanei obiektu formularza do 
$smarty->assign_by_ref('form', $formObj);
?>