<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+

//Zaadowanie niezbdnych moduw
global $appCore;
if (PEAR::isError($err = $appCore->loadModule('Producer'))){echo($appCore->getLastErrorMessage()); exit;}
if (PEAR::isError($err = $appCore->loadModule('Tax'))){echo($appCore->getLastErrorMessage()); exit;}
if (PEAR::isError($err = $appCore->loadModule('Item'))){echo($appCore->getLastErrorMessage()); exit;}		
/**
 * Klasa Product opisujca produkt w sklepie
 * Dziedziczy po klasie ThorObject
 */
class Product extends Object {
	/**#@+
   	 * @access protected
   	 */
  	/**
   	 * @var object Podatek VAT
   	 */
  	var  $_Tax;
  	/**
   	 * @var object Asortyment
   	 */
  	var  $_Item;
	/**
	 * @var Nazwa asortymenu w przypadku produktu zamwionego
	 */
	var $_ItemName;
  	/**
   	 * @var object Waluta
   	 */
  	var  $_Currency;
  	/**
   	 * @var object Producent
   	 */
  	var  $_Producer = NULL;
  	/**
   	 * @var float Cena
   	 */
  	var  $_Price = 0;
  	/**
   	 * @var int Ilo na magazynie
   	 */
  	var  $_Quantity = 0;
  	/**
   	 * @var string Data udostpnienia w sklepie
   	 */
  	var  $_AvailableDate;
  	/**
   	 * @var int Ilo ogldni
   	 */
  	var  $_ViewCount = 0;
  	/**
   	 * @var array Zdjcia produktu
   	 */
  	var  $_Image = array();
  	/**
   	 * @var array Kategorie produktu
   	 */
  	var  $_Category = array();
	/**
	 * @var object Special
	 */
	var $_Special;
    /**#@-*/
	 
  	/**
   	 * Domylna metoda wywoywana podczas inicjalizacji obiektw tej klasy
   	 * @access public
   	 * @param array $productdata Tablica z danymi o produkcie
   	 * @return mixed
   	 */
	function Product($productdata = array())
	{
		// Okrelenie domylnej metody obsugi bdw
		$this->setErrorHandling(PEAR_ERROR_CALLBACK, array(&$this, 'errorHandlerProduct'));

		foreach ($productdata as $key => $value) { 
			switch (strtolower($key)) {
				case 'prd_id':
					$this->setId($value);
					break;
				case 'usr_id':
					$this->setOwner($value);
					break;
				case 'itm_id':
					$this->setItem($value);
					break;
				case 'itm_name':
					$this->setItemName($value);
					break;
				case 'tax_id':
					$this->setTax($value);
					break;
				case 'prc_id':
					$this->getProducerData($value);
					break;
				case 'prd_price':
					$this->setPrice($value);
					break;
				case 'prd_quantity':
					$this->setQuantity($value);
					break;
				case 'prd_availabledate':
					$this->setAvailableDate($value);
					break;
				case 'prd_createdate':
					$this->setCreateDate($value);
					break;
				case 'prd_lastmodifydate':
					$this->setLastModifyDate($value);
					break;
				case 'prd_viewcount':
					$this->setViewCount($value);
					break;
				case 'prd_active':
					$this->setActive($value);
					break;
			}
		}
		$this->getImageData();
		//$this->getTaxData($_SESSION['CurrentUser']);
		//$this->getCurrencyData($_SESSION['CurrentUser']);
		$this->getCategoryData($_SESSION['CurrentUser']);
	}
  	/**
   	 * Ustawia dane o asortymencie produktu
   	 * @access public
   	 * @param string $itemid Identyfikator asortymentu
   	 * @return mixed
   	 */
	function setItem($itemid)
	{
		if (PEAR::isError($result = $this->parseVar($itemid, 'id'))) {
			return $result;
		} else {
			$this->_Item = current(Item::getItemData($_SESSION['CurrentUser'], $itemid));
		}
	}
	/**
	 * Ustawia nazw asortymentu zamwionego produktu
	 * @param string $itemname Nazwa asortymentu z zamwionego produktu
	 */
	function setItemName($itemname) {
		$this->_ItemName = $itemname;
	}
  	/**
   	 * Ustawia dane o stawce podatku VAT 
   	 * @access public
   	 * @param string $taxid Identyfikator stawki podatku VAT
   	 * @return mixed
   	 */
	function setTax($taxid)
	{
		if (PEAR::isError($result = $this->parseVar($taxid, 'id'))) {
			return $result;
		} else {
			$this->_Tax = current(Tax::getData($taxid, 'all'));
		}
	}
  	/**
   	 * Ustawia cen produktu
   	 * @access public
   	 * @param string $price Cena
   	 * @return mixed
   	 */
	function setPrice($price)
	{
		if (PEAR::isError($result = $this->parseVar($price, 'numeric'))) {
			return $result;
		} else {
			$this->_Price = $price;
		}
	}
  	/**
   	 * Ustawia ilo produktu na magazynie
   	 * @access public
   	 * @param string $quantity Ilo
   	 * @return mixed
   	 */
	function setQuantity($quantity)
	{
		if (PEAR::isError($result = $this->parseVar($quantity, 'numeric'))) {
			return $result;
		} else {
			$this->_Quantity = $quantity;
		}
	}
  	/**
   	 * Ustawia dat dostpnoci produktu w sklepie
   	 * @access public
   	 * @param string $availabledate Data
   	 * @return mixed
   	 */
	function setAvailableDate($availabledate)
	{
		if (PEAR::isError($result = $this->parseVar($availabledate, 'date'))) {
			return $result;
		} else {
			$this->_AvailableDate = $availabledate;
		}
	}
  	/**
   	 * Ustawia liczb ogldnie produktu
   	 * @access public
   	 * @param string $viewcount Ilo ogldni
   	 * @return mixed
   	 */
	function setViewCount($viewcount)
	{
		if (PEAR::isError($result = $this->parseVar($viewcount, 'integer'))) {
			return $result;
		} else {
			$this->_ViewCount = $viewcount;
		}
	}
  	/**
   	 * Dodaje produkt do nowej kategorii
   	 * @access public
   	 * @param object $category Kategoria
   	 * @return mixed
   	 */
	function addCategory(&$category)
	{
		//if (PEAR::isError($result = $this->parseVar($param,'array', array(array('not_null'))))) {
		//	return $result;
		//} else {
		//	$param->getParamValue($this->getId());
			$this->_Category[] = $category;
		//}
	}
  	/**
   	 * Przypisuje zdjcie do produktu
   	 * @access public
   	 * @param object $image Zdjcie
   	 * @return mixed
   	 */
	function addImage(&$image)
	{
		//if (PEAR::isError($result = $this->parseVar($param,'array', array(array('not_null'))))) {
		//	return $result;
		//} else {
		//	$param->getParamValue($this->getId());
			$this->_Image[] = $image;
		//}
	}
  	/**
   	 * Dodaje producenta do produktu
   	 * @access public
   	 * @param object $producer Producent
   	 * @return mixed
   	 */
	function setProducer(&$producer){$this->_Producer = $producer;}
	/**
	 * Dodaje promocj do produktu
	 * @param object $special Obiekt promocji
	 */
	function setSpecial(&$special) { $this->_Special = &$special;}
  	/**
   	 * Zwraca obiekt stawki podatku VAT
   	 * @access public
   	 * @return object
   	 */
	function getTax(){ return $this->_Tax;}
  	/**
   	 * Zwraca cen produktu
   	 * @access public
   	 * @return float
   	 */
	function getPrice() {
		switch (DEFAULT_PRICE) {
			case 'netto':
				return $this->getPriceNetto();
				break;
			case 'brutto':
				return $this->getPriceBrutto();
				break;
			default:
				return $this->getPriceBrutto();
		}
	}
  	/**
   	 * Zwraca cen netto produktu
   	 * @access public
   	 * @return float
   	 */
	function getPriceNetto(){ return $this->_Price;}
  	/**
   	 * Zwraca cen brutto produktu
   	 * @access public
   	 * @return float
   	 */
	function getPriceBrutto() { 
		if ($this->_Tax <> '' && $this->_Tax->getValue() > 0) {
			$tax = 1 + $this->_Tax->getValue()/100;
		} else { $tax = 1;}
		$price = $this->_Price * $tax;
		return $price;
	}
  	/**
   	 * Zwraca ilo produktu na magazynie
   	 * @access public
   	 * @return integer
   	 */
	function getQuantity(){ return $this->_Quantity;}
  	/**
   	 * Zwraca obiekt producenta
   	 * @access public
   	 * @return object
   	 */
	function getProducer(){ return $this->_Producer;}
  	/**
   	 * Zwraca dat dostpnoci produktu w sklepie
   	 * @access public
   	 * @return string
   	 */
	function getAvailableDate(){ return $this->_AvailableDate;}
  	/**
   	 * Zwraca ilo ogldni produktu
   	 * @access public
   	 * @return int
   	 */
	function getViewCount(){ return $this->_ViewCount;}
  	/**
   	 * Zwraca domylne zdjcie produktu
   	 * @access public
   	 * @return mixed
   	 */
	function getDefaultImage() { 
		foreach ($this->getImages() as $key => $value) {
			if ($value->getDefault() === TRUE) {
				return $value;
			}		
		}
		return NULL;
	}
  	/**
   	 * Zwraca tablic kategorii, do ktrych naley produkt
   	 * @access public
   	 * @return array
   	 */
	function getCategories(){ return $this->_Category;}
  	/**
   	 * Zwraca tablic zdj produktu
   	 * @access public
   	 * @return array
   	 */
	function getImages(){ return $this->_Image;}
	/**
	 * Zwraca nazw zamwionego produktu
	 * 
	 * @return string
	 */
	function getItemName() {return $this->_ItemName;}
  	/**
   	 * Zwraca podstawowe informacje o produkcie
	 * @param object $user Obiekt typu ThorUser, wskazujca na uytkownika
	 * pobierajcego te dane.
	 * @param string $id Identyfikator produktu, ktrego dane chcemy uzyska.
	 * Warto domylna NULL (pobrane zostan dane wszystkich produktw)
   	 * @access public
   	 * @return mixed
   	 */
	function getData($user, $id = NULL) {

		//Rdze aplikacji
		global $appCore; 
		$product_list = array();
		// Ustawienie poprawnego identyfikatora produktu oraz kryteriw 
		// wyszukiwania
		if (isset($id)) {
			if (PEAR::isError($result = Object::parseVar($id,'id'))) { return $result;}
			$where_statement = " WHERE Product.PRD_Id = '$id' AND Product.PRD_Active = 1";
		} else { 
			$where_statement = " WHERE Product.PRD_Active = 1";
		}
		
   		// Pobranie podstawowych informacji o obiektach
   		$sqlquery = "SELECT * FROM Product $where_statement";
		if (DB::isError($result = &$appCore->Query($sqlquery))) {return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);}

		while ($productdata = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
			$product_list[] = new Product($productdata);
		}

		return $product_list;	
	}
  	/**
   	 * Zwraca podstawowe informacje o produkcie na podstawie identyfikatora
   	 * asortymentu
	 * @param string $id Identyfikator asortymentu, po ktrym bdziemy szuka.
   	 * @access public
   	 * @return mixed
   	 */
	function getDataByItem($itemid) {

		//Rdze aplikacji
		global $appCore; 
		$product_list = array();
		if (PEAR::isError($result = Object::parseVar($itemid,'id'))) { return $result;}
		$where_statement = " WHERE Product.ITM_Id = '$itemid' AND Product.PRD_Active = 1";
		
   		// Pobranie podstawowych informacji o obiektach
   		$sqlquery = "SELECT * FROM Product $where_statement";
		if (DB::isError($result = &$appCore->Query($sqlquery))) {return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);}

		while ($productdata = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
			$product_list[] = new Product($productdata);
		}

		return $product_list;	
	}
  	/**
   	 * Zwraca podstawowe informacje o produktach w danej kategorii
	 * @param string $categoryid Identyfikator kategorii, do ktrej naley produkt.
	 * Warto domylna NULL (pobrane zostan dane z wszystkich kategorii)
   	 * @access public
   	 * @return mixed
   	 */
	function getDatabyCategory($categoryid = NULL) {
		global $appCore; 
		$product_list = array();
		
		// Ustawienie poprawnego identyfikatora kategorii oraz kryteriw 
		// wyszukiwania
		if (isSet($categoryid)) {
			if (PEAR::isError($result = Object::parseVar($categoryid, 'id'))) { return $result;}
			$where_statement = " WHERE Product.PRD_Id = prd_isin_cat.PRD_Id AND prd_isin_cat.CAT_Id = Category.CAT_Id AND (prd_isin_cat.CAT_Id = '$categoryid' OR Category.CAT_Parent = '$categoryid') AND Product.PRD_Active = 1 AND Category.CAT_Active = 1";
		} else { 
			$where_statement = " WHERE Product.PRD_Id = prd_isin_cat.PRD_Id AND prd_isin_cat.CAT_Id = Category.CAT_Id AND Product.PRD_Active = 1 AND Category.CAT_Active = 1";
		}
		
   		// Pobranie podstawowych informacji o obiektach
   		$sqlquery = "SELECT * FROM Product, prd_isin_cat, Category $where_statement";
		if (DB::isError($result = &$appCore->Query($sqlquery))) {
   			return $result;
   		}
		while ($productdata = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
			//if (parent::checkObjectAccess($user, $surveydata['srv_id'], 'r')) {
			$product_list[] = new Product($productdata);
			//}
		}

		//if (isSet($product_list) && sizeof($product_list) > 0) {
			return $product_list;	
		//} else { return PEAR::raiseError($id, -3, null, null, PEAR_LOG_NOTICE);}
	}
	/**
	 * Zwraca czn liczb produktw znajdujcych si w kategorii 
	 * oraz jej podkategoriach
	 *
	 * @param string $categoryid Identyfikator kategorii, do ktrej naley produkt.
   	 * @access protected
	 *
	 *	Metoda _getProductNumber jest metod pomocnicz dla metody getProductNumber
	 *  Nie powinna by wywoywana w inny sposb
   	 * @return int
	 */
	function _getProductNumber($categoryid) {
		//Rdze aplikacji
		global $appCore;

		//Licznik produktw
		$prodCounter = 0;
					
		//Lista produktw w rozpatrywanej kategorii
		$sqlquery = 'SELECT COUNT(DISTINCT(PRD_Id)) FROM prd_isin_cat WHERE CAT_Id="'.$categoryid.'"';		
		if (DB::isError($result = $appCore->Query($sqlquery))) {return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);}
		$row = $result->fetchRow();
		$prodCounter = $row[0];
					
		//Lista podkategorii
		//Lista produktw w rozpatrywanej kategorii
		$sqlquery = 'SELECT CAT_Id FROM Category WHERE CAT_Parent="'.$categoryid.'"';		
		if (DB::isError($result = $appCore->Query($sqlquery))) {return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);}
		while($row = $result->fetchRow()) {
			$prodCounter += $this->_getProductNumber($row[0]);
		}

		return $prodCounter;
	}
	/**
	 * Zwraca czn liczb produktw znajdujcych si w kategorii 
	 * oraz jej podkategoriach
	 *
	 * @param string $categoryid Identyfikator kategorii, do ktrej naley produkt.
   	 * @access protected
	 *
   	 * @return int
	 */
	function getProductNumber($categoryid = NULL) {
		
		//Badanie poprawnoci identyfikatora kategorii
		if(!Object::parseVar($categoryid, 'id')) {return PEAR::raiseError($categoryid, -5002, null, null, PEAR_LOG_ERR);}
		
		//Rdze aplikacji
		global $appCore;
		
		if (!$categoryid) {
			//Zwracana jest cakowita liczba produktw
			$sqlquery = 'select COUNT(DISTINCT(PRD_Id)) from prd_isin_cat';
			if (DB::isError($result = $appCore->Query($sqlquery))) {return PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);}
			$row = $result->fetchRow();
			return $row[0];
		} else {
			//Okrelono Kategori wic zwracana jest liczba produktw znajdujcych
			//si w tej kategorii i jej podkategoriach
			return $this->_getProductNumber($categoryid);
		}
	}
  	/**
   	 * Zwraca informacje o kategoriach, do ktrych naley produkt
	 * @param object $user Obiekt typu ThorUser, wskazujca na uytkownika
	 * pobierajcego te dane.
	 * @param string $categoryid Identyfikator kategorii, ktrej dane chcemy 
	 * uzyska.
	 * Warto domylna NULL (pobrane zostan dane wszystkich kategorii, do ktrych
	 *                        naley produkt)
   	 * @access public
   	 * @return mixed
   	 */
	function getCategoryData(&$user, $categoryid = NULL) {

		//Rdze aplikacji
		global $appCore; 
		
		//Zaadowanie moduu katalogu
		if (PEAR::isError($err = $appCore->loadModule('Catalog'))){echo($appCore->getLastErrorMessage()); exit;}

		// Ustawienie poprawnego identyfikatora kategorii oraz kryteriw 
		// wyszukiwania
		if (isSet($categoryid)) {
			if (PEAR::isError($result = Object::parseVar($categoryid,'id'))) { return $result;}
			$where_statement = " WHERE prd_isin_cat.CAT_Id = Category.CAT_Id AND prd_isin_cat.PRD_Id = '" . $this->getId() . "' AND prd_isin_cat.CAT_Id = '$categoryid' AND Category.CAT_Active = 1";
		} else { 
			$where_statement = " WHERE prd_isin_cat.CAT_Id = Category.CAT_Id AND prd_isin_cat.PRD_Id = '" . $this->getId() . "'  AND Category.CAT_Active = 1";
		}
		
   		// Pobranie informacji o kategoriach obiektu
   		$sqlquery = "SELECT prd_isin_cat.CAT_Id FROM prd_isin_cat, Category $where_statement";
		if (DB::isError($result = &$appCore->Query($sqlquery))) {
   			return $result;
   		}

		while ($categoryid = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
			//if (parent::checkObjectAccess($user, $surveydata['srv_id'], 'r')) {
			if (PEAR::isError($category = Catalog::getCategoryData(current($categoryid)))) { return $category;}
			$this->addCategory($category);
			//}
		}
		return TRUE;
	}
  	/**
   	 * Zwraca informacje o producencie productu
	 * @param string $producerid Identyfikator producenta, ktrej dane chcemy 
	 * uzyska.
   	 * @access public
   	 * @return mixed
   	 */
	function getProducerData($producerid) {

		global $appCore; 

   		if (PEAR::isError($producer = Producer::getData($producerid))) {
			return $producer;
		} else {
			$this->setProducer(current($producer));
		}
	}
  	/**
   	 * Zwraca tablic zdj
   	 * @param string $imageid Identyfikator zdjcia
	 * Warto domylna NULL (zwrcone zostan wszystkie zdjcia produktu)
   	 * @param boolean $default Pobranie zdjcia domylnego
	 * Warto domylna FALSE (zwrcone zostan wszystkie zdjcia produktu)
   	 * @access public
   	 * @return array
   	 */
	function getImageData($imageid = NULL, $default = FALSE){ 
		global $appCore; 

		if ($default === TRUE || $default == 1) {
			$default = 'AND Image.IMG_Default = ';
		}

		// Ustawienie poprawnego identyfikatora zdjcia oraz kryteriw 
		// wyszukiwania
		if (isSet($imageid)) {
			if (PEAR::isError($result = Object::parseVar($imageid,'id'))) { return $result;}
			$where_statement = " WHERE prd_has_img.IMG_Id = Image.IMG_Id AND prd_has_img.PRD_Id = '" . $this->getId() . "' AND prd_has_img.IMG_Id = '$imageid' $default";
		} else { 
			$where_statement = " WHERE prd_has_img.IMG_Id = Image.IMG_Id AND prd_has_img.PRD_Id = '" . $this->getId() . "' $default";
		}
		
   		// Pobranie informacji o kategoriach obiektu
   		$sqlquery = "SELECT prd_has_img.IMG_Id FROM prd_has_img, Image $where_statement";
		if (DB::isError($result = &$appCore->Query($sqlquery))) {
   			return $result;
   		}

		while ($imageid = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
			//if (parent::checkObjectAccess($user, $surveydata['srv_id'], 'r')) {
			if (PEAR::isError($image = Image::getData(current($imageid)))) { return $category;}
			$this->addImage(current($image));
			//}
		}
		return TRUE;
	}
  	/**
   	 * Metoda zapisujca dane produktu w bazie danych
   	 *
   	 * @access public
   	 * @param mixed $product Obiekt Product
   	 * @return mixed
   	 */
   	function saveData($product = NULL)
   	{
		global $appCore;

		if ($product == NULL) { $product = &$this;}
		$product->setCreateDate(date(DATE_FORMAT_DBSAVE));

   		// Zapisanie danych
   		if (PEAR::isError($result = saveProduct($product))) {
			return $result;
   		} else {
   			return TRUE;
   		}
	} 
  	/**
   	 * Metoda sprawdza czy produkt o wskazanym identyfikatorze istnieje
   	 *
   	 * @access public
   	 * @param string $_prodid Identyfikator produktu
   	 * @return mixed
   	 */
	function doesProductExist($_prodid) {
		//Rdzea plikacji
		global $appCore;

		//Przygotowywanie zapytania SQL
		$sqlquery = 'SELECT PRD_Id FROM Product WHERE PRD_Id="'.$_prodid.'"';
		if (DB::isError($result = $appCore->Query($sqlquery))) {
			$err = PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
			if (!isset($this)) {$appCore->handleError($err);}
			return $err;
		}
		
		if ($result->numRows()==1) {return TRUE;}
		return FALSE;
	}
	/**
	 * Metoda sprawdza czy dla danego produktu istnieje aktywna, obowizujca promocja
	 *
	 * Jezeli waciwo _Special nie jest obiektem typu Special metoda 
	 * prbuje utworzy taki obiekt.
	 *
	 * @param bool $reload Parametr wykorzystywany przez koszyk (ze wzgldu na sesj, 
	 * 					   ktra powoduje, e dane nie zawsze s aktualne). Wymusza pobranie
	 *					   danych obiektu promocji bezporednio z bazy danych
	 * @return bool
	 */
	function hasProductAvalSpecial($reload = FALSE) {
		//Rdze aplikacji
		global $appCore;

		//Metoda nie moe by wywoywana statycznie
		if(!isset($this)) {$err = PEAR::raiseError('hasProductAvalSpecial;Product', -5003, null, null, PEAR_LOG_ERR); $appCore->handleError($err); return $err;}
		
		//Sprawdzenie czy modu promocji zosta zaadowany i zaadowanie go w razie koniecznoci
		if (PEAR::isError($err = $appCore->loadModule('Special'))){echo($appCore->getLastErrorMessage()); exit;} 
		
		//Jeeli waciwo _Special nie jest waciwoci klasy Special 
		//naley sprbowa utworzy obiekt
		if ($reload) {$this->_Special = NULL;}
		if (!$this->_Special) {$this->_Special = Special::getSpecialByProductId($this->_Id);}
		
		if(!is_a($this->_Special, 'Special')) {
			//Nie ma aktualnie promocji przypisanej do produktu
			return FALSE;
		} else {
			//Produkt posiada przypisan promocj
			return TRUE;
		}
	}
	/**
	 * Zwraca cen produktu w promocji 
	 * 
	 * @return mixed Warto float lub NULL
	 */
	function getSpecialPrice() {
		switch (DEFAULT_PRICE) {
			case 'netto':
				return $this->getSpecialPriceNetto();
				break;
			case 'brutto':
				return $this->getSpecialPriceBrutto();
				break;
			default:
				return $this->getSpecialPriceBrutto();
		}
	}
	/**
	 * Zwraca cen netto produktu w promocji
	 *
	 * @return mixed float lub NULL
	 */
	 function getSpecialPriceNetto() {
	 	if (is_a($this->_Special, 'Special')) {return $this->_Special->getSpecialPrice();}
		return NULL;
	 }
	/**
	 * Zwraca cen brutto produktu w promocji
	 *
	 * @return mixed float lub NULL
	 */
	 function getSpecialPriceBrutto() { 
	 	if(!($nsPrice = $this->getSpecialPriceNetto())) {return NULL;}
		if ($this->_Tax <> '' && $this->_Tax->getValue() > 0) {
			$tax = 1 + $this->_Tax->getValue()/100;
		} else { $tax = 1;}
		$price = $nsPrice * $tax;
		return $price;
	}
	/**
	 * Zwraca cakowit liczb produktw 
	 *
	 * @param bool $active Parametr okrela czy zwracane s wszystkie produkty, czy tylko
	 *                     Produkty aktywne z kategorii aktywnych
	 * @return mixed Obiekt integer lub PEAR_Error
	 */
	function getTotalProductCount($active=TRUE) {
		//Rdze aplikacji
		global $appCore;
		
		//Przygotowanie i wykonaie pierwszego zapytnia SQL
		$sqlquery = 'SELECT DISTINCT(Product.PRD_Id) FROM Product, prd_isin_cat, Category WHERE Product.PRD_Id = prd_isin_cat.PRD_Id AND prd_isin_cat.CAT_Id = Category.CAT_Id AND Product.PRD_Active = 1 AND Category.CAT_Active = 1';
		if (DB::isError($result = $appCore->Query($sqlquery))) {
			$err = PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
			if (!isset($this)) {Product::errorHandlerProduct($err);}
			return $err;
		}
		
		//Zwracanie wyniku
		return $result->numRows();
	}
	/**
   	 * Domylna metoda obsugi bdw dla obiektw tej klasy
	 * @param mixed $error Kod bdu
   	 * @access public
   	 * @return mixed
   	 */
	function errorHandlerProduct($error) {
	    global $appCore;
		$appCore->handleError($error);
	}
} // Koniec klasy Product

?>