<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+

//Zaadowanie moduu obsugujcego DOM XML
global $appCore;
if (PEAR::isError($err = $appCore->loadModule('XML_DomDoc'))){echo($appCore->getLastErrorMessage()); exit;}

 /**
 * Klasa obiektu obsugi formularza
 *
 * Obiekt na podstawie plikw XML zawierajcych definicj formularzy tworzy z jednej storny
 * odpowiedni kod HTML oraz JavaScript dla klienta, a z drugiej strony dokonuje walidacji danych nadesanych
 * przez klienta po wypenieniu formularza
 *
 */

class Forms extends XML_DomDoc {

	/**#@+
	 * @access private
	 */
	/**
	 * @var _formName String nazwa formularza
	 */
	 var $_formName;
	 /**
	  * @var valueArrays Array Tablica, ktra su do wstpnej inicjacji wartoci elementw formularza
	  */
	 var $valueArrays;
	 /**
	  * @var errorList Array Tablica, zawierajca list bdw formularza po walidacji server-side
	  */
	 var $errorList;
	 /**
	  * @var firstTime bool Zmienna, ktra mwi funkcji genrujcej kod elementu HTML, czy formularz by ju wczeniej wywietlany czy te nie. Mechanizm opiera si na sprawdzeniu, czy istniej zmienne GET lub POST odpowieadjce nazwie takich pl jak TEXT, PASSWORD, czy te TEXTAREA
	  */
	 var $firstTime;
	 /**
	  * @var
	  */
	 var $_msgArray;
	 /**
	  *
	  */
	 /**#@-*/
//-------------------------------------------------
//Konstruktor i destruktor-------------------------
//-------------------------------------------------

	/**
	 * Konstruktor
	 */
	 function forms($formName) {

		//Konstruktor klasy nadrzdnej
	    $this->XML_DomDoc('ISO-8859-1');

		//Standardowa obsuga bdw
		$this->setErrorHandling(PEAR_ERROR_CALLBACK, array(&$this, 'errorHandlerErrorObject'));

		//Definiowanie nazwy formularza
		$this->_formName = str_replace('.', '_', $formName);

		//Zaadowanie listy komunikatw dotyczcych formularza
		global $appCore;
   		$tempVar = $appCore->getMessageSection($this->_formName);
		for($iter=0; $iter<count($tempVar); $iter++) {
			$this->_msgArray[$tempVar[$iter]['ID']] = $tempVar[$iter]['VALUE'];
		}

		//adowanie formularza
		$this->loadFromFile(FORMS_PATH.$formName);

		//Pierwsze uycie formularza
		$this->firstTime = true;
	}
//-------------------------------------------------
//Metody publiczne---------------------------------
//-------------------------------------------------
   /**#@+
	 * @access public
	 */
   /**
    * Metoda walidujca formularz
	*
	* Wynik walidacji jest przekazywany przez referencj do atrybutu wywoania funkcji, ktry jest tablic.
	* Kady element tablicy skda si z dwch elementw 1->Warto atrybutu 'name' elementu lub nazwa 'CONDITION'
	* w przypadku warunku wspzalenego 2-> Tekst bdu wyjty z opisu reguy w XMLu definujcym formularz
	*
	* @param array $resultArray
	*/
   function checkForm(&$resultArray) {
   		//Komunikaty bdw

		//Warunki wspzalene
		function checkCondition($cond, $mtd) {
			$fields = split('#', $cond);
			if($fields[2]=='eq') {
				if ($mtd=='get') {
					if (!isset($_GET[$fields[1]]) || !isset($_GET[$fields[3]])) {return false;}
					if ($_GET[$fields[1]]!=$_GET[$fields[3]]) {return false;}
				} else if($mtd=='post') {
					if (!isset($_POST[$fields[1]]) || !isset($_POST[$fields[3]])) {return false;}
					if ($_POST[$fields[1]]!=$_POST[$fields[3]]) {return false;}
				} else return false;
			}
			return true;
		}

	   	//MIN - MAX
		function checkMinMax($min, $max, $msg) {

			$msg = trim($msg);
			if($max<1) {
				if(strlen($msg)>$min-1) {;
					return true;
				} else {
					return false;
				}
			} else if(strlen($msg)>$min-1 & strlen($msg)<$max+1) {
				return true;;
			} else {
				return false;
			}
		}
		//Maska
		function checkMask($mask, $msg) {
			if(ereg_replace($mask, '', $msg)=='') {
				return TRUE;
			} else return FALSE;
		}
		//Sprawdza jaka selekcja zostaa wykonana
		function checkSelection($selection, $obj) {
			$restrict = explode(';', $selection);
			for($iter=0; $iter<count($restrict); $iter++) {
				if ($obj==$restrict[$iter]) {return false;}
			}
			return true;
		}

		//Waciwy kod
   		$listaElementow = $this->getFormElements();
		$mtd = strtolower($this->getFormMethod());

		//Zabezpieczenie przed bdem
		if ($mtd!='get' & $mtd!='post') {
			$resultArray[] = array('CONDITION', 'Forms XML Error!!!');
			return;
		}

		foreach($listaElementow as $formElemnt) {
			$name = $this->getAttribValue($formElemnt, 'name');
			if ($name) {
				switch(strtolower($formElemnt->name)) {
					case 'checkboxgroup':
						if(!$formElemnt->childNodes) {continue;}
						foreach ($formElemnt->childNodes as $rule) {
							if (strtolower($rule->name) != 'rule') {continue;}
							$require = $this->getAttribValue($rule, 'require');
							if ($require == 'true') {
								if($mtd=='get') {
									if(!isset($_GET[$name])) {
										$message = str_replace('$label', '"'.$this->_msgArray[$this->getAttribValue($formElemnt, 'label')].'"', $this->_msgArray[$this->getAttribValue($rule, 'label')]);
										$resultArray[]=array($name, $message);
									}
								} else {
									if(!isset($_POST[$name])) {
										$message = str_replace('$label', '"'.$this->_msgArray[$this->getAttribValue($formElemnt, 'label')].'"', $this->_msgArray[$this->getAttribValue($rule, 'label')]);
										$resultArray[]=array($name, $message);
									}
								}
							}
						}

					break;
					case 'radiobuttongroup':
						if(!$formElemnt->childNodes) {continue;}
						foreach ($formElemnt->childNodes as $rule) {
							if (strtolower($rule->name) != 'rule') {continue;}
							$require = $this->getAttribValue($rule, 'require');
							if ($require == 'true') {
								if($mtd=='get') {
									if(!isset($_GET[$name])) {
										$message = str_replace('$label', '"'.$this->_msgArray[$this->getAttribValue($formElemnt, 'label')].'"', $this->_msgArray[$this->getAttribValue($rule, 'label')]);
										$resultArray[]=array($name, $message);
									}
								} else {
									if(!isset($_POST[$name])) {
										$message = str_replace('$label', '"'.$this->_msgArray[$this->getAttribValue($formElemnt, 'label')].'"', $this->_msgArray[$this->getAttribValue($rule, 'label')]);
										$resultArray[]=array($name, $message);
									}
								}
							}
						}
					break;
					case 'combobox':
						if ($mtd=='get') {
							if(!isset($_GET[$name])) {
								$resultArray[] = array($name, 'Nie podano wartoci');
								continue;
							}
							$_value = $_GET[$name];
						} else {
							if(!isset($_POST[$name])) {
								$resultArray[] = array($name, 'Nie podano wartoci');
								continue;
							}
							$_value = $_POST[$name];
						}

						//Badanie regu
						if(!$formElemnt->childNodes) {continue;}
						foreach ($formElemnt->childNodes as $rule) {
							if (strtolower($rule->name) != 'rule') {continue;}
							$selection = $this->getAttribValue($rule, 'selection');
							if($selection) {
								if(!checkSelection($selection, $_value)) {
									$message = str_replace('$label', '"'.$this->_msgArray[$this->getAttribValue($formElemnt, 'label')].'"', $this->_msgArray[$this->getAttribValue($rule, 'label')]);
									if (isset($min) & isset($max)) {
										$message = str_replace('$min', $min, str_replace('$max', $max, $message));
									}
									$resultArray[]=array($name, $message);
								}
							}
						}
					break;
					case 'textfield':
					case 'passwordfield':
					case 'textarea':
						if ($mtd=='get') {
							if(!isset($_GET[$name])) {
								$resultArray[] = array($name, 'Nie podano wartoci');
								continue;
							}
							$_name = $_GET[$name];
						} else {
							if(!isset($_POST[$name])) {
								$resultArray[] = array($name, 'Nie podano wartoci');
								continue;
							}
							$_name = $_POST[$name];
						}

						//Badanie regu
						if(!$formElemnt->childNodes) {continue;}
						foreach ($formElemnt->childNodes as $rule) {
							if (strtolower($rule->name) != 'rule') {continue;}
							$min = $this->getAttribValue($rule, 'min'); if(!$min) {$min = 0;}
							$max = $this->getAttribValue($rule, 'max'); if(!$max) {$max = 0;}
							$mask = $this->getAttribValue($rule, 'mask');
							$result = array();
							if($min>0 || $max>0) {
								$result[] = checkMinMax($min, $max, $_name);
								if($mask) {
									$result[] = checkMask($mask, $_name);
								}
							} else if ($mask) {
								$result[] = checkMask($mask, $_name);
							}
							$correct = true;
							for($iter=0; $iter<count($result); $iter++) {
								if(!$result[$iter]) {
									$correct = false;
									continue;
								}
							}
							if(!$correct) {
								$message = str_replace('$label', '"'.$this->_msgArray[$this->getAttribValue($formElemnt, 'label')].'"', $this->_msgArray[$this->getAttribValue($rule, 'label')]);
								$message = str_replace('$min', $min, str_replace('$max', $max, $message));
								$resultArray[]=array($name, $message);
							}
						}
					break;
				}
			}
		}

		//Warunki wspzalene
		foreach($this->documentElement->childNodes as $ruleElem) {
			if($ruleElem->name!='CONDITION') {continue;}
			//Regua
			$rule = $this->getAttribValue($ruleElem, 'rule');
			if(!checkCondition($rule, strtolower($this->getFormMethod()))) {
				$message = $this->_msgArray[$this->getAttribValue($ruleElem, 'label')];
				$resultArray[]=array('CONDITION', stripcslashes($message));
			}
		}

		$this->errorList = $resultArray;
   }
   /**
    * Metoda tworzy wpis w tablicy sucej do wstpnego inicjowania elementw formularza
	*
	* @param string $_arrayName Nazwa tablicy zawierajcej wartoci
	* @param array  $_array Wartoci
	*/
   function setValueArray($_arrayName, $_array) {
   		$this->valueArrays[$_arrayName] = $_array;
   }
   /**
    * Metoda zwraca warto atrybutu 'action' z elementu FORM XMLa definiujcego formularz.
	*/
   function getFormAction() {
   		return $this->getAttribValue($this->documentElement, 'action');
   }
   function setFormAction($actionName) {
   		$domDoc = $this->documentElement;
		if(!$domDoc->attributes) {return FALSE;}
		for($iter=0; $iter<count($domDoc->attributes); $iter++) {
			if(strtolower($domDoc->attributes[$iter][0]) == 'action') {
				$this->documentElement->attributes[$iter][1] = $actionName;
			}
		}
   }
   /**
    * Metoda zwraca warto atrybutu 'method' z elementu FORM XMLa definiujcego formularz.
	*/
   function getFormMethod() {
   		return $this->getAttribValue($this->documentElement, 'method');
   }
   /**
    * Metoda zwraca warto atrybutu 'submit' z elementu FORM XMLa definiujcego formularz.
	*/
   function getFormSubmit() {
   		if( isset($this->_msgArray[$this->getAttribValue($this->documentElement, 'submit')])) {
   			return $this->_msgArray[$this->getAttribValue($this->documentElement, 'submit')];
		}
   }
   /**
    * Metoda zwraca warto atrybutu 'reset' z elementu FORM XMLa definiujcego formularz.
	*/
   function getFormReset() {
   		if( isset($this->_msgArray[$this->getAttribValue($this->documentElement, 'reset')])) {
   			return $this->_msgArray[$this->getAttribValue($this->documentElement, 'reset')];
		}
   }
   /**
    * Metoda zwraca wszystkie elementy formularza.
	*
	* W XMLu definujcym elementy formularza to dzieci elemetu FORM w wyjtkiem elementw CONDITION.
	*/
   function getFormElements() {
   		$elementList = array();
   		foreach($this->documentElement->childNodes as $element) {
			if($element->name!='CONDITION' & $element->name!='HIDDENFIELD' & $element->name!='RESETBUTTON' & $element->name!='SUBMITBUTTON') {$elementList[] = $element;}
		}
   		return $elementList;
   }
   /**
    * Metoda zwraca warto atrybutu labelPL wybranego elementu formularza.
	*
	* @param XML_DOMDOC $_domElement
	*/
   function getFormElementLabel($_domElement) {
   		if( isset($this->_msgArray[$this->getAttribValue($_domElement, 'label')])) {
   			return $this->_msgArray[$this->getAttribValue($_domElement, 'label')];
		}
   }
   /**
    * Metoda zwraca list bdw powstaych po walidacji server-side,
	* ktre s bdami warunkw wspzalenych (CONDITION)
	*
	* @return Array String Lista bdw warunkw wspzalenych
	*/
   function getConditionErrors() {
   		$erList = null;
   		if(!$this->errorList) {return $erList;}
		foreach($this->errorList as $error) {
			if ($error[0] == 'CONDITION') {$erList[] = $error[1];}
		}
		return $erList;
   }
   /**
    * Metoda pozwala na utworzenie bdu warunku wspzalenego.
	*
	* Metoda powinna by wykorzystywana, jeeli na formularzu powinien by
	* wywietlany komunikat o bdzie, ktrego (bdu) nie da si sprawdzi poprzez
	* zwyke reguy walidacyjne oraz reguy wspzalene. Np. Formularz rejestracji owego
	* uykownika pozwala na wprowadzenie proponowanego identyfikator, ale jego reguy walidacyjne
	* oraz warunki wspzalene nie mog spraedzi czy warto z danego pola, do ktorego uytkownik wprowadzi
	* identyfdikator jest unikalna w bazie danych. Skrypt moe sprawdzi to sam i korzystajc z tej metody spowodowa,
	* e bd ten zostanie wywietlony na formularzu jako bd warunku wspzalenego
	*
	* @param String Tre komunikato bdu
    */
   function setConditionError($errorMsg) {$this->errorList[] = array('CONDITION', $errorMsg);}
   /**
    * Metoda zwraca komunikat bdu powstay po walidacji server-side dla wybranego elementu formularza
	*
	* @param XML_DOMDOC $_domElement
	*/
   function getErrorMessage($_domElement) {
   		if(!$this->errorList) {return '';}
   		foreach($this->errorList as $error) {
			if($error[0] == $this->getAttribValue($_domElement, 'name')) {
				return $error[1];
			}
		}
		return '';
   }
   /**
    * Metoda ustawia komunikat bdu dla wybranego pola
	*
	* @param string Nawa elementu formularz, ktrego ma dotyczy bd
	* @param string Tre komunikatu bdu
    */
	function setErrorMessage($_formElemName, $_message) {$this->errorList[] = array($_formElemName, $_message);}
   /**
    * Metoda zwraca kod HTML wszystkich elementw typu HIDDEN
	*
	* Kod ten cakowicie definuje elementy HIDDEN w dokumencie HTML.
	*/
   function getHiddenFormElementCode() {
	   	$codeHidden = '';
		if(!$this->documentElement->childNodes) {return '';}
   		foreach($this->documentElement->childNodes as $element) {
			if($element->name=='HIDDENFIELD') {
				$name  = $this->getAttribValue($element, 'name');
				$value = $this->getAttribValue($element, 'dbvalue');
				if(!$value) {
					$this->getAttribValue($element, 'value');
				} else {
					if (!isset($this->valueArrays[$value])) {continue;}
					$value = $this->valueArrays[$value];
				}
				$codeHidden .= '<input type="hidden" name="'.$name.'" value="'.$value.'"/>';
			}
		}
   		return $codeHidden;
   }
   /**
    * Metoda zwraca kod HTML wybranego elementu formularza
	*
	* Kod ten cakowicie definuje wybrany element formularza w dokumencie HTML.
	*
	* @param XML_DOMDOC $_domElement
	*/
   function getFormElementCode($_domElement) {
   		$elemType = $this->getFormElementType($_domElement);
		$code = ''; $code2 = '';
		$_useArray = false;

		//Warto wstpna
		$valName = $this->getAttribValue($_domElement, 'name');
		$value = false;
		$mtd = strtolower($this->getFormMethod());
		if($mtd == 'get') {
			if (isset($_GET[$valName])) {$value =  $_GET[$valName]; $this->firstTime = false;}
		} else if ($mtd=='post') {
			if (isset($_POST[$valName])) {$value = $_POST[$valName]; $this->firstTime = false;}
		}

		//name="{$formObject->getFormElementName($formElem)}" size="{$formObject->getFormElementSize($formElem)}" maxlength="{$formObject->getFormElementMaxLength($formElem)}"/>
   		switch ($elemType) {
			case 'filefield':
				$code = '<input type="file"';
			break;
			case 'textfield':
				$code = '<input type="text"';
				if($value) {
					$code .= ' value="'.$value.'"';
				}
			break;
			case 'passwordfield':
				$code = '<input type="password"';
			break;
			case 'textarea':
				$code = '<textarea';
				if($value) {
					$code2 = $value;
				}
			break;
			case 'combobox':
				$code = '<select';
				if($onValue = $this->getAttribValue($_domElement, 'onchange')) {$code .= ' onChange="'.$onValue.'"';}
			break;
			case 'checkboxgroup':
				$groupName = $this->getAttribValue($_domElement, 'name');
				$objArray = $this->getAttribValue($_domElement, 'checkbox');
				if($objArray) {
					if(!$this->valueArrays[$objArray]) {continue;}
					$iterator = 0;
					foreach($this->valueArrays[$objArray] as $option) {
						if($option[2]=='left') {
							$code .= $option[1].' <input type="checkbox" name="'.$groupName.'[]" value="'.$option[0].'"';
							if($value) {
								foreach($value as $val) {
									if ($val == $option[0]) {
										$code .= ' checked="true"';
										break;
									}
								}
							} else 	if(count($option)==4 & $this->firstTime) {
								$code .= ' checked="true"';
							}
							$code .='/><br/>';
						} else {
							$code .= '<input type="checkbox" name="'.$groupName.'[]" value="'.$option[0].'"';
							if(count($option)==4) {
								$code .= ' checked="true"';
							}


							if (isset($this->_msgArray[$option[1]])) {
								$code .='/>'.$this->_msgArray[$option[1]].'<br/>';
							} else {$code .='/><br/>';}
						}
					}
				} else {
					if(!$_domElement->childNodes) {continue;}
					foreach($_domElement->childNodes as $roption) {
						if(strtolower($roption->name)!='checkbox') {continue;}
						$label      = $this->_msgArray[$this->getAttribValue($roption, 'label')];
						$labelAlign = $this->getAttribValue($roption, 'labelalign');
						if($labelAlign=='left') {
							$code .= $label.' <input type="checkbox" name="'.$groupName.'" value="'.$this->getAttribValue($roption, 'value').'"';
							if($this->getAttribValue($roption, 'checked')) {
								$code .= ' checked="true"';
							}
							$code .='/><br/>';
						} else {
							$code .= '<input type="checkbox" name="'.$this->getAttribValue($_domElement, 'name').'" value="'.$this->getAttribValue($roption, 'value').'"';
							if($this->getAttribValue($roption, 'checked')) {
								$code .= ' checked="true"';
							}
							$code .= '/> '.$label.'<br/>';
						}
					}
				}
			break;
			case 'radiobuttongroup':
				$groupName = $this->getAttribValue($_domElement, 'name');
				$objArray = $this->getAttribValue($_domElement, 'radiobutton');
				if($objArray) {
					if(!$this->valueArrays[$objArray]) {continue;}
					foreach($this->valueArrays[$objArray] as $option) {
						if($option[2]=='left') {
							$code .= $option[1].' <input type="radio" name="'.$groupName.'" value="'.$option[0].'"';
							if ($value) {
								if($value==$option[0]) {
									$code .= ' checked="true"';
								}
							} else if(count($option)==4) {
								$code .= ' checked="true"';
							}
							$code .='/><br/>';
						} else {
							$code .= '<input type="radio" name="'.$groupName.'" value="'.$option[0].'"';
							if(count($option)==4) {
								$code .= ' checked="true"';
							}
							$code .='/> '.$option[1].'<br/>';
						}
					}
				} else {
					if(!$_domElement->childNodes) {continue;}
					foreach($_domElement->childNodes as $roption) {
						if(strtolower($roption->name)!='radiobutton') {continue;}
						$label      = $this->_msgArray[$this->getAttribValue($roption, 'label')];
						$labelAlign = $this->getAttribValue($roption, 'labelalign');
						if($labelAlign=='left') {
							$code .= $label.' <input type="radio" name="'.$groupName.'" value="'.$this->getAttribValue($roption, 'value').'"';
							if($this->getAttribValue($roption, 'checked')) {
								$code .= ' checked="true"';
							}
							$code .='/><br/>';
						} else {
							$code .= '<input type="radio" name="'.$this->getAttribValue($_domElement, 'name').'" value="'.$this->getAttribValue($roption, 'value').'"';
							if($this->getAttribValue($roption, 'checked')) {
								$code .= ' checked="true"';
							}
							$code .= '/> '.$label.'<br/>';
						}
					}
				}
			break;
			default:
				return '';
			break;
		}

		//Podstawowe elementy
		foreach($_domElement->attributes as $elemAttrib) {
			if ($elemType=='radiobuttongroup') {continue;}
			if ($elemType=='checkboxgroup') {continue;}
			switch(strtolower($elemAttrib[0])) {
				case 'name':
					$code .= ' name="'.$elemAttrib[1].'"';
				break;
				case 'dbvalue':
					if(!$this->firstTime) {continue;}
					if(!isset($this->valueArrays[$elemAttrib[1]])) {continue;}
					if($this->valueArrays[$elemAttrib[1]]) {
						if ($elemType=='textarea') {
							$code2 = $this->valueArrays[$elemAttrib[1]];
						} else {
							$code .= ' value="'.$this->valueArrays[$elemAttrib[1]].'"';
						}
					}
				case 'value':
					if(!$this->firstTime) {continue;}
					if($this->getAttribValue($_domElement, 'dbvalue')) {continue;}
					if ($elemType=='textarea') {
						$code2 = $elemAttrib[1];
					} else {
						$code .= ' value="'.$elemAttrib[1].'"';
					}
				break;
				case 'rows':
					$code .= ' rows="'.$elemAttrib[1].'"';
				break;
				case 'cols':
					$code .= ' cols="'.$elemAttrib[1].'"';
				break;
				case 'size':
					$code .= ' size="'.$elemAttrib[1].'"';
				break;
				case 'cboption':
					$_useArray = $elemAttrib[1];
					if(!$this->valueArrays[$elemAttrib[1]]) {continue;}
					foreach($this->valueArrays[$elemAttrib[1]] as $option) {
						$code2 .= '<option value="'.$option[0].'"';
						if($value) {
							if ($value==$option[0]) {
								$code2 .= ' selected ';
							}
						} else if(count($option)==3) {
							$code2 .= ' selected ';
						}
						$code2 .= '>'.$option[1].'</option>';
					}
				break;
			}
		}

		//Elementy kodu z regu
		if (count($_domElement->childNodes)>0) {
			foreach($_domElement->childNodes as $subElem) {
				switch(strtolower($subElem->name)) {
					case 'rule':
						foreach($subElem->attributes as $attribElem) {
							switch(strtolower($attribElem[0])) {
								case 'max':
									if ($elemType=='textfield' || $elemType=='passwordfield') {
										$code .= ' maxlength="'.$attribElem[1].'"';
									}
								break;
							}
						}
					break;
					case 'cboption':
						if ($_useArray)  {continue;}
						$code3='<option';$code4='';
						foreach($subElem->attributes as $attribElem) {
							switch(strtolower($attribElem[0])) {
								case 'label':
									$code4 .= '>'.$attribElem[1].'</option>';
								break;
								case 'selected':
									if($attribElem[1]=='true') {
										$code3 .= ' selected ';
									}
								break;
								default:
									$code3 .= ' '.strtolower($attribElem[0]).'="'.$attribElem[1].'"';
								break;
							}
						}
						$code2 .= $code3.$code4;
					break;
				}
			}
		}
		switch($elemType) {
			case 'textarea':
				$code .= ' >'.$code2.'</textarea>';
			break;
			case 'combobox':
				$code .= ' >'.$code2.'</select>';
			break;
			case 'textfield':
			case 'passwordfield':
			case 'filefield':
				$code .= ' />';
			break;

		}

		return $code;
   }
   /**
    * Metoda zwraca warto atrybutu 'name' elmentu formularza zdefinuwanego w dokumencie XML
	*
	* @param XML_DOMDOC $_domElement
	*/
   function getFormElementName($_domElement) {
   		return $this->getAttribValue($_domElement, 'name');
   }
   /**
    * Metoda zwraca tablic z kodem HTML definujcym elementy SUBMIT
	*
	* @return Array Tablica znakw - kodw HTML definujcych elementy SUBMIT
	*/
	function getSubmitElementsCodeList() {
		$submitFiled = NULL;
		if(!$this->documentElement->childNodes) {return '';}
   		foreach($this->documentElement->childNodes as $element) {
			if($element->name=='SUBMITBUTTON') {
				$name  = $this->getAttribValue($element, 'name');
				$value = $this->getFormElementLabel($element);
				$submitFiled[] = '<input type="submit" name="'.$name.'" value="'.$value.'"/>';
			}
		}
   		return $submitFiled ;
	}
   /**
    * Metoda zwraca tablic z kodem HTML definujcym elementy RESET
	*
	* @return Array Tablica znakw - kodw HTML definujcych elementy RESET
	*/
	function getResetElementsCodeList() {
		$resetField = NULL;
		if(!$this->documentElement->childNodes) {return '';}
   		foreach($this->documentElement->childNodes as $element) {
			if($element->name=='RESETBUTTON') {
				$name  = $this->getAttribValue($element, 'name');
				$value = $this->getFormElementLabel($element);
				$resetField[] = '<input type="reset"  value="'.$value.'"/>';
			}
		}
   		return $resetField;
	}

   /**
    * Metoda zwraca warto atrybutu 'length' elmentu formularza zdefinuwanego w dokumencie XML
	*
	* @param XML_DOMDOC $_domElement
	*/
   /*function getFormElementSize($_domElement) {
   		return $this->getAttribValue($_domElement, 'length');
   }*/
   /**
    * Metoda zwraca typ elementu zdefiniowanego w dokumencie XML
	*
	* Typami elementw s np.: TEXTFIELD, PASSWORDFIELS, TEXTAREA itd.
	*
	* @param XML_DOMDOC $_domElement
	*/
   function getFormElementType($_domElement) {
   		return strtolower($_domElement->name);
   }
   /**
    * Metoda zwraca kod JavaScript (niezlaeny od przegldarki internetowej) ktry suy do walidacji formularz client-side.
	*/
   function getFormValidationScriptCode() {

		//Pocztek skryptu
		$svCode  = "<script>\n";

		//Sprawdzanie reg wspzalenych
		$svCode .= "function checkCondition(_condition, src) {\n";
		$svCode .= "	fields = _condition.split('#'); \n";
		$svCode .= "	if(fields[2]=='eq') {\n";
		$svCode .= "		text1= eval('src.'+fields[1]+'.value'); \n";
		$svCode .= "		text2= eval('src.'+fields[3]+'.value'); \n";
		$svCode .= "		if(text1!=text2) {return false;}\n";
		$svCode .= "		return true;\n";
		$svCode .= "	}\n";
		$svCode .= "}\n";

		//
		$svCode .= "function isSet(_obj) {\n";
		$svCode .= "	for(iter=0;iter<_obj.length; iter++) {\n";
		$svCode .= "		if(_obj[iter].checked) {\n";
		$svCode .= "			return true;\n;";
		$svCode .= "		}\n";
		$svCode .= "	}\n";
		$svCode .= "	return false;\n";
		$svCode .= "}\n";

		//Funkcja sprawdzajca czy selekcja zostaa wykonana poprawnie
		$svCode .= "function checkSelection(_selection, _obj) {\n";
		$svCode .= "	restrict = _selection.split(';');\n";
		$svCode .= "	for(iter=0; iter<restrict.length; iter++) {\n";
		$svCode .= "		if (_obj.value==restrict[iter]) { return false;}\n";
		$svCode .= "	}\n";
		$svCode .= "	return true;\n";
		$svCode .= "}\n";

		//Funkcja sprawdzajca, czy warto zawiera odpowiedni liczb znakw
		$svCode .= "function checkMinMax(_min, _max, _obj) {\n";
		$svCode .= "	_obj=_obj.replace(/^\s|\s+$/g,'');\n";
		$svCode .= "	if(_max<1) {\n";
		$svCode .= "		if(_obj.length>_min-1) {\n";
		$svCode .= "			return true;\n";
		$svCode .= "		} else {\n";
		$svCode .= "			return false;\n";
		$svCode .= "		}\n";
		$svCode .= "	}else if(_obj.length>_min-1 & _obj.length<_max+1) {\n";
		$svCode .= "		return true;\n";
		$svCode .= " 	} else {\n";
		$svCode .= "		return false;\n";
		$svCode .= "	}\n";
		$svCode .= "}\n";

		//Funkcja sprawdzajca czy do formularza wprowadzono odpowiednie znaczki
		$svCode .= "function checkMask(_mask, _obj) {\n";
		$svCode .= "    switch(_mask) {\n";
		$svCode .= " 	    case '/#emask/g' :\n";
		$svCode .= "            emask = /[a-zA-Z0-9]\w+(\x2e\w+)*[a-zA-Z0-9]\x40\w{2,}(\x2e\w{2,})+/g;\n";
		$svCode .= "            alert(_obj);\n";
		$svCode .= "            if(_obj.replace(emask, '')!='') {\n";
		$svCode .= "		        return false;\n";
		$svCode .= "	        } else {\n";
		$svCode .= "		        return true;\n";
		$svCode .= " 	        }\n";
		$svCode .= " 	    break;\n";
		$svCode .= "        default:\n";
		$svCode .= "	        if(_obj.replace(_mask,'')!='') {\n";
		$svCode .= "		        return false;\n";
		$svCode .= "	        } else {\n";
		$svCode .= "		        return true;\n";
		$svCode .= " 	        }\n";
		$svCode .= " 	    break;\n";
		$svCode .= "    }\n";
		$svCode .= "}\n";

		//Gwna funkcja walidujca formularz
		$svCode .= "function _".$this->_formName."(src) {\n";
		if(!$this->documentElement->childNodes) {return;}
		foreach($this->documentElement->childNodes as $formElem) {
			//Etykieta
			$label = $this->getFormElementLabel($formElem);
			$name  = $this->getFormElementName($formElem);

			//Tworzenie kodu dla kadego z elementw
			switch($this->getFormElementType($formElem)) {
				case 'condition': //Regua warunku zalenego
					$rule = $this->getAttribValue($formElem, 'rule');
					$error= $this->_msgArray[$this->getAttribValue($formElem, 'label')];
					//Komunikat bedu
					//$fields = explode('#', $rule);
					//$errorLog = str_replace($fields[1], '', $error);
					$errorLog = $error;

					$svCode .= "	if( !checkCondition('".$rule."', src)) {\n";
					$svCode .= "		alert('".$errorLog."')\n";
					$svCode .= "		return false;\n;";
					$svCode .= " 	}\n";

					//$errorLog = str_replace('$labelPL', '"'.$label.'"', $this->getAttribValue($rule, 'langpl'));
					//
				break;
				case 'radiobuttongroup':
				//case 'checkboxgroup'://Bd JavaScript gdy atrybut name posiada zakoczenie [] - do rozwizanie
					foreach($formElem->childNodes as $rule) {
						if(strtolower($rule->name) != 'rule') {continue;}
						$svCode .= "	if( ";
						$require = $this->getAttribValue($rule, 'require');
						$first = false;
						//Wybr selekcji
						if ($require=='true') {
							$svCode .= "!isSet(src.".$name.")";
							$first = true;
						}

						//Komunikat bedu
						$errorLog = str_replace('$label', '"'.$label.'"', $this->_msgArray[$this->getAttribValue($rule, 'label')]);

						$svCode .= " ) {\n";
						$svCode .= " 		alert('".$errorLog."')\n";
						$svCode .= "		return false;\n";
						$svCode .= "	}\n";

					}
				break;
				case 'combobox':
					if(!$formElem->childNodes) {continue;}
					foreach($formElem->childNodes as $rule) {
						if(strtolower($rule->name) != 'rule') {continue;}
						$svCode .= "	if( ";
						$selection = $this->getAttribValue($rule, 'selection');
						$first = false;
						//Wybr selekcji
						if ($selection) {
							$svCode .= "!checkSelection('".$selection."', src.".$name.")";
							$first = true;
						}

						//Komunikat bedu
						$errorLog = str_replace('$label', '"'.$label.'"', $this->_msgArray[$this->getAttribValue($rule, 'label')]);
						//$errorLog = str_replace('$min', $min, str_replace('$max', $max, $errorLog));

						$svCode .= " ) {\n";
						$svCode .= " 		alert('".$errorLog."')\n";
						$svCode .= "		return false;\n";
						$svCode .= "	}\n";

					}
				break;
				case 'textfield':
				case 'passwordfield':
				case 'textarea':
				case 'filefield':
					if(!$formElem->childNodes) {continue;}
					foreach($formElem->childNodes as $rule) {
						$svCode .= "	if( ";
						$min  = $this->getAttribValue($rule, 'min'); if(!$min) {$min = 0;}
						$max  = $this->getAttribValue($rule, 'max'); if(!$max) {$max = 0;}
						$mask = $this->getAttribValue($rule, 'mask');
						$first = false;
						//Liczba znakw w polu
						if($min>0 || $max>0) {
							$svCode .= "!checkMinMax(".$min.", ".$max.", src.".$name.".value)";
							$first = true;
						}
						//Maska wprowadzania
						if ($mask!='') {
							if($first) {
								$svCode .= " || !checkMask(/".$mask."/g, src.".$name.".value)";
							} else {
								$svCode .= "!checkMask(/".$mask."/g, src.".$name.".value)";
							}
							$first = true;
						}

						$labelTemp = '';
						if (isset($this->_msgArray[$this->getAttribValue($rule, 'label')])) {
							$labelTemp = $this->_msgArray[$this->getAttribValue($rule, 'label')];
						}
						$errorLog = str_replace('$label', '"'.$label.'"', $labelTemp);
						$errorLog = str_replace('$min', $min, str_replace('$max', $max, $errorLog));

						$svCode .= " ) {\n";
						$svCode .= " 		alert('".$errorLog."')\n";
						$svCode .= "		return false;\n";
						$svCode .= "	}\n";
					}
				break;
			}

		}

		$svCode .= "}\n";

		//Koniec skryptu
		$svCode .= "</script>";

		//Wysanie kodu skryptu
		return $svCode;
   }
   /**
    * Metoda zwraca kod JavaScript (niezaleny od przegldarki), ktry powinien zosta podany jako warto atrybutu 'onSubmit' znacznika FORM jzyka HTML
	*/
   function getFormOnSubmitFunction() {
  		return "return _".$this->_formName."(this);";
   }
   /**#@-*/

//-------------------------------------------------
//Metody prywatne----------------------------------
//-------------------------------------------------
	//Obsuga bw
	function errorHandlerErrorObject($error) {
		    global $appCore;
			$appCore->handleError($error);
	}

	/**
	 * Metoda zwraca warto okrelonego atrybutu, wybranego elementu
	 *
	 * @param _element xml_Element element XMl, ktrego atrybut ma zosta zwrcony
	 * @param _attribName string nazwa atrybutu do zwrotu
	 */
	function getAttribValue($_element, $_attribName) {
		foreach($_element->attributes as $attrib) {
			if(strtolower($attrib[0]) == $_attribName) {
				return $attrib[1];
			}
		}
		return FALSE;
	}
}
?>