<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+

/**
 * Klasa State opisujca wojewdztwo
 * Dziedziczy po klasie Object
 */
class State extends Object {
	/**#@+
   	 * @access protected
   	 */
  	/**
   	 * @var object Nazwa wojewdztwa
   	 */
  	var  $_Name;
    /**#@-*/
	 
  	/**
   	 * Domylna metoda wywoywana podczas inicjalizacji obiektw tej klasy
   	 * @access public
   	 * @param array $statedata Tablica z danymi o wojewdztwie
   	 * @return mixed
   	 */
	function State($statedata = array())
	{
		// Okrelenie domylnej metody obsugi bdw
		$this->setErrorHandling(PEAR_ERROR_CALLBACK, array(&$this, 'errorHandlerState'));
		foreach ($statedata as $key => $value) { 
			switch (strtolower($key)) {
				case 'st_id':
					$this->setId($value);
					break;
				case 'usr_id':
					$this->setOwner($value);
					break;
				case 'st_name':
					$this->setName($value);
					break;
				case 'st_createdate':
					$this->setCreateDate($value);
					break;
				case 'st_lastmodifydate':
					$this->setLastModifyDate($value);
					break;
				case 'st_active':
					$this->setActive($value);
					break;
			}
		}
	}
  	/**
   	 * Ustawia nazw wojewdztwa
   	 * @access public
   	 * @param string $name Nazwa wojewdztwa
   	 * @return mixed
   	 */
	function setName($name)
	{
		if (PEAR::isError($result = $this->parseVar($name,'string', array(array('not_null'), array('striptags'))))) {
			return $result;
		} else {
			$this->_Name = $name;
		}
	}
  	/**
   	 * Zwraca nazw wojewdztwa
   	 * @access public
   	 * @return string
   	 */
	function getName(){ return $this->_Name;}
  	/**
   	 * Zwraca podstawowe informacje o wojewdztwie
	 * @param string $stateid Identyfikator wojewdztwa, ktrego dane chcemy uzyska.
	 * Warto domylna NULL (pobrane zostan dane wszystkich wojewdztw)
	 * @param string $filter Filtr wyboru danych:
	 *						 - 'active' - aktywne wiersze (warto domylna)
	 *						 - 'nonactive' - nieaktywne wiersze
	 *						 - 'all' - wszystkie wiersze
   	 * @access public
   	 * @return mixed
   	 */
	function getData($stateid = NULL, $filter = 'active') {

		//Rdze aplikacji
		global $appCore; 
		$state_list = array();
		
		// Ustawienie poprawnego identyfikatora wojewdztwa oraz kryteriw 
		// wyszukiwania
		switch ($filter) {
			case 'active':
				$where_active = 'State.ST_Active = 1';
				break;
			case 'nonactive':
				$where_active = 'State.ST_Active = 0';
				break;
			case 'all':
				$where_active = '(State.ST_Active = 0 OR State.ST_Active = 1)';
				break;
			default:
				$where_active = 'State.ST_Active = 1';
		}
		if (isSet($stateid)) {
			if (PEAR::isError($result = Object::parseVar($stateid,'id'))) { return $result;}
			$where_statement = " WHERE State.ST_Id = '$stateid' AND $where_active";
		} else { 
			$where_statement = " WHERE $where_active";
		}
		
   		// Pobranie podstawowych informacji o wojewdztwach
   		$sqlquery = "SELECT * FROM State $where_statement ORDER BY ST_Name";
		if (DB::isError($result = &$appCore->Query($sqlquery))) {
   			return $result;
   		}

		while ($statedata = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
			$state_list[] = new State($statedata);
		}

		return $state_list;	
	}
  	/**
   	 * Metoda zapisujca dane wojewdztwo w bazie danych
   	 *
   	 * @access public
   	 * @param mixed $state Obiekt State
   	 * @return mixed
   	 */
   	function saveData($state = NULL)
   	{
		global $appCore;

		if ($state == NULL) { $state = &$this;}
		$state->setCreateDate(date(DATE_FORMAT_DBSAVE));

   		// Zapisanie danych
   		if (PEAR::isError($result = saveState($state))) {
			return $result;
   		} else {
   			return TRUE;
   		}
	}
  	/**
   	 * Metoda uaktualniajca dane wojewdztwa w bazie danych
   	 *
   	 * @access public
   	 * @param mixed $state Obiekt State
   	 * @return mixed
   	 */
   	function updateData($state = NULL)
   	{
		global $appCore;

		if ($state == NULL) { $state = &$this;}
		$state->setLastModifyDate(date(DATE_FORMAT_DBSAVE));

   		// Zaktualizowanie danych
   		if (PEAR::isError($result = updateState($state))) {
			return $result;
   		} else {
   			return TRUE;
   		}
	} 
  	/**
   	 * Metoda usuwajca dane wojewdztwo z bazy danych
   	 *
   	 * @access public
   	 * @param string $stateid Identyfikator obiektu
   	 * @return mixed
   	 */
   	function deleteData($stateid = NULL)
   	{
		global $appCore;

		if ($stateid == NULL) { $stateid = &$this->getId();}

   		// Usunicie danych
   		if (PEAR::isError($result = deleteState($stateid))) {
			return $result;
   		} else {
   			return TRUE;
   		}
	} 
	/**
	 * Przygotowuje tablica parametrw dla pola comboBox moduu formularza
	 *
	 * @param &array &$resArray Tablica, ktra bdzie zawiera list pozycji 
	 * sownikowych
	 * @param bool $active 
	 * @param string $selId
	 */
	function prepareComboBoxValues(&$resArray, $active = TRUE, $selId=NULL) {
		//Rdze aplikacji
		global $appCore;
				
		//Przygotowanie zapytania SQL
		$sqlquery = 'SELECT ST_Id, ST_Name FROM State';
		if ($active) {$sqlquery .= ' WHERE ST_Active=1';}
		if (DB::isError($result = $appCore->Query($sqlquery))) {
			$err =  PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
			if(!isset($this)) {DeliveryType::errorHandlerDeliveryType($err);}
			return $err;
		}

		//Tworzenie tablicy 
		while($row = $result->fetchRow()) {if ($selId == $row[0]) {$resArray[] = array($row[0], $row[1], TRUE);} else {$resArray[] = array($row[0], $row[1]);}}
	}
  	/**
   	 * Domylna metoda obsugi bdw dla obiektw tej klasy
	 * @param mixed $error Kod bdu
   	 * @access public
   	 * @return mixed
   	 */
	function errorHandlerState($error) {
	    global $appCore;
		$appCore->handleError($error);
	}
} // Koniec klasy State

?>