<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+
/**
 * Klasa Producer opisujca producenta
 * Dziedziczy po klasie Object
 */
class Producer extends Object {
	/**#@+
   	 * @access protected
   	 */
  	/**
   	 * @var object Nazwa producenta 
   	 */
  	var  $_Name;
  	/**
   	 * @var string Adres strony www
   	 */
  	var  $_URL;
  	/**
   	 * @var string Adres poczty elektronicznej
   	 */
  	var  $_Email;
  	/**
   	 * @var array Tablica z adresami
   	 */
  	var  $_Address = array();
    /**#@-*/
	 
  	/**
   	 * Domylna metoda wywoywana podczas inicjalizacji obiektw tej klasy
   	 * @access public
   	 * @param array $productdata Tablica z danymi o produkcie
   	 * @return mixed
   	 */
	function Producer($producerdata = NULL)
	{
		// Okrelenie domylnej metody obsugi bdw
		$this->setErrorHandling(PEAR_ERROR_CALLBACK, array(&$this, 'errorHandlerProducer'));
		foreach ($producerdata as $key => $value) { 
			switch (strtolower($key)) {
				case 'prc_id':
					$this->setId($value);
					break;
				case 'usr_id':
					$this->setOwner($value);
					break;
				case 'prc_name':
					$this->setName($value);
					break;
				case 'prc_desc':
					$this->setDesc($value);
					break;
				case 'prc_createdate':
					$this->setCreateDate($value);
					break;
				case 'prc_lastmodifydate':
					$this->setLastModifyDate($value);
					break;
				case 'prc_url':
					$this->setURL($value);
					break;
				case 'prc_email':
					$this->setEmail($value);
					break;
				case 'prc_active':
					$this->setActive($value);
					break;
			}
		}
		// Pobranie danych adresowych
		$this->getAddressData();
	}
  	/**
   	 * Ustawia nazw producenta
   	 * @access public
   	 * @param string $name Nazwa producenta
   	 * @return mixed
   	 */
	function setName($name)
	{
		if (PEAR::isError($result = $this->parseVar($name,'string', array(array('not_null'), array('htmlspecialchars'), array('striptags'))))) {
			return $result;
		} else {
			$this->_Name = $name;
		}
	}
  	/**
   	 * Ustawia adres strony www
   	 * @access public
   	 * @param string $url Adres www
   	 * @return mixed
   	 */
	function setURL($url)
	{
		if (PEAR::isError($result = $this->parseVar($url,'string', array(array('striptags'))))) {
			return $result;
		} else {
			$this->_URL = $url;
		}
	}
  	/**
   	 * Ustawia adres poczty elektronicznej producenta
   	 * @access public
   	 * @param string $email Adres e-mail
   	 * @return mixed
   	 */
	function setEmail($email)
	{
		if (PEAR::isError($result = $this->parseVar($email,'string', array(array('striptags'))))) {
			return $result;
		} else {
			$this->_Email = $email;
		}
	}
  	/**
   	 * Dodaje adres poczty elektronicznej do producenta
   	 * @access public
   	 * @param object $address Obiekt klasy Address
   	 * @return mixed
   	 */
	function addAddress($address)
	{
		$this->_Address[] = $address;
	}
  	/**
   	 * Zwraca nazw producenta
   	 * @access public
   	 * @return string
   	 */
	function getName(){ return $this->_Name;}
  	/**
   	 * Zwraca adres strony internetowej producenta
   	 * @access public
   	 * @return string
   	 */
	function getURL(){ return $this->_URL;}
  	/**
   	 * Zwraca adres poczty elektronicznej producenta
   	 * @access public
   	 * @return string
   	 */
	function getEmail(){ return $this->_Email;}
  	/**
   	 * Zwraca tablic adresw producenta
   	 * @access public
   	 * @return array
   	 */
	function getAddresses(){ return $this->_Address;} 
  	/**
   	 * Zwraca podstawowe informacje o producencie
	 * @param string $producerid Identyfikator producenta, ktrego dane chcemy 
	 *                           uzyska.
	 * Warto domylna NULL (pobrane zostan dane wszystkich producentw)
	 * @param string $filter Filtr wyboru danych:
	 *						 - 'active' - aktywne wiersze (warto domylna)
	 *						 - 'nonactive' - nieaktywne wiersze
	 *						 - 'all' - wszystkie wiersze
   	 * @access public
   	 * @return mixed
   	 */
	function getData($producerid = NULL, $filter = 'active') {

		global $appCore; 
		$producer_list = array();
		// Ustawienie poprawnego identyfikatora producenta oraz kryteriw 
		// wyszukiwania
		switch ($filter) {
			case 'active':
				$where_active = 'Producer.PRC_Active = 1';
				break;
			case 'nonactive':
				$where_active = 'Producer.PRC_Active = 0';
				break;
			case 'all':
				$where_active = '(Producer.PRC_Active = 0 OR Producer.PRC_Active = 1)';
				break;
			default:
				$where_active = 'Producer.PRC_Active = 1';
		}
		
		if (isSet($producerid)) {
			if (PEAR::isError($result = Object::parseVar($producerid,'id'))) { return $result;}
			$where_statement = " WHERE Producer.PRC_Id = '$producerid' AND $where_active";
		} else { 
			$where_statement = " WHERE $where_active";
		}
		
   		// Pobranie podstawowych informacji o producentach
   		$sqlquery = "SELECT * FROM Producer $where_statement ORDER BY PRC_Name";
		if (DB::isError($result = &$appCore->Query($sqlquery))) {
   			return $result;
   		}

		while ($producerdata = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
			$producer_list[] = new Producer($producerdata);
		}

		return $producer_list;	
	}
  	/**
   	 * Zwraca informacje o adresach producentw
	 * @param string $addressid Identyfikator adresu, ktrego dane chcemy uzyska.
	 * Warto domylna NULL (pobrane zostan dane wszystkich adresw producenta)
   	 * @access public
   	 * @return mixed
   	 */
	function getAddressData($addressid = NULL) {

		global $appCore; 
		$this->_Address = array();
		
		// Ustawienie poprawnego identyfikatora adresu oraz kryteriw 
		// wyszukiwania
		if (isSet($addressid)) {
			if (PEAR::isError($result = thorObject::parseVar($addressid,'id'))) { return $result;}
			$where_statement = " WHERE prc_has_addr.ADDR_Id = Address.ADDR_Id AND prc_has_addr.PRC_Id = '" . $this->getId() . "' AND prc_has_addr.ADDR_Id = '$addressid'";
		} else { 
			$where_statement = " WHERE prc_has_addr.ADDR_Id = Address.ADDR_Id AND prc_has_addr.PRC_Id = '" . $this->getId() . "'";
		}
		
   		// Pobranie informacji o adresach uytkownika
   		$sqlquery = "SELECT prc_has_addr.ADDR_Id FROM prc_has_addr, Address $where_statement";

		if (DB::isError($result = &$appCore->Query($sqlquery))) {
   			return $result;
   		}

		while ($addressid = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
			if (PEAR::isError($address = Address::getAddressData(&$this, current($addressid)))) { return $address;}
			$this->addAddress($address);
		}
		return TRUE;
	}
  	/**
   	 * Metoda zapisujca danego producenta w bazie danych
   	 *
   	 * @access public
   	 * @param mixed $producer Obiekt Producer
   	 * @return mixed
   	 */
   	function saveData($producer = NULL)
   	{
		global $appCore;

		if ($producer == NULL) { $producer = &$this;}
		$producer->setCreateDate(date(DATE_FORMAT_DBSAVE));

   		// Zapisanie danych
   		if (PEAR::isError($result = saveProducer($producer))) {
			return $result;
   		} else {
   			return TRUE;
   		}
	} 
  	/**
   	 * Metoda uaktualniajca dane producenta w bazie danych
   	 *
   	 * @access public
   	 * @param mixed $producer Obiekt Producer
   	 * @return mixed
   	 */
   	function updateData($producer = NULL)
   	{
		global $appCore;

		if ($producer == NULL) { $producer = &$this;}
		$producer->setLastModifyDate(date(DATE_FORMAT_DBSAVE));

   		// Zaktualizowanie danych
   		if (PEAR::isError($result = updateProducer($producer))) {
			return $result;
   		} else {
   			return TRUE;
   		}
	} 
  	/**
   	 * Metoda usuwajca dane producenta z bazy danych
   	 *
   	 * @access public
   	 * @param string $producerid Identyfikator producenta
   	 * @return mixed
   	 */
   	function deleteData($producerid = NULL)
   	{
		global $appCore;

		if ($producerid == NULL) { $producerid = &$this->getId();}

   		// Usunicie danych
   		if (PEAR::isError($result = deleteProducer($producerid))) {
			return $result;
   		} else {
   			return TRUE;
   		}
	} 
  	/**
   	 * Metoda usuwajca adres producenta z bazy danych
   	 *
   	 * @access public
   	 * @param string $addressid Identyfikator adresu
	 * @param string $addressowner
	 *				 - 'user' - adres uytkownika (warto domylna)
	 *				 - 'producer' - adres producenta
   	 * @return mixed
   	 */
   	function deleteAddress($addressid, $addressowner)
   	{
		global $appCore;

   		// Usunicie danych
   		if (PEAR::isError($result = deleteAddress($addressid, $addressowner))) {
			return $result;
   		} else {
   			return TRUE;
   		}
	} 
  	/**
   	 * Domylna metoda obsugi bdw dla obiektw tej klasy
	 * @param mixed $error Kod bdu
   	 * @access public
   	 * @return mixed
   	 */
	function errorHandlerProducer($error) {
	    global $appCore;
		$appCore->handleError($error);
	}
} // Koniec klasy Producer

?>