<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+

//Klasa obsugujca sownik statusw zamwie - Order status
class OrderStatus extends Object {
   /**#@+
   	* @access protected
   	*/
	/**
	 * @var string Identyfikator uytkownika, ktry doda pozycj sownika
	 */
	var $_UserId;
	/**
	 * @var string Nazwa pozycji sownikowej
	 */
	var $_Name;
	/**
	 * @var string Data ostatniej modyfikacji
	 */
	var $_LastModifyDate;
	/**#@-*/
	 
	/**#@+
   	 * @access public
   	 */
	/**
	 * Konstruktor klasy statusw zamwie
	 *    	 
	 * @param array $dictdata Tablica z danymi obiektu sownikowego
	 */
	function OrderStatus($osdata=array()) {
		// Okrelenie domylnej metody obsugi bdw
		$this->setErrorHandling(PEAR_ERROR_CALLBACK, array(&$this, 'errorHandlerOrderStatus'));
		//Tworzenie obiektu
		foreach ($osdata as $key => $value) { 
			switch (strtolower($key)) {
				case 'ors_id':
					$this->setId($value);
				break;
				case 'usr_id':
					$this->setUser($value);
				break;
				case 'ors_name':
					$this->setName($value);
				break;
				case 'ors_desc':
					$this->setDesc($value);
				break;
				case 'ors_createdate':
					$this->setCreateDate($value);
				break;				
				case 'ors_lastmodifydate':
					$this->setLastModifyDate($value);
				break;
				case 'ors_active':
					$this->setActive($value);
				break;
			}
		}
		
			
	}
	/**
	 * Ustawia identyfikator uytkownika, ktry jest wacicielem pozycji sownika
	 *
	 * @param string $userid
	 */
	function setUser($userid) {$this->_UserId = $userid;}
	/**
	 * Ustawia nazw pozycji sownika
	 *
	 * @param string $name
	 */
	function setName($name) {$this->Name = $name;}
	/**
	 * Ustawia dat ostatniej modyfikacji
	 *
	 * @param string $lmdate 
	 */
	function setLastModifyDate($lmdate) {$this->_LastModifyDate = $lmdate;}
	/**
	 * Zwraca identyfikator uytkownika, ktry jest wacicielem pozycji sownika
	 *
	 * @return string
	 */
	function getUser() {return $this->_UserId;}
	/**
	 * Zwraca nazw pozycji sownika
	 *
	 * @return string
	 */
	function getName() {return $this->Name;}
	/**
	 * Zwraca dat ostatniej modyfikacji
	 *
	 * @return string
	 */
	function getLastModifyDate() {return $this->_LastModifyDate;}
	/**
	 * Zwraca obiekt lub obiekty repezentujce pozycje sownika
	 *
	 * @param string $podid Identyfikator pozycji sownika
	 */
	function getData($posid = NULL) {
		//Rdze aplikacji
		global $appCore;
		
	}
	/**
	 * Sprawdza czy obiekt jest obiektem klasy OrderStatus
	 *
	 * @param &objectn $object
	 */
	function isOrderStatusObject(&$object) {return Object::isClassObject($object, 'OrderStatus');}
	/**
	 * Zapisuje dane obiektu do bazy
	 *
	 * Metoda nie moe by wywoywana statycznie
	 */
	function saveData() {
		//Rdze aplikacji
		global $appCore;
		
		//Przygowanie do zapisu
		$appCore->setTransactionStatus(FALSE);
		if (PEAR::isError($err = Transaction('BEGIN'))) {return $err;}
		$appCore->setTransactionStatus(TRUE);
		
		//Zapisywanie danych ---------------------------------------------
			
			if (OrderStatus::doesOrderStatusExist($this->_Id)) {
				//Pozycja sownika istnieje wic bdzie modyfikacja
			} else {
				//Pozycja sownika nie istnieje wic bdzie tworzona od podstaw
				//Generowanie identyfikatora
				$this->generateId();
				
				//Przygotowanie i wykonanie zapytania SQL
				$sqlquery  = 'INSERT INTO OrderStatus (ORS_Id, USR_Id, ORS_Name, ORS_Desc, ORS_CreateDate, ORS_LastModifyDate, ORS_Active) ';
				$sqlquery .= 'VALUES ("'.$this->getId().'", "'.$this->getUser().'", "'.$this->getName().'", "'.$this->getDesc().'", CURRENT_TIMESTAMP(0), NULL, ';
				if ($this->getActive()) {$sqlquery .= '1)';} else {$sqlquery .= '0)';}
				if (DB::isError($result = $appCore->Query($sqlquery))) {
					$err =  PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
					if(!isset($this)) {OrderStatus::errorHandlerOrderStatus($err);}
					return $err;
				}
			}
			
		//Zapisywanie danych ---------------------------------------------
		
		//Proces zapisywania danych zakoczony pomylnie
		if (PEAR::isError($err = Transaction('COMMIT'))) {return $err;}
		$appCore->setTransactionStatus(FALSE);
	}
	/**
	 * Usuwa obiekt z bazy danych
	 *
	 * @param string $id Identyfikator obiektu do usunicia
	 */
	function deleteData($id = NULL) {

		if (!$id) {$id = $this->_Id;}
		//Rdze aplikacji
		global $appCore;
		
		//Sprawdzenie czy obiekt moe by usunity
		OrderStatus::canBeDeleted($id);
	}
	/**
	 * Sprawdza czy obiekt moe by usunity z bazy danych
	 *
	 * Metoda moe by wywoywana tylko statycznie
	 *
	 * @param string $id Identyfikator obiektu do usunicia
	 */
	function canBeDeleted($id) {

		//Rdze aplikacji
		global $appCore;
	}
	/**
	 * Sprawdza czy obiekt istnieje w bazie danych
	 *
	 * @param string $id Identyfikator obiektu
	 * @return mixed Obiekt bool lub PEAR_Error
	 */
	function doesOrderStatusExist($id) {
		//Rdze aplikacji
		global $appCore;
		
		//Przygotowanie zapytania SQL
		$sqlquery = 'SELECT ORS_Id FROM OrderStatus WHERE ORS_Id="'.$id.'"';
		if (DB::isError($result = $appCore->Query($sqlquery))) {
			$err =  PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
			if(!isset($this)) {OrderStatus::errorHandlerOrderStatus($err);}
			return $err;
		}
		
		//Zwracanie wyniku warunku logicznego
		return ($result->numRows()==1);
	}
	
	/**
   	 * Domylna metoda obsugi bdw dla obiektw tej klasy
	 * @param PEAR_Error $error Kod bdu
   	 * @access public
   	 */
	function errorHandlerOrderStatus($error) {
		//Rdze aplikacji
		global $appCore;

		//Odwoanie transakcji
		if ($appCore->getTransactionStatus()) {
			Transaction('ROLLBACK');
			$appCore->setTransactionStatus(FALSE);
		}
		
		//Standardowa obsuga bdu
		$appCore->handleError($error);
	}
    /**#@-*/
}
?>