<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+

/**
 * Klasa Image obsugujca bibliotek zdj
 * Dziedziczy po klasie Object
 */
class Image extends Object {
	/**#@+
   	 * @access protected
   	 */
  	/**
   	 * @var mixed Zdjcie
   	 */
  	var  $_Image;
  	/**
   	 * @var string cieka dostpu do pliku
   	 */
  	var  $_FileName;
  	/**
   	 * @var string Format zdjcia
   	 */
  	var  $_ContentType;
  	/**
   	 * @var bool Domylno zdjcia (TRUE - zdjcie jest zdjciem domylnym)
   	 */
  	var  $_Default;
    /**#@-*/
	 
  	/**
   	 * Domylna metoda wywoywana podczas inicjalizacji obiektw tej klasy
   	 * @access public
   	 * @param array $imagedata Tablica z danymi o zdjciu
   	 * @return mixed
   	 */
	function Image($imagedata = array())
	{
		// Okrelenie domylnej metody obsugi bdw
		$this->setErrorHandling(PEAR_ERROR_CALLBACK, array(&$this, 'errorHandlerImage'));
		foreach ($imagedata as $key => $value) { 
			switch (strtolower($key)) {
				case 'img_id':
					$this->setId($value);
					break;
				case 'usr_id':
					$this->setOwner($value);
					break;
				case 'img_desc':
					$this->setDesc($value);
					break;
				case 'img_image':
					$this->setImage($value);
					break;
				case 'img_filename':
					$this->setFileName($value);
					break;
				case 'img_contenttype':
					$this->setContentType($value);
					break;
				case 'img_default':
					$this->setDefault($value);
					break;
				case 'img_createdate':
					$this->setCreateDate($value);
					break;
				case 'img_lastmodifydate':
					$this->setLastModifyDate($value);
					break;
				case 'img_active':
					$this->setActive($value);
					break;
			}
		}
	}
  	/**
   	 * Ustawia zdjcie
   	 * @access public
   	 * @param mixed $image Zdjcie
   	 * @return mixed
   	 */
	function setImage($image)
	{
			$this->_Image = $image;
	}
  	/**
   	 * Ustawia ciek dostpu do pliku ze zdjciem
   	 * @access public
   	 * @param string $filename cieka dostpu
   	 * @return mixed
   	 */
	function setFileName($filename)
	{
		if (PEAR::isError($result = $this->parseVar($filename,'string', array(array('striptags'))))) {
			return $result;
		} else {
			$this->_FileName = $filename;
		}
	}
  	/**
   	 * Ustawia format zdjcia
   	 * @access public
   	 * @param string $contenttype Format zdjcia
   	 * @return mixed
   	 */
	function setContentType($contenttype)
	{
		if (PEAR::isError($result = $this->parseVar($contenttype,'string', array(array('striptags'))))) {
			return $result;
		} else {
			$this->_ContentType = $contenttype;
		}
	}
  	/**
   	 * Ustawia domylno wywietlania danego zdjcia
   	 * @access public
   	 * @param string $default Domylno
   	 * moliwe wartoci true:false, t:f, 1:0, yes:no
   	 * (parametry niewraliwe na wielko liter)
   	 * @return bool
   	 */
	function setDefault($default)
	{
		switch (strtolower($default)) {
			case 'true':
			case 't':
			case 1:
			case 'yes':
				$this->_Default = TRUE;
				return TRUE;
			case 'false':
			case 'f':
			case 0:
			case 'no':
				$this->_Default = FALSE;
				return TRUE;
			default: return -4;
		}
	}
  	/**
   	 * Zwraca zdjcie
   	 * @access public
   	 * @return mixed
   	 */
	function getImage(){ return $this->_Image;}
  	/**
   	 * Zwraca symbol kraju
   	 * @access public
   	 * @return string
   	 */
	function getFileName(){ return $this->_FileName;}
  	/**
   	 * Zwraca format zdjcia
   	 * @access public
   	 * @return string
   	 */
	function getContentType(){ return $this->_ContentType;}
  	/**
   	 * Zwraca domylno zdjcia
   	 * @access public
	 * @param string $mode Format zwracanej wartoci:
	 * ('basic' - dane zwracane w taki sposb, w jaki zapisane s w bazie danych;
	 *  'extended' (domylny) - zwraca wartoci typu boolean - TRUE albo FALSE)
	 *  'verbose' - zwraca wartoci w postaci dajcej si wywietli na ekranie)
   	 * @return mixed
   	 */
	function getDefault($mode = 'extended') { 
		switch ($mode) {
			case 'basic': return $this->_Default;
			case 'extended':
				switch ($this->_Default) {
					case TRUE:
					case 'true':
					case 't':
					case 'T': return TRUE;
					case FALSE:
					case 'false':
					case 'f':
					case 'F': return FALSE;
					default: return NULL;
				}
			case 'verbose':
				switch ($this->_Default) {
					case TRUE:
					case 'true':
					case 't':
					case 'T': return 'Tak';
					case FALSE:
					case 'false':
					case 'f':
					case 'F': return 'Nie';
					default: return NULL;
				}
			default: return NULL;
		}
	}
  	/**
   	 * Zwraca podstawowe informacje o zdjciu
	 * @param string $imageid Identyfikator zdjcia, ktrego dane chcemy uzyska.
	 * Warto domylna NULL (pobrane zostan dane wszystkich zdj)
	 * @param string $filter Filtr wyboru danych:
	 *						 - 'active' - aktywne wiersze (warto domylna)
	 *						 - 'nonactive' - nieaktywne wiersze
	 *						 - 'all' - wszystkie wiersze
   	 * @access public
   	 * @return mixed
   	 */
	function getData($imageid = NULL, $filter = 'active') {

		global $appCore; 
		$image_list = array();
		// Ustawienie poprawnego identyfikatora kraju oraz kryteriw 
		// wyszukiwania
		switch ($filter) {
			case 'active':
				$where_active = 'Image.IMG_Active = 1';
				break;
			case 'nonactive':
				$where_active = 'Image.IMG_Active = 0';
				break;
			case 'all':
				$where_active = '(Image.IMG_Active = 0 OR Image.IMG_Active = 1)';
				break;
			default:
				$where_active = 'Image.IMG_Active = 1';
		}
		if (isSet($imageid)) {
			if (PEAR::isError($result = Object::parseVar($imageid,'id'))) { return $result;}
			$where_statement = " WHERE Image.IMG_Id = '$imageid' AND $where_active";
		} else { 
			$where_statement = " WHERE $where_active";
		}

   		// Pobranie podstawowych informacji o zdjciach
   		$sqlquery = "SELECT * FROM Image $where_statement ORDER BY IMG_Desc";
		if (DB::isError($result = &$appCore->Query($sqlquery))) {
   			return $result;
   		}
		while ($imagedata = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
			$image_list[] = new Image($imagedata);
		}

		return $image_list;	
	}
  	/**
   	 * Metoda zapisujca dane zdjcie w bazie danych
   	 *
   	 * @access public
   	 * @param mixed $image Obiekt Image
   	 * @return mixed
   	 */
   	function saveData($image = NULL)
   	{
		global $appCore;

		if ($image == NULL) { $image = &$this;}
		$image->setCreateDate(date(DATE_FORMAT_DBSAVE));

   		// Zapisanie danych
   		if (PEAR::isError($result = saveImage($image))) {
			return $result;
   		} else {
   			return TRUE;
   		}
	} 
  	/**
   	 * Domylna metoda obsugi bdw dla obiektw tej klasy
	 * @param mixed $error Kod bdu
   	 * @access public
   	 * @return mixed
   	 */
	function errorHandlerImage($error) {
	    global $appCore;
		$appCore->handleError($error);
	}
} // Koniec klasy Image

?>