<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+

//Klasa obsugujca sownik typw dostawy - Delivery type
class DeliveryType extends Object {
   /**#@+
   	* @access protected
   	*/
	/**
	 * @var string Identyfikator uytkownika, ktry doda pozycj sownika
	 */
	var $_UserId;
	/**
	 * @var string Nazwa pozycji sownikowej
	 */
	var $_Name;
	/**
	 * @var string Data ostatniej modyfikacji
	 */
	var $_LastModifyDate;
	/**
	 * @var float Cena dostawy
	 */
	var $_Price;
	/**#@-*/
	 
	/**#@+
   	 * @access public
   	 */
	/**
	 * Konstruktor klasy typw dostaw
	 *    	 
	 * @param array $dictdata Tablica z danymi obiektu sownikowego
	 */
	function DeliveryType ($dictdata=array()) {
		// Okrelenie domylnej metody obsugi bdw
		$this->setErrorHandling(PEAR_ERROR_CALLBACK, array(&$this, 'errorHandlerDeliveryType'));

		//Tworzenie obiektu
		foreach ($dictdata as $key => $value) { 
			switch (strtolower($key)) {
				case 'dlt_id':
					$this->setId($value);
				break;
				case 'usr_id':
					$this->setUser($value);
				break;
				case 'dlt_name':
					$this->setName($value);
				break;
				case 'dlt_desc':
					$this->setDesc($value);
				break;
				case 'dlt_createdate':
					$this->setCreateDate($value);
				break;				
				case 'dlt_lastmodifydate':
					$this->setLastModifyDate($value);
				break;
				case 'dlt_price':
					$this->setPrice($value);
				break;
				case 'dlt_active':
					$this->setActive($value);
				break;
			}
		}
	}
	/**
	 * Ustawia identyfikator uytkownika, ktry jest wacicielem pozycji sownika
	 *
	 * @param string $userid
	 */
	function setUser($userid) {$this->_UserId = $userid;}
	/**
	 * Ustawia nazw pozycji sownika
	 *
	 * @param string $name
	 */
	function setName($name) {$this->Name = $name;}
	/**
	 * Ustawia dat ostatniej modyfikacji
	 *
	 * @param string $lmdate 
	 */
	function setLastModifyDate($lmdate) {$this->_LastModifyDate = $lmdate;}
	/**
	 * Ustawia koszt typu dostarczenia
	 *
	 * @param float $price
	 */
	function setPrice($price) {$this->_Price = $price;}
	/**
	 * Zwraca identyfikator uytkownika, ktry jest wacicielem pozycji sownika
	 *
	 * @return string
	 */
	function getUser() {return $this->_UserId;}
	/**
	 * Zwraca nazw pozycji sownika
	 *
	 * @return string
	 */
	function getName() {return $this->Name;}
	/**
	 * Zwraca dat ostatniej modyfikacji
	 *
	 * @return string
	 */
	function getLastModifyDate() {return $this->_LastModifyDate;}
	/**
	 * Zwraca koszt typu dostarczenia
	 *
	 * @return float
	 */
	function getPrice() {return $this->_Price;}
	/**
	 * Zwraca obiekt lub obiekty repezentujce pozycje sownika
	 *
	 * @param string $podid Identyfikator pozycji sownika
	 */
	function getData($posid = NULL) {
		//Rdze aplikacji
		global $appCore;
		
	}
	/**
	 * Sprawdza czy obiekt jest obiektem klasy DeliveryType
	 *
	 * @param &objectn $object
	 */
	function isDeliveryTypeObject(&$object) {return Object::isClassObject($object, 'DeliveryType');}
	/**
	 * Zapisuje dane obiektu do bazy
	 *
	 * Metoda nie moe by wywoywana statycznie
	 */
	function saveData() {
		//Rdze aplikacji
		global $appCore;
		
		//Przygowanie do zapisu
		$appCore->setTransactionStatus(FALSE);
		if (PEAR::isError($err = Transaction('BEGIN'))) {return $err;}
		$appCore->setTransactionStatus(TRUE);
		
		//Zapisywanie danych ---------------------------------------------
			
			if (DeliveryType::doesDeliveryTypeExist($this->_Id)) {
				//Pozycja sownika istnieje wic bdzie modyfikacja
			} else {
				//Pozycja sownika nie istnieje wic bdzie tworzona od podstaw
				//Generowanie identyfikatora
				$this->generateId();
				
				//Przygotowanie i wykonanie zapytania SQL
				$sqlquery  = 'INSERT INTO DeliveryType (DLT_Id, USR_Id, DLT_Name, DLT_Desc, DLT_CreateDate, DLT_LastModifyDate, DLT_Price, DLT_Active) ';
				$sqlquery .= 'VALUES ("'.$this->getId().'", "'.$this->getUser().'", "'.$this->getName().'", "'.$this->getDesc().'", CURRENT_TIMESTAMP(0), NULL, "'.$this->getPrice().'", ';
				if ($this->getActive()) {$sqlquery .= '1)';} else {$sqlquery .= '0)';}
				if (DB::isError($result = $appCore->Query($sqlquery))) {
					$err =  PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
					if(!isset($this)) {DeliveryType::errorHandlerDeliveryType($err);}
					return $err;
				}
			}
			
		//Zapisywanie danych ---------------------------------------------
		
		//Proces zapisywania danych zakoczony pomylnie
		if (PEAR::isError($err = Transaction('COMMIT'))) {return $err;}
		$appCore->setTransactionStatus(FALSE);
	}
	/**
	 * Usuwa obiekt z bazy danych
	 *
	 * @param string $id Identyfikator obiektu do usunicia
	 */
	function deleteData($id = NULL) {

		if (!$id) {$id = $this->_Id;}
		//Rdze aplikacji
		global $appCore;
		
		//Sprawdzenie czy obiekt moe by usunity
		DeliveryType::canBeDeleted($id);
	}
	/**
	 * Sprawdza czy obiekt moe by usunity z bazy danych
	 *
	 * Metoda moe by wywoywana tylko statycznie
	 *
	 * @param string $id Identyfikator obiektu do usunicia
	 */
	function canBeDeleted($id) {

		//Rdze aplikacji
		global $appCore;
	}
	/**
	 * Sprawdza czy obiekt istnieje w bazie danych
	 *
	 * @param string $id Identyfikator obiektu
	 * @return mixed Obiekt bool lub PEAR_Error
	 */
	function doesDeliveryTypeExist($id) {
		//Rdze aplikacji
		global $appCore;
		
		//Przygotowanie zapytania SQL
		$sqlquery = 'SELECT DLT_Id FROM DeliveryType WHERE DLT_Id="'.$id.'"';
		if (DB::isError($result = $appCore->Query($sqlquery))) {
			$err =  PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
			if(!isset($this)) {DeliveryType::errorHandlerDeliveryType($err);}
			return $err;
		}
		
		//Zwracanie wyniku warunku logicznego
		return ($result->numRows()==1);
	}
	/**
	 * Przygotowuje tablica parametrw dla pola comboBox moduu formularza
	 *
	 * @param &array &$resArray Tablica, ktra bdzie zawiera list pozycji sownikowych
	 * @param bool $active 
	 */
	function prepareComboBoxValues(&$resArray, $active = TRUE) {
		//Rdze aplikacji
		global $appCore;
				
		//Przygotowanie zapytania SQL
		$sqlquery = 'SELECT DLT_Id, DLT_Name FROM DeliveryType';
		if ($active) {$sqlquery .= ' WHERE DLT_Active=1';}
		if (DB::isError($result = $appCore->Query($sqlquery))) {
			$err =  PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
			if(!isset($this)) {DeliveryType::errorHandlerDeliveryType($err);}
			return $err;
		}

		//Tworzenie tablicy 
		while($row = $result->fetchRow()) {$resArray[] = array($row[0], $row[1]);}
	}
	/**
   	 * Domylna metoda obsugi bdw dla obiektw tej klasy
	 * @param PEAR_Error $error Kod bdu
   	 * @access public
   	 */
	function errorHandlerDeliveryType($error) {
		//Rdze aplikacji
		global $appCore;

		//Odwoanie transakcji
		if ($appCore->getTransactionStatus()) {
			Transaction('ROLLBACK');
			$appCore->setTransactionStatus(FALSE);
		}
		
		//Standardowa obsuga bdu
		$appCore->handleError($error);
	}
    /**#@-*/
}
?>