<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+

/**
 * Klasa Country opisujca pastwo
 * Dziedziczy po klasie Object
 */
class Country extends Object {
	/**#@+
   	 * @access protected
   	 */
  	/**
   	 * @var object Nazwa kraju
   	 */
  	var  $_Name;
  	/**
   	 * @var string Symbol kraju
   	 */
  	var  $_Symbol;
    /**#@-*/
	 
  	/**
   	 * Domylna metoda wywoywana podczas inicjalizacji obiektw tej klasy
   	 * @access public
   	 * @param array $countrydata Tablica z danymi o kraju
   	 */
	function Country($countrydata = array())
	{
		// Okrelenie domylnej metody obsugi bdw
		$this->setErrorHandling(PEAR_ERROR_CALLBACK, array(&$this, 'errorHandlerCountry'));
		foreach ($countrydata as $key => $value) { 
			switch (strtolower($key)) {
				case 'cry_id':
					$this->setId($value);
					break;
				case 'usr_id':
					$this->setOwner($value);
					break;
				case 'cry_name':
					$this->setName($value);
					break;
				case 'cry_createdate':
					$this->setCreateDate($value);
					break;
				case 'cry_lastmodifydate':
					$this->setLastModifyDate($value);
					break;
				case 'cry_symbol':
					$this->setSymbol($value);
					break;
				case 'cry_active':
					$this->setActive($value);
					break;
			}
		}
	}
  	/**
   	 * Ustawia nazw kraju
   	 * @access public
   	 * @param string $name Nazwa kraju
   	 * @return mixed
   	 */
	function setName($name)
	{
		if (PEAR::isError($result = $this->parseVar($name,'string', array(array('not_null'), array('striptags'))))) {
			return $result;
		} else {
			$this->_Name = $name;
		}
	}
  	/**
   	 * Ustawia symbol kraju
   	 * @access public
   	 * @param string $symbol Symbol
   	 * @return mixed
   	 */
	function setSymbol($symbol)
	{
		if (PEAR::isError($result = $this->parseVar($symbol,'string', array(array('striptags'))))) {
			return $result;
		} else {
			$this->_Symbol = $symbol;
		}
	}
  	/**
   	 * Zwraca nazw kraju
   	 * @access public
   	 * @return string
   	 */
	function getName(){ return $this->_Name;}
  	/**
   	 * Zwraca symbol kraju
   	 * @access public
   	 * @return string
   	 */
	function getSymbol(){ return $this->_Symbol;}
  	/**
   	 * Zwraca podstawowe informacje o kraju
	 * @param string $countryid Identyfikator kraju, ktrego dane chcemy uzyska.
	 * Warto domylna NULL (pobrane zostan dane wszystkich pastw)
	 * @param string $filter Filtr wyboru danych:
	 *						 - 'active' - aktywne wiersze (warto domylna)
	 *						 - 'nonactive' - nieaktywne wiersze
	 *						 - 'all' - wszystkie wiersze
   	 * @access public
   	 * @return mixed
   	 */
	function getData($countryid = NULL, $filter = 'active') {

		global $appCore; 
		$country_list = array();
		// Ustawienie poprawnego identyfikatora kraju oraz kryteriw 
		// wyszukiwania
		switch ($filter) {
			case 'active':
				$where_active = 'Country.CRY_Active = 1';
				break;
			case 'nonactive':
				$where_active = 'Country.CRY_Active = 0';
				break;
			case 'all':
				$where_active = '(Country.CRY_Active = 0 OR Country.CRY_Active = 1)';
				break;
			default:
				$where_active = 'Country.CRY_Active = 1';
		}
		if (isSet($countryid)) {
			if (PEAR::isError($result = Object::parseVar($countryid,'id'))) { return $result;}
			$where_statement = " WHERE Country.CRY_Id = '$countryid' AND $where_active";
		} else { 
			$where_statement = " WHERE $where_active";
		}
		
   		// Pobranie podstawowych informacji o pastwach
   		$sqlquery = "SELECT * FROM Country $where_statement ORDER BY CRY_Name";
		if (DB::isError($result = &$appCore->Query($sqlquery))) {
   			return $result;
   		}

		while ($countrydata = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
			$country_list[] = new Country($countrydata);
		}

		return $country_list;	
	}
  	/**
   	 * Metoda zapisujca dane pastwo w bazie danych
   	 *
   	 * @access public
   	 * @param mixed $country Obiekt Country
   	 * @return mixed
   	 */
   	function saveData($country = NULL)
   	{
		global $appCore;

		if ($country == NULL) { $country = &$this;}
		$country->setCreateDate(date(DATE_FORMAT_DBSAVE));

   		// Zapisanie danych
   		if (PEAR::isError($result = saveCountry($country))) {
			return $result;
   		} else {
   			return TRUE;
   		}
	} 
  	/**
   	 * Metoda uaktualniajca dane kraju w bazie danych
   	 *
   	 * @access public
   	 * @param mixed $country Obiekt Country
   	 * @return mixed
   	 */
   	function updateData($country = NULL)
   	{
		global $appCore;

		if ($country == NULL) { $country = &$this;}
		$country->setLastModifyDate(date(DATE_FORMAT_DBSAVE));

   		// Zaktualizowanie danych
   		if (PEAR::isError($result = updateCountry($country))) {
			return $result;
   		} else {
   			return TRUE;
   		}
	} 
  	/**
   	 * Metoda usuwajca dany kraj z bazy danych
   	 *
   	 * @access public
   	 * @param string $countryid Identyfikator obiektu
   	 * @return mixed
   	 */
   	function deleteData($countryid = NULL)
   	{
		global $appCore;

		if ($countryid == NULL) { $countryid = &$this->getId();}

   		// Usunicie danych
   		if (PEAR::isError($result = deleteCountry($countryid))) {
			return $result;
   		} else {
   			return TRUE;
   		}
	} 
	/**
	 * Przygotowuje tablica parametrw dla pola comboBox moduu formularza
	 *
	 * @param &array &$resArray Tablica, ktra bdzie zawiera list pozycji 
	 * sownikowych
	 * @param bool $active 
	 * @param string $selId
	 */
	function prepareComboBoxValues(&$resArray, $active = TRUE, $selId=NULL) {
		//Rdze aplikacji
		global $appCore;
				
		//Przygotowanie zapytania SQL
		$sqlquery = 'SELECT CRY_Id, CRY_Name FROM Country';
		if ($active) {$sqlquery .= ' WHERE CRY_Active=1';}
		if (DB::isError($result = $appCore->Query($sqlquery))) {
			$err =  PEAR::raiseError($result->getMessage().';'.$sqlquery, -500, null, null, PEAR_LOG_ERR);
			if(!isset($this)) {DeliveryType::errorHandlerDeliveryType($err);}
			return $err;
		}

		//Tworzenie tablicy 
		while($row = $result->fetchRow()) {if ($selId == $row[0]) {$resArray[] = array($row[0], $row[1], TRUE);} else {$resArray[] = array($row[0], $row[1]);}}
	}
  	/**
   	 * Domylna metoda obsugi bdw dla obiektw tej klasy
	 * @param mixed $error Kod bdu
   	 * @access public
   	 * @return mixed
   	 */
	function errorHandlerCountry($error) {
	    global $appCore;
		$appCore->handleError($error);
	}
} // Koniec klasy Country
?>