<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+
//Zaadowanie niezbdnych moduw
global $appCore;
if (PEAR::isError($err = $appCore->loadModule('Order'))){echo($appCore->getLastErrorMessage()); exit;}
if (PEAR::isError($err = $appCore->loadModule('Product'))){echo($appCore->getLastErrorMessage()); exit;}

//Klasa obsugujca koszyk
class Basket extends PEAR {
	/**
	 * @var Array Tablica produktw dodanych do koszyka
	 */
	var $_products;
	/**
	 * @var Integer Limit sztuk jednego produktu w koszyku
	 */
	var $_maxquantity;
	/**
	 * Konstruktor klasy
	 */
	function Basket ($_maxq=10) {
		// Okrelenie domylnej metody obsugi bdw
		$this->setErrorHandling(PEAR_ERROR_CALLBACK, array(&$this, 'errorHandlerBasket'));
		
		//Jawne wyczyszczenie zawartoci koszyka
		$this->_products = NULL;
		
		//Maksymalna liczba sztuk jednego produktu w koszyku
		$this->_maxquantity = $_maxq;
	}
	/***
	 * Zwaraca maksymaln liczb produktw, ktre mog znajdowa si w koszyku
	 *
	 * @return integer
	 */
	function getMaxQuantity() {return $this->_maxquantity;}
	/**
	 * Metoda zwraca tablic zawierajc produkty dodane do koszyka
	 *
	 * @return Array Tablica produktw znajdujcych si w koszyku
	 */
	function getBasket() {return $this->_products;}
	/**
	 * Metoda dodaje produkt do koszyka
	 * 
	 * Jeeli produkt o podanymidentyfikatorze znajduje si ju w koszyku. 
	 * Zwikszana jest liczba sztuk danego produktu w koszyku
	 *
	 * @param string $_prodid 32-znakowy identyfikator produktu
	 * @return mixed Wartos TRUE w przypadku powodzenia lub PEAR_Error
	 */
	function addProduct($_prodid) {
	
		//Sprawdzenie czy produkt o podanym identyfikatorze istnieje
		$result = Product::doesProductExist($_prodid);
		if(PEAR::isError($result) || !$result) {return PEAR::raiseError($_prodid, -1500, null, null, PEAR_LOG_NOTICE);}
	
		//Sprawdzenie czy produkt nie znajduje si ju przypadkiem w koszyku
		for($iter=0; $iter<count($this->_products); $iter++) {
			if ($this->_products[$iter][0]->getId() == $_prodid) {
			
				//Jeeli si znajduje prbujemy zwiekszy liczb sztuk w koszyku
				
				//Wprawdzamy, czy liczna sztuk obecna nie jest maksymalna
				if ($this->_products[$iter][1] == $this->_maxquantity) {
					$this->_products[$iter][1] = $this->_maxquantity;
					return PEAR::raiseError($this->_maxquantity.';'.$this->_products[$iter][0]->_Item->getName(), -1503, null, null, PEAR_LOG_NOTICE);
				}
				//ZAwikszana jest liczba sztuk w koszyku
				$this->_products[$iter][1]++;
				return TRUE;
			}
		}
			
		//Produkt nie znajduje si w koszyku
		$newProd = Product::getData(NULL, $_prodid);
		$this->_products[] = array($newProd[0] , 1);
		return TRUE;
	}
	/**
	 * Metoda modyfikuje liczb sztuk wybranego produktu w koszyku
	 *
	 * @param $_prodid string Identyfikator produktu
	 * @param $__newCount integer Liczba produktw
	 * @return mixed Warto true w przypadku powodzenia lub PEAR_Error
	 */
	function changeProductCount($_prodid, $_newCount) {		
		
		//Sprawdzenie czy produkt znajduje si w koszyku
		if(PEAR::isError($prod = $this->getProductFromBasket($_prodid))) {
			return PEAR::raiseError($_prodid.';'.$_newCount, -1502, null, null, PEAR_LOG_NOTICE);
		}
		
		//Sprawdzenie czy liczba sztuk produktu jest odpowiednia
		if (intval($_newCount)<0 || $_newCount>$this->_maxquantity) {
			return PEAR::raiseError($this->_products[$prod][0]->_Item->getName().';'.$_newCount, -1501, null, null, PEAR_LOG_NOTICE);
		}
		
		if ($_newCount == 0) {
			//Zupene usunicie produktu z koszyka
			array_splice($this->_products, $prod, 1);
		} else {
			//Zmiana liczby produktw w koszyku
			$this->_products[$prod][1] = $_newCount;
		}
		
	}
	/**
	 * Metoda zwraca obiekt produktu, ktry znajduje si w koszyku
	 *
	 * @param _prodid string 
	 * @return mixed Zwraca numer elementu tablicy _products, w ktrej
	 *			     znajduje si produktu lub obiekt PEAR_Error
	 */
	function getProductFromBasket($_prodid) {
				
		//Sprawdzenie czy produkt o podanym identyfikatorze znajduje si w 
		//koszyku i zwrcenie jego obiektu
		for($iter=0; $iter<count($this->_products); $iter++) {
			if ($this->_products[$iter][0]->getId() == $_prodid) {
				return $iter;
			}
		}
		
		//Produkt nie znajduje si w koszyku
		return PEAR::raiseError($_prodid, -1502, null, null, PEAR_LOG_NOTICE);
	}
	/**
	 * Metoda czyci zawarto koszyka
	 */
	function clearBasket() {$this->_products = NULL;}
	/**
	 * Metoda zawraca czn warto cenow (newtto lub brutto) produktw w koszyku
	 *
	 * @return float Cakowita warto produktw w koszyku 
	 */
	function getTotalPrice() {
		switch (DEFAULT_PRICE) {
			case 'netto':
				return $this->getTotalPriceNetto();
				break;
			case 'brutto':
				return $this->getTotalPriceBrutto();
				break;
			default:
				return $this->getTotalPriceBrutto();
		}
	}
	/**
	 * Zwraca czn warto cenow netto produktw w koszyku
	 *
	 * @return float Cakowita warto produktw w koszyku 
	 */
	function getTotalPriceNetto() {
		$priceValue = 0;
		for($iter=0; $iter<count($this->_products); $iter++) {
			//Jeeli produkt jest w promocji to dodawana jest cena promocyjna
			if ($this->_products[$iter][0]->hasProductAvalSpecial()) {
				$priceValue += $this->_products[$iter][0]->getSpecialPriceNetto()*$this->_products[$iter][1];
			} else {
				$priceValue += $this->_products[$iter][0]->getPriceNetto()*$this->_products[$iter][1];
			}
		}
		return $priceValue;
	}
	/**
	 * Zwraca czn warto cenow brutto produktw w koszyku
	 *
	 * @return float Cakowita warto brutto produktw w koszyku 
	 */
	function getTotalPriceBrutto() {
		$priceValue = 0;
		for($iter=0; $iter<count($this->_products); $iter++) {
			//Jeeli produkt jest w promocji to dodawana jest cena promocyjna
			if ($this->_products[$iter][0]->hasProductAvalSpecial()) {
				$priceValue += $this->_products[$iter][0]->getSpecialPriceBrutto()*$this->_products[$iter][1];
			} else {
				$priceValue += $this->_products[$iter][0]->getPriceBrutto()*$this->_products[$iter][1];
			}
		}
		return $priceValue;
	}
	/**
	 * Metoda wykonuje proces zoenia zamwienia. 
	 * 
	 * Po pomylnie wykonanej operacji zawarto koszyka jest czyszczona
	 *
	 * @param $array $orderAddres Adres wystwiany do zamwienia
	 * @return mixed Warto TRUE lub obiekt PEAR_Error
	 */
	function placeOrder($orderAddres) {
	
		//Rdze aplikacji
		global $appCore;
				
		//Sprawdzenie czy zarejestrowany jest user typu Customer
		if ($_SESSION['CurrentUser']->getType()!='C') {
			$this->clearBasket();
			return PEAR::raiseError(NULL, -1504, null, null, PEAR_LOG_ERR);
		}
				
		//Tworzony jest obiekt zamwienia
		$ordObj = new Order();
		
		//Uytkownik skadajcy zamwienie
		$cUser = &$_SESSION['CurrentUser'];
		
		$ordObj->setDeliveryTypeId($orderAddres['dt']);
		$ordObj->setPaymentType($orderAddres['pt']);
		$ordObj->setUserId($cUser->getId());
		//function setCurencyId($value) {$this->_CurId = $value;}
		//function setOrderStatusId($value) {$this->_OrdId = $value;}
		$ordObj->setUserName($cUser->getName());
		$ordObj->setUserLastName($cUser->getLastName());
		$ordObj->setUserEmail($cUser->getEmail());
		
		$ordObj->setAddrStreetName($orderAddres['astrnm']);
		$ordObj->setAddrStreetNr($orderAddres['astrnum']);
		$ordObj->setAddrHomeNr($orderAddres['ahomenum']);
		$ordObj->setAddrCity($orderAddres['acity']);
		$ordObj->setAddrZip($orderAddres['azip']);
		$ordObj->setAddrState($orderAddres['astate']);
		$ordObj->setAddrCountry($orderAddres['acountry']);
		$ordObj->setPrice($this->getTotalPriceBrutto());
		$ordObj->setOrderedProducts($this->_products);
		$ordObj->setActive(TRUE);
		
		//Prba zapisania danych obiektu zamwienia
		if(PEAR::isError($result = $ordObj->saveData())) {
			$this->clearBasket();
			return $result;
		}
		
	
		//Po zoeniu zamwienia koszyk powinien zosta wyczyszczony
		$this->clearBasket();
		return TRUE;
	}
	/**
   	 * Domylna metoda obsugi bdw dla obiektw tej klasy
	 * @param PEAR_Error $error Kod bdu
   	 * @access public
   	 */
	function errorHandlerBasket($error) {
		//Rdze aplikacji
		global $appCore;

		//Odwoanie transakcji
		if ($appCore->getTransactionStatus()) {
			Transaction('ROLLBACK');
			$appCore->setTransactionStatus(FALSE);
		}
		
		//Standardowa obsuga bdu
		$appCore->handleError($error);
	}

}
?>