<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+
//Na bazie klasy bazowej PEAR
require_once('PEAR.php');
/**
 * Klasa parsera XML Klasa bazowa dla wszystkich obiektw uywanych do obsugi platformy thorEngine
 */
class ConfXML_Parser extends PEAR {

	/**#@+
   	 * @access private
   	 */
  	/**
   	 * @var string Unikalny identyfikator obiektu (32 znaki).
   	 */
	var $_pXML;
	/**
   	 * @var string Unikalny identyfikator obiektu (32 znaki).
   	 */
	var $_section;
	/**
   	 * @var string Unikalny identyfikator obiektu (32 znaki).
   	 */
	var $_id;
	/**
   	 * @var string Unikalny identyfikator obiektu (32 znaki).
   	 */
	var $_fileHandler;
	/**
   	 * @var string Unikalny identyfikator obiektu (32 znaki).
   	 */
	var $_xmlString;
	/**
   	 * @var string Unikalny identyfikator obiektu (32 znaki).
   	 */
	var $_status;
	/**
   	 * @var string Unikalny identyfikator obiektu (32 znaki).
   	 */
	var $_fileName;
	/**
   	 * @var string Unikalny identyfikator obiektu (32 znaki).
   	 */
	var $_encoding;
	/**
   	 * @var string Unikalny identyfikator obiektu (32 znaki).
   	 */
	var $_xmlBody;
	/**#@-*/
	
	/**#@+
   	 * @access public
   	 */
	/**
   	 * Konstruktor klasy.
	 *
   	 * @param string $_filename Nazwa pliku konfiguracyjnego XML wraz z pen ciek dostpu
	 * @param string $_enc Sposb kodanie znakw w pliku konfiguracyjnym XML (parametr nieobowizkowy)
   	 */
	function ConfXML_Parser($_filename, $_enc = NULL) {
		$this->_fileName = $_filename;
		$this->_encoding = $_enc;
		
		//Standardowa obsuga bdw
		$this->setErrorHandling(PEAR_ERROR_CALLBACK, array(&$this, 'errorHandlerConfXML_Parser'));
	}
	
	/**
	 * Metoda zwracajca list parametrw wybranej sekcji lub konkretny parametr wybranej sekcji 
	 *
	 * @param string $_sectionId Warto atrybutu ID elementu SECTION pliku konfiguracyjnego
	 * @param string $_parametrId Warto atrybutu ID elementu PARAM pliku konfiguracyjnego
	 * @return mixed Tablica parametrw, tablica atrybutw parametru lub obiekt klasy PEAR_Error
	 */
	function getXMLSection($_sectionId, $_parametrId="") {
		
		//Tworzenie obiekt standardowego parsera XML jzyka PHP
		$this->_pXML = xml_parser_create($this->_encoding);
		xml_set_object($this->_pXML, &$this);
		xml_set_element_handler($this->_pXML, '_startTagFunc', '_endTagFunc');
		$this->_status = 'waiting';
		$this->_xmlString = null;
	    
		$this->_section = $_sectionId; $this->_id = $_parametrId;
		
		//Prba otwarcia pliku
		if (!file_exists($this->_fileName)) {return PEAR::raiseError($this->_fileName, -401, null, null, PEAR_LOG_ERR);}
        if (!($this->_fileHandler = @fopen($this->_fileName, "r"))) {return PEAR::raiseError($this->_fileName, -402, null, null, PEAR_LOG_ERR);}
	 
		//Uruchomienie parsowania
		if(PEAR::isError($err = $this->_parseXML())) {
			return PEAR::raiseError($this->_fileName, -351, null, null, PEAR_LOG_ERR);
		}
		
		xml_parser_free($this->_pXML);
		fclose($this->_fileHandler);
		return $this->_xmlString;
	}
	
	function getXMLErrorMsg ($_sectionId, $_errorNo) {
		
		//Tworzenie obiekt standardowego parsera XML jzyka PHP
		$this->_pXML = xml_parser_create($this->_encoding);
		xml_set_object($this->_pXML, &$this);
		xml_set_element_handler($this->_pXML, '_startTagNumberFunc', '_endTagFunc');
		$this->_status = 'waiting';
		$this->_xmlString = null;
	    
		$this->_section = $_sectionId; $this->_id = $_errorNo;

		//Prba otwarcia pliku
		if (!file_exists($this->_fileName)) {return PEAR::raiseError($this->_fileName, -401, null, null, PEAR_LOG_ERR);}
        if (!($this->_fileHandler = @fopen($this->_fileName, "r"))) {return PEAR::raiseError($this->_fileName, -402, null, null, PEAR_LOG_ERR);}

		//Uruchomienie parsowania
		if(PEAR::isError($err = $this->_parseXML())) {
			return PEAR::raiseError($this->_fileName, -351, null, null, PEAR_LOG_ERR);
		}
		
		xml_parser_free($this->_pXML);
		fclose($this->_fileHandler);
		return $this->_xmlString;
	}
	/**#@-*/
	
	/**#@+
   	 * @access private
   	 */
	/**
	 * Metoda wywoywana w momencie wystpienia zdarzenia napotkania znacznika otwierajcego elementu XML
	 */
	function _startTagFunc($_parser, $_name, $_attrs) {
		if ($this->_status == 'waiting') {
			if($_name=='SECTION') {
				if ($_attrs['ID'] == $this->_section) {
					$this->_status = 'reading';
				}
			}
		} else if ($this->_status == 'reading') {
			if ($this->_id!='') {
				if ($this->_id==$_attrs['ID']) {
					while(list($key, $val1) = each($_attrs)) {;
					 $this->_xmlString[$key] = $val1;
					}
					$this->_status = 'done';
				}
			} else {
				$paramArr = array();
				while(list($key, $val1) = each($_attrs)) {;
					 $paramArr[$key] = $val1;
				}
				$this->_xmlString[] = $paramArr;
			}
		}
    }
	
	function _startTagNumberFunc($_parser, $_name, $_attrs) {
		if ($this->_status == 'waiting') {
			if($_name=='SECTION') {
				if ($_attrs['ID'] == $this->_section) {
					$this->_status = 'reading';
				}
			}
		} else if ($this->_status == 'reading') {

			if ($this->_id==$_attrs['ID']) {
				$this->_xmlString = $_attrs['VALUE'];
				$this->_status = 'done';
			}
		}
    }
	/**
	 * Metoda wywoywana w momencie wystpienia zdarzenia napotkania znacznika zamykajcego elementu XML
	 */
	function _endTagFunc($_parser, $_name) {
		if($_name=='SECTION') {
			if($this->_status == 'reading') {
				$this->_status = 'done';
			} 
		}
    }
	/**
	 * Metoda parsujca dokument XML
	 */
	function _parseXML () {
	    while ($data = fread($this->_fileHandler, 40)) {
            if (!xml_parse($this->_pXML, $data, feof($this->_fileHandler))) {
			   return PEAR::raiseError(xml_error_string(xml_get_error_code($this->_pXML)).', '.xml_get_current_line_number($this->_pXML), -550, null, null, PEAR_LOG_ERR);
            }
			if ($this->_status == 'done') {
				return;
			}
        }
	}
	
	function errorHandlerConfXML_Parser($error) {
	    //Rdze aplikacji
		global $appCore;
		$appCore->handleError($error);
	}
	
	/**#@-*/
}
?>