<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+

require_once('PEAR.php');
require_once(APP_CORE_PATH.'common.inc.php');

/**
 * Funkcja zapisuje dane nowego asortymentu w bazie danych
 *
 * @access public
 * @param object $item
 * @return mixed
 */
 function saveItem(&$item) {
 	
	global $appCore;

	// Rozpoczcie transakcji 
    if (PEAR::isError($result = Transaction('BEGIN'))) return $result;
	// Zapisanie danych w tabeli Item
 	$sqlquery = "INSERT INTO Item (ITM_Id, USR_Id, ITM_Name, ITM_DescShort, ITM_DescLong, ITM_CreateDate, ITM_Active) VALUES ('" . $item->getId() . "', '" . $item->getOwner() . "', '" . $item->getName() . "', '" . $item->getDescShort() . "', '" . $item->getDescLong() . "', '" . $item->getCreateDate() . "', '" . $item->getActive() . "')";
	if(DB::isError($result = $appCore->Query($sqlquery))) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($sqlquery, -650, null, null, PEAR_LOG_NOTICE);
	}
	$dbObject = &$appCore->getConnection(); 
	if ($dbObject->affectedRows() < 1) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error("Dodanie asortymentu do sklepu", -651, null, null, PEAR_LOG_NOTICE);	
	} else {
		$params = $item->getParams();
		foreach ($params as $key => $value) {
			// Sprawdzenie duplikatw parametrw
		 	$sqlquery = "SELECT COUNT(*) FROM itm_has_par WHERE itm_has_par.ITM_Id = '" . $item->getId() . "' AND itm_has_par.PAR_Id = '" . $value->getId() . "'";
			if(DB::isError($result = $appCore->Query($sqlquery))) {
				// Odwoanie transakcji 
				Transaction('ROLLBACK');
				return new PEAR_Error("Przypisanie parametru do asortymentu", -651, null, null, PEAR_LOG_NOTICE);	
			}
			$paramcount = &$result->fetchRow(DB_FETCHMODE_ASSOC);
			
			if (current($paramcount) == 0) {
	                // Zapisanie danych parametru
                $sqlquery = "INSERT INTO itm_has_par (PAR_Id, ITM_Id, PAR_Value) VALUES ('" . $value->getId() . "', '" . $item->getId() . "', '" . $value->getValue() . "')";
                if(DB::isError($result = $appCore->Query($sqlquery))) {
                    // Odwoanie transakcji
                    Transaction('ROLLBACK');
                    return new PEAR_Error($sqlquery, -650, null, null, PEAR_LOG_NOTICE);
                }
                $dbObject = &$appCore->getConnection(); 
                if ($dbObject->affectedRows() < 1) {
                    // Odwoanie transakcji
                    Transaction('ROLLBACK');
                    return new PEAR_Error("Przypisanie parametru do asortymentu", -651, null, null, PEAR_LOG_NOTICE);   
                }
            }
		}
	    if (PEAR::isError($result = Transaction('COMMIT'))) return $result;
		return TRUE;
	}
 }
/**
 * Funkcja zapisuje dane nowego produktu w bazie danych
 *
 * @access public
 * @param object $product
 * @return mixed
 */
 function saveProduct(&$product) {
 	
	global $appCore;

	// Rozpoczcie transakcji 
    if (PEAR::isError($result = Transaction('BEGIN'))) return $result;
	// Zapisanie danych w tabeli Product
	$prc_id = 'NULL';
	if ($product->_Producer <> '') $prc_id = "'" . $product->_Producer->getId() . "'";
 	$sqlquery = "INSERT INTO Product (PRD_Id, USR_Id, ITM_Id, PRC_Id, TAX_Id, PRD_Price, PRD_Quantity, PRD_CreateDate, PRD_AvailableDate, PRD_ViewCount, PRD_Active) VALUES ('" . $product->getId() . "', '" . $product->getOwner() . "', '" . $product->_Item->getId() . "', " . $prc_id . ", '" . $product->_Tax->getId() . "', '" . $product->getPriceNetto() . "', '" . $product->getQuantity() . "', '" . $product->getCreateDate() . "', '" . $product->getAvailableDate() . "', '" . $product->getViewCount() . "', '" . $product->getActive() . "')";
	if(DB::isError($result = $appCore->Query($sqlquery))) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($sqlquery, -650, null, null, PEAR_LOG_NOTICE);
	}
	$dbObject = &$appCore->getConnection(); 
	if ($dbObject->affectedRows() < 1) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error("Dodanie produktu do sklepu", -651, null, null, PEAR_LOG_NOTICE);	
	} else {
		// Przypisanie produktu do kategorii
		$categories = $product->getCategories();
		foreach ($categories as $key => $value) {
			// Sprawdzenie czy produkt nie jest ju w tej kategorii
		 	$sqlquery = "SELECT COUNT(*) FROM prd_isin_cat WHERE prd_isin_cat.PRD_Id = '" . $product->getId() . "' AND prd_isin_cat.CAT_Id = '" . $value->getId() . "'";
			if(DB::isError($result = $appCore->Query($sqlquery))) {
				// Odwoanie transakcji 
				Transaction('ROLLBACK');
				return new PEAR_Error("Przypisanie produktu do kategorii", -651, null, null, PEAR_LOG_NOTICE);	
			}
			$catcount = &$result->fetchRow(DB_FETCHMODE_ASSOC);
			if (current($catcount) == 0) {
                $sqlquery = "INSERT INTO prd_isin_cat (CAT_Id, PRD_Id) VALUES ('" . $value->getId() . "', '" . $product->getId() . "')";
                if(DB::isError($result = $appCore->Query($sqlquery))) {
                    // Odwoanie transakcji
                    Transaction('ROLLBACK');
                    return $result;
                }
                $dbObject = &$appCore->getConnection(); 
                if ($dbObject->affectedRows() < 1) {
                    // Odwoanie transakcji
                    Transaction('ROLLBACK');
                    return new PEAR_Error($product->getId(), -651, null, null, PEAR_LOG_NOTICE);    
                }
			}
		}
		// Przypisanie zdj do produktu
		$images = $product->getImages();
		foreach ($images as $key => $value) {
			// Zapisanie danych zdjcia
		 	$sqlquery = "INSERT INTO prd_has_img (IMG_Id, PRD_Id) VALUES ('" . $value->getId() . "', '" . $product->getId() . "')";
			if(DB::isError($result = $appCore->Query($sqlquery))) {
				// Odwoanie transakcji
				Transaction('ROLLBACK');
				return $result;
			}
			$dbObject = &$appCore->getConnection(); 
			if ($dbObject->affectedRows() < 1) {
				// Odwoanie transakcji
				Transaction('ROLLBACK');
				return new PEAR_Error($product->getId(), -651, null, null, PEAR_LOG_NOTICE);	
			}
		}
		if (PEAR::isError($result = Transaction('COMMIT'))) return $result;
		return TRUE;
	}
 }
/**
 * Funkcja zapisuje dane nowego producenta w bazie danych
 *
 * @access public
 * @param object $producer
 * @return mixed
 */
 function saveProducer(&$producer) {
 	
	global $appCore;

	// Rozpoczcie transakcji 
    if (PEAR::isError($result = Transaction('BEGIN'))) return $result;
	// Zapisanie danych w tabeli Producer
 	$sqlquery = "INSERT INTO Producer (PRC_Id, USR_Id, PRC_Name, PRC_Desc, PRC_CreateDate, PRC_LastModifyDate, PRC_URL, PRC_Email, PRC_Active) VALUES ('" . $producer->getId() . "', '" . $producer->getOwner() . "', '" . $producer->getName() . "', '" . $producer->getDesc() . "', '" . $producer->getCreateDate() . "', '" . $producer->getLastModifyDate() . "', '" . $producer->getURL() . "', '" . $producer->getEmail() . "', '" . $producer->getActive() . "')";
	if(DB::isError($result = $appCore->Query($sqlquery))) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return $result;
	}
	$dbObject = &$appCore->getConnection(); 
	if ($dbObject->affectedRows() < 1) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($producer->getId(), -651, null, null, PEAR_LOG_NOTICE);	
	} else {
		foreach ($producer->getAddresses() as $key => $value) {
		 	$sqlquery = "INSERT INTO Address (ADDR_Id, ADT_Id, CRY_Id, ST_Id, ADDR_StreetName, ADDR_StreetNr, ADDR_HomeNr, ADDR_City, ADDR_Zip, ADDR_Phone, ADDR_Fax, ADDR_CreateDate, ADDR_Active) VALUES ('" . $value->getId() . "', '" . $value->_addressType->getId() . "', '" . $value->_country->getId() . "', '" . $value->_state->getId() . "', '" . $value->getStreetName() . "', '" . $value->getStreetNr() . "', '" . $value->getHomeNr() . "', '" . $value->getCity() . "', '" . $value->getZIP() . "', '" . $value->getPhone() . "', '" . $value->getFax() . "', '" . $value->getCreateDate() . "', '" . $value->getActive() . "')";
			if(DB::isError($result = $appCore->Query($sqlquery))) {
				// Odwoanie transakcji
				Transaction('ROLLBACK');
				return $result;
			}
			$dbObject = &$appCore->getConnection(); 
			if ($dbObject->affectedRows() < 1) {
				// Odwoanie transakcji
				Transaction('ROLLBACK');
				return new PEAR_Error($producer->getId(), -651, null, null, PEAR_LOG_NOTICE);	
			}
			$sqlquery = "INSERT INTO prc_has_addr (PRC_Id, ADDR_Id) VALUES ('" . $producer->getId() . "', '" . $value->getId() . "')";
			if(DB::isError($result = $appCore->Query($sqlquery))) {
				// Odwoanie transakcji
				Transaction('ROLLBACK');
				return $result;
			}
			$dbObject = &$appCore->getConnection(); 
			if ($dbObject->affectedRows() < 1) {
				// Odwoanie transakcji
				Transaction('ROLLBACK');
				return new PEAR_Error($producer->getId(), -651, null, null, PEAR_LOG_NOTICE);	
			}
		}
	    if (PEAR::isError($result = Transaction('COMMIT'))) return $result;
		return TRUE;
	}
 }
/**
 * Funkcja uaktualnia dane producenta w bazie danych
 *
 * @access public
 * @param object $producer
 * @return mixed
 */
 function updateProducer(&$producer) {
 	
	global $appCore;
	// Rozpoczcie transakcji 
    if (PEAR::isError($result = Transaction('BEGIN'))) return $result;
 	// Uaktualnienie danych producenta w bazie danych
	$sqlquery = "UPDATE Producer SET Producer.USR_Id = '" . $_SESSION['CurrentUser']->getId() . "', Producer.PRC_Name = '" . $producer->getName() . "', Producer.PRC_Desc = '" . $producer->getDesc() . "', Producer.PRC_Url = '" . $producer->getURL() . "', Producer.PRC_Email = '" . $producer->getEmail() . "', Producer.PRC_LastModifyDate = '" . $producer->getLastModifyDate() . "', Producer.PRC_Active = " . $producer->getActive() . " WHERE Producer.PRC_Id = '" . $producer->getId() . "'";
	if(DB::isError($result = $appCore->Query($sqlquery))) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($sqlquery, -654, null, null, PEAR_LOG_NOTICE);
	}
	$dbObject = &$appCore->getConnection(); 
	if (DB::isError($result = $dbObject->affectedRows())) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error("Aktualizacja danych producenta", -651, null, null, PEAR_LOG_NOTICE);	
	} else {
		foreach ($producer->getAddresses() as $key => $value) {
	 		// Sprawdzenie istnienia danego adresu w bazie danych
			$sqlquery = "SELECT prc_has_addr.ADDR_Id FROM prc_has_addr WHERE prc_has_addr.ADDR_Id = '" . $value->getId() . "' AND prc_has_addr.PRC_Id = '" . $producer->getId() . "'";
			if(DB::isError($result = $appCore->Query($sqlquery))) {
				// Odwoanie transakcji 
				Transaction('ROLLBACK');
				return new PEAR_Error("Sprawdzenie aktualnych adresw", -651, null, null, PEAR_LOG_NOTICE);	
			}
			// Adres istnieje - trzeba uaktualni jego dane
			if ($address_id = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
				$sqlquery = "UPDATE Address SET ADT_Id = '" . $value->_addressType->getId() . "', CRY_Id = '" . $value->_country->getId() . "', ST_Id = '" . $value->_state->getId() . "', ADDR_StreetName = '" . $value->getStreetName() . "', ADDR_StreetNr = '" . $value->getStreetNr() . "', ADDR_HomeNr = '" . $value->getHomeNr() . "', ADDR_City = '" . $value->getCity() . "', ADDR_Zip = '" . $value->getZIP() . "', ADDR_Phone = '" . $value->getPhone() . "', ADDR_Fax = '" . $value->getFax() . "', ADDR_LastModifyDate = '" . $value->getLastModifyDate() . "', ADDR_Active = " . $value->getActive() . " WHERE Address.ADDR_Id = '" . $value->getId() . "'";
				if(DB::isError($result = $appCore->Query($sqlquery))) {
					// Odwoanie transakcji
					Transaction('ROLLBACK');
					return new PEAR_Error("Modyfikacja danych adresu", -651, null, null, PEAR_LOG_NOTICE);	
				}
				$dbObject = &$appCore->getConnection(); 
				if (DB::isError($result = $dbObject->affectedRows())) {
					// Odwoanie transakcji
					Transaction('ROLLBACK');
					return new PEAR_Error("Zapis zmodyfikowanych danych adresu", -651, null, null, PEAR_LOG_NOTICE);	
				} 
			} else {
			// Adres nie istnieje - trzeba go wprowadzi
				$sqlquery = "INSERT INTO Address (ADDR_Id, ADT_Id, CRY_Id, ST_Id, ADDR_StreetName, ADDR_StreetNr, ADDR_HomeNr, ADDR_City, ADDR_Zip, ADDR_Phone, ADDR_Fax, ADDR_CreateDate, ADDR_Active) VALUES ('" . $value->getId() . "', '" . $value->_addressType->getId() . "', '" . $value->_country->getId() . "', '" . $value->_state->getId() . "', '" . $value->getStreetName() . "', '" . $value->getStreetNr() . "', '" . $value->getHomeNr() . "', '" . $value->getCity() . "', '" . $value->getZIP() . "', '" . $value->getPhone() . "', '" . $value->getFax() . "', '" . $value->getCreateDate() . "', 1)";
				if(DB::isError($result = $appCore->Query($sqlquery))) {
					// Odwoanie transakcji
					Transaction('ROLLBACK');
					return new PEAR_Error("Dodanie nowego adresu", -651, null, null, PEAR_LOG_NOTICE);	
				}
				$dbObject = &$appCore->getConnection(); 
				if (DB::isError($result = $dbObject->affectedRows())) {
					// Odwoanie transakcji
					Transaction('ROLLBACK');
					return new PEAR_Error("Zapis nowego adresu", -651, null, null, PEAR_LOG_NOTICE);	
				} else {
					$sqlquery = "INSERT INTO prc_has_addr (PRC_Id, ADDR_Id) VALUES ('" . $producer->getId() . "', '" . $value->getId() . "')";
					if(DB::isError($result = $appCore->Query($sqlquery))) {
						// Odwoanie transakcji
						Transaction('ROLLBACK');
						return new PEAR_Error("Przypisanie nowego adresu", -651, null, null, PEAR_LOG_NOTICE);	
					}
					$dbObject = &$appCore->getConnection(); 
					if (DB::isError($result = $dbObject->affectedRows())) {
						// Odwoanie transakcji
						Transaction('ROLLBACK');
						return new PEAR_Error("Zapis przypisania adresu", -651, null, null, PEAR_LOG_NOTICE);	
					}
				}
			}
		}
		if (PEAR::isError($result = Transaction('COMMIT'))) return $result;
		return TRUE;
	}
 }
/**
 * Funkcja usuwa dane producenta z bazy danych
 *
 * @access public
 * @param string $producerid
 * @return mixed
 */
 function deleteProducer($producerid) {
 	
	global $appCore;
	// Pobranie etykiet

	$action_label = $appCore->getMessage('dict_producer', 'producer_actiondelete_label');
	$dependency_label = $appCore->getMessage('dict_producer', 'producer_actiondelete_dependency_label');

	// Rozpoczcie transakcji 
    if (PEAR::isError($result = Transaction('BEGIN'))) return $result;
 	// Wyszukanie powiza producenta z produktami
	$sqlquery = "SELECT COUNT(*) FROM Product WHERE Product.PRC_Id = '$producerid'";
	if(DB::isError($result = $appCore->Query($sqlquery))) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($sqlquery, -654, null, null, PEAR_LOG_NOTICE);
	}
	if ($productcount = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
		if (current($productcount) < 1) {
			// Sprawdzenie istnienia adresw producenta w bazie danych
			$sqlquery = "SELECT prc_has_addr.ADDR_Id FROM prc_has_addr WHERE prc_has_addr.PRC_Id = '$producerid'";
			if(DB::isError($result = $appCore->Query($sqlquery))) {
				// Odwoanie transakcji 
				Transaction('ROLLBACK');
				return new PEAR_Error("Sprawdzenie aktualnych adresw", -651, null, null, PEAR_LOG_NOTICE);
			}
			// Adres istnieje - trzeba usun jego dane
            if ($address_id = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
                foreach ($address_id as $key => $value) {
                    $sqlquery = "DELETE FROM Address WHERE Address.ADDR_Id = '$value'";                  if(DB::isError($result = $appCore->Query($sqlquery))) {    
                        // Odwoanie transakcji
                        Transaction('ROLLBACK');
                        return new PEAR_Error("Usunicie danych adresu", -651, null, null, PEAR_LOG_NOTICE);    
                    }
                }
                // Usunicie przypisania adresw do producenta z bazy danych
                $sqlquery = "DELETE FROM prc_has_addr WHERE prc_has_addr.PRC_Id = '$producerid'";
                if(DB::isError($result = $appCore->Query($sqlquery))) {
                    // Odwoanie transakcji
                    Transaction('ROLLBACK');
                    return new PEAR_Error("Usunicie przypisania adresu", -651, null, null, PEAR_LOG_NOTICE);   
                }
            }
            // Usunicie danych producenta z bazy danych 
            $sqlquery = "DELETE FROM Producer WHERE Producer.PRC_Id = '$producerid'";
            if(DB::isError($result = $appCore->Query($sqlquery))) {
                // Odwoanie transakcji
                Transaction('ROLLBACK');
                return new PEAR_Error("Usunicie producenta", -651, null, null, PEAR_LOG_NOTICE);   
            }
            $dbObject = &$appCore->getConnection(); 
            if (DB::isError($result = $dbObject->affectedRows())) {
                // Odwoanie transakcji
                Transaction('ROLLBACK');
                return new PEAR_Error("Usunicie producenta", -651, null, null, PEAR_LOG_NOTICE);   
            } else {
                if (PEAR::isError($result = Transaction('COMMIT'))) return $result;
                return TRUE;
            }
		} else {
			// Odwoanie transakcji
			Transaction('ROLLBACK');
			return new PEAR_Error($action_label['VALUE'] . ';' . $dependency_label['VALUE'], -655, null, null, PEAR_LOG_NOTICE);			
		}
	} else {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($sqlquery . ';' . $action_label, -656, null, null, PEAR_LOG_NOTICE);	
	}
 }
/**
 * Funkcja zapisuje dane nowego kraju w bazie danych
 *
 * @access public
 * @param object $country
 * @return mixed
 */
 function saveCountry(&$country) {
 	
	global $appCore;

	// Rozpoczcie transakcji 
    if (PEAR::isError($result = Transaction('BEGIN'))) return $result;
	// Zapisanie danych w tabeli Producer
 	$sqlquery = "INSERT INTO Country (CRY_Id, USR_Id, CRY_Name, CRY_CreateDate,  CRY_Symbol, CRY_Active) VALUES ('" . $country->getId() . "', '" . $country->getOwner() . "', '" . $country->getName() . "', '" . $country->getCreateDate() . "', '" . $country->getSymbol() . "', '" . $country->getActive() . "')";
	if(DB::isError($result = $appCore->Query($sqlquery))) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return $result;
	}
	$dbObject = &$appCore->getConnection(); 
	if ($dbObject->affectedRows() < 1) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($country->getId(), -651, null, null, PEAR_LOG_NOTICE);	
	} else {
	    if (PEAR::isError($result = Transaction('COMMIT'))) return $result;
		return TRUE;
	}
 }
/**
 * Funkcja uaktualnia dane kraju w bazie danych
 *
 * @access public
 * @param object $country
 * @return mixed
 */
 function updateCountry(&$country) {
 	
	global $appCore;
	// Rozpoczcie transakcji 
    if (PEAR::isError($result = Transaction('BEGIN'))) return $result;
 	// Uaktualnie danych kraju w bazie danych
	$sqlquery = "UPDATE Country SET Country.USR_Id = '" . $_SESSION['CurrentUser']->getId() . "', Country.CRY_Name = '" . $country->getName() . "',  Country.CRY_Symbol = '" . $country->getSymbol() . "', Country.CRY_LastModifyDate = '" . $country->getLastModifyDate() . "', Country.CRY_Active = " . $country->getActive() . " WHERE Country.CRY_Id = '" . $country->getId() . "'";
	if(DB::isError($result = $appCore->Query($sqlquery))) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($sqlquery, -654, null, null, PEAR_LOG_NOTICE);
	}
	$dbObject = &$appCore->getConnection(); 
	if (DB::isError($result = $dbObject->affectedRows())) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error("Aktualizacja kraju", -651, null, null, PEAR_LOG_NOTICE);	
	} else {
		if (PEAR::isError($result = Transaction('COMMIT'))) return $result;
		return TRUE;
	}
 }
/**
 * Funkcja usuwa dany kraj z bazy danych
 *
 * @access public
 * @param string $countryid
 * @return mixed
 */
 function deleteCountry(&$countryid) {
 	
	global $appCore;
	// Rozpoczcie transakcji 
    if (PEAR::isError($result = Transaction('BEGIN'))) return $result;
 	// Wyszukanie powiza kraju z tabel Address
	$sqlquery = "SELECT COUNT(*) FROM Address WHERE Address.CRY_Id = '$countryid'";
	if(DB::isError($result = $appCore->Query($sqlquery))) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($sqlquery, -654, null, null, PEAR_LOG_NOTICE);
	}
	if ($countrycount = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
		// Powiza nie ma
		if (current($countrycount) == 0) {
		 	// Usunicie kraju z bazy danych
			$sqlquery = "DELETE FROM Country WHERE Country.CRY_Id = '$countryid'";
			if(DB::isError($result = $appCore->Query($sqlquery))) {
				// Odwoanie transakcji
				Transaction('ROLLBACK');
				return new PEAR_Error($sqlquery, -654, null, null, PEAR_LOG_NOTICE);
			}
			$dbObject = &$appCore->getConnection(); 
			if (DB::isError($result = $dbObject->affectedRows())) {
				// Odwoanie transakcji
				Transaction('ROLLBACK');
				return new PEAR_Error("Usunicie kraju", -651, null, null, PEAR_LOG_NOTICE);	
			} else {
				if (PEAR::isError($result = Transaction('COMMIT'))) return $result;
				return TRUE;
			}
		} else {
			// Odwoanie transakcji
			Transaction('ROLLBACK');
			return new PEAR_Error("Usunicie kraju; Usu ze sklepu uytkownikw lub producentw, ktrzy w adresie maj ten kraj.", -655, null, null, PEAR_LOG_NOTICE);			
		}
	} else {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error("$sqlquery; Usunicie kraju", -656, null, null, PEAR_LOG_NOTICE);	
	}
 }
/**
 * Funkcja zapisuje dane nowego wojewdztwa w bazie danych
 *
 * @access public
 * @param object $state
 * @return mixed
 */
 function saveState(&$state) {
 	
	global $appCore;

	// Rozpoczcie transakcji 
    if (PEAR::isError($result = Transaction('BEGIN'))) return $result;
	// Zapisanie danych w tabeli Producer
 	$sqlquery = "INSERT INTO State (ST_Id, USR_Id, ST_Name, ST_CreateDate, ST_Active) VALUES ('" . $state->getId() . "', '" . $state->getOwner() . "', '" . $state->getName() . "', '" . $state->getCreateDate() . "', '" . $state->getActive() . "')";
	if(DB::isError($result = $appCore->Query($sqlquery))) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return $result;
	}
	$dbObject = &$appCore->getConnection(); 
	if ($dbObject->affectedRows() < 1) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($state->getId(), -651, null, null, PEAR_LOG_NOTICE);	
	} else {
	    if (PEAR::isError($result = Transaction('COMMIT'))) return $result;
		return TRUE;
	}
 }
/**
 * Funkcja uaktualnia dane wojewdztwa w bazie danych
 *
 * @access public
 * @param object $state
 * @return mixed
 */
 function updateState(&$state) {
 	
	global $appCore;
	// Rozpoczcie transakcji 
    if (PEAR::isError($result = Transaction('BEGIN'))) return $result;
 	// Uaktualnie danych wojewdztwa w bazie danych
	$sqlquery = "UPDATE State SET State.USR_Id = '" . $_SESSION['CurrentUser']->getId() . "', State.ST_Name = '" . $state->getName() . "', State.ST_LastModifyDate = '" . $state->getLastModifyDate() . "', State.ST_Active = " . $state->getActive() . " WHERE State.ST_Id = '" . $state->getId() . "'";
	if(DB::isError($result = $appCore->Query($sqlquery))) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($sqlquery, -654, null, null, PEAR_LOG_NOTICE);
	}
	$dbObject = &$appCore->getConnection(); 
	if (DB::isError($result = $dbObject->affectedRows())) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error("Aktualizacja danych stawki podatku VAT", -651, null, null, PEAR_LOG_NOTICE);	
	} else {
		if (PEAR::isError($result = Transaction('COMMIT'))) return $result;
		return TRUE;
	}
 }
/**
 * Funkcja usuwa dane wojewdztwo z bazy danych
 *
 * @access public
 * @param string $stateid
 * @return mixed
 */
 function deleteState(&$stateid) {
 	
	global $appCore;
	// Rozpoczcie transakcji 
    if (PEAR::isError($result = Transaction('BEGIN'))) return $result;
 	// Wyszukanie powiza wojewdztwa z tabel Address
	$sqlquery = "SELECT COUNT(*) FROM Address WHERE Address.ST_Id = '$stateid'";
	if(DB::isError($result = $appCore->Query($sqlquery))) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($sqlquery, -654, null, null, PEAR_LOG_NOTICE);
	}
	if ($statecount = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
		// Powiza nie ma
		if (current($statecount) == 0) {
		 	// Usunicie wojewdztwa z bazy danych
			$sqlquery = "DELETE FROM State WHERE State.ST_Id = '$stateid'";
			if(DB::isError($result = $appCore->Query($sqlquery))) {
				// Odwoanie transakcji
				Transaction('ROLLBACK');
				return new PEAR_Error($sqlquery, -654, null, null, PEAR_LOG_NOTICE);
			}
			$dbObject = &$appCore->getConnection(); 
			if (DB::isError($result = $dbObject->affectedRows())) {
				// Odwoanie transakcji
				Transaction('ROLLBACK');
				return new PEAR_Error("Usunicie wojewdztwa", -651, null, null, PEAR_LOG_NOTICE);	
			} else {
				if (PEAR::isError($result = Transaction('COMMIT'))) return $result;
				return TRUE;
			}
		} else {
			// Odwoanie transakcji
			Transaction('ROLLBACK');
			return new PEAR_Error("Usunicie wojewdztwa; Usu ze sklepu uytkownikw lub producentw, ktrzy w adresie maj to wojewdztwo.", -655, null, null, PEAR_LOG_NOTICE);			
		}
	} else {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error("$sqlquery; Usunicie wojewdztwa", -656, null, null, PEAR_LOG_NOTICE);	
	}
 }
/**
 * Funkcja zapisuje dane nowego zdjcia w bazie danych
 *
 * @access public
 * @param object $image
 * @return mixed
 */
 function saveImage(&$image) {
 	require_once("HTTP/Upload.php");
	global $appCore;

	$upload = new HTTP_Upload('en');
	$file = $upload->getFiles('image_file');
	if ($file->isValid()) {
		// Plik zosta przesany poprawnie
		// Ustalenie nazwy pliku na podstawie identyfikatora
		$file->setName('safe');
		// Przeniesienie pliku do katalogu IMAGE_TMPPATH
		if (PEAR::isError($file_name = $file->moveTo(IMAGE_TMPPATH))) {
			return new PEAR_Error($file_name->getMessage(), -404, null, null, PEAR_LOG_NOTICE);
		} else {
			// Pobranie zawartoci pliku
			$hfile = fopen(IMAGE_TMPPATH . '/' . $file->getProp('name'), "rb");
			$isize = sizeof(IMAGE_TMPPATH . '/' . $file->getProp('name'));
			//$img_size = sizeof($filepath);
			$img_data = "";
			while (!feof($hfile)) {
				$img_data .= fread($hfile, $isize);
			}
			//$img_data = fread($hfile, $file->getProp('size'));
			// Zabezpieczenie zawartoci pliku
			//$img_data = str_replace('##', '\#\#', mysql_escape_string($img_data));
			$img_data = addslashes($img_data);
			//$img_data = mysql_escape_string($img_data);
			// Rozpoczcie transakcji 
		    if (PEAR::isError($result = Transaction('BEGIN'))) return $result;
			// Zapisanie danych w tabeli Image
		 	$sqlquery = "INSERT INTO Image (IMG_Id, USR_Id, IMG_Desc, IMG_Image, IMG_ContentType, IMG_Default, IMG_CreateDate, IMG_Active) VALUES ('" . $image->getId() . "', '" . $image->getOwner() . "', '" . $image->getDesc() . "', '" . $img_data . "', '" . $file->getProp('type') . "', '" . $image->getDefault() . "', '" . $image->getCreateDate() . "', " . $image->getActive() . ")";
			if(DB::isError($result = $appCore->Query($sqlquery))) {
				// Odwoanie transakcji
				Transaction('ROLLBACK');
				return $result;
			}
			$dbObject = &$appCore->getConnection(); 
			if ($dbObject->affectedRows() < 1) {
				// Odwoanie transakcji
				Transaction('ROLLBACK');
				return new PEAR_Error($state->getId(), -651, null, null, PEAR_LOG_NOTICE);
			} else {
	    		if (PEAR::isError($result = Transaction('COMMIT'))) return $result;
				return TRUE;
			}
		}
	} elseif ($file->isMissing()) {
		// Uytkownik nie wskaza pliku do przesania
		return new PEAR_Error($image->getId(), -403, null, null, PEAR_LOG_NOTICE);
	} else {
		// Wystpi bd w trakcie przesyania
		return new PEAR_Error($file_name->getMessage(), -405, null, null, PEAR_LOG_NOTICE);
	}
 }
/**
 * Funkcja zapisuje dane nowego adresu w bazie danych
 *
 * @access public
 * @param object $address
 * @return mixed
 */
 function saveAddress(&$address) {
 	
	global $appCore;

	// Rozpoczcie transakcji 
    if (PEAR::isError($result = Transaction('BEGIN'))) return $result;
	// Zapisanie danych w tabeli Address
		$sqlquery = "INSERT INTO Address (ADDR_Id, ADT_Id, CRY_Id, ST_Id, ADDR_StreetName, ADDR_StreetNr, ADDR_HomeNr, ADDR_City, ADDR_Zip, ADDR_Phone, ADDR_Fax, ADDR_CreateDate, ADDR_Active) VALUES ('" . $address->getId() . "', '" . $address->_addressType->getId() . "', '" . $address->_country->getId() . "', '" . $address->_state->getId() . "', '" . $address->getStreetName() . "', '" . $address->getStreetNr() . "', '" . $address->getHomeNr() . "', '" . $address->getCity() . "', '" . $address->getZIP() . "', '" . $address->getPhone() . "', '" . $address->getFax() . "', '" . $address->getCreateDate() . "', 1)";
	if(DB::isError($result = $appCore->Query($sqlquery))) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($address->getId(), -654, null, null, PEAR_LOG_NOTICE);
	}
	$dbObject = &$appCore->getConnection(); 
	if ($dbObject->affectedRows() < 1) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($address->getId(), -651, null, null, PEAR_LOG_NOTICE);	
	} else {
	    if (PEAR::isError($result = Transaction('COMMIT'))) return $result;
		return TRUE;
	}
 }
/**
 * Funkcja uaktualnia dane adresu w bazie danych
 *
 * @access public
 * @param object $address
 * @return mixed
 */
 function updateAddress(&$address) {
 	
	global $appCore;
	// Rozpoczcie transakcji 
    if (PEAR::isError($result = Transaction('BEGIN'))) return $result;
		$sqlquery = "UPDATE Address SET ADT_Id = '" . $address->_addressType->getId() . "', CRY_Id = '" . $address->_country->getId() . "', ST_Id = '" . $address->_state->getId() . "', ADDR_StreetName = '" . $address->getStreetName() . "', ADDR_StreetNr = '" . $address->getStreetNr() . "', ADDR_HomeNr = '" . $address->getHomeNr() . "', ADDR_City = '" . $address->getCity() . "', ADDR_Zip = '" . $address->getZIP() . "', ADDR_Phone = '" . $address->getPhone() . "', ADDR_Fax = '" . $address->getFax() . "', ADDR_LastModifyDate = '" . $address->getLastModifyDate() . "', ADDR_Active = " . $address->getActive() . " WHERE Address.ADDR_Id = '" . $address->getId() . "'";
	if(DB::isError($result = $appCore->Query($sqlquery))) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($sqlquery, -654, null, null, PEAR_LOG_NOTICE);
	}
	$dbObject = &$appCore->getConnection(); 
	if (DB::isError($result = $dbObject->affectedRows())) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error("Aktualizacja danych adresu", -651, null, null, PEAR_LOG_NOTICE);	
	} else {
		if (PEAR::isError($result = Transaction('COMMIT'))) return $result;
		return TRUE;
	}
 }
/**
 * Funkcja usuwa dany adres z bazy danych
 *
 * @access public
 * @param string $addressid
 * @param string $addressowner
 *				 - 'user' - adres uytkownika (warto domylna)
 *				 - 'producer' - adres producenta
 * @return mixed
 */
 function deleteAddress(&$addressid, $addressowner = 'user') {
 	
	global $appCore;
	$table = NULL;
	// Pobranie etykiet
	$action_label = $appCore->getMessage('dict_address', 'address_action_label');
	$dependency_label = $appCore->getMessage('dict_address', 'address_action_dependency_label');

	switch ($addressowner) {
		case 'user':
			$table = 'usr_has_addr';
			break;
		case 'producer':
			$table = 'prc_has_addr';
			break;
		default:
			$table = 'usr_has_addr';
	}
	 
	// Rozpoczcie transakcji 
    if (PEAR::isError($result = Transaction('BEGIN'))) return $result;
 	// Wyszukanie powiza adresu z tabelami prc_has_addr oraz usr_has_addr
	$sqlquery = "SELECT COUNT(*) FROM $table WHERE $table.ADDR_Id = '$addressid'";
	if(DB::isError($result = $appCore->Query($sqlquery))) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($sqlquery, -654, null, null, PEAR_LOG_NOTICE);
	}
	if ($addresscount = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
		// Powiza nie ma
		if (current($addresscount) > 0) {
			// Usunicie przypisanie adresu do waciciela
			$sqlquery = "DELETE FROM $table WHERE $table.ADDR_Id = '$addressid'";
			if(DB::isError($result = $appCore->Query($sqlquery))) {
				// Odwoanie transakcji
				Transaction('ROLLBACK');
				return new PEAR_Error($sqlquery, -654, null, null, PEAR_LOG_NOTICE);
			}
			$dbObject = &$appCore->getConnection(); 
			if (DB::isError($result = $dbObject->affectedRows())) {
				// Odwoanie transakcji
				Transaction('ROLLBACK');
				return new PEAR_Error($action_label, -651, null, null, PEAR_LOG_NOTICE);	
	 		// Usunicie adresu z bazy danych
			} else {
				$sqlquery = "DELETE FROM Address WHERE Address.ADDR_Id = '$addressid'";
				if(DB::isError($result = $appCore->Query($sqlquery))) {
					// Odwoanie transakcji
					Transaction('ROLLBACK');
					return new PEAR_Error($sqlquery, -654, null, null, PEAR_LOG_NOTICE);
				}
				$dbObject = &$appCore->getConnection(); 
				if (DB::isError($result = $dbObject->affectedRows())) {
					// Odwoanie transakcji
					Transaction('ROLLBACK');
					return new PEAR_Error($action_label, -651, null, null, PEAR_LOG_NOTICE);	
				} else {
					if (PEAR::isError($result = Transaction('COMMIT'))) return $result;
					return TRUE;
				}			
			}
		} else {
			// Odwoanie transakcji
			Transaction('ROLLBACK');
			return new PEAR_Error($action_label . ';' . $dependency_label, -655, null, null, PEAR_LOG_NOTICE);			
		}
	} else {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($sqlquery . ';' . $action_label, -656, null, null, PEAR_LOG_NOTICE);	
	}
 }
/**
 * Funkcja zapisuje dane nowego typu adresu w bazie danych
 *
 * @access public
 * @param object $addresstype
 * @return mixed
 */
 function saveAddressType(&$addresstype) {
 	
	global $appCore;

	// Rozpoczcie transakcji 
    if (PEAR::isError($result = Transaction('BEGIN'))) return $result;
	// Zapisanie danych w tabeli AddressType
 	$sqlquery = "INSERT INTO AddressType (ADT_Id, USR_Id, ADT_Name, ADT_CreateDate, ADT_Active) VALUES ('" . $addresstype->getId() . "', '" . $addresstype->getOwner() . "', '" . $addresstype->getName() . "', '" . $addresstype->getCreateDate() . "', '" . $addresstype->getActive() . "')";
	if(DB::isError($result = $appCore->Query($sqlquery))) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($addresstype->getId(), -654, null, null, PEAR_LOG_NOTICE);
	}
	$dbObject = &$appCore->getConnection(); 
	if ($dbObject->affectedRows() < 1) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($addresstype->getId(), -651, null, null, PEAR_LOG_NOTICE);	
	} else {
	    if (PEAR::isError($result = Transaction('COMMIT'))) return $result;
		return TRUE;
	}
 }
/**
 * Funkcja uaktualnia dane typu adresu w bazie danych
 *
 * @access public
 * @param object $adt
 * @return mixed
 */
 function updateAddressType(&$adt) {
 	
	global $appCore;
	// Rozpoczcie transakcji 
    if (PEAR::isError($result = Transaction('BEGIN'))) return $result;
 	// Uaktualnie danych wojewdztwa w bazie danych
	$sqlquery = "UPDATE AddressType SET AddressType.USR_Id = '" . $_SESSION['CurrentUser']->getId() . "', AddressType.ADT_Name = '" . $adt->getName() . "', AddressType.ADT_LastModifyDate = '" . $adt->getLastModifyDate() . "', AddressType.ADT_Active = " . $adt->getActive() . " WHERE AddressType.ADT_Id = '" . $adt->getId() . "'";
	if(DB::isError($result = $appCore->Query($sqlquery))) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($sqlquery, -654, null, null, PEAR_LOG_NOTICE);
	}
	$dbObject = &$appCore->getConnection(); 
	if (DB::isError($result = $dbObject->affectedRows())) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error("Aktualizacja danych stawki podatku VAT", -651, null, null, PEAR_LOG_NOTICE);	
	} else {
		if (PEAR::isError($result = Transaction('COMMIT'))) return $result;
		return TRUE;
	}
 }
/**
 * Funkcja usuwa dany typ adresu z bazy danych
 *
 * @access public
 * @param string $adtid
 * @return mixed
 */
 function deleteAddressType(&$adtid) {
 	
	global $appCore;
	// Pobranie etykiet
	$action_label = $appCore->getMessage('dict_addresstype', 'addresstype_action_label');
	$dependency_label = $appCore->getMessage('dict_addresstype', 'addresstype_action_dependency_label');

	// Rozpoczcie transakcji 
    if (PEAR::isError($result = Transaction('BEGIN'))) return $result;
 	// Wyszukanie powiza typu adresu z tabel Address
	$sqlquery = "SELECT COUNT(*) FROM Address WHERE Address.ADT_Id = '$adtid'";
	if(DB::isError($result = $appCore->Query($sqlquery))) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($sqlquery, -654, null, null, PEAR_LOG_NOTICE);
	}
	if ($adtcount = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
		// Powiza nie ma
		if (current($adtcount) == 0) {
		 	// Usunicie typu adresu z bazy danych
			$sqlquery = "DELETE FROM AddressType WHERE AddressType.ADT_Id = '$adtid'";
			if(DB::isError($result = $appCore->Query($sqlquery))) {
				// Odwoanie transakcji
				Transaction('ROLLBACK');
				return new PEAR_Error($sqlquery, -654, null, null, PEAR_LOG_NOTICE);
			}
			$dbObject = &$appCore->getConnection(); 
			if (DB::isError($result = $dbObject->affectedRows())) {
				// Odwoanie transakcji
				Transaction('ROLLBACK');
				return new PEAR_Error($action_label, -651, null, null, PEAR_LOG_NOTICE);	
			} else {
				if (PEAR::isError($result = Transaction('COMMIT'))) return $result;
				return TRUE;
			}
		} else {
			// Odwoanie transakcji
			Transaction('ROLLBACK');
			return new PEAR_Error($action_label . ';' . $dependency_label, -655, null, null, PEAR_LOG_NOTICE);			
		}
	} else {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($sqlquery . ';' . $action_label, -656, null, null, PEAR_LOG_NOTICE);	
	}
 }
/**
 * Funkcja zapisuje dane nowej stawki podatku VAT w bazie danych
 *
 * @access public
 * @param object $tax
 * @return mixed
 */
 function saveTax(&$tax) {
 	
	global $appCore;
	// Rozpoczcie transakcji 
    if (PEAR::isError($result = Transaction('BEGIN'))) return $result;
 	// Wyczyszczenie wartoci domylnych
	if ($tax->getDefault() == 1) {
 		$sqlquery = "UPDATE TaxRate SET TaxRate.TAX_Default = 0";
		if(DB::isError($result = $appCore->Query($sqlquery))) {
			// Odwoanie transakcji
			Transaction('ROLLBACK');
			return new PEAR_Error($sqlquery, -654, null, null, PEAR_LOG_NOTICE);
   		}
	}

	// Zapisanie danych w tabeli TaxRate
 	$sqlquery = "INSERT INTO TaxRate (TAX_Id, USR_Id, TAX_Desc, TAX_Value, TAX_Default, TAX_CreateDate, TAX_Active) VALUES ('" . $tax->getId() . "', '" . $tax->getOwner() . "', '" . $tax->getDesc() . "', " . $tax->getValue() . ", " . $tax->getDefault() . ", '" . $tax->getCreateDate() . "', '" . $tax->getActive() . "')";
	if(DB::isError($result = $appCore->Query($sqlquery))) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($sqlquery, -654, null, null, PEAR_LOG_NOTICE);
	}
	$dbObject = &$appCore->getConnection(); 
	if ($dbObject->affectedRows() < 1) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error("Zapis nowej stawki podatku VAT", -650, null, null, PEAR_LOG_NOTICE);	
	} else {
	    if (PEAR::isError($result = Transaction('COMMIT'))) return $result;
		return TRUE;
	}
 }
/**
 * Funkcja uaktualnia dane stawki podatku VAT w bazie danych
 *
 * @access public
 * @param object $tax
 * @return mixed
 */
 function updateTax(&$tax) {
 	
	global $appCore;
	// Rozpoczcie transakcji 
    if (PEAR::isError($result = Transaction('BEGIN'))) return $result;
 	// Ustalenie domylnoci podatku
	if ($tax->getDefault() == 1) {
		// Usunicie domylnoci z pozostaych stawek podatku
		$sqlquery = "UPDATE TaxRate SET TaxRate.TAX_Default = 'f'";
	 	if(DB::isError($result = $appCore->Query($sqlquery))) {
			// Odwoanie transakcji
			Transaction('ROLLBACK');
			return new PEAR_Error($sqlquery, -654, null, null, PEAR_LOG_NOTICE);
		}
	}
 	// Uaktualnie danych stawki podatku w bazie danych
	$sqlquery = "UPDATE TaxRate SET TaxRate.USR_Id = '" . $_SESSION['CurrentUser']->getId() . "', TaxRate.TAX_Desc = '" . $tax->getDesc() . "', TaxRate.TAX_Value = " . $tax->getValue() . ", TaxRate.TAX_Default = " . $tax->getDefault() . ", TaxRate.TAX_LastModifyDate = '" . $tax->getLastModifyDate() . "', TaxRate.TAX_Active = " . $tax->getActive() . " WHERE TaxRate.TAX_Id = '" . $tax->getId() . "'";
	if(DB::isError($result = $appCore->Query($sqlquery))) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($sqlquery, -654, null, null, PEAR_LOG_NOTICE);
	}
	$dbObject = &$appCore->getConnection(); 
	if (DB::isError($result = $dbObject->affectedRows())) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error("Aktualizacja danych stawki podatku VAT", -651, null, null, PEAR_LOG_NOTICE);	
	} else {
		if (PEAR::isError($result = Transaction('COMMIT'))) return $result;
		return TRUE;
	}
 }
/**
 * Funkcja usuwa dan stawk podatku VAT z bazy danych
 *
 * @access public
 * @param string $taxid
 * @return mixed
 */
 function deleteTax(&$taxid) {
 	
	global $appCore;
	// Rozpoczcie transakcji 
    if (PEAR::isError($result = Transaction('BEGIN'))) return $result;
 	// Wyszukanie powiza stawki podatku z tabel Product
	$sqlquery = "SELECT COUNT(*) FROM Product WHERE Product.TAX_Id = '$taxid'";
	if(DB::isError($result = $appCore->Query($sqlquery))) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($sqlquery, -654, null, null, PEAR_LOG_NOTICE);
	}
	if ($taxcount = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
		// Powiza nie ma
		if (current($taxcount) == 0) {
		 	// Usunicie stawki podatku z bazy danych
			$sqlquery = "DELETE FROM TaxRate WHERE TaxRate.TAX_Id = '$taxid'";
			if(DB::isError($result = $appCore->Query($sqlquery))) {
				// Odwoanie transakcji
				Transaction('ROLLBACK');
				return new PEAR_Error($sqlquery, -654, null, null, PEAR_LOG_NOTICE);
			}
			$dbObject = &$appCore->getConnection(); 
			if (DB::isError($result = $dbObject->affectedRows())) {
				// Odwoanie transakcji
				Transaction('ROLLBACK');
				return new PEAR_Error("Usunicie stawki podatku VAT", -651, null, null, PEAR_LOG_NOTICE);	
			} else {
				if (PEAR::isError($result = Transaction('COMMIT'))) return $result;
				return TRUE;
			}
		} else {
			// Odwoanie transakcji
			Transaction('ROLLBACK');
			return new PEAR_Error("Usunicie stawki podatku VAT; Usu ze sklepu produkty z t stawk podatku VAT", -655, null, null, PEAR_LOG_NOTICE);			
		}
	} else {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error("$sqlquery; Usunicie stawki podatku VAT", -656, null, null, PEAR_LOG_NOTICE);	
	}
 }
/**
 * Funkcja uaktualnia dane parametru w bazie danych
 *
 * @access public
 * @param object $param
 * @return mixed
 */
 function updateParam(&$param) {
 	
	global $appCore;
	// Rozpoczcie transakcji 
    if (PEAR::isError($result = Transaction('BEGIN'))) return $result;
 	// Uaktualnie danych wojewdztwa w bazie danych
	$sqlquery = "UPDATE Parameter SET Parameter.USR_Id = '" . $_SESSION['CurrentUser']->getId() . "', Parameter.PAR_Name = '" . $param->getName() . "', Parameter.PAR_Desc = '" . $param->getDesc() . "', Parameter.PAR_LastModifyDate = '" . $param->getLastModifyDate() . "', Parameter.PAR_Active = " . $param->getActive() . " WHERE Parameter.PAR_Id = '" . $param->getId() . "'";
	if(DB::isError($result = $appCore->Query($sqlquery))) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($sqlquery, -654, null, null, PEAR_LOG_NOTICE);
	}
	$dbObject = &$appCore->getConnection(); 
	if (DB::isError($result = $dbObject->affectedRows())) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error("Aktualizacja danych parametru asortymentu", -651, null, null, PEAR_LOG_NOTICE);	
	} else {
		if (PEAR::isError($result = Transaction('COMMIT'))) return $result;
		return TRUE;
	}
 }
/**
 * Funkcja usuwa dany parametr z bazy danych
 *
 * @access public
 * @param string $paramid
 * @return mixed
 */
 function deleteParam(&$paramid) {
 	
	global $appCore;
	// Rozpoczcie transakcji 
    if (PEAR::isError($result = Transaction('BEGIN'))) return $result;
 	// Wyszukanie powiza parametrw z tabel Item
	$sqlquery = "SELECT COUNT(*) FROM itm_has_par WHERE itm_has_par.PAR_Id = '$paramid'";
	if(DB::isError($result = $appCore->Query($sqlquery))) {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error($sqlquery, -654, null, null, PEAR_LOG_NOTICE);
	}
	if ($paramcount = &$result->fetchRow(DB_FETCHMODE_ASSOC)) {
		// Powiza nie ma
		if (current($paramcount) == 0) {
		 	// Usunicie parametru z bazy danych
			$sqlquery = "DELETE FROM Parameter WHERE Parameter.PAR_Id = '$paramid'";
			if(DB::isError($result = $appCore->Query($sqlquery))) {
				// Odwoanie transakcji
				Transaction('ROLLBACK');
				return new PEAR_Error($sqlquery, -654, null, null, PEAR_LOG_NOTICE);
			}
			$dbObject = &$appCore->getConnection(); 
			if (DB::isError($result = $dbObject->affectedRows())) {
				// Odwoanie transakcji
				Transaction('ROLLBACK');
				return new PEAR_Error("Usunicie parametru", -651, null, null, PEAR_LOG_NOTICE);	
			} else {
				if (PEAR::isError($result = Transaction('COMMIT'))) return $result;
				return TRUE;
			}
		} else {
			// Odwoanie transakcji
			Transaction('ROLLBACK');
			return new PEAR_Error("Usunicie parametru; Usu ze sklepu produkty i asortyment, ktre posiadaj ten parametr.", -655, null, null, PEAR_LOG_NOTICE);			
		}
	} else {
		// Odwoanie transakcji
		Transaction('ROLLBACK');
		return new PEAR_Error("$sqlquery; Usunicie parametru", -656, null, null, PEAR_LOG_NOTICE);	
	}
 } 
?>