<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+

/**
 * Inicjalizacja domylnego cigu DSN
 *
 * Na podstawie ustawie globalnych aplikacji tworzony jest cig DSN pozwalajcy
 * na poczenie si z baz danych. 
 * @access public
 * @return string PEAR::DB->_DSN string Cig DSN
 */
function DSNInit()
{
	// Doczenie obsugi klasy PEAR-DB
	require_once('DB.php');
	
	return DB_TYPE . '://' . DB_USERNAME . ':' . DB_PASSWD . '@' . DB_PROTOCOL . '(' . DB_HOST . ')/' . DB_NAME;
}

/**
 * Obsuga transakcji bazodanowych
 *
 * @access public
 * @param string $type Rodzaj transakcji:
 *                     	- BEGIN - rozpoczcie transakcji
 *						- COMMIT - zatwierdzenie transakcji
 *						- ROLLBACK - zwinicie transakcji
 * @return mixed TRUE - jeli funkcja wykonaa si prawidowo
 *				 Obiekt PEAR::Error - jeli w trakcie wykonywania funkcji
 *									wystpi bd		
 */
function Transaction($type)
{
	// Doczenie obsugi klasy PEAR-DB
	require_once('DB.php');
	global $appCore;

	$sqlquery = $type;
	if (DB::isError($result = $appCore->Query($sqlquery))) {
		return new PEAR_Error($type, -652, null, null, PEAR_LOG_NOTICE);
	} else {

		$dbObject = &$appCore->getConnection(); 
		if ($dbObject->affectedRows() < 0) {
	   		return new PEAR_Error($type, -651, null, null, PEAR_LOG_NOTICE);}
	}
	return TRUE;
}
/**
 * Funkcja wywietlajca standardowe okno dialogowe platformy
 *
 * @access public
 * @param string $windowTitle - tytu okna dialogowego
 * @param string $windowType - typ okna dialogowego
 *				 - 'confirm' - okno potwierdzajce (przyciski OK oraz Cancel)
 *				 - 'info' - okno informujce (przycisk OK)
 * @param string $message - komunikat wywietlany w oknie dialogowym
 * @param string $content - szablon, do ktrego wczytany zostanie formularz okna
 */
function showDialogBox($windowTitle, $message, $windowType, &$content)
{
	global $appCore;
	global $smarty;

	// Wczytanie moduu Forms
	if (PEAR::isError($err = $appCore->loadModule('Forms'))){echo($appCore->getLastErrorMessage()); exit;}
	$formObj = new Forms('confirmdialogbox.xml');

	$smarty->assign('windowTitle', $windowTitle['VALUE']); 
	$smarty->assign('message', $message);
	$content = 'confirmdialogbox.tpl';
}
?>