<?php
//<meta http-equiv="Content-type" content="text/html; charset=iso-8859-2" />
//<meta name="Author" content="Sebastian Marek, Daniel Bargie" />
// +----------------------------------------------------------------------+
// | Sklep Internetowy												  	  |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Daniel Bargie, Sebastian Marek 				  |
// +----------------------------------------------------------------------+
//Niezbdne funkcje i klasy obiektw
require_once('../config/define.cfg.php'); //Podstawowy plik konfiguracyjny
require_once('xml/confxml_parser.php'); //Parser plikw XML zawierajacych dane koniguracyjne
require_once('PEAR.php'); //Klasa bazowa PEAR'a
require_once('Log.php');  //Klasa obiektu dziennika zdarze
require_once('DB.php');   //Klasa obiektu poczenia z baz danych
require_once('object.inc.php');
require_once('common.inc.php'); //Niezbdne funkcje (m.in. obsuga bdw)
require_once('user.inc.php'); //Niezbdne funkcje (m.in. obsuga bdw)

switch(DB_TYPE) {
	/*case 'pgsql':
		switch(DB_VERSION) {
			default:
		}
		break;*/
	case 'mysql':
		switch(DB_VERSION) {
			/*case '3.23':
				require_once(APP_CORE_PATH.'db_support/mysql/3.23/func_security.inc.php');
				break;*/
			case '4.01':
				require_once(APP_CORE_PATH.'db_support/mysql/4.01/func_security.inc.php');
				require_once(APP_CORE_PATH.'db_support/mysql/4.01/func_shop.inc.php');
				break;
		}
		break;
}
/**
 * Klasa obiektu jdra aplikacji
 *
 * Obiekt jdra aplikacji przechowuje najwaniejsze parametry aplikacji
 * takie jak: lista nazw zaadowanych moduw...
 *
 */
class ApplicationCore extends PEAR {
    /**#@+
	 * @access private
	 */
	/**
	 * @var string() Lista nazw zaadowanych do aplikacji moduw
	 */
    var $_loadedMod;
	/**
	 * @var object Obiekt dziennika zdarze
	 */
	var $_logObject;
	/**
	 * @var object Obiekt komunkatw 
	 */
	var $_msgObj;
	/**
	 * @var string Ostatni komunikat bdu
	 */
	var $_errorMessage;
	/**
	 * @var string ostatni kod bdu
	 */
	var $_errorCode;
	/**
	 * @var boolean Flaga informaujca o tym, czy aplikacja zostaa zainicjowana
	 */
	var $_appInitialized;
	/**
	 * Obiekt PEAR pamitajcy poczenie z baz danych
	 */
	 var $_dataBaseConnection;
	/**
	 * @var Zmienna 
	 */
	var $_transaction;
	/**#@-*/
	
	/**#@+
	 * @access public
	 */
	/**
	 * Konstruktor klasy
	 *
	 * Ustawia jedynie warto waciwoci $_appInitialized na FALSE aby jawnie zaznaczy, e aplikacja nie zostaa zainicjowana
	 */
	function ApplicationCore() {
		//Aplikacja musi zosta zainicjalizowana
		$this->_appInitialized = FALSE;	
	}	
	
	/**
	 * Metoda inicjuje rdze aplikacji, tworzc obiekt komunikatw oraz inicjujc 
	 * wstpn obsug bdw i obiekt dziennika zadarze
	 *
	 * @param $msgFile cieka dostpu do pliku komunikatw
	 */
	function initializeApplication($msgFile) {		
		
		//Inicjacja dziennika zdarze
		if (LOG_WRITE) {
			$conf = array('mode' => LOG_MODE, 'timeFormat' => '%d %B %Y, %H:%M');
			if (!($this->_logObject = &Log::singleton(LOG_TYPE, LOG_NAME, LOG_USERNAME, $conf, LOG_PRIORITY))) {
				//Bd krytyczny. Zwracanu jest tylko komunikar
				$this->_errorMessage = 'Nie mona utworzy dziennika zdarze';
				return new PEAR_Error(NULL);
			}
		}
		
		
		//adowanie pliku komunikatw
		$this->_msgObj = new ConfXML_Parser($msgFile);
		
		//Sprawdzenie czy istnieje obowizkowa sekcja 'error'
		if (PEAR::isError($this->_msgObj->getXMLErrorMsg('error', -1000))){
			//Zapis do dziennika zdarze
			if(LOG_WRITE) {	$this->_logObject->log('Nie mona zaadowa pliku komunikatw', PEAR_LOG_ERR);}
			$this->_errorMessage = 'Nie mona zaadowa pliku komunikatw';
			return new PEAR_Error(NULL);
		}
			
		//Standardowa obsuga bdw
		$this->setErrorHandling(PEAR_ERROR_CALLBACK, array(&$this, 'handleError'));
		
		//Lista zaadowanych moduw
		$this->_loadedMod = array();
		
		//Ostatni komunikat bdu oraz ostatni kod bdu
		$this->_errorMessage = ''; $this->_errorCode    = '';
		
		//Prba nawizania poczenia z baz danych
		if (PEAR::isError($this->_dataBaseConnection = DB::connect(DSNInit()))) {
			$this->_errorMessage = 'Nie mona nawiza poczenia z ba danych. Przyczyna: '.$this->_dataBaseConnection->getMessage();
			return new PEAR_ERROR(NULL);

		}
		
		//Aplikacja zostaa poprawnie zainicjowana
		$this->_appInitialized = TRUE;
	
	}
	
	function loadConfigFile($fileName) {
		//Zwraca bd jeeli aplikacja nie zostaa zainicjowana
		if (!$this->_appInitialized) {return new PEAR_ERROR(NULL);}
		
		//adowanie pliku XML
		$confXML = new ConfXML_Parser($fileName);
		
		//Pobranie caej sekcji parametrw
		if (PEAR::isError($params = $confXML->getXMLSection('params'))) {return $params;}
		
		//Tworzenie staych
		if (count($params)!=0) {
			foreach($params as $param) {
				if (!defined($param['ID'])) {
					define($param['ID'], $param['VALUE']);
				}
			}
		}
		
		//Pobranie caej sekcji moduw
		if (PEAR::isError($modules = $confXML->getXMLSection('modules'))) {return $params;}
		
		//Utworzenie listy moduw do zaadowania
		if (count($modules)>0) {
			foreach($modules as $module) {
				if (!isset($this->_loadedMod[$module['ID']])) {
					$this->_loadedMod[$module['ID']][0]= $module['PATH'];
					$this->_loadedMod[$module['ID']][1]= $module['FILE'];
				}
			}
		}
	}

	/**
	 * Metoda aduje plik moduu
	 *
	 * @param string $_modName Nazwa moduu, ktrego plik powinien by zaadowany
	 */
	function loadModule($_modName) {
		//Zwraca bd jeeli aplikacja nie zostaa zainicjowana
		if (!$this->_appInitialized) {return new PEAR_ERROR(NULL);}
		
		if (isset($this->_loadedMod[$_modName])) {
			$fPath = $this->_loadedMod[$_modName][0].'/'.$this->_loadedMod[$_modName][1];
			if (file_exists($fPath)) {
				include_once($fPath);
			} else {return PEAR::raiseError($_modName, -364, null, null, PEAR_LOG_ERR);}
		} else {
			return PEAR::raiseError($_modName, -363, null, null, PEAR_LOG_ERR);
		}
	}
	 
	/**
	 * Metoda dodaje nazw moduu do listy
	 *
	 * @param string $modName
	 */
	function addModuleToList($modName, $modFile) {
	    $this->_loadedMod[$modName] = $modFile;
	}
	/**
	 * Metoda zwraca lit nazw zadowanych moduw
	 *
	 * @return array Tablica nazw zaadowanych moduw
	 *
	 */
	function getModulesList() {
	    return $this->_loadedMod;
	}	
	/**
	 *
	 */
	function handleError($error) {
		//Zwraca bd jeeli aplikacja nie zostaa zainicjowana
		if (!$this->_appInitialized) {return new PEAR_ERROR(NULL);}
		
		$this->_errorCode = $error->getCode();
		$this->_errorMessage = $this->getErrorMsg($error->getCode());
		$errMsg = explode(';', $error->getMessage()); 
		for($iter=0; $iter<count($errMsg); $iter++) {
			$this->_errorMessage = str_replace('$param'.($iter+1), '"'.$errMsg[$iter].'"', $this->_errorMessage);		
		
		}
						
		//Zapis do dziennika zdarze
		if(LOG_WRITE) {$this->_logObject->log('('.$this->_errorCode.') '.$this->_errorMessage, $error->getUserInfo());}

	}
	/**
	 * Metoda zwraca tre komunikatu bdu
	 */
	function getErrorMsg($errNo) {
		//Zwraca bd jeeli aplikacja nie zostaa zainicjowana
		if (!$this->_appInitialized) {return new PEAR_ERROR(NULL);}
		
		return $this->_msgObj->getXMLErrorMsg('error', $errNo);
	}
	/**
	 * Metoda zwraca komunikat z wybranej sekcji
	 */
	function getMessage($section, $msgid, $params=NULL) {
		//Zwraca bd jeeli aplikacja nie zostaa zainicjowana
		if (!$this->_appInitialized) {return new PEAR_ERROR(NULL);}

		//Zwraca zwyky komunikat, lub komunikat z parametrami
		if(!$params || count($params)==0) {
			return $this->_msgObj->getXMLSection($section, $msgid);
		} else {
			$msg = $this->_msgObj->getXMLSection($section, $msgid);
			for($iter=0; $iter<count($params); $iter++) {$msg = str_replace('$param'.($iter+1), $params[$iter], $msg); }
			return $msg;
		}
	}
	/**
	 * Zwraca sekcji komunikatw
	 */
	function getMessageSection($section) {
		return $this->_msgObj->getXMLSection($section);
	}
	/**
	 * Metoda zawraca tre komunikatu ostatniego bdu
	 */
	function getLastErrorMessage() {return $this->_errorMessage;}
	/**
	 * Metoda czyci ostatni komunikat bdu
	 */
	function clearLastErrorMessage() {$this->_errorMessage='';}
	/*
	 * Metoda zwraca kod ostatniego bdu
	 */
	function getLastErrorCode() {return $this->_errorCode;}
	/**
	 * Metoda czyci kod ostatniego bedu
	 */
	function clearLastErrorCode() {$this->_errorCode = 0;}
	/**
	 * Metoda wykonuje zapytanie do bazy danych
	 * @param string $queryString Kod SQL zapytania
	 * @return mixed
	 */
	function Query($queryString) {
		return $this->_dataBaseConnection->Query($queryString);
	}
	/**
	 * Metoda zwraca obiekt poczenia z baz danych
	 */
	function getConnection() {	
		return	$this->_dataBaseConnection;
	}
	/**
	 * Metoda ustawia status traksakcji
	 *
	 * @param bool $status 
	 */
	function setTransactionStatus($status){if($status) {$this->_transaction = TRUE;} else {$this->_transaction = FALSE;};}
	/**
	 * Metoda zwraca warto statusu transakcji
	 *
	 * @return bool
	 */
	function getTransactionStatus() { return $this->_transaction;}
	/**#@-*/
}

//Odnonik do obiektu jdra aplikacji
$appCore = new ApplicationCore();
?>