<?php
  // Definiuje pliki, z ktrych bdziemy korzysta
  $srcurl = 'http://localhost/index.php'; // To musi by URL!
  $tempfilename = 'tempindex.html';       // To musi by nazwa pliku!
  $targetfilename = 'index.html';         // To take musi by nazwa pliku!
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Generowanie pliku <?php echo $targetfilename; ?></title>
<meta http-equiv="content-type"
    content="text/html; charset=iso-8859-2" />
</head>
<body>
<p>Generowanie pliku <?php echo $targetfilename; ?>...</p>
<?php

  // Zaczynamy od usunicia pliku tymczasowego, gdyby przypadkiem 
  // jaki si poniewiera. Operacja ta moe wywoa komunikat
  // o bdzie, gdyby pliku jednak nie byo, wic uywamy operatora
  // @ by zablokowa wywietlanie komunikatu o bdzie.
  @unlink($tempfilename);

  // adujemy dynamiczn stron dajc jej za pomoc adresu 
  // URL. Kod PHP zostanie przetworzony przez serwer WWW 
  // za nim trafi do nas (w gruncie rzeczy podszywamy si 
  // tu pod przegldark WWW), wic to co otrzymamy bdzie
  // statyczn stron HTML. Parametr 'r' oznacza, e zamierzamy
  // tylko odczytywa dane z tego "pliku".

  $dynpage = fopen($srcurl, 'r');

  // Szukamy bdw
  if (!$dynpage) {
    exit("<p>Nie mona zaadowa pliku $srcurl. Aktualizacja statycznej " .
        "strony przerwana!</p>");
  }

  // Wczytaj zawarto znalezion pod adresem URL do zmiennej PHP.
  // Zaznacz, e zamierzamy odczyta najwyej do 1MB danych
  // (na wypadek gdyby co poszo nie tak).
  $htmldata = fread($dynpage, 1024*1024);

  // Zamknij poczenie ze rdowym "plikiem", ju
  // nie jest nam potrzebny.
  fclose($dynpage);

  // Otwrz plik tymczasowy (tworzc go w trakcie tej
  // operacji), by mc w nim zapisywa dane (co sygnalizuje
  // parametr 'w').

  $tempfile = fopen($tempfilename, 'w');

  // Szukamy bdw
  if (!$tempfile) {
    exit("<p>Nie mona otworzy tymczasowego pliku ($tempfilename) dla " .
        "potrzeb zapisu. Przerwano aktualizacj statycznej strony!</p>");
  }


  // Zapisz dane tworzce statyczna stron 
  // w tymczasowym pliku
  fwrite($tempfile, $htmldata);

  // Zamknij plik tymczasowy, skoczylimy ju
  // zapisywanie w nim danych.
  fclose($tempfile);

  // Jeli dotarlimy tutaj, to znaczy, e tymczasowy plik 
  // zosta zachowany, wic moemy go skopiowa na
  // istniejcy plik statycznej strony.

  $ok = copy($tempfilename, $targetfilename);

  // Na koniec usuwamy plik tymczasowy.
  unlink($tempfilename);
?>
<p>Statyczna strona zostaa zaktualizowana z powodzeniem!</p>
</body>
</html>
