<?php include_once $_SERVER['DOCUMENT_ROOT'] .
        '/includes/helpers.inc.php'; ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="pl" lang="pl">
    <head>
        <title>Koszyk na zakupy</title>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <style type="text/css">
        table {
            border-collapse: collapse;
        }
        td, th {
            border: 1px solid black;
        }
        </style>
    </head>
    <body>
        <h1>Twój koszyk na zakupy</h1>
        <?php if (count($cart) > 0): ?>
        <table>
            <thead>
                <tr>
                    <th>Opis produktu</th>
                    <th>Cena</th>
                </tr>
            </thead>
            <tfoot>
                <tr>
                    <td>Razem:</td>
                    <td>$<?php echo number_format($total, 2); ?></td>
                </tr>
            </tfoot>
            <tbody>
                <?php foreach ($cart as $item): ?>
                    <tr>
                        <td><?php htmlout($item['desc']); ?></td>
                        <td>
                            $<?php echo number_format($item['price'], 2); ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <?php else: ?>
        <p>Twój koszyk jest pusty!</p>
        <?php endif; ?>
        <form action="?" method="post">
            <p>
                <a href="?">Kontynuuj zakupy</a> lub
                <input type="submit" name="action" value="Opróżnij koszyk"/>
            </p>
        </form>
    </body>
</html>