<?php
  require_once("wyjatki_plikowe.php");

  // utworzenie krótkich nazw zmiennych
  $iloscopon = (int)$_POST['iloscopon'];
  $iloscoleju = (int)$_POST['iloscoleju'];
  $iloscswiec = (int)$_POST['iloscswiec'];
  $adres = preg_replace('/\t|\R/',' ',$_POST['adres']);
  $date = date('H:i, jS F Y'); 
  $document_root = $_SERVER['DOCUMENT_ROOT'];
?>
<!DOCTYPE html>
<html>
<head>
  <title>Części samochodowe Janka — wyniki zamówienia</title>
</head>
<body>
<h1>Części samochodowe Janka</h1>
<h2>Wyniki zamówienia</h2>
<?php
  echo "<p>Zamówienie przyjęte o ".date('H:i, jS F Y')."</p>";
  echo "<p>Państwa zamówienie wygląda następująco:</p>";

  $ilosc = 0;
  $wartosc=0.00;

  define('CENAOPON', 100);
  define('CENAOLEJU', 10);
  define('CENASWIEC', 4);

  $ilosc = $iloscopon + $iloscoleju +$iloscswiec;
  echo "<p>Ilość zamówionych produktów: ".$ilosc."<br />";

  if( $ilosc == 0 ) {
    echo "Na poprzedniej stronie nie zostało złożone żadne zamówienie!<br />";
  } else {
    if ( $iloscopon>0 ) {
      echo htmlspecialchars($iloscopon)." opon<br />";
    }
    if ( $iloscoleju>0 ) {
      echo htmlspecialchars($iloscoleju)." butelek oleju<br />";
    }
    if ( $iloscswiec>0 ) {
      echo htmlspecialchars($iloscswiec)." świec zapłonowych<br />";
    }
  }

  $wartosc = $iloscopon * CENAOPON
           + $iloscoleju * CENAOLEJU
           + $iloscswiec * CENASWIEC;

  echo "Wartość zamówienia wynosi ".number_format($wartosc, 2, '.', ' ')."<br />";

  $podatek = 0.22; // podatek wynosi 22%
  $wartosc = $wartosc * (1 + $podatek);
  echo "Wartość zmaówienia z podatkiem wynosi: ".number_format($wartosc,2, '.', ' ')." PLN</p>";

  echo "<p>Adres wysyłki to ".$adres."</p>";

  $ciagwyjsciowy = $data."\t".$iloscopon." opon \t".$iloscoleju." butelek oleju\t"
                   .$iloscswiec." świec zapłonowych\t".$wartosc
                   ."PLN/t". $adres."\n";

  // otwarcie pliku w celu dopisywania
  try
  {
    if (!($fp = @fopen("$DOCUMENT_ROOT/../zamowienia/zamowienia.txt", 'ab'))) {
      throw new otwarciePlikuException();
    }

    if (!flock($p, LOCK_EX)) {
      throw new blokadaPlikuException();
    }

    if (!fwrite($wp, $ciagwyjsciowy)) {
      throw new zapisPlikuException();
    }

    flock($wp, LOCK_UN);
    fclose($wp);
    echo '<p>Zamówienie zapisane.</p>';
  }
  catch (otwarciePlikuException $ope)
  {
    echo "<p><strong> Nie można otworzyć pliku zamówień.
          Proszę skontaktować się z administratorem systemu.</strong></p>";
  }
  catch (Exception $e)
  {
    echo "<p><strong>Państwa zamówienie nie może zostać przyjęte w tej chwili.
          Proszę spróbować później.</strong></p>";
  }
?>
</body>
</html>